/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.WorkerConfigTransformer;
import org.apache.kafka.connect.runtime.rest.entities.ConfigInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConfigInfos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerConfigDecorator {
    private static final Logger log = LoggerFactory.getLogger(WorkerConfigDecorator.class);
    private static final String NO_DOC = "";
    protected static final String CONFLUENT_LICENSE_CONFIG = "confluent.license";
    private static final String CONFLUENT_LICENSE_DEFAULT = "";
    protected static final String CONFLUENT_TOPIC_CONFIG = "confluent.topic";
    private static final String CONFLUENT_TOPIC_DEFAULT = "_confluent-command";
    protected static final String CONFLUENT_TOPIC_PREFIX = "confluent.topic.";
    protected static final String CONFLUENT_TOPIC_PRODUCER_PREFIX = "confluent.topic.producer.";
    protected static final String CONFLUENT_TOPIC_CONSUMER_PREFIX = "confluent.topic.consumer.";
    protected static final String CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_CONFIG = "confluent.topic.bootstrap.servers";
    private static final List<?> CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_DEFAULT = Collections.emptyList();
    protected static final String CONFLUENT_TOPIC_REPLICATION_FACTOR_CONFIG = "confluent.topic.replication.factor";
    private static final int CONFLUENT_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
    protected static final String CONFLUENT_INJECT_INTO_CONNECTORS_CONFIG = "confluent.license.inject.into.connectors";
    private static final List<DecorationPattern> PATTERNS = Collections.singletonList(new LicensePropertiesDecorator());
    private final WorkerConfig workerConfig;
    private final WorkerConfigTransformer transformer;

    static ConfigDef decorateWorkerConfig(ConfigDef workerConfigDef, Map<String, String> workerProps) {
        ConfigDef copy = new ConfigDef(workerConfigDef);
        if (PATTERNS.stream().map(p -> p.addToWorkerConfig(copy, workerProps)).anyMatch(r -> r)) {
            return copy;
        }
        return workerConfigDef;
    }

    protected static WorkerConfigDecorator initialize(WorkerConfig workerProperties, WorkerConfigTransformer transformer) {
        return new WorkerConfigDecorator(workerProperties, transformer);
    }

    private static ConfigDef without(ConfigDef configDef, String ... keysToExclude) {
        HashSet<String> excludedKeys = new HashSet<String>(Arrays.asList(keysToExclude));
        ConfigDef result = new ConfigDef();
        configDef.configKeys().forEach((key, value) -> {
            if (!excludedKeys.contains(key)) {
                result.define(value);
            }
        });
        return result;
    }

    private static ConfigDef commonConfigDef(ConfigDef firstConfig, ConfigDef secondConfig) {
        ConfigDef result = new ConfigDef();
        firstConfig.configKeys().forEach((key, value) -> {
            if (secondConfig.configKeys().keySet().contains(key)) {
                result.define(value);
            }
        });
        return result;
    }

    protected static void addWithPrefix(ConfigDef configDef, String prefix, ConfigDef toAdd) {
        configDef.embed(Objects.requireNonNull(prefix), "", configDef.configKeys().size(), Objects.requireNonNull(toAdd));
    }

    protected WorkerConfigDecorator(WorkerConfig workerConfig, WorkerConfigTransformer transformer) {
        this.workerConfig = Objects.requireNonNull(workerConfig);
        this.transformer = Objects.requireNonNull(transformer);
    }

    public Map<String, String> decorateConnectorConfig(String connectorName, Connector connector, ConfigDef configDef, Map<String, String> properties) {
        String connectorNameOrPlaceholder = connectorName == null ? "<unspecified>" : connectorName;
        Objects.requireNonNull(connector);
        Objects.requireNonNull(configDef);
        Objects.requireNonNull(properties);
        HashMap<String, String> decorated = new HashMap<String, String>(properties);
        PATTERNS.forEach(pattern -> {
            Map<String, String> injected = pattern.injectedConnectorProperties(this.workerConfig, connectorNameOrPlaceholder, configDef, properties);
            decorated.putAll(injected);
        });
        return decorated;
    }

    public ConfigInfos decorateValidationResult(String connectorName, Connector connector, ConfigDef configDef, Map<String, String> original, ConfigInfos validateResult) {
        String connectorNameOrPlaceholder = connectorName == null ? "<unspecified>" : connectorName;
        Objects.requireNonNull(connector);
        Objects.requireNonNull(configDef);
        Objects.requireNonNull(original);
        Objects.requireNonNull(validateResult);
        MutableConfigInfos infos = new MutableConfigInfos(validateResult);
        PATTERNS.forEach(pattern -> pattern.filterValidationResults(this.workerConfig, connectorNameOrPlaceholder, original, infos));
        infos.forEachErrorInRemoved(info -> log.debug("Found {} error(s) in injected property {}: {}", new Object[]{info.configValue().errors().size(), info.configValue().name(), info.configValue().errors()}));
        return infos.asConfigInfos();
    }

    protected static class LicensePropertiesDecorator
    extends DecorationPattern {
        public LicensePropertiesDecorator() {
            super("Confluent license");
        }

        @Override
        public boolean isEnabled(Map<String, String> workerConfig) {
            String enabledValue = workerConfig.get(WorkerConfigDecorator.CONFLUENT_INJECT_INTO_CONNECTORS_CONFIG);
            return enabledValue == null || Boolean.TRUE.equals(enabledValue) || "true".equalsIgnoreCase(enabledValue.toString().trim());
        }

        @Override
        public boolean addToWorkerConfig(ConfigDef workerConfigDef, Map<String, String> workerProps) {
            if (!this.isEnabled(workerProps)) {
                log.info("Confluent license injection into licensed connectors is disabled. Connectors must configure license-related properties");
                return false;
            }
            log.debug("Injecting Confluent license properties into worker config");
            Objects.requireNonNull(workerConfigDef).defineInternal(WorkerConfigDecorator.CONFLUENT_INJECT_INTO_CONNECTORS_CONFIG, ConfigDef.Type.BOOLEAN, (Object)Boolean.TRUE, ConfigDef.Importance.LOW).define(WorkerConfigDecorator.CONFLUENT_LICENSE_CONFIG, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.MEDIUM, "").define(WorkerConfigDecorator.CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Type.LIST, (Object)CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_DEFAULT, ConfigDef.Importance.MEDIUM, "").define(WorkerConfigDecorator.CONFLUENT_TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)WorkerConfigDecorator.CONFLUENT_TOPIC_DEFAULT, ConfigDef.Importance.LOW, "").define(WorkerConfigDecorator.CONFLUENT_TOPIC_REPLICATION_FACTOR_CONFIG, ConfigDef.Type.INT, (Object)3, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "");
            ConfigDef producerConfigs = WorkerConfigDecorator.without(ProducerConfig.configDef(), new String[]{"bootstrap.servers", "key.serializer", "value.serializer", "retries"});
            ConfigDef consumerConfigs = WorkerConfigDecorator.without(ConsumerConfig.configDef(), new String[]{"bootstrap.servers", "key.deserializer", "value.deserializer"});
            ConfigDef commonClientConfigs = WorkerConfigDecorator.commonConfigDef(producerConfigs, consumerConfigs);
            WorkerConfigDecorator.addWithPrefix(workerConfigDef, WorkerConfigDecorator.CONFLUENT_TOPIC_PREFIX, commonClientConfigs);
            WorkerConfigDecorator.addWithPrefix(workerConfigDef, WorkerConfigDecorator.CONFLUENT_TOPIC_PRODUCER_PREFIX, producerConfigs);
            WorkerConfigDecorator.addWithPrefix(workerConfigDef, WorkerConfigDecorator.CONFLUENT_TOPIC_CONSUMER_PREFIX, consumerConfigs);
            return true;
        }

        @Override
        protected boolean matchesInjectedProperty(String key) {
            return WorkerConfigDecorator.CONFLUENT_LICENSE_CONFIG.equals(key) || WorkerConfigDecorator.CONFLUENT_TOPIC_CONFIG.equals(key) || key.startsWith(WorkerConfigDecorator.CONFLUENT_TOPIC_PREFIX);
        }

        @Override
        public Map<String, String> computeInjectedProperties(WorkerConfig workerConfig, String connectorName, ConfigDef connectorConfigDef, Map<String, String> connectorConfig) {
            log.debug("Injecting Confluent license properties into '{}' connector configuration", (Object)connectorName);
            HashMap<String, String> injectable = new HashMap<String, String>();
            String bootstrap = (String)workerConfig.originalsStrings().get("bootstrap.servers");
            injectable.put(WorkerConfigDecorator.CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_CONFIG, bootstrap);
            injectable.put(WorkerConfigDecorator.CONFLUENT_LICENSE_CONFIG, workerConfig.getPassword(WorkerConfigDecorator.CONFLUENT_LICENSE_CONFIG).value());
            injectable.put(WorkerConfigDecorator.CONFLUENT_TOPIC_CONFIG, workerConfig.getString(WorkerConfigDecorator.CONFLUENT_TOPIC_CONFIG));
            injectable.put(WorkerConfigDecorator.CONFLUENT_TOPIC_REPLICATION_FACTOR_CONFIG, Integer.toString(workerConfig.getInt(WorkerConfigDecorator.CONFLUENT_TOPIC_REPLICATION_FACTOR_CONFIG)));
            Map originals = workerConfig.originals();
            originals.remove("group.id");
            this.addInherited(originals, injectable);
            this.addInherited(workerConfig.originalsWithPrefix(WorkerConfigDecorator.CONFLUENT_TOPIC_PREFIX), injectable);
            workerConfig.originalsStrings().entrySet().stream().filter(entry -> this.matchesInjectedProperty((String)entry.getKey())).forEach(entry -> {
                String cfr_ignored_0 = (String)injectable.put((String)entry.getKey(), (String)entry.getValue());
            });
            injectable.remove("confluent.topic.producer.bootstrap.servers");
            injectable.remove("confluent.topic.consumer.bootstrap.servers");
            injectable.remove("confluent.topic.producer.key.serializer");
            injectable.remove("confluent.topic.producer.value.serializer");
            injectable.remove("confluent.topic.producer.retries");
            injectable.remove("confluent.topic.producer.bootstrap.servers");
            injectable.remove("confluent.topic.consumer.bootstrap.servers");
            injectable.remove("confluent.topic.consumer.key.deserializer");
            injectable.remove("confluent.topic.consumer.value.deserializer");
            return injectable;
        }

        protected void addInherited(Map<String, ?> original, Map<String, String> result) {
            original.entrySet().forEach(entry -> this.addInherited((String)entry.getKey(), entry.getValue().toString(), result));
        }

        protected void addInherited(String key, String value, Map<String, String> result) {
            boolean producerProp = ProducerConfig.configNames().contains(key);
            boolean consumerProp = ConsumerConfig.configNames().contains(key);
            if (this.matchesInjectedProperty(key)) {
                result.put(key, value);
            } else if (producerProp && consumerProp) {
                result.put(WorkerConfigDecorator.CONFLUENT_TOPIC_PREFIX + key, value);
            } else if (producerProp) {
                result.put(WorkerConfigDecorator.CONFLUENT_TOPIC_PRODUCER_PREFIX + key, value);
            } else if (consumerProp) {
                result.put(WorkerConfigDecorator.CONFLUENT_TOPIC_CONSUMER_PREFIX + key, value);
            }
        }
    }

    protected static abstract class DecorationPattern {
        private final String patternName;

        protected DecorationPattern(String patternName) {
            this.patternName = Objects.requireNonNull(patternName);
        }

        public String patternName() {
            return this.patternName;
        }

        public boolean addToWorkerConfig(ConfigDef configDef, Map<String, String> workerProps) {
            return false;
        }

        public Map<String, String> injectedConnectorProperties(WorkerConfig workerConfig, String connectorName, ConfigDef connectorConfigDef, Map<String, String> connectorConfig) {
            if (!this.isEnabled(workerConfig.originalsStrings())) {
                log.debug("{} injection is disabled; injecting no properties into connector '{}'", (Object)this, (Object)connectorName);
                return Collections.emptyMap();
            }
            if (this.shouldInjectIntoConnector(workerConfig, connectorName, connectorConfigDef, connectorConfig)) {
                log.info("Injecting {} properties into connector '{}'", (Object)this.patternName(), (Object)connectorName);
                return this.computeInjectedProperties(workerConfig, connectorName, connectorConfigDef, connectorConfig);
            }
            return Collections.emptyMap();
        }

        public boolean filterValidationResults(WorkerConfig workerConfig, String connectorName, Map<String, String> originalConnectorConfig, MutableConfigInfos validationResults) {
            if (!this.isEnabled(workerConfig.originalsStrings())) {
                log.debug("{} injection is disabled; no filtering of validation results for connector '{}'", (Object)this, (Object)connectorName);
                return false;
            }
            if (!this.alreadyHasInjectedConnectorProperties(originalConnectorConfig) && validationResults.removeAllWithName(this::matchesInjectedProperty) > 0) {
                log.debug("Removing injected {} properties from validation results for connector '{}'", (Object)this.patternName(), (Object)connectorName);
                return true;
            }
            log.debug("Found 0 injected {} properties from validation results for connector '{}'", (Object)this.patternName(), (Object)connectorName);
            return false;
        }

        public boolean isEnabled(Map<String, String> workerConfig) {
            return true;
        }

        public String toString() {
            return this.patternName;
        }

        protected boolean shouldInjectIntoConnector(WorkerConfig config, String connectorName, ConfigDef connectorConfigDef, Map<String, String> connectorConfig) {
            return this.requiresInjectedConnectorProperties(connectorConfigDef) && !this.alreadyHasInjectedConnectorProperties(connectorConfig);
        }

        protected boolean requiresInjectedConnectorProperties(ConfigDef configDef) {
            return configDef.configKeys().keySet().stream().filter(Objects::nonNull).anyMatch(this::matchesInjectedProperty);
        }

        protected boolean alreadyHasInjectedConnectorProperties(Map<String, String> properties) {
            return properties.keySet().stream().anyMatch(this::matchesInjectedProperty);
        }

        protected abstract boolean matchesInjectedProperty(String var1);

        protected abstract Map<String, String> computeInjectedProperties(WorkerConfig var1, String var2, ConfigDef var3, Map<String, String> var4);
    }

    private static class MutableConfigInfos {
        private final ConfigInfos original;
        private final List<ConfigInfo> values;
        private final List<ConfigInfo> removed = new ArrayList<ConfigInfo>();

        public MutableConfigInfos(ConfigInfos original) {
            this.original = Objects.requireNonNull(original);
            this.values = this.original.values();
        }

        public int removeAllWithName(Predicate<String> keyPredicate) {
            return this.removeAll(info -> info == null || info.configValue() == null ? false : keyPredicate.test(info.configValue().name()));
        }

        public int removeAll(Predicate<ConfigInfo> predicate) {
            int removedCount = 0;
            Iterator<ConfigInfo> iter = this.values.iterator();
            while (iter.hasNext()) {
                ConfigInfo info = iter.next();
                if (info == null || !predicate.test(info)) continue;
                this.removed.add(info);
                iter.remove();
                ++removedCount;
            }
            return removedCount;
        }

        public void forEachErrorInRemoved(Consumer<ConfigInfo> handler) {
            this.removed.stream().forEach(handler);
        }

        public ConfigInfos asConfigInfos() {
            if (this.removed.isEmpty()) {
                return this.original;
            }
            AtomicInteger errorCount = new AtomicInteger();
            LinkedHashSet groups = new LinkedHashSet();
            this.values.forEach(configInfo -> {
                String group;
                if (configInfo.configKey() != null && (group = configInfo.configKey().group()) != null) {
                    groups.add(group);
                }
                errorCount.addAndGet(configInfo.configValue().errors().size());
            });
            return new ConfigInfos(this.original.name(), errorCount.get(), new ArrayList<String>(groups), this.values);
        }
    }
}

