/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerCoordinator;
import org.apache.kafka.clients.consumer.internals.ConsumerInterceptors;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.clients.consumer.internals.Fetcher;
import org.apache.kafka.clients.consumer.internals.NoOpConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.GroupCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockMetricsReporter;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class KafkaConsumerTest {
    private final String topic = "test";
    private final TopicPartition tp0 = new TopicPartition("test", 0);
    private final TopicPartition tp1 = new TopicPartition("test", 1);
    private final String topic2 = "test2";
    private final TopicPartition t2p0 = new TopicPartition("test2", 0);
    private final String topic3 = "test3";
    private final TopicPartition t3p0 = new TopicPartition("test3", 0);

    @Test
    public void testConstructorClose() throws Exception {
        Properties props = new Properties();
        props.setProperty("client.id", "testConstructorClose");
        props.setProperty("bootstrap.servers", "some.invalid.hostname.foo.bar:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        int oldInitCount = MockMetricsReporter.INIT_COUNT.get();
        int oldCloseCount = MockMetricsReporter.CLOSE_COUNT.get();
        try {
            new KafkaConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        }
        catch (KafkaException e) {
            Assert.assertEquals((long)(oldInitCount + 1), (long)MockMetricsReporter.INIT_COUNT.get());
            Assert.assertEquals((long)(oldCloseCount + 1), (long)MockMetricsReporter.CLOSE_COUNT.get());
            Assert.assertEquals((Object)"Failed to construct kafka consumer", (Object)e.getMessage());
            return;
        }
        Assert.fail((String)"should have caught an exception and returned");
    }

    @Test
    public void testOsDefaultSocketBufferSizes() throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", "localhost:9999");
        config.put("send.buffer.bytes", -1);
        config.put("receive.buffer.bytes", -1);
        KafkaConsumer consumer = new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        consumer.close();
    }

    @Test(expected=KafkaException.class)
    public void testInvalidSocketSendBufferSize() throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", "localhost:9999");
        config.put("send.buffer.bytes", -2);
        new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    @Test(expected=KafkaException.class)
    public void testInvalidSocketReceiveBufferSize() throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", "localhost:9999");
        config.put("receive.buffer.bytes", -2);
        new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    @Test
    public void testSubscription() {
        KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();
        consumer.subscribe(Collections.singletonList("test"));
        Assert.assertEquals(Collections.singleton("test"), (Object)consumer.subscription());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        consumer.subscribe(Collections.emptyList());
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        consumer.assign(Collections.singletonList(this.tp0));
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        consumer.unsubscribe();
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        consumer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testSubscriptionOnNullTopicCollection() {
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.subscribe(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testSubscriptionOnNullTopic() {
        Object nullTopic = null;
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.subscribe(Collections.singletonList(nullTopic));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testSubscriptionOnEmptyTopic() {
        String emptyTopic = "  ";
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.subscribe(Collections.singletonList(emptyTopic));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testSubscriptionOnNullPattern() {
        Pattern pattern = null;
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.subscribe(pattern, (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testSeekNegative() {
        Properties props = new Properties();
        props.setProperty("client.id", "testSeekNegative");
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.assign(Arrays.asList(new TopicPartition("nonExistTopic", 0)));
            consumer.seek(new TopicPartition("nonExistTopic", 0), -1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testAssignOnNullTopicPartition() {
        Properties props = new Properties();
        props.setProperty("client.id", "testAssignOnNullTopicPartition");
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.assign(null);
        }
    }

    @Test
    public void testAssignOnEmptyTopicPartition() {
        KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();
        consumer.assign(Collections.emptyList());
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        consumer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testAssignOnNullTopicInPartition() {
        Properties props = new Properties();
        props.setProperty("client.id", "testAssignOnNullTopicInPartition");
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.assign(Arrays.asList(new TopicPartition(null, 0)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testAssignOnEmptyTopicInPartition() {
        Properties props = new Properties();
        props.setProperty("client.id", "testAssignOnEmptyTopicInPartition");
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.assign(Arrays.asList(new TopicPartition("  ", 0)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterceptorConstructorClose() throws Exception {
        try {
            Properties props = new Properties();
            props.setProperty("bootstrap.servers", "localhost:9999");
            props.setProperty("interceptor.classes", MockConsumerInterceptor.class.getName());
            KafkaConsumer consumer = new KafkaConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            Assert.assertEquals((long)1L, (long)MockConsumerInterceptor.INIT_COUNT.get());
            Assert.assertEquals((long)0L, (long)MockConsumerInterceptor.CLOSE_COUNT.get());
            consumer.close();
            Assert.assertEquals((long)1L, (long)MockConsumerInterceptor.INIT_COUNT.get());
            Assert.assertEquals((long)1L, (long)MockConsumerInterceptor.CLOSE_COUNT.get());
            Assert.assertNull((Object)MockConsumerInterceptor.CLUSTER_META.get());
        }
        finally {
            MockConsumerInterceptor.resetCounters();
        }
    }

    @Test
    public void testPause() {
        KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();
        consumer.assign(Collections.singletonList(this.tp0));
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        Assert.assertTrue((boolean)consumer.paused().isEmpty());
        consumer.pause(Collections.singleton(this.tp0));
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.paused());
        consumer.resume(Collections.singleton(this.tp0));
        Assert.assertTrue((boolean)consumer.paused().isEmpty());
        consumer.unsubscribe();
        Assert.assertTrue((boolean)consumer.paused().isEmpty());
        consumer.close();
    }

    private KafkaConsumer<byte[], byte[]> newConsumer() {
        Properties props = new Properties();
        props.setProperty("client.id", "my.consumer");
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        return new KafkaConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    @Test
    public void verifyHeartbeatSent() throws Exception {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 1000;
        int autoCommitIntervalMs = 10000;
        MockTime time = new MockTime();
        Cluster cluster = TestUtils.singletonCluster("test", 1);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
        metadata.update(cluster, time.milliseconds());
        MockClient client = new MockClient(time);
        client.setNode(node);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        consumer.subscribe(Arrays.asList("test"), this.getConsumerRebalanceListener(consumer));
        Node coordinator = this.prepareRebalance(client, node, (PartitionAssignor)assignor, Arrays.asList(this.tp0), null);
        client.prepareResponseFrom(this.fetchResponse(this.tp0, 0L, 0), node);
        consumer.poll(0L);
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        AtomicBoolean heartbeatReceived = this.prepareHeartbeatResponse(client, coordinator);
        time.sleep(heartbeatIntervalMs);
        Thread.sleep(heartbeatIntervalMs);
        consumer.poll(0L);
        Assert.assertTrue((boolean)heartbeatReceived.get());
    }

    @Test
    public void verifyHeartbeatSentWhenFetchedDataReady() throws Exception {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 1000;
        int autoCommitIntervalMs = 10000;
        MockTime time = new MockTime();
        Cluster cluster = TestUtils.singletonCluster("test", 1);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
        metadata.update(cluster, time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        consumer.subscribe(Arrays.asList("test"), this.getConsumerRebalanceListener(consumer));
        Node coordinator = this.prepareRebalance(client, node, (PartitionAssignor)assignor, Arrays.asList(this.tp0), null);
        consumer.poll(0L);
        client.respondFrom(this.fetchResponse(this.tp0, 0L, 5), node);
        client.poll(0L, time.milliseconds());
        client.prepareResponseFrom(this.fetchResponse(this.tp0, 5L, 0), node);
        AtomicBoolean heartbeatReceived = this.prepareHeartbeatResponse(client, coordinator);
        time.sleep(heartbeatIntervalMs);
        Thread.sleep(heartbeatIntervalMs);
        consumer.poll(0L);
        Assert.assertTrue((boolean)heartbeatReceived.get());
    }

    @Test
    public void verifyNoCoordinatorLookupForManualAssignmentWithSeek() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 3000;
        int heartbeatIntervalMs = 2000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        Cluster cluster = TestUtils.singletonCluster("test", 1);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
        metadata.update(cluster, time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        consumer.assign(Arrays.asList(this.tp0));
        consumer.seekToBeginning(Arrays.asList(this.tp0));
        client.prepareResponse(this.listOffsetsResponse(Collections.singletonMap(this.tp0, 50L), Errors.NONE.code()));
        client.prepareResponse(this.fetchResponse(this.tp0, 50L, 5));
        ConsumerRecords records = consumer.poll(0L);
        Assert.assertEquals((long)5L, (long)records.count());
        Assert.assertEquals((long)55L, (long)consumer.position(this.tp0));
    }

    @Test
    public void testCommitsFetchedDuringAssign() {
        long offset1 = 10000L;
        long offset2 = 20000L;
        int rebalanceTimeoutMs = 6000;
        int sessionTimeoutMs = 3000;
        int heartbeatIntervalMs = 2000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        Cluster cluster = TestUtils.singletonCluster("test", 1);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
        metadata.update(cluster, time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        consumer.assign(Arrays.asList(this.tp0));
        client.prepareResponseFrom(new GroupCoordinatorResponse(Errors.NONE.code(), node).toStruct(), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom(this.offsetResponse(Collections.singletonMap(this.tp0, offset1), Errors.NONE.code()), coordinator);
        Assert.assertEquals((long)offset1, (long)consumer.committed(this.tp0).offset());
        consumer.assign(Arrays.asList(this.tp0, this.tp1));
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        offsets.put(this.tp0, offset1);
        offsets.put(this.tp1, offset2);
        client.prepareResponseFrom(this.offsetResponse(offsets, Errors.NONE.code()), coordinator);
        Assert.assertEquals((long)offset1, (long)consumer.committed(this.tp0).offset());
        Assert.assertEquals((long)offset2, (long)consumer.committed(this.tp1).offset());
    }

    @Test
    public void testAutoCommitSentBeforePositionUpdate() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        Cluster cluster = TestUtils.singletonCluster("test", 1);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
        metadata.update(cluster, time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        consumer.subscribe(Arrays.asList("test"), this.getConsumerRebalanceListener(consumer));
        Node coordinator = this.prepareRebalance(client, node, (PartitionAssignor)assignor, Arrays.asList(this.tp0), null);
        consumer.poll(0L);
        client.respondFrom(this.fetchResponse(this.tp0, 0L, 5), node);
        client.poll(0L, time.milliseconds());
        time.sleep(autoCommitIntervalMs);
        client.prepareResponseFrom(this.fetchResponse(this.tp0, 5L, 0), node);
        AtomicBoolean commitReceived = this.prepareOffsetCommitResponse(client, coordinator, this.tp0, 0L);
        consumer.poll(0L);
        Assert.assertTrue((boolean)commitReceived.get());
    }

    @Test
    public void testRegexSubscription() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        String unmatchedTopic = "unmatched";
        MockTime time = new MockTime();
        HashMap<String, Integer> topicMetadata = new HashMap<String, Integer>();
        topicMetadata.put("test", 1);
        topicMetadata.put(unmatchedTopic, 1);
        Cluster cluster = TestUtils.clusterWith(1, topicMetadata);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
        Node node = (Node)cluster.nodes().get(0);
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        this.prepareRebalance(client, node, Collections.singleton("test"), (PartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        consumer.subscribe(Pattern.compile("test"), this.getConsumerRebalanceListener(consumer));
        client.prepareMetadataUpdate(cluster);
        consumer.poll(0L);
        Assert.assertEquals(Collections.singleton("test"), (Object)consumer.subscription());
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
    }

    @Test
    public void testChangingRegexSubscription() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        String otherTopic = "other";
        TopicPartition otherTopicPartition = new TopicPartition(otherTopic, 0);
        MockTime time = new MockTime();
        HashMap<String, Integer> topicMetadata = new HashMap<String, Integer>();
        topicMetadata.put("test", 1);
        topicMetadata.put(otherTopic, 1);
        Cluster cluster = TestUtils.clusterWith(1, topicMetadata);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
        Node node = (Node)cluster.nodes().get(0);
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        metadata.update(cluster, time.milliseconds());
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, false, autoCommitIntervalMs);
        Node coordinator = this.prepareRebalance(client, node, Collections.singleton("test"), (PartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        consumer.subscribe(Pattern.compile("test"), this.getConsumerRebalanceListener(consumer));
        client.prepareMetadataUpdate(cluster);
        consumer.poll(0L);
        Assert.assertEquals(Collections.singleton("test"), (Object)consumer.subscription());
        consumer.subscribe(Pattern.compile(otherTopic), this.getConsumerRebalanceListener(consumer));
        client.prepareMetadataUpdate(cluster);
        this.prepareRebalance(client, node, Collections.singleton(otherTopic), (PartitionAssignor)assignor, Collections.singletonList(otherTopicPartition), coordinator);
        consumer.poll(0L);
        Assert.assertEquals(Collections.singleton(otherTopic), (Object)consumer.subscription());
    }

    @Test
    public void testWakeupWithFetchDataAvailable() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        Cluster cluster = TestUtils.singletonCluster("test", 1);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
        metadata.update(cluster, time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RoundRobinAssignor assignor = new RoundRobinAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        consumer.subscribe(Arrays.asList("test"), this.getConsumerRebalanceListener(consumer));
        this.prepareRebalance(client, node, (PartitionAssignor)assignor, Arrays.asList(this.tp0), null);
        consumer.poll(0L);
        client.respondFrom(this.fetchResponse(this.tp0, 0L, 5), node);
        client.poll(0L, time.milliseconds());
        consumer.wakeup();
        try {
            consumer.poll(0L);
            Assert.fail();
        }
        catch (WakeupException wakeupException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)consumer.position(this.tp0));
        ConsumerRecords records = consumer.poll(0L);
        Assert.assertEquals((long)5L, (long)records.count());
    }

    @Test
    public void fetchResponseWithUnexpectedPartitionIsIgnored() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        Cluster cluster = TestUtils.singletonCluster(Collections.singletonMap("test", 1));
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
        metadata.update(cluster, time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RangeAssignor assignor = new RangeAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        consumer.subscribe(Collections.singletonList("test"), this.getConsumerRebalanceListener(consumer));
        this.prepareRebalance(client, node, (PartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        HashMap<TopicPartition, FetchInfo> fetches1 = new HashMap<TopicPartition, FetchInfo>();
        fetches1.put(this.tp0, new FetchInfo(0L, 1));
        fetches1.put(this.t2p0, new FetchInfo(0L, 10));
        client.prepareResponseFrom(this.fetchResponse(fetches1), node);
        ConsumerRecords records = consumer.poll(0L);
        Assert.assertEquals((long)0L, (long)records.count());
    }

    @Test
    public void testSubscriptionChangesWithAutoCommitEnabled() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        HashMap<String, Integer> tpCounts = new HashMap<String, Integer>();
        tpCounts.put("test", 1);
        tpCounts.put("test2", 1);
        tpCounts.put("test3", 1);
        Cluster cluster = TestUtils.singletonCluster(tpCounts);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
        metadata.update(cluster, time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RangeAssignor assignor = new RangeAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        consumer.subscribe(Arrays.asList("test", "test2"), this.getConsumerRebalanceListener(consumer));
        Assert.assertTrue((consumer.subscription().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((consumer.subscription().contains("test") && consumer.subscription().contains("test2") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        Node coordinator = this.prepareRebalance(client, node, (PartitionAssignor)assignor, Arrays.asList(this.tp0, this.t2p0), null);
        consumer.poll(0L);
        Assert.assertTrue((consumer.subscription().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((consumer.subscription().contains("test") && consumer.subscription().contains("test2") ? 1 : 0) != 0);
        Assert.assertTrue((consumer.assignment().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((consumer.assignment().contains(this.tp0) && consumer.assignment().contains(this.t2p0) ? 1 : 0) != 0);
        HashMap<TopicPartition, FetchInfo> fetches1 = new HashMap<TopicPartition, FetchInfo>();
        fetches1.put(this.tp0, new FetchInfo(0L, 1));
        fetches1.put(this.t2p0, new FetchInfo(0L, 10));
        client.respondFrom(this.fetchResponse(fetches1), node);
        client.poll(0L, time.milliseconds());
        ConsumerRecords records = consumer.poll(0L);
        fetches1.put(this.tp0, new FetchInfo(1L, 0));
        fetches1.put(this.t2p0, new FetchInfo(10L, 0));
        client.respondFrom(this.fetchResponse(fetches1), node);
        client.poll(0L, time.milliseconds());
        Assert.assertEquals((long)11L, (long)records.count());
        Assert.assertEquals((long)1L, (long)consumer.position(this.tp0));
        Assert.assertEquals((long)10L, (long)consumer.position(this.t2p0));
        consumer.subscribe(Arrays.asList("test", "test3"), this.getConsumerRebalanceListener(consumer));
        Assert.assertTrue((consumer.subscription().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((consumer.subscription().contains("test") && consumer.subscription().contains("test3") ? 1 : 0) != 0);
        Assert.assertTrue((consumer.assignment().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((consumer.assignment().contains(this.tp0) && consumer.assignment().contains(this.t2p0) ? 1 : 0) != 0);
        HashMap<TopicPartition, Long> partitionOffsets1 = new HashMap<TopicPartition, Long>();
        partitionOffsets1.put(this.tp0, 1L);
        partitionOffsets1.put(this.t2p0, 10L);
        AtomicBoolean commitReceived = this.prepareOffsetCommitResponse(client, coordinator, partitionOffsets1);
        this.prepareRebalance(client, node, (PartitionAssignor)assignor, Arrays.asList(this.tp0, this.t3p0), coordinator);
        HashMap<TopicPartition, FetchInfo> fetches2 = new HashMap<TopicPartition, FetchInfo>();
        fetches2.put(this.tp0, new FetchInfo(1L, 1));
        fetches2.put(this.t3p0, new FetchInfo(0L, 100));
        client.prepareResponse(this.fetchResponse(fetches2));
        records = consumer.poll(0L);
        Assert.assertEquals((long)101L, (long)records.count());
        Assert.assertEquals((long)2L, (long)consumer.position(this.tp0));
        Assert.assertEquals((long)100L, (long)consumer.position(this.t3p0));
        Assert.assertTrue((boolean)commitReceived.get());
        Assert.assertTrue((consumer.subscription().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((consumer.subscription().contains("test") && consumer.subscription().contains("test3") ? 1 : 0) != 0);
        Assert.assertTrue((consumer.assignment().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((consumer.assignment().contains(this.tp0) && consumer.assignment().contains(this.t3p0) ? 1 : 0) != 0);
        consumer.unsubscribe();
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        consumer.close();
    }

    @Test
    public void testSubscriptionChangesWithAutoCommitDisabled() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        HashMap<String, Integer> tpCounts = new HashMap<String, Integer>();
        tpCounts.put("test", 1);
        tpCounts.put("test2", 1);
        Cluster cluster = TestUtils.singletonCluster(tpCounts);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
        metadata.update(cluster, time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RangeAssignor assignor = new RangeAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, false, autoCommitIntervalMs);
        consumer.subscribe(Arrays.asList("test"), this.getConsumerRebalanceListener(consumer));
        Assert.assertTrue((boolean)consumer.subscription().equals(Collections.singleton("test")));
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        this.prepareRebalance(client, node, (PartitionAssignor)assignor, Arrays.asList(this.tp0), null);
        consumer.poll(0L);
        Assert.assertTrue((boolean)consumer.subscription().equals(Collections.singleton("test")));
        Assert.assertTrue((boolean)consumer.assignment().equals(Collections.singleton(this.tp0)));
        consumer.poll(0L);
        consumer.subscribe(Arrays.asList("test2"), this.getConsumerRebalanceListener(consumer));
        Assert.assertTrue((boolean)consumer.subscription().equals(Collections.singleton("test2")));
        Assert.assertTrue((boolean)consumer.assignment().equals(Collections.singleton(this.tp0)));
        for (ClientRequest req : client.requests()) {
            Assert.assertTrue((req.request().header().apiKey() != ApiKeys.OFFSET_COMMIT.id ? 1 : 0) != 0);
        }
        consumer.unsubscribe();
        Assert.assertTrue((boolean)consumer.subscription().isEmpty());
        Assert.assertTrue((boolean)consumer.assignment().isEmpty());
        for (ClientRequest req : client.requests()) {
            Assert.assertTrue((req.request().header().apiKey() != ApiKeys.OFFSET_COMMIT.id ? 1 : 0) != 0);
        }
        consumer.close();
    }

    @Test
    public void testManualAssignmentChangeWithAutoCommitEnabled() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        HashMap<String, Integer> tpCounts = new HashMap<String, Integer>();
        tpCounts.put("test", 1);
        tpCounts.put("test2", 1);
        Cluster cluster = TestUtils.singletonCluster(tpCounts);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
        metadata.update(cluster, time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RangeAssignor assignor = new RangeAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, true, autoCommitIntervalMs);
        client.prepareResponseFrom(new GroupCoordinatorResponse(Errors.NONE.code(), node).toStruct(), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        consumer.assign(Arrays.asList(this.tp0));
        consumer.seekToBeginning(Arrays.asList(this.tp0));
        client.prepareResponseFrom(this.offsetResponse(Collections.singletonMap(this.tp0, 0L), Errors.NONE.code()), coordinator);
        Assert.assertEquals((long)0L, (long)consumer.committed(this.tp0).offset());
        Assert.assertTrue((boolean)consumer.assignment().equals(Collections.singleton(this.tp0)));
        client.prepareResponse(this.listOffsetsResponse(Collections.singletonMap(this.tp0, 10L), Errors.NONE.code()));
        client.prepareResponse(this.fetchResponse(this.tp0, 10L, 1));
        ConsumerRecords records = consumer.poll(0L);
        Assert.assertEquals((long)1L, (long)records.count());
        Assert.assertEquals((long)11L, (long)consumer.position(this.tp0));
        AtomicBoolean commitReceived = this.prepareOffsetCommitResponse(client, coordinator, this.tp0, 11L);
        consumer.assign(Arrays.asList(this.t2p0));
        Assert.assertTrue((boolean)consumer.assignment().equals(Collections.singleton(this.t2p0)));
        Assert.assertTrue((boolean)commitReceived.get());
        consumer.close();
    }

    @Test
    public void testManualAssignmentChangeWithAutoCommitDisabled() {
        int rebalanceTimeoutMs = 60000;
        int sessionTimeoutMs = 30000;
        int heartbeatIntervalMs = 3000;
        int autoCommitIntervalMs = 1000;
        MockTime time = new MockTime();
        HashMap<String, Integer> tpCounts = new HashMap<String, Integer>();
        tpCounts.put("test", 1);
        tpCounts.put("test2", 1);
        Cluster cluster = TestUtils.singletonCluster(tpCounts);
        Node node = (Node)cluster.nodes().get(0);
        Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
        metadata.update(cluster, time.milliseconds());
        MockClient client = new MockClient(time, metadata);
        client.setNode(node);
        RangeAssignor assignor = new RangeAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(time, client, metadata, (PartitionAssignor)assignor, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, false, autoCommitIntervalMs);
        client.prepareResponseFrom(new GroupCoordinatorResponse(Errors.NONE.code(), node).toStruct(), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        consumer.assign(Arrays.asList(this.tp0));
        consumer.seekToBeginning(Arrays.asList(this.tp0));
        client.prepareResponseFrom(this.offsetResponse(Collections.singletonMap(this.tp0, 0L), Errors.NONE.code()), coordinator);
        Assert.assertEquals((long)0L, (long)consumer.committed(this.tp0).offset());
        Assert.assertTrue((boolean)consumer.assignment().equals(Collections.singleton(this.tp0)));
        client.prepareResponse(this.listOffsetsResponse(Collections.singletonMap(this.tp0, 10L), Errors.NONE.code()));
        client.prepareResponse(this.fetchResponse(this.tp0, 10L, 1));
        ConsumerRecords records = consumer.poll(0L);
        Assert.assertEquals((long)1L, (long)records.count());
        Assert.assertEquals((long)11L, (long)consumer.position(this.tp0));
        consumer.assign(Arrays.asList(this.t2p0));
        Assert.assertTrue((boolean)consumer.assignment().equals(Collections.singleton(this.t2p0)));
        for (ClientRequest req : client.requests()) {
            Assert.assertTrue((req.request().header().apiKey() != ApiKeys.OFFSET_COMMIT.id ? 1 : 0) != 0);
        }
        consumer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testPollWithNoSubscription() {
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.poll(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testPollWithEmptySubscription() {
        consumer.subscribe(Collections.emptyList());
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.poll(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testPollWithEmptyUserAssignment() {
        consumer.assign(Collections.emptySet());
        try (KafkaConsumer<byte[], byte[]> consumer = this.newConsumer();){
            consumer.poll(0L);
        }
    }

    private ConsumerRebalanceListener getConsumerRebalanceListener(final KafkaConsumer<String, String> consumer) {
        return new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                for (TopicPartition partition : partitions) {
                    consumer.seek(partition, 0L);
                }
            }
        };
    }

    private Node prepareRebalance(MockClient client, Node node, final Set<String> subscribedTopics, PartitionAssignor assignor, List<TopicPartition> partitions, Node coordinator) {
        if (coordinator == null) {
            client.prepareResponseFrom(new GroupCoordinatorResponse(Errors.NONE.code(), node).toStruct(), node);
            coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        }
        client.prepareResponseFrom(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(ClientRequest request) {
                JoinGroupRequest joinGroupRequest = new JoinGroupRequest(request.request().body());
                PartitionAssignor.Subscription subscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)((JoinGroupRequest.ProtocolMetadata)joinGroupRequest.groupProtocols().get(0)).metadata());
                return subscribedTopics.equals(new HashSet(subscription.topics()));
            }
        }, this.joinGroupFollowerResponse(assignor, 1, "memberId", "leaderId", Errors.NONE.code()), coordinator);
        client.prepareResponseFrom(this.syncGroupResponse(partitions, Errors.NONE.code()), coordinator);
        return coordinator;
    }

    private Node prepareRebalance(MockClient client, Node node, PartitionAssignor assignor, List<TopicPartition> partitions, Node coordinator) {
        if (coordinator == null) {
            client.prepareResponseFrom(new GroupCoordinatorResponse(Errors.NONE.code(), node).toStruct(), node);
            coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        }
        client.prepareResponseFrom(this.joinGroupFollowerResponse(assignor, 1, "memberId", "leaderId", Errors.NONE.code()), coordinator);
        client.prepareResponseFrom(this.syncGroupResponse(partitions, Errors.NONE.code()), coordinator);
        return coordinator;
    }

    private AtomicBoolean prepareHeartbeatResponse(MockClient client, Node coordinator) {
        final AtomicBoolean heartbeatReceived = new AtomicBoolean(false);
        client.prepareResponseFrom(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(ClientRequest request) {
                heartbeatReceived.set(true);
                return true;
            }
        }, new HeartbeatResponse(Errors.NONE.code()).toStruct(), coordinator);
        return heartbeatReceived;
    }

    private AtomicBoolean prepareOffsetCommitResponse(MockClient client, Node coordinator, final Map<TopicPartition, Long> partitionOffsets) {
        final AtomicBoolean commitReceived = new AtomicBoolean(true);
        HashMap<TopicPartition, Short> response = new HashMap<TopicPartition, Short>();
        for (TopicPartition partition : partitionOffsets.keySet()) {
            response.put(partition, Errors.NONE.code());
        }
        client.prepareResponseFrom(new MockClient.RequestMatcher(){

            @Override
            public boolean matches(ClientRequest request) {
                OffsetCommitRequest commitRequest = new OffsetCommitRequest(request.request().body());
                for (Map.Entry partitionOffset : partitionOffsets.entrySet()) {
                    OffsetCommitRequest.PartitionData partitionData = (OffsetCommitRequest.PartitionData)commitRequest.offsetData().get(partitionOffset.getKey());
                    if (partitionData.offset == (Long)partitionOffset.getValue()) continue;
                    commitReceived.set(false);
                    return false;
                }
                return true;
            }
        }, this.offsetCommitResponse(response), coordinator);
        return commitReceived;
    }

    private AtomicBoolean prepareOffsetCommitResponse(MockClient client, Node coordinator, TopicPartition partition, long offset) {
        return this.prepareOffsetCommitResponse(client, coordinator, Collections.singletonMap(partition, offset));
    }

    private Struct offsetCommitResponse(Map<TopicPartition, Short> responseData) {
        OffsetCommitResponse response = new OffsetCommitResponse(responseData);
        return response.toStruct();
    }

    private Struct joinGroupFollowerResponse(PartitionAssignor assignor, int generationId, String memberId, String leaderId, short error) {
        return new JoinGroupResponse(error, generationId, assignor.name(), memberId, leaderId, Collections.emptyMap()).toStruct();
    }

    private Struct syncGroupResponse(List<TopicPartition> partitions, short error) {
        ByteBuffer buf = ConsumerProtocol.serializeAssignment((PartitionAssignor.Assignment)new PartitionAssignor.Assignment(partitions));
        return new SyncGroupResponse(error, buf).toStruct();
    }

    private Struct offsetResponse(Map<TopicPartition, Long> offsets, short error) {
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> partitionData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        for (Map.Entry<TopicPartition, Long> entry : offsets.entrySet()) {
            partitionData.put(entry.getKey(), new OffsetFetchResponse.PartitionData(entry.getValue().longValue(), "", error));
        }
        return new OffsetFetchResponse(partitionData).toStruct();
    }

    private Struct listOffsetsResponse(Map<TopicPartition, Long> offsets, short error) {
        HashMap<TopicPartition, ListOffsetResponse.PartitionData> partitionData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
        for (Map.Entry<TopicPartition, Long> partitionOffset : offsets.entrySet()) {
            partitionData.put(partitionOffset.getKey(), new ListOffsetResponse.PartitionData(error, 1L, partitionOffset.getValue().longValue()));
        }
        return new ListOffsetResponse(partitionData, 1).toStruct();
    }

    private Struct fetchResponse(Map<TopicPartition, FetchInfo> fetches) {
        HashMap<TopicPartition, FetchResponse.PartitionData> tpResponses = new HashMap<TopicPartition, FetchResponse.PartitionData>();
        for (Map.Entry<TopicPartition, FetchInfo> fetchEntry : fetches.entrySet()) {
            TopicPartition partition = fetchEntry.getKey();
            long fetchOffset = fetchEntry.getValue().offset;
            int fetchCount = fetchEntry.getValue().count;
            MemoryRecords records = MemoryRecords.emptyRecords((ByteBuffer)ByteBuffer.allocate(1024), (CompressionType)CompressionType.NONE);
            for (int i = 0; i < fetchCount; ++i) {
                records.append(fetchOffset + (long)i, 0L, ("key-" + i).getBytes(), ("value-" + i).getBytes());
            }
            records.close();
            tpResponses.put(partition, new FetchResponse.PartitionData(Errors.NONE.code(), 0L, records.buffer()));
        }
        FetchResponse response = new FetchResponse(tpResponses, 0);
        return response.toStruct();
    }

    private Struct fetchResponse(TopicPartition partition, long fetchOffset, int count) {
        FetchInfo fetchInfo = new FetchInfo(fetchOffset, count);
        return this.fetchResponse(Collections.singletonMap(partition, fetchInfo));
    }

    private KafkaConsumer<String, String> newConsumer(Time time, KafkaClient client, Metadata metadata, PartitionAssignor assignor, int rebalanceTimeoutMs, int sessionTimeoutMs, int heartbeatIntervalMs, boolean autoCommitEnabled, int autoCommitIntervalMs) {
        String clientId = "mock-consumer";
        String groupId = "mock-group";
        String metricGroupPrefix = "consumer";
        long retryBackoffMs = 100L;
        long requestTimeoutMs = 30000L;
        boolean excludeInternalTopics = true;
        int minBytes = 1;
        int maxBytes = Integer.MAX_VALUE;
        int maxWaitMs = 500;
        int fetchSize = 0x100000;
        int maxPollRecords = Integer.MAX_VALUE;
        boolean checkCrcs = true;
        StringDeserializer keyDeserializer = new StringDeserializer();
        StringDeserializer valueDeserializer = new StringDeserializer();
        OffsetResetStrategy autoResetStrategy = OffsetResetStrategy.EARLIEST;
        ConsumerCoordinator.DefaultOffsetCommitCallback defaultCommitCallback = new ConsumerCoordinator.DefaultOffsetCommitCallback();
        List<PartitionAssignor> assignors = Arrays.asList(assignor);
        ConsumerInterceptors interceptors = null;
        Metrics metrics = new Metrics();
        SubscriptionState subscriptions = new SubscriptionState(autoResetStrategy);
        ConsumerNetworkClient consumerClient = new ConsumerNetworkClient(client, metadata, time, retryBackoffMs, requestTimeoutMs);
        ConsumerCoordinator consumerCoordinator = new ConsumerCoordinator(consumerClient, groupId, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, assignors, metadata, subscriptions, metrics, metricGroupPrefix, time, retryBackoffMs, (OffsetCommitCallback)defaultCommitCallback, autoCommitEnabled, autoCommitIntervalMs, interceptors, excludeInternalTopics);
        Fetcher fetcher = new Fetcher(consumerClient, minBytes, maxBytes, maxWaitMs, fetchSize, maxPollRecords, checkCrcs, (Deserializer)keyDeserializer, (Deserializer)valueDeserializer, metadata, subscriptions, metrics, metricGroupPrefix, time, retryBackoffMs);
        return new KafkaConsumer(clientId, consumerCoordinator, (Deserializer)keyDeserializer, (Deserializer)valueDeserializer, fetcher, interceptors, time, consumerClient, metrics, subscriptions, metadata, retryBackoffMs, requestTimeoutMs);
    }

    private static class FetchInfo {
        long offset;
        int count;

        FetchInfo(long offset, int count) {
            this.offset = offset;
            this.count = count;
        }
    }
}

