/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.Utils;

public class MetadataRequest
extends AbstractRequest {
    private static final String TOPICS_KEY_NAME = "topics";
    private final List<String> topics;

    public static MetadataRequest allTopics(short version) {
        return (MetadataRequest)new Builder(null).setVersion(version).build();
    }

    public MetadataRequest(List<String> topics, short version) {
        super(new Struct(ProtoUtils.requestSchema(ApiKeys.METADATA.id, version)), version);
        if (topics == null) {
            this.struct.set(TOPICS_KEY_NAME, null);
        } else {
            this.struct.set(TOPICS_KEY_NAME, (Object)topics.toArray());
        }
        this.topics = topics;
    }

    public MetadataRequest(Struct struct, short version) {
        super(struct, version);
        Object[] topicArray = struct.getArray(TOPICS_KEY_NAME);
        if (topicArray != null) {
            this.topics = new ArrayList<String>();
            for (Object topicObj : topicArray) {
                this.topics.add((String)topicObj);
            }
        } else {
            this.topics = null;
        }
    }

    @Override
    public AbstractResponse getErrorResponse(Throwable e) {
        ArrayList<MetadataResponse.TopicMetadata> topicMetadatas = new ArrayList<MetadataResponse.TopicMetadata>();
        Errors error = Errors.forException(e);
        List<MetadataResponse.PartitionMetadata> partitions = Collections.emptyList();
        if (this.topics != null) {
            for (String topic : this.topics) {
                topicMetadatas.add(new MetadataResponse.TopicMetadata(error, topic, false, partitions));
            }
        }
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: 
            case 2: {
                return new MetadataResponse(Collections.emptyList(), null, -1, topicMetadatas, versionId);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.METADATA.id)));
    }

    public boolean isAllTopics() {
        return this.topics == null;
    }

    public List<String> topics() {
        return this.topics;
    }

    public static MetadataRequest parse(ByteBuffer buffer, int versionId) {
        return new MetadataRequest(ProtoUtils.parseRequest(ApiKeys.METADATA.id, versionId, buffer), (short)versionId);
    }

    public static MetadataRequest parse(ByteBuffer buffer) {
        return MetadataRequest.parse(buffer, ProtoUtils.latestVersion(ApiKeys.METADATA.id));
    }

    public static class Builder
    extends AbstractRequest.Builder<MetadataRequest> {
        private static final List<String> ALL_TOPICS = null;
        private final List<String> topics;

        public static Builder allTopics() {
            return new Builder(ALL_TOPICS);
        }

        public Builder(List<String> topics) {
            super(ApiKeys.METADATA);
            this.topics = topics;
        }

        public List<String> topics() {
            return this.topics;
        }

        public boolean isAllTopics() {
            return this.topics == ALL_TOPICS;
        }

        @Override
        public MetadataRequest build() {
            short version = this.version();
            if (version < 1) {
                throw new UnsupportedVersionException("MetadataRequest versions older than 1 are not supported.");
            }
            return new MetadataRequest(this.topics, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=MetadataRequest").append(", topics=");
            if (this.topics == null) {
                bld.append("<ALL>");
            } else {
                bld.append(Utils.join(this.topics, ","));
            }
            bld.append(")");
            return bld.toString();
        }
    }
}

