/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics
implements Closeable {
    private final MetricConfig config;
    private final ConcurrentMap<MetricName, KafkaMetric> metrics;
    private final ConcurrentMap<String, Sensor> sensors;
    private final ConcurrentMap<Sensor, List<Sensor>> childrenSensors;
    private final List<MetricsReporter> reporters;
    private final Time time;
    private final ScheduledThreadPoolExecutor metricsScheduler;
    private static final Logger log = LoggerFactory.getLogger(Metrics.class);

    public Metrics() {
        this(new MetricConfig());
    }

    public Metrics(Time time) {
        this(new MetricConfig(), new ArrayList<MetricsReporter>(0), time);
    }

    public Metrics(MetricConfig defaultConfig) {
        this(defaultConfig, new ArrayList<MetricsReporter>(0), new SystemTime());
    }

    public Metrics(MetricConfig defaultConfig, List<MetricsReporter> reporters, Time time) {
        this(defaultConfig, reporters, time, false);
    }

    public Metrics(MetricConfig defaultConfig, List<MetricsReporter> reporters, Time time, boolean enableExpiration) {
        this.config = defaultConfig;
        this.sensors = new ConcurrentHashMap<String, Sensor>();
        this.metrics = new ConcurrentHashMap<MetricName, KafkaMetric>();
        this.childrenSensors = new ConcurrentHashMap<Sensor, List<Sensor>>();
        this.reporters = Utils.notNull(reporters);
        this.time = time;
        for (MetricsReporter reporter : reporters) {
            reporter.init(new ArrayList<KafkaMetric>());
        }
        if (enableExpiration) {
            this.metricsScheduler = new ScheduledThreadPoolExecutor(1);
            this.metricsScheduler.setThreadFactory(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    return Utils.newThread("SensorExpiryThread", runnable, true);
                }
            });
            this.metricsScheduler.scheduleAtFixedRate(new ExpireSensorTask(), 30L, 30L, TimeUnit.SECONDS);
        } else {
            this.metricsScheduler = null;
        }
    }

    public Sensor getSensor(String name) {
        return (Sensor)this.sensors.get(Utils.notNull(name));
    }

    public Sensor sensor(String name) {
        return this.sensor(name, (MetricConfig)null, (Sensor[])null);
    }

    public Sensor sensor(String name, Sensor ... parents) {
        return this.sensor(name, (MetricConfig)null, parents);
    }

    public synchronized Sensor sensor(String name, MetricConfig config, Sensor ... parents) {
        return this.sensor(name, config, Long.MAX_VALUE, parents);
    }

    public synchronized Sensor sensor(String name, MetricConfig config, long inactiveSensorExpirationTimeSeconds, Sensor ... parents) {
        Sensor s = this.getSensor(name);
        if (s == null) {
            s = new Sensor(this, name, parents, config == null ? this.config : config, this.time, inactiveSensorExpirationTimeSeconds);
            this.sensors.put(name, s);
            if (parents != null) {
                for (Sensor parent : parents) {
                    ArrayList<Sensor> children = (ArrayList<Sensor>)this.childrenSensors.get(parent);
                    if (children == null) {
                        children = new ArrayList<Sensor>();
                        this.childrenSensors.put(parent, children);
                    }
                    children.add(s);
                }
            }
            log.debug("Added sensor with name {}", (Object)name);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSensor(String name) {
        Sensor sensor = (Sensor)this.sensors.get(name);
        if (sensor != null) {
            List childSensors = null;
            Sensor sensor2 = sensor;
            synchronized (sensor2) {
                Metrics metrics = this;
                synchronized (metrics) {
                    if (this.sensors.remove(name, sensor)) {
                        for (KafkaMetric metric : sensor.metrics()) {
                            this.removeMetric(metric.metricName());
                        }
                        log.debug("Removed sensor with name {}", (Object)name);
                        childSensors = (List)this.childrenSensors.remove(sensor);
                    }
                }
            }
            if (childSensors != null) {
                for (Sensor childSensor : childSensors) {
                    this.removeSensor(childSensor.name());
                }
            }
        }
    }

    public void addMetric(MetricName metricName, Measurable measurable) {
        this.addMetric(metricName, null, measurable);
    }

    public synchronized void addMetric(MetricName metricName, MetricConfig config, Measurable measurable) {
        KafkaMetric m = new KafkaMetric(new Object(), Utils.notNull(metricName), Utils.notNull(measurable), config == null ? this.config : config, this.time);
        this.registerMetric(m);
    }

    public synchronized KafkaMetric removeMetric(MetricName metricName) {
        KafkaMetric metric = (KafkaMetric)this.metrics.remove(metricName);
        if (metric != null) {
            for (MetricsReporter reporter : this.reporters) {
                reporter.metricRemoval(metric);
            }
        }
        return metric;
    }

    public synchronized void addReporter(MetricsReporter reporter) {
        Utils.notNull(reporter).init(new ArrayList<KafkaMetric>(this.metrics.values()));
        this.reporters.add(reporter);
    }

    synchronized void registerMetric(KafkaMetric metric) {
        MetricName metricName = metric.metricName();
        if (this.metrics.containsKey(metricName)) {
            throw new IllegalArgumentException("A metric named '" + metricName + "' already exists, can't register another one.");
        }
        this.metrics.put(metricName, metric);
        for (MetricsReporter reporter : this.reporters) {
            reporter.metricChange(metric);
        }
    }

    public Map<MetricName, KafkaMetric> metrics() {
        return this.metrics;
    }

    Map<Sensor, List<Sensor>> childrenSensors() {
        return Collections.unmodifiableMap(this.childrenSensors);
    }

    @Override
    public void close() {
        if (this.metricsScheduler != null) {
            this.metricsScheduler.shutdown();
            try {
                this.metricsScheduler.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (MetricsReporter reporter : this.reporters) {
            reporter.close();
        }
    }

    class ExpireSensorTask
    implements Runnable {
        ExpireSensorTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (Map.Entry sensorEntry : Metrics.this.sensors.entrySet()) {
                Sensor sensor = (Sensor)sensorEntry.getValue();
                synchronized (sensor) {
                    if (((Sensor)sensorEntry.getValue()).hasExpired()) {
                        log.debug("Removing expired sensor {}", sensorEntry.getKey());
                        Metrics.this.removeSensor((String)sensorEntry.getKey());
                    }
                }
            }
        }
    }
}

