/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.mapr;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GenericHFactory<T> {
    protected static final Map<String, Constructor<? extends Object>> CONSTRUCTOR_CACHE = new ConcurrentHashMap<String, Constructor<? extends Object>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getImplementorInstance(String className, Object[] params, Class<?> ... classes) {
        StringBuffer suffix = new StringBuffer();
        if (classes != null && classes.length > 0) {
            for (Class<?> c : classes) {
                suffix.append("_").append(c.getName());
            }
        }
        try {
            String key = className + suffix;
            Constructor<Object> method = CONSTRUCTOR_CACHE.get(key);
            if (method == null) {
                Map<String, Constructor<? extends Object>> map = CONSTRUCTOR_CACHE;
                synchronized (map) {
                    method = CONSTRUCTOR_CACHE.get(key);
                    if (method == null) {
                        Class<?> clazz = Class.forName(className);
                        method = clazz.getDeclaredConstructor(classes);
                        method.setAccessible(true);
                        CONSTRUCTOR_CACHE.put(key, method);
                    }
                }
            }
            return (T)method.newInstance(params);
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("Error occurred while instantiating %s.\n==> %s.", className, this.getMessage(t)), t);
        }
    }

    public T runMethod(String className, String methodName, Object[] params, Class[] paramTypes) {
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getDeclaredMethod(methodName, paramTypes);
            boolean isMethodAccessible = method.isAccessible();
            method.setAccessible(true);
            Object obj = method.invoke(null, params);
            method.setAccessible(isMethodAccessible);
            return (T)obj;
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("Error occurred while invoking %s:%s.\n==> %s.", className, methodName, this.getMessage(t)), t);
        }
    }

    private Object getMessage(Throwable t) {
        String msg = t.getMessage();
        while ((t instanceof InvocationTargetException || t instanceof RuntimeException || msg == null) && t.getCause() != null && t.getCause() != t) {
            t = t.getCause();
            msg = t.toString();
        }
        return msg;
    }

    public static void handleIOException(Throwable t) throws IOException {
        Throwable ioe;
        for (ioe = t; ioe != null && !(ioe instanceof IOException) && ioe != ioe.getCause(); ioe = ioe.getCause()) {
        }
        if (ioe == null || !(ioe instanceof IOException)) {
            throw new IOException(t);
        }
        throw (IOException)ioe;
    }
}

