/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class SubscriptionStateTest {
    private final SubscriptionState state = new SubscriptionState(OffsetResetStrategy.EARLIEST);
    private final String topic = "test";
    private final String topic1 = "test1";
    private final TopicPartition tp0 = new TopicPartition("test", 0);
    private final TopicPartition tp1 = new TopicPartition("test", 1);
    private final TopicPartition t1p0 = new TopicPartition("test1", 0);
    private final MockRebalanceListener rebalanceListener = new MockRebalanceListener();

    @Test
    public void partitionAssignment() {
        this.state.assignFromUser(Collections.singleton(this.tp0));
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)this.state.assignedPartitions());
        Assert.assertFalse((boolean)this.state.hasAllFetchPositions());
        this.state.seek(this.tp0, 1L);
        Assert.assertTrue((boolean)this.state.isFetchable(this.tp0));
        Assert.assertEquals((long)1L, (long)this.state.position(this.tp0));
        this.state.assignFromUser(Collections.emptySet());
        Assert.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        Assert.assertFalse((boolean)this.state.isAssigned(this.tp0));
        Assert.assertFalse((boolean)this.state.isFetchable(this.tp0));
    }

    @Test
    public void partitionAssignmentChangeOnTopicSubscription() {
        this.state.assignFromUser(new HashSet<TopicPartition>(Arrays.asList(this.tp0, this.tp1)));
        Assert.assertEquals((long)2L, (long)this.state.assignedPartitions().size());
        Assert.assertTrue((boolean)this.state.assignedPartitions().contains(this.tp0));
        Assert.assertTrue((boolean)this.state.assignedPartitions().contains(this.tp1));
        this.state.unsubscribe();
        Assert.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        this.state.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        Assert.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        this.state.assignFromSubscribed(Collections.singleton(this.t1p0));
        Assert.assertEquals(Collections.singleton(this.t1p0), (Object)this.state.assignedPartitions());
        this.state.subscribe(Collections.singleton("test"), (ConsumerRebalanceListener)this.rebalanceListener);
        Assert.assertEquals(Collections.singleton(this.t1p0), (Object)this.state.assignedPartitions());
        this.state.unsubscribe();
        Assert.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
    }

    @Test
    public void partitionAssignmentChangeOnPatternSubscription() {
        this.state.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
        Assert.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        this.state.subscribeFromPattern(new HashSet<String>(Collections.singletonList("test")));
        Assert.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        this.state.assignFromSubscribed(Collections.singleton(this.tp1));
        Assert.assertEquals(Collections.singleton(this.tp1), (Object)this.state.assignedPartitions());
        Assert.assertEquals(Collections.singleton("test"), (Object)this.state.subscription());
        this.state.assignFromSubscribed(Collections.singletonList(this.t1p0));
        Assert.assertEquals(Collections.singleton(this.t1p0), (Object)this.state.assignedPartitions());
        Assert.assertEquals(Collections.singleton("test"), (Object)this.state.subscription());
        this.state.subscribe(Pattern.compile(".*t"), (ConsumerRebalanceListener)this.rebalanceListener);
        Assert.assertEquals(Collections.singleton(this.t1p0), (Object)this.state.assignedPartitions());
        this.state.subscribeFromPattern(Collections.singleton("test"));
        Assert.assertEquals(Collections.singleton(this.t1p0), (Object)this.state.assignedPartitions());
        this.state.assignFromSubscribed(Collections.singletonList(this.tp0));
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)this.state.assignedPartitions());
        Assert.assertEquals(Collections.singleton("test"), (Object)this.state.subscription());
        this.state.unsubscribe();
        Assert.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
    }

    @Test
    public void verifyAssignmentListener() {
        final AtomicReference assignmentRef = new AtomicReference();
        this.state.addListener(new SubscriptionState.Listener(){

            public void onAssignment(Set<TopicPartition> assignment) {
                assignmentRef.set(assignment);
            }
        });
        Set userAssignment = Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.tp1});
        this.state.assignFromUser(userAssignment);
        Assert.assertEquals((Object)userAssignment, assignmentRef.get());
        this.state.unsubscribe();
        Assert.assertEquals(Collections.emptySet(), assignmentRef.get());
        Set autoAssignment = Utils.mkSet((Object[])new TopicPartition[]{this.t1p0});
        this.state.subscribe(Collections.singleton("test1"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.state.assignFromSubscribed((Collection)autoAssignment);
        Assert.assertEquals((Object)autoAssignment, assignmentRef.get());
    }

    @Test
    public void partitionReset() {
        this.state.assignFromUser(Collections.singleton(this.tp0));
        this.state.seek(this.tp0, 5L);
        Assert.assertEquals((long)5L, (long)this.state.position(this.tp0));
        this.state.requestOffsetReset(this.tp0);
        Assert.assertFalse((boolean)this.state.isFetchable(this.tp0));
        Assert.assertTrue((boolean)this.state.isOffsetResetNeeded(this.tp0));
        Assert.assertEquals(null, (Object)this.state.position(this.tp0));
        this.state.seek(this.tp0, 0L);
        Assert.assertTrue((boolean)this.state.isFetchable(this.tp0));
        Assert.assertFalse((boolean)this.state.isOffsetResetNeeded(this.tp0));
    }

    @Test
    public void topicSubscription() {
        this.state.subscribe(Collections.singleton("test"), (ConsumerRebalanceListener)this.rebalanceListener);
        Assert.assertEquals((long)1L, (long)this.state.subscription().size());
        Assert.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        Assert.assertTrue((boolean)this.state.partitionsAutoAssigned());
        this.state.assignFromSubscribed(Collections.singleton(this.tp0));
        this.state.seek(this.tp0, 1L);
        Assert.assertEquals((long)1L, (long)this.state.position(this.tp0));
        this.state.assignFromSubscribed(Collections.singleton(this.tp1));
        Assert.assertTrue((boolean)this.state.isAssigned(this.tp1));
        Assert.assertFalse((boolean)this.state.isAssigned(this.tp0));
        Assert.assertFalse((boolean)this.state.isFetchable(this.tp1));
        Assert.assertEquals(Collections.singleton(this.tp1), (Object)this.state.assignedPartitions());
    }

    @Test
    public void partitionPause() {
        this.state.assignFromUser(Collections.singleton(this.tp0));
        this.state.seek(this.tp0, 100L);
        Assert.assertTrue((boolean)this.state.isFetchable(this.tp0));
        this.state.pause(this.tp0);
        Assert.assertFalse((boolean)this.state.isFetchable(this.tp0));
        this.state.resume(this.tp0);
        Assert.assertTrue((boolean)this.state.isFetchable(this.tp0));
    }

    @Test(expected=IllegalStateException.class)
    public void invalidPositionUpdate() {
        this.state.subscribe(Collections.singleton("test"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.state.assignFromSubscribed(Collections.singleton(this.tp0));
        this.state.position(this.tp0, 0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void cantAssignPartitionForUnsubscribedTopics() {
        this.state.subscribe(Collections.singleton("test"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.state.assignFromSubscribed(Collections.singletonList(this.t1p0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void cantAssignPartitionForUnmatchedPattern() {
        this.state.subscribe(Pattern.compile(".*t"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.state.subscribeFromPattern(new HashSet<String>(Collections.singletonList("test")));
        this.state.assignFromSubscribed(Collections.singletonList(this.t1p0));
    }

    @Test(expected=IllegalStateException.class)
    public void cantChangePositionForNonAssignedPartition() {
        this.state.position(this.tp0, 1L);
    }

    @Test(expected=IllegalStateException.class)
    public void cantSubscribeTopicAndPattern() {
        this.state.subscribe(Collections.singleton("test"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.state.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
    }

    @Test(expected=IllegalStateException.class)
    public void cantSubscribePartitionAndPattern() {
        this.state.assignFromUser(Collections.singleton(this.tp0));
        this.state.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
    }

    @Test(expected=IllegalStateException.class)
    public void cantSubscribePatternAndTopic() {
        this.state.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.state.subscribe(Collections.singleton("test"), (ConsumerRebalanceListener)this.rebalanceListener);
    }

    @Test(expected=IllegalStateException.class)
    public void cantSubscribePatternAndPartition() {
        this.state.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.state.assignFromUser(Collections.singleton(this.tp0));
    }

    @Test
    public void patternSubscription() {
        this.state.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.state.subscribeFromPattern(new HashSet<String>(Arrays.asList("test", "test1")));
        Assert.assertEquals((String)"Expected subscribed topics count is incorrect", (long)2L, (long)this.state.subscription().size());
    }

    @Test
    public void unsubscribeUserAssignment() {
        this.state.assignFromUser(new HashSet<TopicPartition>(Arrays.asList(this.tp0, this.tp1)));
        this.state.unsubscribe();
        this.state.subscribe(Collections.singleton("test"), (ConsumerRebalanceListener)this.rebalanceListener);
        Assert.assertEquals(Collections.singleton("test"), (Object)this.state.subscription());
    }

    @Test
    public void unsubscribeUserSubscribe() {
        this.state.subscribe(Collections.singleton("test"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.state.unsubscribe();
        this.state.assignFromUser(Collections.singleton(this.tp0));
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)this.state.assignedPartitions());
    }

    @Test
    public void unsubscription() {
        this.state.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.state.subscribeFromPattern(new HashSet<String>(Arrays.asList("test", "test1")));
        this.state.assignFromSubscribed(Collections.singleton(this.tp1));
        Assert.assertEquals(Collections.singleton(this.tp1), (Object)this.state.assignedPartitions());
        this.state.unsubscribe();
        Assert.assertEquals((long)0L, (long)this.state.subscription().size());
        Assert.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        this.state.assignFromUser(Collections.singleton(this.tp0));
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)this.state.assignedPartitions());
        this.state.unsubscribe();
        Assert.assertEquals((long)0L, (long)this.state.subscription().size());
        Assert.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
    }

    private static class MockRebalanceListener
    implements ConsumerRebalanceListener {
        public Collection<TopicPartition> revoked;
        public Collection<TopicPartition> assigned;
        public int revokedCount = 0;
        public int assignedCount = 0;

        private MockRebalanceListener() {
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.assigned = partitions;
            ++this.assignedCount;
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.revoked = partitions;
            ++this.revokedCount;
        }
    }
}

