/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerClientInitialResponse;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServer;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerConfigException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredLoginCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredValidatorCallbackHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OAuthBearerSaslServerTest {
    private static final String USER = "user";
    private static final Map<String, ?> CONFIGS;
    private static final AuthenticateCallbackHandler LOGIN_CALLBACK_HANDLER;
    private static final AuthenticateCallbackHandler VALIDATOR_CALLBACK_HANDLER;
    private OAuthBearerSaslServer saslServer;

    @Before
    public void setUp() throws Exception {
        this.saslServer = new OAuthBearerSaslServer((CallbackHandler)VALIDATOR_CALLBACK_HANDLER);
    }

    @Test
    public void noAuthorizationIdSpecified() throws Exception {
        byte[] nextChallenge = this.saslServer.evaluateResponse(this.clientInitialResponse(null));
        Assert.assertTrue((String)"Next challenge is not empty", (nextChallenge.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void authorizatonIdEqualsAuthenticationId() throws Exception {
        byte[] nextChallenge = this.saslServer.evaluateResponse(this.clientInitialResponse(USER));
        Assert.assertTrue((String)"Next challenge is not empty", (nextChallenge.length == 0 ? 1 : 0) != 0);
    }

    @Test(expected=SaslAuthenticationException.class)
    public void authorizatonIdNotEqualsAuthenticationId() throws Exception {
        this.saslServer.evaluateResponse(this.clientInitialResponse("userx"));
    }

    @Test
    public void illegalToken() throws Exception {
        byte[] bytes = this.saslServer.evaluateResponse(this.clientInitialResponse(null, true));
        String challenge = new String(bytes, StandardCharsets.UTF_8);
        Assert.assertEquals((Object)"{\"status\":\"invalid_token\"}", (Object)challenge);
    }

    private byte[] clientInitialResponse(String authorizationId) throws OAuthBearerConfigException, IOException, UnsupportedCallbackException, LoginException {
        return this.clientInitialResponse(authorizationId, false);
    }

    private byte[] clientInitialResponse(String authorizationId, boolean illegalToken) throws OAuthBearerConfigException, IOException, UnsupportedCallbackException, LoginException {
        OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
        LOGIN_CALLBACK_HANDLER.handle(new Callback[]{callback});
        OAuthBearerToken token = callback.token();
        String compactSerialization = token.value();
        String tokenValue = compactSerialization + (illegalToken ? "AB" : "");
        return new OAuthBearerClientInitialResponse(tokenValue, authorizationId, Collections.emptyMap()).toBytes();
    }

    static {
        String jaasConfigText = "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule Required unsecuredLoginStringClaim_sub=\"user\";";
        HashMap<String, Password> tmp = new HashMap<String, Password>();
        tmp.put("sasl.jaas.config", new Password(jaasConfigText));
        CONFIGS = Collections.unmodifiableMap(tmp);
        LOGIN_CALLBACK_HANDLER = new OAuthBearerUnsecuredLoginCallbackHandler();
        LOGIN_CALLBACK_HANDLER.configure(CONFIGS, "OAUTHBEARER", JaasContext.loadClientContext(CONFIGS).configurationEntries());
        VALIDATOR_CALLBACK_HANDLER = new OAuthBearerUnsecuredValidatorCallbackHandler();
        VALIDATOR_CALLBACK_HANDLER.configure(CONFIGS, "OAUTHBEARER", JaasContext.loadClientContext(CONFIGS).configurationEntries());
    }
}

