/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.junit.Assert;
import org.junit.Test;

public class DefaultPartitionerTest {
    private byte[] keyBytes = "key".getBytes();
    private Partitioner partitioner = new DefaultPartitioner();
    private Node node0 = new Node(0, "localhost", 99);
    private Node node1 = new Node(1, "localhost", 100);
    private Node node2 = new Node(2, "localhost", 101);
    private Node[] nodes = new Node[]{this.node0, this.node1, this.node2};
    private String topic = "test";
    private List<PartitionInfo> partitions = Arrays.asList(new PartitionInfo(this.topic, 1, null, this.nodes, this.nodes), new PartitionInfo(this.topic, 2, this.node1, this.nodes, this.nodes), new PartitionInfo(this.topic, 0, this.node0, this.nodes, this.nodes));
    private Cluster cluster = new Cluster("clusterId", Arrays.asList(this.node0, this.node1, this.node2), this.partitions, Collections.emptySet(), Collections.emptySet());

    @Test
    public void testKeyPartitionIsStable() {
        int partition = this.partitioner.partition("test", null, this.keyBytes, null, null, this.cluster);
        Assert.assertEquals((String)"Same key should yield same partition", (long)partition, (long)this.partitioner.partition("test", null, this.keyBytes, null, null, this.cluster));
    }

    @Test
    public void testRoundRobinWithUnavailablePartitions() {
        int countForPart0 = 0;
        int countForPart2 = 0;
        for (int i = 1; i <= 100; ++i) {
            int part = this.partitioner.partition("test", null, null, null, null, this.cluster);
            Assert.assertTrue((String)"We should never choose a leader-less node in round robin", (part == 0 || part == 2 ? 1 : 0) != 0);
            if (part == 0) {
                ++countForPart0;
                continue;
            }
            ++countForPart2;
        }
        Assert.assertEquals((String)"The distribution between two available partitions should be even", (long)countForPart0, (long)countForPart2);
    }

    @Test
    public void testRoundRobin() throws InterruptedException {
        String topicA = "topicA";
        String topicB = "topicB";
        List<PartitionInfo> allPartitions = Arrays.asList(new PartitionInfo("topicA", 0, this.node0, this.nodes, this.nodes), new PartitionInfo("topicA", 1, this.node1, this.nodes, this.nodes), new PartitionInfo("topicA", 2, this.node2, this.nodes, this.nodes), new PartitionInfo("topicB", 0, this.node0, this.nodes, this.nodes));
        Cluster testCluster = new Cluster("clusterId", Arrays.asList(this.node0, this.node1, this.node2), allPartitions, Collections.emptySet(), Collections.emptySet());
        HashMap<Integer, Integer> partitionCount = new HashMap<Integer, Integer>();
        for (int i = 0; i < 30; ++i) {
            int partition = this.partitioner.partition("topicA", null, null, null, null, testCluster);
            Integer count = (Integer)partitionCount.get(partition);
            if (null == count) {
                count = 0;
            }
            partitionCount.put(partition, count + 1);
            if (i % 5 != 0) continue;
            this.partitioner.partition("topicB", null, null, null, null, testCluster);
        }
        Assert.assertEquals((long)10L, (long)((Integer)partitionCount.get(0)).intValue());
        Assert.assertEquals((long)10L, (long)((Integer)partitionCount.get(1)).intValue());
        Assert.assertEquals((long)10L, (long)((Integer)partitionCount.get(2)).intValue());
    }
}

