/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.junit.Assert;
import org.junit.Test;

public class NodeApiVersionsTest {
    @Test
    public void testUnsupportedVersionsToString() {
        NodeApiVersions versions = new NodeApiVersions(Collections.emptyList());
        StringBuilder bld = new StringBuilder();
        String prefix = "(";
        for (ApiKeys apiKey : ApiKeys.values()) {
            bld.append(prefix).append(apiKey.name).append("(").append(apiKey.id).append("): UNSUPPORTED");
            prefix = ", ";
        }
        bld.append(")");
        Assert.assertEquals((Object)bld.toString(), (Object)versions.toString());
    }

    @Test
    public void testUnknownApiVersionsToString() {
        ApiVersionsResponse.ApiVersion unknownApiVersion = new ApiVersionsResponse.ApiVersion(337, 0, 1);
        NodeApiVersions versions = new NodeApiVersions(Collections.singleton(unknownApiVersion));
        Assert.assertTrue((boolean)versions.toString().endsWith("UNKNOWN(337): 0 to 1)"));
    }

    @Test
    public void testVersionsToString() {
        ArrayList<ApiVersionsResponse.ApiVersion> versionList = new ArrayList<ApiVersionsResponse.ApiVersion>();
        for (ApiKeys apiKey : ApiKeys.values()) {
            if (apiKey == ApiKeys.DELETE_TOPICS) {
                versionList.add(new ApiVersionsResponse.ApiVersion(apiKey, 10000, 10001));
                continue;
            }
            versionList.add(new ApiVersionsResponse.ApiVersion(apiKey));
        }
        NodeApiVersions versions = new NodeApiVersions(versionList);
        StringBuilder bld = new StringBuilder();
        String prefix = "(";
        for (ApiKeys apiKey : ApiKeys.values()) {
            bld.append(prefix);
            if (apiKey == ApiKeys.DELETE_TOPICS) {
                bld.append("DeleteTopics(20): 10000 to 10001 [unusable: node too new]");
            } else {
                bld.append(apiKey.name).append("(").append(apiKey.id).append("): ");
                if (apiKey.oldestVersion() == apiKey.latestVersion()) {
                    bld.append(apiKey.oldestVersion());
                } else {
                    bld.append(apiKey.oldestVersion()).append(" to ").append(apiKey.latestVersion());
                }
                bld.append(" [usable: ").append(apiKey.latestVersion()).append("]");
            }
            prefix = ", ";
        }
        bld.append(")");
        Assert.assertEquals((Object)bld.toString(), (Object)versions.toString());
    }

    @Test
    public void testLatestUsableVersion() {
        NodeApiVersions apiVersions = NodeApiVersions.create(Collections.singleton(new ApiVersionsResponse.ApiVersion(ApiKeys.PRODUCE, 1, 3)));
        Assert.assertEquals((long)3L, (long)apiVersions.latestUsableVersion(ApiKeys.PRODUCE));
        Assert.assertEquals((long)1L, (long)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)0, (short)1));
        Assert.assertEquals((long)1L, (long)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)1, (short)1));
        Assert.assertEquals((long)2L, (long)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)1, (short)2));
        Assert.assertEquals((long)3L, (long)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)1, (short)3));
        Assert.assertEquals((long)2L, (long)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)2, (short)2));
        Assert.assertEquals((long)3L, (long)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)2, (short)3));
        Assert.assertEquals((long)3L, (long)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)3, (short)3));
        Assert.assertEquals((long)3L, (long)apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)3, (short)4));
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testLatestUsableVersionOutOfRangeLow() {
        NodeApiVersions apiVersions = NodeApiVersions.create(Collections.singleton(new ApiVersionsResponse.ApiVersion(ApiKeys.PRODUCE, 1, 2)));
        apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)3, (short)4);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testLatestUsableVersionOutOfRangeHigh() {
        NodeApiVersions apiVersions = NodeApiVersions.create(Collections.singleton(new ApiVersionsResponse.ApiVersion(ApiKeys.PRODUCE, 2, 3)));
        apiVersions.latestUsableVersion(ApiKeys.PRODUCE, (short)0, (short)1);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testUsableVersionCalculationNoKnownVersions() {
        ArrayList versionList = new ArrayList();
        NodeApiVersions versions = new NodeApiVersions(versionList);
        versions.latestUsableVersion(ApiKeys.FETCH);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testLatestUsableVersionOutOfRange() {
        NodeApiVersions apiVersions = NodeApiVersions.create(Collections.singleton(new ApiVersionsResponse.ApiVersion(ApiKeys.PRODUCE, 300, 300)));
        apiVersions.latestUsableVersion(ApiKeys.PRODUCE);
    }

    @Test
    public void testUsableVersionLatestVersions() {
        LinkedList<ApiVersionsResponse.ApiVersion> versionList = new LinkedList<ApiVersionsResponse.ApiVersion>();
        for (ApiVersionsResponse.ApiVersion apiVersion : ApiVersionsResponse.defaultApiVersionsResponse().apiVersions()) {
            versionList.add(apiVersion);
        }
        versionList.add(new ApiVersionsResponse.ApiVersion(100, 0, 1));
        NodeApiVersions versions = new NodeApiVersions(versionList);
        for (ApiKeys apiKey : ApiKeys.values()) {
            Assert.assertEquals((long)apiKey.latestVersion(), (long)versions.latestUsableVersion(apiKey));
        }
    }
}

