/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.junit.Assert;
import org.junit.Test;

public class LeaveGroupResponseTest {
    private final int throttleTimeMs = 10;

    @Test
    public void testConstructor() {
        Map<Errors, Integer> expectedErrorCounts = Collections.singletonMap(Errors.NOT_COORDINATOR, 1);
        LeaveGroupResponseData responseData = new LeaveGroupResponseData().setErrorCode(Errors.NOT_COORDINATOR.code()).setThrottleTimeMs(10);
        for (short version = 0; version <= ApiKeys.LEAVE_GROUP.latestVersion(); version = (short)(version + 1)) {
            LeaveGroupResponse leaveGroupResponse = new LeaveGroupResponse(responseData.toStruct(version), version);
            Assert.assertEquals(expectedErrorCounts, (Object)leaveGroupResponse.errorCounts());
            if (version >= 1) {
                Assert.assertEquals((long)10L, (long)leaveGroupResponse.throttleTimeMs());
            } else {
                Assert.assertEquals((long)0L, (long)leaveGroupResponse.throttleTimeMs());
            }
            Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)leaveGroupResponse.error());
        }
    }

    @Test
    public void testShouldThrottle() {
        LeaveGroupResponse response = new LeaveGroupResponse(new LeaveGroupResponseData());
        for (short version = 0; version <= ApiKeys.LEAVE_GROUP.latestVersion(); version = (short)(version + 1)) {
            if (version >= 2) {
                Assert.assertTrue((boolean)response.shouldClientThrottle(version));
                continue;
            }
            Assert.assertFalse((boolean)response.shouldClientThrottle(version));
        }
    }

    @Test
    public void testEquality() {
        LeaveGroupResponseData responseData = new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setThrottleTimeMs(10);
        for (short version = 0; version <= ApiKeys.LEAVE_GROUP.latestVersion(); version = (short)(version + 1)) {
            LeaveGroupResponse primaryResponse = new LeaveGroupResponse(responseData.toStruct(version), version);
            LeaveGroupResponse secondaryResponse = new LeaveGroupResponse(responseData.toStruct(version), version);
            Assert.assertEquals((Object)primaryResponse, (Object)primaryResponse);
            Assert.assertEquals((Object)primaryResponse, (Object)secondaryResponse);
            Assert.assertEquals((long)primaryResponse.hashCode(), (long)secondaryResponse.hashCode());
        }
    }
}

