/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.PartialDefaultRecord;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class DefaultRecordBatchTest {
    @Test
    public void testWriteEmptyHeader() {
        long producerId = 23423L;
        short producerEpoch = 145;
        int baseSequence = 983;
        long baseOffset = 15L;
        long lastOffset = 37L;
        int partitionLeaderEpoch = 15;
        long timestamp = System.currentTimeMillis();
        for (TimestampType timestampType : Arrays.asList(TimestampType.CREATE_TIME, TimestampType.LOG_APPEND_TIME)) {
            for (boolean isTransactional : Arrays.asList(true, false)) {
                for (boolean isControlBatch : Arrays.asList(true, false)) {
                    ByteBuffer buffer = ByteBuffer.allocate(2048);
                    DefaultRecordBatch.writeEmptyHeader((ByteBuffer)buffer, (byte)2, (long)producerId, (short)producerEpoch, (int)baseSequence, (long)baseOffset, (long)lastOffset, (int)partitionLeaderEpoch, (TimestampType)timestampType, (long)timestamp, (boolean)isTransactional, (boolean)isControlBatch);
                    buffer.flip();
                    DefaultRecordBatch batch = new DefaultRecordBatch(buffer);
                    Assert.assertEquals((long)producerId, (long)batch.producerId());
                    Assert.assertEquals((long)producerEpoch, (long)batch.producerEpoch());
                    Assert.assertEquals((long)baseSequence, (long)batch.baseSequence());
                    Assert.assertEquals((long)(baseSequence + (int)(lastOffset - baseOffset)), (long)batch.lastSequence());
                    Assert.assertEquals((long)baseOffset, (long)batch.baseOffset());
                    Assert.assertEquals((long)lastOffset, (long)batch.lastOffset());
                    Assert.assertEquals((long)partitionLeaderEpoch, (long)batch.partitionLeaderEpoch());
                    Assert.assertEquals((Object)isTransactional, (Object)batch.isTransactional());
                    Assert.assertEquals((Object)timestampType, (Object)batch.timestampType());
                    Assert.assertEquals((long)timestamp, (long)batch.maxTimestamp());
                    Assert.assertEquals((long)-1L, (long)batch.firstTimestamp());
                    Assert.assertEquals((Object)isControlBatch, (Object)batch.isControlBatch());
                }
            }
        }
    }

    @Test
    public void buildDefaultRecordBatch() {
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)1234567L);
        builder.appendWithOffset(1234567L, 1L, "a".getBytes(), "v".getBytes());
        builder.appendWithOffset(1234568L, 2L, "b".getBytes(), "v".getBytes());
        MemoryRecords records = builder.build();
        for (MutableRecordBatch batch : records.batches()) {
            Assert.assertTrue((boolean)batch.isValid());
            Assert.assertEquals((long)1234567L, (long)batch.baseOffset());
            Assert.assertEquals((long)1234568L, (long)batch.lastOffset());
            Assert.assertEquals((long)2L, (long)batch.maxTimestamp());
            Assert.assertEquals((long)-1L, (long)batch.producerId());
            Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
            Assert.assertEquals((long)-1L, (long)batch.baseSequence());
            Assert.assertEquals((long)-1L, (long)batch.lastSequence());
            for (Record record : batch) {
                Assert.assertTrue((boolean)record.isValid());
            }
        }
    }

    @Test
    public void buildDefaultRecordBatchWithProducerId() {
        long pid = 23423L;
        short epoch = 145;
        int baseSequence = 983;
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)1234567L, (long)-1L, (long)pid, (short)epoch, (int)baseSequence);
        builder.appendWithOffset(1234567L, 1L, "a".getBytes(), "v".getBytes());
        builder.appendWithOffset(1234568L, 2L, "b".getBytes(), "v".getBytes());
        MemoryRecords records = builder.build();
        for (MutableRecordBatch batch : records.batches()) {
            Assert.assertTrue((boolean)batch.isValid());
            Assert.assertEquals((long)1234567L, (long)batch.baseOffset());
            Assert.assertEquals((long)1234568L, (long)batch.lastOffset());
            Assert.assertEquals((long)2L, (long)batch.maxTimestamp());
            Assert.assertEquals((long)pid, (long)batch.producerId());
            Assert.assertEquals((long)epoch, (long)batch.producerEpoch());
            Assert.assertEquals((long)baseSequence, (long)batch.baseSequence());
            Assert.assertEquals((long)(baseSequence + 1), (long)batch.lastSequence());
            for (Record record : batch) {
                Assert.assertTrue((boolean)record.isValid());
            }
        }
    }

    @Test
    public void buildDefaultRecordBatchWithSequenceWrapAround() {
        long pid = 23423L;
        short epoch = 145;
        int baseSequence = 0x7FFFFFFE;
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)1234567L, (long)-1L, (long)pid, (short)epoch, (int)baseSequence);
        builder.appendWithOffset(1234567L, 1L, "a".getBytes(), "v".getBytes());
        builder.appendWithOffset(1234568L, 2L, "b".getBytes(), "v".getBytes());
        builder.appendWithOffset(1234569L, 3L, "c".getBytes(), "v".getBytes());
        MemoryRecords records = builder.build();
        List batches = TestUtils.toList(records.batches());
        Assert.assertEquals((long)1L, (long)batches.size());
        RecordBatch batch = (RecordBatch)batches.get(0);
        Assert.assertEquals((long)pid, (long)batch.producerId());
        Assert.assertEquals((long)epoch, (long)batch.producerEpoch());
        Assert.assertEquals((long)baseSequence, (long)batch.baseSequence());
        Assert.assertEquals((long)0L, (long)batch.lastSequence());
        List allRecords = TestUtils.toList(batch);
        Assert.assertEquals((long)3L, (long)allRecords.size());
        Assert.assertEquals((long)0x7FFFFFFEL, (long)((Record)allRecords.get(0)).sequence());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)((Record)allRecords.get(1)).sequence());
        Assert.assertEquals((long)0L, (long)((Record)allRecords.get(2)).sequence());
    }

    @Test
    public void testSizeInBytes() {
        Header[] headers = new Header[]{new RecordHeader("foo", "value".getBytes()), new RecordHeader("bar", (byte[])null)};
        long timestamp = System.currentTimeMillis();
        SimpleRecord[] records = new SimpleRecord[]{new SimpleRecord(timestamp, "key".getBytes(), "value".getBytes()), new SimpleRecord(timestamp + 30000L, null, "value".getBytes()), new SimpleRecord(timestamp + 60000L, "key".getBytes(), null), new SimpleRecord(timestamp + 60000L, "key".getBytes(), "value".getBytes(), headers)};
        int actualSize = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])records).sizeInBytes();
        Assert.assertEquals((long)actualSize, (long)DefaultRecordBatch.sizeInBytes(Arrays.asList(records)));
    }

    @Test(expected=CorruptRecordException.class)
    public void testInvalidRecordSize() {
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        ByteBuffer buffer = records.buffer();
        buffer.putInt(8, 10);
        DefaultRecordBatch batch = new DefaultRecordBatch(buffer);
        Assert.assertFalse((boolean)batch.isValid());
        batch.ensureValid();
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidRecordCountTooManyNonCompressedV2() {
        long now = System.currentTimeMillis();
        DefaultRecordBatch batch = DefaultRecordBatchTest.recordsWithInvalidRecordCount((byte)2, now, CompressionType.NONE, 5);
        for (Record record : batch) {
            record.isValid();
        }
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidRecordCountTooLittleNonCompressedV2() {
        long now = System.currentTimeMillis();
        DefaultRecordBatch batch = DefaultRecordBatchTest.recordsWithInvalidRecordCount((byte)2, now, CompressionType.NONE, 2);
        for (Record record : batch) {
            record.isValid();
        }
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidRecordCountTooManyCompressedV2() {
        long now = System.currentTimeMillis();
        DefaultRecordBatch batch = DefaultRecordBatchTest.recordsWithInvalidRecordCount((byte)2, now, CompressionType.GZIP, 5);
        for (Record record : batch) {
            record.isValid();
        }
    }

    @Test(expected=InvalidRecordException.class)
    public void testInvalidRecordCountTooLittleCompressedV2() {
        long now = System.currentTimeMillis();
        DefaultRecordBatch batch = DefaultRecordBatchTest.recordsWithInvalidRecordCount((byte)2, now, CompressionType.GZIP, 2);
        for (Record record : batch) {
            record.isValid();
        }
    }

    @Test(expected=CorruptRecordException.class)
    public void testInvalidCrc() {
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        ByteBuffer buffer = records.buffer();
        buffer.putInt(23, 23);
        DefaultRecordBatch batch = new DefaultRecordBatch(buffer);
        Assert.assertFalse((boolean)batch.isValid());
        batch.ensureValid();
    }

    @Test
    public void testSetLastOffset() {
        SimpleRecord[] simpleRecords = new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())};
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])simpleRecords);
        long lastOffset = 500L;
        long firstOffset = lastOffset - (long)simpleRecords.length + 1L;
        DefaultRecordBatch batch = new DefaultRecordBatch(records.buffer());
        batch.setLastOffset(lastOffset);
        Assert.assertEquals((long)lastOffset, (long)batch.lastOffset());
        Assert.assertEquals((long)firstOffset, (long)batch.baseOffset());
        Assert.assertTrue((boolean)batch.isValid());
        List recordBatches = Utils.toList(records.batches().iterator());
        Assert.assertEquals((long)1L, (long)recordBatches.size());
        Assert.assertEquals((long)lastOffset, (long)((MutableRecordBatch)recordBatches.get(0)).lastOffset());
        long offset = firstOffset;
        for (Record record : records.records()) {
            Assert.assertEquals((long)offset++, (long)record.offset());
        }
    }

    @Test
    public void testSetPartitionLeaderEpoch() {
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        int leaderEpoch = 500;
        DefaultRecordBatch batch = new DefaultRecordBatch(records.buffer());
        batch.setPartitionLeaderEpoch(leaderEpoch);
        Assert.assertEquals((long)leaderEpoch, (long)batch.partitionLeaderEpoch());
        Assert.assertTrue((boolean)batch.isValid());
        List recordBatches = Utils.toList(records.batches().iterator());
        Assert.assertEquals((long)1L, (long)recordBatches.size());
        Assert.assertEquals((long)leaderEpoch, (long)((MutableRecordBatch)recordBatches.get(0)).partitionLeaderEpoch());
    }

    @Test
    public void testSetLogAppendTime() {
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        long logAppendTime = 15L;
        DefaultRecordBatch batch = new DefaultRecordBatch(records.buffer());
        batch.setMaxTimestamp(TimestampType.LOG_APPEND_TIME, logAppendTime);
        Assert.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)batch.timestampType());
        Assert.assertEquals((long)logAppendTime, (long)batch.maxTimestamp());
        Assert.assertTrue((boolean)batch.isValid());
        List recordBatches = Utils.toList(records.batches().iterator());
        Assert.assertEquals((long)1L, (long)recordBatches.size());
        Assert.assertEquals((long)logAppendTime, (long)((MutableRecordBatch)recordBatches.get(0)).maxTimestamp());
        Assert.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)((MutableRecordBatch)recordBatches.get(0)).timestampType());
        for (Record record : records.records()) {
            Assert.assertEquals((long)logAppendTime, (long)record.timestamp());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetNoTimestampTypeNotAllowed() {
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        DefaultRecordBatch batch = new DefaultRecordBatch(records.buffer());
        batch.setMaxTimestamp(TimestampType.NO_TIMESTAMP_TYPE, -1L);
    }

    @Test
    public void testReadAndWriteControlBatch() {
        long producerId = 1L;
        short producerEpoch = 0;
        int coordinatorEpoch = 15;
        ByteBuffer buffer = ByteBuffer.allocate(128);
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, 2, CompressionType.NONE, TimestampType.CREATE_TIME, 0L, -1L, producerId, producerEpoch, -1, true, true, -1, buffer.remaining());
        EndTransactionMarker marker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        builder.appendEndTxnMarker(System.currentTimeMillis(), marker);
        MemoryRecords records = builder.build();
        List batches = TestUtils.toList(records.batches());
        Assert.assertEquals((long)1L, (long)batches.size());
        MutableRecordBatch batch = (MutableRecordBatch)batches.get(0);
        Assert.assertTrue((boolean)batch.isControlBatch());
        List logRecords = TestUtils.toList(records.records());
        Assert.assertEquals((long)1L, (long)logRecords.size());
        Record commitRecord = (Record)logRecords.get(0);
        Assert.assertEquals((Object)marker, (Object)EndTransactionMarker.deserialize((Record)commitRecord));
    }

    @Test
    public void testStreamingIteratorConsistency() {
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        DefaultRecordBatch batch = new DefaultRecordBatch(records.buffer());
        try (CloseableIterator streamingIterator = batch.streamingIterator(BufferSupplier.create());){
            TestUtils.checkEquals(streamingIterator, batch.iterator());
        }
    }

    @Test
    public void testSkipKeyValueIteratorCorrectness() {
        Header[] headers = new Header[]{new RecordHeader("k1", "v1".getBytes()), new RecordHeader("k2", "v2".getBytes())};
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)CompressionType.LZ4, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes()), new SimpleRecord(1000L, "abc".getBytes(), "0".getBytes()), new SimpleRecord(9999L, "abc".getBytes(), "0".getBytes(), headers)});
        DefaultRecordBatch batch = new DefaultRecordBatch(records.buffer());
        try (CloseableIterator streamingIterator = batch.skipKeyValueIterator(BufferSupplier.NO_CACHING);){
            Assert.assertEquals(Arrays.asList(new PartialDefaultRecord(9, 0, 0L, 1L, -1, 1, 1), new PartialDefaultRecord(9, 0, 1L, 2L, -1, 1, 1), new PartialDefaultRecord(9, 0, 2L, 3L, -1, 1, 1), new PartialDefaultRecord(12, 0, 3L, 1000L, -1, 3, 1), new PartialDefaultRecord(25, 0, 4L, 9999L, -1, 3, 1)), (Object)Utils.toList((Iterator)streamingIterator));
        }
    }

    @Test
    public void testIncrementSequence() {
        Assert.assertEquals((long)10L, (long)DefaultRecordBatch.incrementSequence((int)5, (int)5));
        Assert.assertEquals((long)0L, (long)DefaultRecordBatch.incrementSequence((int)Integer.MAX_VALUE, (int)1));
        Assert.assertEquals((long)4L, (long)DefaultRecordBatch.incrementSequence((int)0x7FFFFFFA, (int)10));
    }

    @Test
    public void testDecrementSequence() {
        Assert.assertEquals((long)0L, (long)DefaultRecordBatch.decrementSequence((int)5, (int)5));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)DefaultRecordBatch.decrementSequence((int)0, (int)1));
    }

    private static DefaultRecordBatch recordsWithInvalidRecordCount(Byte magicValue, long timestamp, CompressionType codec, int invalidCount) {
        ByteBuffer buf = ByteBuffer.allocate(512);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        MemoryRecords records = builder.build();
        ByteBuffer buffer = records.buffer();
        buffer.position(0);
        buffer.putInt(57, invalidCount);
        buffer.position(0);
        return new DefaultRecordBatch(buffer);
    }
}

