/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotCoordinatorException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.ControlledShutdownRequestData;
import org.apache.kafka.common.message.ControlledShutdownResponseData;
import org.apache.kafka.common.message.CreateAclsRequestData;
import org.apache.kafka.common.message.CreateAclsResponseData;
import org.apache.kafka.common.message.CreateDelegationTokenRequestData;
import org.apache.kafka.common.message.CreateDelegationTokenResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteAclsRequestData;
import org.apache.kafka.common.message.DeleteAclsResponseData;
import org.apache.kafka.common.message.DeleteGroupsRequestData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeAclsResponseData;
import org.apache.kafka.common.message.DescribeGroupsRequestData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.EndTxnRequestData;
import org.apache.kafka.common.message.EndTxnResponseData;
import org.apache.kafka.common.message.ExpireDelegationTokenRequestData;
import org.apache.kafka.common.message.ExpireDelegationTokenResponseData;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.InitProducerIdRequestData;
import org.apache.kafka.common.message.InitProducerIdResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaderAndIsrResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.RenewDelegationTokenRequestData;
import org.apache.kafka.common.message.RenewDelegationTokenResponseData;
import org.apache.kafka.common.message.SaslAuthenticateRequestData;
import org.apache.kafka.common.message.SaslAuthenticateResponseData;
import org.apache.kafka.common.message.SaslHandshakeRequestData;
import org.apache.kafka.common.message.SaslHandshakeResponseData;
import org.apache.kafka.common.message.StopReplicaResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.message.UpdateMetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddOffsetsToTxnRequest;
import org.apache.kafka.common.requests.AddOffsetsToTxnResponse;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.ControlledShutdownRequest;
import org.apache.kafka.common.requests.ControlledShutdownResponse;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.CreateDelegationTokenRequest;
import org.apache.kafka.common.requests.CreateDelegationTokenResponse;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DeleteGroupsRequest;
import org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.DescribeDelegationTokenRequest;
import org.apache.kafka.common.requests.DescribeDelegationTokenResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.ElectLeadersRequest;
import org.apache.kafka.common.requests.ElectLeadersResponse;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.common.requests.EndTxnResponse;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.ExpireDelegationTokenRequest;
import org.apache.kafka.common.requests.ExpireDelegationTokenResponse;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.ListPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetDeleteRequest;
import org.apache.kafka.common.requests.OffsetDeleteResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RenewDelegationTokenRequest;
import org.apache.kafka.common.requests.RenewDelegationTokenResponse;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.SaslAuthenticateRequest;
import org.apache.kafka.common.requests.SaslAuthenticateResponse;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class RequestResponseTest {
    @Test
    public void testSerialization() throws Exception {
        int v;
        this.checkRequest((AbstractRequest)this.createFindCoordinatorRequest(0), true);
        this.checkRequest((AbstractRequest)this.createFindCoordinatorRequest(1), true);
        this.checkErrorResponse((AbstractRequest)this.createFindCoordinatorRequest(0), (Throwable)new UnknownServerException(), true);
        this.checkErrorResponse((AbstractRequest)this.createFindCoordinatorRequest(1), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createFindCoordinatorResponse(), 0, true);
        this.checkResponse((AbstractResponse)this.createFindCoordinatorResponse(), 1, true);
        this.checkRequest((AbstractRequest)this.createControlledShutdownRequest(), true);
        this.checkResponse((AbstractResponse)this.createControlledShutdownResponse(), 1, true);
        this.checkErrorResponse((AbstractRequest)this.createControlledShutdownRequest(), (Throwable)new UnknownServerException(), true);
        this.checkErrorResponse((AbstractRequest)this.createControlledShutdownRequest(0), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createFetchRequest(4), true);
        this.checkResponse((AbstractResponse)this.createFetchResponse(), 4, true);
        ArrayList<TopicPartition> toForgetTopics = new ArrayList<TopicPartition>();
        toForgetTopics.add(new TopicPartition("foo", 0));
        toForgetTopics.add(new TopicPartition("foo", 2));
        toForgetTopics.add(new TopicPartition("bar", 0));
        this.checkRequest((AbstractRequest)this.createFetchRequest(7, new FetchMetadata(123, 456), toForgetTopics), true);
        this.checkResponse((AbstractResponse)this.createFetchResponse(123), 7, true);
        this.checkResponse((AbstractResponse)this.createFetchResponse(Errors.FETCH_SESSION_ID_NOT_FOUND, 123), 7, true);
        this.checkErrorResponse((AbstractRequest)this.createFetchRequest(4), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createHeartBeatRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createHeartBeatRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createHeartBeatResponse(), 0, true);
        for (v = ApiKeys.JOIN_GROUP.oldestVersion(); v <= ApiKeys.JOIN_GROUP.latestVersion(); ++v) {
            this.checkRequest((AbstractRequest)this.createJoinGroupRequest(v), true);
            this.checkErrorResponse((AbstractRequest)this.createJoinGroupRequest(v), (Throwable)new UnknownServerException(), true);
            this.checkResponse((AbstractResponse)this.createJoinGroupResponse(v), v, true);
        }
        for (v = ApiKeys.SYNC_GROUP.oldestVersion(); v <= ApiKeys.SYNC_GROUP.latestVersion(); ++v) {
            this.checkRequest((AbstractRequest)this.createSyncGroupRequest(v), true);
            this.checkErrorResponse((AbstractRequest)this.createSyncGroupRequest(v), (Throwable)new UnknownServerException(), true);
            this.checkResponse((AbstractResponse)this.createSyncGroupResponse(v), v, true);
        }
        this.checkRequest((AbstractRequest)this.createLeaveGroupRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createLeaveGroupRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createLeaveGroupResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createListGroupsRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createListGroupsRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createListGroupsResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createDescribeGroupRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createDescribeGroupRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createDescribeGroupResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createDeleteGroupsRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createDeleteGroupsRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createDeleteGroupsResponse(), 0, true);
        for (int i = 0; i < ApiKeys.LIST_OFFSETS.latestVersion(); ++i) {
            this.checkRequest((AbstractRequest)this.createListOffsetRequest(i), true);
            this.checkErrorResponse((AbstractRequest)this.createListOffsetRequest(i), (Throwable)new UnknownServerException(), true);
            this.checkResponse((AbstractResponse)this.createListOffsetResponse(i), i, true);
        }
        this.checkRequest((AbstractRequest)MetadataRequest.Builder.allTopics().build((short)2), true);
        this.checkRequest((AbstractRequest)this.createMetadataRequest(1, Collections.singletonList("topic1")), true);
        this.checkErrorResponse((AbstractRequest)this.createMetadataRequest(1, Collections.singletonList("topic1")), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createMetadataResponse(), 2, true);
        this.checkErrorResponse((AbstractRequest)this.createMetadataRequest(2, Collections.singletonList("topic1")), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createMetadataResponse(), 3, true);
        this.checkErrorResponse((AbstractRequest)this.createMetadataRequest(3, Collections.singletonList("topic1")), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createMetadataResponse(), 4, true);
        this.checkErrorResponse((AbstractRequest)this.createMetadataRequest(4, Collections.singletonList("topic1")), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createOffsetFetchRequestForAllPartition("group1", false), true);
        this.checkRequest((AbstractRequest)this.createOffsetFetchRequestForAllPartition("group1", true), true);
        this.checkErrorResponse((AbstractRequest)this.createOffsetFetchRequestForAllPartition("group1", false), (Throwable)new NotCoordinatorException("Not Coordinator"), true);
        this.checkErrorResponse((AbstractRequest)this.createOffsetFetchRequestForAllPartition("group1", true), (Throwable)new NotCoordinatorException("Not Coordinator"), true);
        this.checkRequest((AbstractRequest)this.createOffsetFetchRequest(0, false), true);
        this.checkRequest((AbstractRequest)this.createOffsetFetchRequest(1, false), true);
        this.checkRequest((AbstractRequest)this.createOffsetFetchRequest(2, false), true);
        this.checkRequest((AbstractRequest)this.createOffsetFetchRequest(7, true), true);
        this.checkRequest((AbstractRequest)this.createOffsetFetchRequestForAllPartition("group1", false), true);
        this.checkRequest((AbstractRequest)this.createOffsetFetchRequestForAllPartition("group1", true), true);
        this.checkErrorResponse((AbstractRequest)this.createOffsetFetchRequest(0, false), (Throwable)new UnknownServerException(), true);
        this.checkErrorResponse((AbstractRequest)this.createOffsetFetchRequest(1, false), (Throwable)new UnknownServerException(), true);
        this.checkErrorResponse((AbstractRequest)this.createOffsetFetchRequest(2, false), (Throwable)new UnknownServerException(), true);
        this.checkErrorResponse((AbstractRequest)this.createOffsetFetchRequest(7, true), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createOffsetFetchResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createProduceRequest(2), true);
        this.checkErrorResponse((AbstractRequest)this.createProduceRequest(2), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createProduceRequest(3), true);
        this.checkErrorResponse((AbstractRequest)this.createProduceRequest(3), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createProduceResponse(), 2, true);
        this.checkResponse((AbstractResponse)this.createProduceResponseWithErrorMessage(), 8, true);
        this.checkRequest((AbstractRequest)this.createStopReplicaRequest(0, true), true);
        this.checkRequest((AbstractRequest)this.createStopReplicaRequest(0, false), true);
        this.checkErrorResponse((AbstractRequest)this.createStopReplicaRequest(0, true), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createStopReplicaRequest(1, true), true);
        this.checkRequest((AbstractRequest)this.createStopReplicaRequest(1, false), true);
        this.checkErrorResponse((AbstractRequest)this.createStopReplicaRequest(1, true), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createStopReplicaResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createLeaderAndIsrRequest(0), true);
        this.checkErrorResponse((AbstractRequest)this.createLeaderAndIsrRequest(0), (Throwable)new UnknownServerException(), false);
        this.checkRequest((AbstractRequest)this.createLeaderAndIsrRequest(1), true);
        this.checkErrorResponse((AbstractRequest)this.createLeaderAndIsrRequest(1), (Throwable)new UnknownServerException(), false);
        this.checkRequest((AbstractRequest)this.createLeaderAndIsrRequest(2), true);
        this.checkErrorResponse((AbstractRequest)this.createLeaderAndIsrRequest(2), (Throwable)new UnknownServerException(), false);
        this.checkResponse((AbstractResponse)this.createLeaderAndIsrResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createSaslHandshakeRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createSaslHandshakeRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createSaslHandshakeResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createSaslAuthenticateRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createSaslAuthenticateRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createSaslAuthenticateResponse(), 0, true);
        this.checkResponse((AbstractResponse)this.createSaslAuthenticateResponse(), 1, true);
        this.checkRequest((AbstractRequest)this.createApiVersionRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createApiVersionRequest(), (Throwable)new UnknownServerException(), true);
        this.checkErrorResponse((AbstractRequest)this.createApiVersionRequest(), new UnsupportedVersionException("Not Supported"), true);
        this.checkResponse((AbstractResponse)this.createApiVersionResponse(), 0, true);
        this.checkResponse((AbstractResponse)this.createApiVersionResponse(), 1, true);
        this.checkResponse((AbstractResponse)this.createApiVersionResponse(), 2, true);
        this.checkResponse((AbstractResponse)this.createApiVersionResponse(), 3, true);
        this.checkResponse((AbstractResponse)ApiVersionsResponse.DEFAULT_API_VERSIONS_RESPONSE, 0, true);
        this.checkResponse((AbstractResponse)ApiVersionsResponse.DEFAULT_API_VERSIONS_RESPONSE, 1, true);
        this.checkResponse((AbstractResponse)ApiVersionsResponse.DEFAULT_API_VERSIONS_RESPONSE, 2, true);
        this.checkResponse((AbstractResponse)ApiVersionsResponse.DEFAULT_API_VERSIONS_RESPONSE, 3, true);
        this.checkRequest((AbstractRequest)this.createCreateTopicRequest(0), true);
        this.checkErrorResponse((AbstractRequest)this.createCreateTopicRequest(0), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createCreateTopicResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createCreateTopicRequest(1), true);
        this.checkErrorResponse((AbstractRequest)this.createCreateTopicRequest(1), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createCreateTopicResponse(), 1, true);
        this.checkRequest((AbstractRequest)this.createCreateTopicRequest(2), true);
        this.checkErrorResponse((AbstractRequest)this.createCreateTopicRequest(2), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createCreateTopicResponse(), 2, true);
        this.checkRequest((AbstractRequest)this.createCreateTopicRequest(3), true);
        this.checkErrorResponse((AbstractRequest)this.createCreateTopicRequest(3), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createCreateTopicResponse(), 3, true);
        this.checkRequest((AbstractRequest)this.createCreateTopicRequest(4), true);
        this.checkErrorResponse((AbstractRequest)this.createCreateTopicRequest(4), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createCreateTopicResponse(), 4, true);
        this.checkRequest((AbstractRequest)this.createCreateTopicRequest(5), true);
        this.checkErrorResponse((AbstractRequest)this.createCreateTopicRequest(5), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createCreateTopicResponse(), 5, true);
        this.checkRequest((AbstractRequest)this.createDeleteTopicsRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createDeleteTopicsRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createDeleteTopicsResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createInitPidRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createInitPidRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createInitPidResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createAddPartitionsToTxnRequest(), true);
        this.checkResponse((AbstractResponse)this.createAddPartitionsToTxnResponse(), 0, true);
        this.checkErrorResponse((AbstractRequest)this.createAddPartitionsToTxnRequest(), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createAddOffsetsToTxnRequest(), true);
        this.checkResponse((AbstractResponse)this.createAddOffsetsToTxnResponse(), 0, true);
        this.checkErrorResponse((AbstractRequest)this.createAddOffsetsToTxnRequest(), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createEndTxnRequest(), true);
        this.checkResponse((AbstractResponse)this.createEndTxnResponse(), 0, true);
        this.checkErrorResponse((AbstractRequest)this.createEndTxnRequest(), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createWriteTxnMarkersRequest(), true);
        this.checkResponse((AbstractResponse)this.createWriteTxnMarkersResponse(), 0, true);
        this.checkErrorResponse((AbstractRequest)this.createWriteTxnMarkersRequest(), (Throwable)new UnknownServerException(), true);
        this.checkOlderFetchVersions();
        this.checkResponse((AbstractResponse)this.createMetadataResponse(), 0, true);
        this.checkResponse((AbstractResponse)this.createMetadataResponse(), 1, true);
        this.checkErrorResponse((AbstractRequest)this.createMetadataRequest(1, Collections.singletonList("topic1")), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createOffsetCommitRequest(0), true);
        this.checkErrorResponse((AbstractRequest)this.createOffsetCommitRequest(0), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createOffsetCommitRequest(1), true);
        this.checkErrorResponse((AbstractRequest)this.createOffsetCommitRequest(1), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createOffsetCommitRequest(2), true);
        this.checkErrorResponse((AbstractRequest)this.createOffsetCommitRequest(2), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createOffsetCommitRequest(3), true);
        this.checkErrorResponse((AbstractRequest)this.createOffsetCommitRequest(3), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createOffsetCommitRequest(4), true);
        this.checkErrorResponse((AbstractRequest)this.createOffsetCommitRequest(4), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createOffsetCommitResponse(), 4, true);
        this.checkRequest((AbstractRequest)this.createOffsetCommitRequest(5), true);
        this.checkErrorResponse((AbstractRequest)this.createOffsetCommitRequest(5), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createOffsetCommitResponse(), 5, true);
        this.checkRequest((AbstractRequest)this.createJoinGroupRequest(0), true);
        this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(0, null), false);
        this.checkErrorResponse((AbstractRequest)this.createUpdateMetadataRequest(0, null), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(1, null), false);
        this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(1, "rack1"), false);
        this.checkErrorResponse((AbstractRequest)this.createUpdateMetadataRequest(1, null), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(2, "rack1"), false);
        this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(2, null), false);
        this.checkErrorResponse((AbstractRequest)this.createUpdateMetadataRequest(2, "rack1"), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(3, "rack1"), false);
        this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(3, null), false);
        this.checkErrorResponse((AbstractRequest)this.createUpdateMetadataRequest(3, "rack1"), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(4, "rack1"), false);
        this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(4, null), false);
        this.checkErrorResponse((AbstractRequest)this.createUpdateMetadataRequest(4, "rack1"), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(5, "rack1"), false);
        this.checkRequest((AbstractRequest)this.createUpdateMetadataRequest(5, null), false);
        this.checkErrorResponse((AbstractRequest)this.createUpdateMetadataRequest(5, "rack1"), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createUpdateMetadataResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createListOffsetRequest(0), true);
        this.checkErrorResponse((AbstractRequest)this.createListOffsetRequest(0), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createListOffsetResponse(0), 0, true);
        this.checkRequest((AbstractRequest)this.createLeaderEpochRequestForReplica(0, 1), true);
        this.checkRequest((AbstractRequest)this.createLeaderEpochRequestForConsumer(), true);
        this.checkResponse((AbstractResponse)this.createLeaderEpochResponse(), 0, true);
        this.checkErrorResponse((AbstractRequest)this.createLeaderEpochRequestForConsumer(), (Throwable)new UnknownServerException(), true);
        this.checkRequest((AbstractRequest)this.createAddPartitionsToTxnRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createAddPartitionsToTxnRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createAddPartitionsToTxnResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createAddOffsetsToTxnRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createAddOffsetsToTxnRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createAddOffsetsToTxnResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createEndTxnRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createEndTxnRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createEndTxnResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createWriteTxnMarkersRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createWriteTxnMarkersRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createWriteTxnMarkersResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createTxnOffsetCommitRequest(0), true);
        this.checkRequest((AbstractRequest)this.createTxnOffsetCommitRequest(3), true);
        this.checkErrorResponse((AbstractRequest)this.createTxnOffsetCommitRequest(0), (Throwable)new UnknownServerException(), true);
        this.checkErrorResponse((AbstractRequest)this.createTxnOffsetCommitRequest(3), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createTxnOffsetCommitResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createDescribeAclsRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createDescribeAclsRequest(), (Throwable)new SecurityDisabledException("Security is not enabled."), true);
        this.checkResponse((AbstractResponse)this.createDescribeAclsResponse(), ApiKeys.DESCRIBE_ACLS.latestVersion(), true);
        this.checkRequest((AbstractRequest)this.createCreateAclsRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createCreateAclsRequest(), (Throwable)new SecurityDisabledException("Security is not enabled."), true);
        this.checkResponse((AbstractResponse)this.createCreateAclsResponse(), ApiKeys.CREATE_ACLS.latestVersion(), true);
        this.checkRequest((AbstractRequest)this.createDeleteAclsRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createDeleteAclsRequest(), (Throwable)new SecurityDisabledException("Security is not enabled."), true);
        this.checkResponse((AbstractResponse)this.createDeleteAclsResponse(), ApiKeys.DELETE_ACLS.latestVersion(), true);
        this.checkRequest((AbstractRequest)this.createAlterConfigsRequest(), false);
        this.checkErrorResponse((AbstractRequest)this.createAlterConfigsRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createAlterConfigsResponse(), 0, false);
        this.checkRequest((AbstractRequest)this.createDescribeConfigsRequest(0), true);
        this.checkRequest((AbstractRequest)this.createDescribeConfigsRequestWithConfigEntries(0), false);
        this.checkErrorResponse((AbstractRequest)this.createDescribeConfigsRequest(0), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createDescribeConfigsResponse(), 0, false);
        this.checkRequest((AbstractRequest)this.createDescribeConfigsRequest(1), true);
        this.checkRequest((AbstractRequest)this.createDescribeConfigsRequestWithConfigEntries(1), false);
        this.checkErrorResponse((AbstractRequest)this.createDescribeConfigsRequest(1), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createDescribeConfigsResponse(), 1, false);
        this.checkDescribeConfigsResponseVersions();
        this.checkRequest((AbstractRequest)this.createCreatePartitionsRequest(), true);
        this.checkRequest((AbstractRequest)this.createCreatePartitionsRequestWithAssignments(), false);
        this.checkErrorResponse((AbstractRequest)this.createCreatePartitionsRequest(), (Throwable)new InvalidTopicException(), true);
        this.checkResponse((AbstractResponse)this.createCreatePartitionsResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createCreateTokenRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createCreateTokenRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createCreateTokenResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createDescribeTokenRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createDescribeTokenRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createDescribeTokenResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createExpireTokenRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createExpireTokenRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createExpireTokenResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createRenewTokenRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createRenewTokenRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createRenewTokenResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createElectLeadersRequest(), true);
        this.checkRequest((AbstractRequest)this.createElectLeadersRequestNullPartitions(), true);
        this.checkErrorResponse((AbstractRequest)this.createElectLeadersRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createElectLeadersResponse(), 1, true);
        this.checkRequest((AbstractRequest)this.createIncrementalAlterConfigsRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createIncrementalAlterConfigsRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createIncrementalAlterConfigsResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createAlterPartitionReassignmentsRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createAlterPartitionReassignmentsRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createAlterPartitionReassignmentsResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createListPartitionReassignmentsRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createListPartitionReassignmentsRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createListPartitionReassignmentsResponse(), 0, true);
        this.checkRequest((AbstractRequest)this.createOffsetDeleteRequest(), true);
        this.checkErrorResponse((AbstractRequest)this.createOffsetDeleteRequest(), (Throwable)new UnknownServerException(), true);
        this.checkResponse((AbstractResponse)this.createOffsetDeleteResponse(), 0, true);
    }

    @Test
    public void testResponseHeader() {
        ResponseHeader header = this.createResponseHeader((short)1);
        ByteBuffer buffer = TestUtils.toBuffer(header.toStruct());
        ResponseHeader deserialized = ResponseHeader.parse((ByteBuffer)buffer, (short)header.headerVersion());
        Assert.assertEquals((long)header.correlationId(), (long)deserialized.correlationId());
    }

    private void checkOlderFetchVersions() throws Exception {
        int latestVersion = ApiKeys.FETCH.latestVersion();
        for (int i = 0; i < latestVersion; ++i) {
            this.checkErrorResponse((AbstractRequest)this.createFetchRequest(i), (Throwable)new UnknownServerException(), true);
            this.checkRequest((AbstractRequest)this.createFetchRequest(i), true);
            this.checkResponse((AbstractResponse)this.createFetchResponse(), i, true);
        }
    }

    private void verifyDescribeConfigsResponse(DescribeConfigsResponse expected, DescribeConfigsResponse actual, int version) throws Exception {
        for (ConfigResource resource : expected.configs().keySet()) {
            Collection deserializedEntries1 = actual.config(resource).entries();
            Iterator expectedEntries = expected.config(resource).entries().iterator();
            for (DescribeConfigsResponse.ConfigEntry entry : deserializedEntries1) {
                DescribeConfigsResponse.ConfigEntry expectedEntry = (DescribeConfigsResponse.ConfigEntry)expectedEntries.next();
                Assert.assertEquals((Object)expectedEntry.name(), (Object)entry.name());
                Assert.assertEquals((Object)expectedEntry.value(), (Object)entry.value());
                Assert.assertEquals((Object)expectedEntry.isReadOnly(), (Object)entry.isReadOnly());
                Assert.assertEquals((Object)expectedEntry.isSensitive(), (Object)entry.isSensitive());
                if (version == 1 || expectedEntry.source() != DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG && expectedEntry.source() != DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG) {
                    Assert.assertEquals((Object)expectedEntry.source(), (Object)entry.source());
                    continue;
                }
                Assert.assertEquals((Object)DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, (Object)entry.source());
            }
        }
    }

    private void checkDescribeConfigsResponseVersions() throws Exception {
        DescribeConfigsResponse response = this.createDescribeConfigsResponse();
        DescribeConfigsResponse deserialized0 = (DescribeConfigsResponse)this.deserialize((AbstractRequestResponse)response, response.toStruct((short)0), (short)0);
        this.verifyDescribeConfigsResponse(response, deserialized0, 0);
        DescribeConfigsResponse deserialized1 = (DescribeConfigsResponse)this.deserialize((AbstractRequestResponse)response, response.toStruct((short)1), (short)1);
        this.verifyDescribeConfigsResponse(response, deserialized1, 1);
    }

    private void checkErrorResponse(AbstractRequest req, Throwable e, boolean checkEqualityAndHashCode) {
        this.checkResponse(req.getErrorResponse(e), req.version(), checkEqualityAndHashCode);
    }

    private void checkRequest(AbstractRequest req, boolean checkEqualityAndHashCode) {
        try {
            Struct struct = req.toStruct();
            AbstractRequest deserialized = AbstractRequest.parseRequest((ApiKeys)req.api, (short)req.version(), (Struct)struct);
            Struct struct2 = deserialized.toStruct();
            if (checkEqualityAndHashCode) {
                Assert.assertEquals((Object)struct, (Object)struct2);
                Assert.assertEquals((long)struct.hashCode(), (long)struct2.hashCode());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to deserialize request " + req + " with type " + req.getClass(), e);
        }
    }

    private void checkResponse(AbstractResponse response, int version, boolean checkEqualityAndHashCode) {
        try {
            Struct struct = response.toStruct((short)version);
            AbstractResponse deserialized = (AbstractResponse)this.deserialize((AbstractRequestResponse)response, struct, (short)version);
            Struct struct2 = deserialized.toStruct((short)version);
            if (checkEqualityAndHashCode) {
                Assert.assertEquals((Object)struct, (Object)struct2);
                Assert.assertEquals((long)struct.hashCode(), (long)struct2.hashCode());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to deserialize response " + response + " with type " + response.getClass(), e);
        }
    }

    private AbstractRequestResponse deserialize(AbstractRequestResponse req, Struct struct, short version) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ByteBuffer buffer = TestUtils.toBuffer(struct);
        Method deserializer = req.getClass().getDeclaredMethod("parse", ByteBuffer.class, Short.TYPE);
        return (AbstractRequestResponse)deserializer.invoke(null, buffer, version);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void cannotUseFindCoordinatorV0ToFindTransactionCoordinator() {
        FindCoordinatorRequest.Builder builder = new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.TRANSACTION.id).setKey("foobar"));
        builder.build((short)0);
    }

    @Test
    public void produceRequestToStringTest() {
        ProduceRequest request = this.createProduceRequest(ApiKeys.PRODUCE.latestVersion());
        Assert.assertEquals((long)1L, (long)request.partitionRecordsOrFail().size());
        Assert.assertFalse((boolean)request.toString(false).contains("partitionSizes"));
        Assert.assertTrue((boolean)request.toString(false).contains("numPartitions=1"));
        Assert.assertTrue((boolean)request.toString(true).contains("partitionSizes"));
        Assert.assertFalse((boolean)request.toString(true).contains("numPartitions"));
        request.clearPartitionRecords();
        try {
            request.partitionRecordsOrFail();
            Assert.fail((String)"partitionRecordsOrFail should fail after clearPartitionRecords()");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)request.toString(false).contains("partitionSizes"));
        Assert.assertTrue((boolean)request.toString(false).contains("numPartitions=1"));
        Assert.assertTrue((boolean)request.toString(true).contains("partitionSizes"));
        Assert.assertFalse((boolean)request.toString(true).contains("numPartitions"));
    }

    @Test
    public void produceRequestGetErrorResponseTest() {
        ProduceRequest request = this.createProduceRequest(ApiKeys.PRODUCE.latestVersion());
        HashSet partitions = new HashSet(request.partitionRecordsOrFail().keySet());
        ProduceResponse errorResponse = (ProduceResponse)request.getErrorResponse((Throwable)new NotEnoughReplicasException());
        Assert.assertEquals(partitions, errorResponse.responses().keySet());
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)errorResponse.responses().values().iterator().next();
        Assert.assertEquals((Object)Errors.NOT_ENOUGH_REPLICAS, (Object)partitionResponse.error);
        Assert.assertEquals((long)-1L, (long)partitionResponse.baseOffset);
        Assert.assertEquals((long)-1L, (long)partitionResponse.logAppendTime);
        request.clearPartitionRecords();
        errorResponse = (ProduceResponse)request.getErrorResponse((Throwable)new NotEnoughReplicasException());
        Assert.assertEquals(partitions, errorResponse.responses().keySet());
        partitionResponse = (ProduceResponse.PartitionResponse)errorResponse.responses().values().iterator().next();
        Assert.assertEquals((Object)Errors.NOT_ENOUGH_REPLICAS, (Object)partitionResponse.error);
        Assert.assertEquals((long)-1L, (long)partitionResponse.baseOffset);
        Assert.assertEquals((long)-1L, (long)partitionResponse.logAppendTime);
    }

    @Test
    public void fetchResponseVersionTest() {
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> responseData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)ByteBuffer.allocate(10));
        responseData.put(new TopicPartition("test", 0), new FetchResponse.PartitionData(Errors.NONE, 1000000L, -1L, 0L, Optional.empty(), null, (BaseRecords)records));
        FetchResponse v0Response = new FetchResponse(Errors.NONE, responseData, 0, 0);
        FetchResponse v1Response = new FetchResponse(Errors.NONE, responseData, 10, 0);
        Assert.assertEquals((String)"Throttle time must be zero", (long)0L, (long)v0Response.throttleTimeMs());
        Assert.assertEquals((String)"Throttle time must be 10", (long)10L, (long)v1Response.throttleTimeMs());
        Assert.assertEquals((String)"Should use schema version 0", (Object)ApiKeys.FETCH.responseSchema((short)0), (Object)v0Response.toStruct((short)0).schema());
        Assert.assertEquals((String)"Should use schema version 1", (Object)ApiKeys.FETCH.responseSchema((short)1), (Object)v1Response.toStruct((short)1).schema());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v0Response.responseData());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v1Response.responseData());
    }

    @Test
    public void testFetchResponseV4() {
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> responseData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)ByteBuffer.allocate(10));
        List<FetchResponse.AbortedTransaction> abortedTransactions = Arrays.asList(new FetchResponse.AbortedTransaction(10L, 100L), new FetchResponse.AbortedTransaction(15L, 50L));
        responseData.put(new TopicPartition("bar", 0), new FetchResponse.PartitionData(Errors.NONE, 100000L, -1L, -1L, Optional.empty(), abortedTransactions, (BaseRecords)records));
        responseData.put(new TopicPartition("bar", 1), new FetchResponse.PartitionData(Errors.NONE, 900000L, 5L, -1L, Optional.empty(), null, (BaseRecords)records));
        responseData.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 70000L, 6L, -1L, Optional.empty(), Collections.emptyList(), (BaseRecords)records));
        FetchResponse response = new FetchResponse(Errors.NONE, responseData, 10, 0);
        FetchResponse deserialized = FetchResponse.parse((ByteBuffer)TestUtils.toBuffer(response.toStruct((short)4)), (short)4);
        Assert.assertEquals(responseData, (Object)deserialized.responseData());
    }

    @Test
    public void verifyFetchResponseFullWrites() throws Exception {
        this.verifyFetchResponseFullWrite(ApiKeys.FETCH.latestVersion(), this.createFetchResponse(123));
        this.verifyFetchResponseFullWrite(ApiKeys.FETCH.latestVersion(), this.createFetchResponse(Errors.FETCH_SESSION_ID_NOT_FOUND, 123));
        for (short version = 0; version <= ApiKeys.FETCH.latestVersion(); version = (short)(version + 1)) {
            this.verifyFetchResponseFullWrite(version, this.createFetchResponse());
        }
    }

    private void verifyFetchResponseFullWrite(short apiVersion, FetchResponse fetchResponse) throws Exception {
        int correlationId = 15;
        short responseHeaderVersion = ApiKeys.FETCH.responseHeaderVersion(apiVersion);
        Send send = fetchResponse.toSend("1", new ResponseHeader(correlationId, responseHeaderVersion), apiVersion);
        ByteBufferChannel channel = new ByteBufferChannel(send.size());
        send.writeTo((GatheringByteChannel)channel);
        channel.close();
        ByteBuffer buf = channel.buffer();
        int size = buf.getInt();
        Assert.assertTrue((size > 0 ? 1 : 0) != 0);
        ResponseHeader responseHeader = ResponseHeader.parse((ByteBuffer)channel.buffer(), (short)responseHeaderVersion);
        Assert.assertEquals((long)correlationId, (long)responseHeader.correlationId());
        Struct responseBody = ApiKeys.FETCH.responseSchema(apiVersion).read(buf);
        Assert.assertEquals((Object)fetchResponse.toStruct(apiVersion), (Object)responseBody);
        Assert.assertEquals((long)size, (long)(responseHeader.sizeOf() + responseBody.sizeOf()));
    }

    @Test
    public void testControlledShutdownResponse() {
        ControlledShutdownResponse response = this.createControlledShutdownResponse();
        short version = ApiKeys.CONTROLLED_SHUTDOWN.latestVersion();
        Struct struct = response.toStruct(version);
        ByteBuffer buffer = TestUtils.toBuffer(struct);
        ControlledShutdownResponse deserialized = ControlledShutdownResponse.parse((ByteBuffer)buffer, (short)version);
        Assert.assertEquals((Object)response.error(), (Object)deserialized.error());
        Assert.assertEquals((Object)((Object)response.data().remainingPartitions()), (Object)((Object)deserialized.data().remainingPartitions()));
    }

    @Test(expected=UnsupportedVersionException.class)
    public void testCreateTopicRequestV0FailsIfValidateOnly() {
        this.createCreateTopicRequest(0, true);
    }

    @Test
    public void testCreateTopicRequestV3FailsIfNoPartitionsOrReplicas() {
        UnsupportedVersionException exception = (UnsupportedVersionException)Assert.assertThrows(UnsupportedVersionException.class, () -> {
            CreateTopicsRequestData data = new CreateTopicsRequestData().setTimeoutMs(123).setValidateOnly(false);
            data.topics().add(new CreateTopicsRequestData.CreatableTopic().setName("foo").setNumPartitions(-1).setReplicationFactor((short)1));
            data.topics().add(new CreateTopicsRequestData.CreatableTopic().setName("bar").setNumPartitions(1).setReplicationFactor((short)-1));
            new CreateTopicsRequest.Builder(data).build((short)3);
        });
        Assert.assertTrue((boolean)exception.getMessage().contains("supported in CreateTopicRequest version 4+"));
        Assert.assertTrue((boolean)exception.getMessage().contains("[foo, bar]"));
    }

    @Test
    public void testFetchRequestMaxBytesOldVersions() throws Exception {
        boolean version = true;
        FetchRequest fr = this.createFetchRequest(1);
        FetchRequest fr2 = new FetchRequest(fr.toStruct(), 1);
        Assert.assertEquals((long)fr2.maxBytes(), (long)fr.maxBytes());
    }

    @Test
    public void testFetchRequestIsolationLevel() throws Exception {
        FetchRequest request = this.createFetchRequest(4, IsolationLevel.READ_COMMITTED);
        Struct struct = request.toStruct();
        FetchRequest deserialized = (FetchRequest)this.deserialize((AbstractRequestResponse)request, struct, request.version());
        Assert.assertEquals((Object)request.isolationLevel(), (Object)deserialized.isolationLevel());
        request = this.createFetchRequest(4, IsolationLevel.READ_UNCOMMITTED);
        struct = request.toStruct();
        deserialized = (FetchRequest)this.deserialize((AbstractRequestResponse)request, struct, request.version());
        Assert.assertEquals((Object)request.isolationLevel(), (Object)deserialized.isolationLevel());
    }

    @Test
    public void testFetchRequestWithMetadata() throws Exception {
        FetchRequest request = this.createFetchRequest(4, IsolationLevel.READ_COMMITTED);
        Struct struct = request.toStruct();
        FetchRequest deserialized = (FetchRequest)this.deserialize((AbstractRequestResponse)request, struct, request.version());
        Assert.assertEquals((Object)request.isolationLevel(), (Object)deserialized.isolationLevel());
        request = this.createFetchRequest(4, IsolationLevel.READ_UNCOMMITTED);
        struct = request.toStruct();
        deserialized = (FetchRequest)this.deserialize((AbstractRequestResponse)request, struct, request.version());
        Assert.assertEquals((Object)request.isolationLevel(), (Object)deserialized.isolationLevel());
    }

    @Test
    public void testJoinGroupRequestVersion0RebalanceTimeout() {
        boolean version = false;
        JoinGroupRequest jgr = this.createJoinGroupRequest(0);
        JoinGroupRequest jgr2 = new JoinGroupRequest(jgr.toStruct(), 0);
        Assert.assertEquals((long)jgr2.data().rebalanceTimeoutMs(), (long)jgr.data().rebalanceTimeoutMs());
    }

    @Test
    public void testOffsetFetchRequestBuilderToString() {
        List<Boolean> stableFlags = Arrays.asList(true, false);
        for (Boolean requireStable : stableFlags) {
            String allTopicPartitionsString = new OffsetFetchRequest.Builder("someGroup", requireStable.booleanValue(), null).toString();
            Assert.assertTrue((boolean)allTopicPartitionsString.contains("groupId='someGroup', topics=null, requireStable=" + requireStable.toString()));
            String string = new OffsetFetchRequest.Builder("group1", requireStable.booleanValue(), Collections.singletonList(new TopicPartition("test11", 1))).toString();
            Assert.assertTrue((boolean)string.contains("test11"));
            Assert.assertTrue((boolean)string.contains("group1"));
            Assert.assertTrue((boolean)string.contains("requireStable=" + requireStable.toString()));
        }
    }

    @Test
    public void testApiVersionsRequestBeforeV3Validation() {
        for (short version = 0; version < 3; version = (short)(version + 1)) {
            ApiVersionsRequest request = new ApiVersionsRequest(new ApiVersionsRequestData(), version);
            Assert.assertTrue((boolean)request.isValid());
        }
    }

    @Test
    public void testValidApiVersionsRequest() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        Assert.assertTrue((boolean)request.isValid());
        request = new ApiVersionsRequest(new ApiVersionsRequestData().setClientSoftwareName("apache-kafka.java").setClientSoftwareVersion("0.0.0-SNAPSHOT"), ApiKeys.API_VERSIONS.latestVersion());
        Assert.assertTrue((boolean)request.isValid());
    }

    @Test
    public void testInvalidApiVersionsRequest() {
        this.testInvalidCase("java@apache_kafka", "0.0.0-SNAPSHOT");
        this.testInvalidCase("apache-kafka-java", "0.0.0@java");
        this.testInvalidCase("-apache-kafka-java", "0.0.0");
        this.testInvalidCase("apache-kafka-java.", "0.0.0");
    }

    private void testInvalidCase(String name, String version) {
        ApiVersionsRequest request = new ApiVersionsRequest(new ApiVersionsRequestData().setClientSoftwareName(name).setClientSoftwareVersion(version), ApiKeys.API_VERSIONS.latestVersion());
        Assert.assertFalse((boolean)request.isValid());
    }

    @Test
    public void testApiVersionResponseWithUnsupportedError() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse response = request.getErrorResponse(0, (Throwable)Errors.UNSUPPORTED_VERSION.exception());
        Assert.assertEquals((long)Errors.UNSUPPORTED_VERSION.code(), (long)response.data.errorCode());
        ApiVersionsResponseData.ApiVersionsResponseKey apiVersion = response.data.apiKeys().find(ApiKeys.API_VERSIONS.id);
        Assert.assertNotNull((Object)apiVersion);
        Assert.assertEquals((long)ApiKeys.API_VERSIONS.id, (long)apiVersion.apiKey());
        Assert.assertEquals((long)ApiKeys.API_VERSIONS.oldestVersion(), (long)apiVersion.minVersion());
        Assert.assertEquals((long)ApiKeys.API_VERSIONS.latestVersion(), (long)apiVersion.maxVersion());
    }

    @Test
    public void testApiVersionResponseWithNotUnsupportedError() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse response = request.getErrorResponse(0, (Throwable)Errors.INVALID_REQUEST.exception());
        Assert.assertEquals((long)response.data.errorCode(), (long)Errors.INVALID_REQUEST.code());
        Assert.assertTrue((boolean)response.data.apiKeys().isEmpty());
    }

    @Test
    public void testApiVersionResponseStructParsingFallback() {
        Struct struct = ApiVersionsResponse.DEFAULT_API_VERSIONS_RESPONSE.toStruct((short)0);
        ApiVersionsResponse response = ApiVersionsResponse.fromStruct((Struct)struct, (short)ApiKeys.API_VERSIONS.latestVersion());
        Assert.assertEquals((long)Errors.NONE.code(), (long)response.data.errorCode());
    }

    @Test(expected=SchemaException.class)
    public void testApiVersionResponseStructParsingFallbackException() {
        short version = 0;
        ApiVersionsResponse.fromStruct((Struct)new Struct(ApiKeys.API_VERSIONS.requestSchema(version)), (short)version);
    }

    @Test
    public void testApiVersionResponseStructParsing() {
        Struct struct = ApiVersionsResponse.DEFAULT_API_VERSIONS_RESPONSE.toStruct(ApiKeys.API_VERSIONS.latestVersion());
        ApiVersionsResponse response = ApiVersionsResponse.fromStruct((Struct)struct, (short)ApiKeys.API_VERSIONS.latestVersion());
        Assert.assertEquals((long)Errors.NONE.code(), (long)response.data.errorCode());
    }

    @Test
    public void testInitProducerIdRequestVersions() {
        InitProducerIdRequest.Builder bld = new InitProducerIdRequest.Builder(new InitProducerIdRequestData().setTransactionTimeoutMs(1000).setTransactionalId("abracadabra").setProducerId(123L));
        UnsupportedVersionException exception = (UnsupportedVersionException)Assert.assertThrows(UnsupportedVersionException.class, () -> bld.build((short)2).toStruct());
        Assert.assertTrue((boolean)exception.getMessage().contains("Attempted to write a non-default producerId at version 2"));
        bld.build((short)3);
    }

    private ResponseHeader createResponseHeader(short headerVersion) {
        return new ResponseHeader(10, headerVersion);
    }

    private FindCoordinatorRequest createFindCoordinatorRequest(int version) {
        return new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.GROUP.id()).setKey("test-group")).build((short)version);
    }

    private FindCoordinatorResponse createFindCoordinatorResponse() {
        Node node = new Node(10, "host1", 2014);
        return FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (Node)node);
    }

    private FetchRequest createFetchRequest(int version, FetchMetadata metadata, List<TopicPartition> toForget) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> fetchData = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        fetchData.put(new TopicPartition("test1", 0), new FetchRequest.PartitionData(100L, 0L, 1000000, Optional.of(15)));
        fetchData.put(new TopicPartition("test2", 0), new FetchRequest.PartitionData(200L, 0L, 1000000, Optional.of(25)));
        return FetchRequest.Builder.forConsumer((int)100, (int)100000, fetchData).metadata(metadata).setMaxBytes(1000).toForget(toForget).build((short)version);
    }

    private FetchRequest createFetchRequest(int version, IsolationLevel isolationLevel) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> fetchData = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        fetchData.put(new TopicPartition("test1", 0), new FetchRequest.PartitionData(100L, 0L, 1000000, Optional.of(15)));
        fetchData.put(new TopicPartition("test2", 0), new FetchRequest.PartitionData(200L, 0L, 1000000, Optional.of(25)));
        return FetchRequest.Builder.forConsumer((int)100, (int)100000, fetchData).isolationLevel(isolationLevel).setMaxBytes(1000).build((short)version);
    }

    private FetchRequest createFetchRequest(int version) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> fetchData = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        fetchData.put(new TopicPartition("test1", 0), new FetchRequest.PartitionData(100L, 0L, 1000000, Optional.of(15)));
        fetchData.put(new TopicPartition("test2", 0), new FetchRequest.PartitionData(200L, 0L, 1000000, Optional.of(25)));
        return FetchRequest.Builder.forConsumer((int)100, (int)100000, fetchData).setMaxBytes(1000).build((short)version);
    }

    private FetchResponse<MemoryRecords> createFetchResponse(Errors error, int sessionId) {
        return new FetchResponse(error, new LinkedHashMap(), 25, sessionId);
    }

    private FetchResponse<MemoryRecords> createFetchResponse(int sessionId) {
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> responseData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("blah".getBytes())});
        responseData.put(new TopicPartition("test", 0), new FetchResponse.PartitionData(Errors.NONE, 1000000L, -1L, 0L, Optional.empty(), null, (BaseRecords)records));
        List<FetchResponse.AbortedTransaction> abortedTransactions = Collections.singletonList(new FetchResponse.AbortedTransaction(234L, 999L));
        responseData.put(new TopicPartition("test", 1), new FetchResponse.PartitionData(Errors.NONE, 1000000L, -1L, 0L, Optional.empty(), abortedTransactions, (BaseRecords)MemoryRecords.EMPTY));
        return new FetchResponse(Errors.NONE, responseData, 25, sessionId);
    }

    private FetchResponse<MemoryRecords> createFetchResponse() {
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> responseData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("blah".getBytes())});
        responseData.put(new TopicPartition("test", 0), new FetchResponse.PartitionData(Errors.NONE, 1000000L, -1L, 0L, Optional.empty(), null, (BaseRecords)records));
        List<FetchResponse.AbortedTransaction> abortedTransactions = Collections.singletonList(new FetchResponse.AbortedTransaction(234L, 999L));
        responseData.put(new TopicPartition("test", 1), new FetchResponse.PartitionData(Errors.NONE, 1000000L, -1L, 0L, Optional.empty(), abortedTransactions, (BaseRecords)MemoryRecords.EMPTY));
        return new FetchResponse(Errors.NONE, responseData, 25, 0);
    }

    private HeartbeatRequest createHeartBeatRequest() {
        return (HeartbeatRequest)new HeartbeatRequest.Builder(new HeartbeatRequestData().setGroupId("group1").setGenerationId(1).setMemberId("consumer1")).build();
    }

    private HeartbeatResponse createHeartBeatResponse() {
        return new HeartbeatResponse(new HeartbeatResponseData().setErrorCode(Errors.NONE.code()));
    }

    private JoinGroupRequest createJoinGroupRequest(int version) {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(Collections.singleton(new JoinGroupRequestData.JoinGroupRequestProtocol().setName("consumer-range").setMetadata(new byte[0])).iterator());
        JoinGroupRequestData data = new JoinGroupRequestData().setGroupId("group1").setSessionTimeoutMs(30000).setMemberId("consumer1").setProtocolType("consumer").setProtocols(protocols);
        if (version >= 1) {
            data.setRebalanceTimeoutMs(60000);
        }
        if (version >= 5) {
            data.setGroupInstanceId("groupInstanceId");
        }
        return new JoinGroupRequest.Builder(data).build((short)version);
    }

    private JoinGroupResponse createJoinGroupResponse(int version) {
        ArrayList<JoinGroupResponseData.JoinGroupResponseMember> members = new ArrayList<JoinGroupResponseData.JoinGroupResponseMember>();
        for (int i = 0; i < 2; ++i) {
            JoinGroupResponseData.JoinGroupResponseMember member = new JoinGroupResponseData.JoinGroupResponseMember().setMemberId("consumer" + i).setMetadata(new byte[0]);
            if (version >= 5) {
                member.setGroupInstanceId("instance" + i);
            }
            members.add(member);
        }
        JoinGroupResponseData data = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(1).setProtocolType("consumer").setProtocolName("range").setLeader("leader").setMemberId("consumer1").setMembers(members);
        if (version >= 1) {
            data.setThrottleTimeMs(1000);
        }
        return new JoinGroupResponse(data);
    }

    private SyncGroupRequest createSyncGroupRequest(int version) {
        List<SyncGroupRequestData.SyncGroupRequestAssignment> assignments = Collections.singletonList(new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId("member").setAssignment(new byte[0]));
        SyncGroupRequestData data = new SyncGroupRequestData().setGroupId("group1").setGenerationId(1).setMemberId("member").setProtocolType("consumer").setProtocolName("range").setAssignments(assignments);
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(Collections.singleton(new JoinGroupRequestData.JoinGroupRequestProtocol().setName("consumer-range").setMetadata(new byte[0])).iterator());
        if (version >= 3) {
            data.setGroupInstanceId("groupInstanceId");
        }
        return new SyncGroupRequest.Builder(data).build((short)version);
    }

    private SyncGroupResponse createSyncGroupResponse(int version) {
        SyncGroupResponseData data = new SyncGroupResponseData().setErrorCode(Errors.NONE.code()).setProtocolType("consumer").setProtocolName("range").setAssignment(new byte[0]);
        if (version >= 1) {
            data.setThrottleTimeMs(1000);
        }
        return new SyncGroupResponse(data);
    }

    private ListGroupsRequest createListGroupsRequest() {
        return (ListGroupsRequest)new ListGroupsRequest.Builder(new ListGroupsRequestData()).build();
    }

    private ListGroupsResponse createListGroupsResponse() {
        return new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Collections.singletonList(new ListGroupsResponseData.ListedGroup().setGroupId("test-group").setProtocolType("consumer"))));
    }

    private DescribeGroupsRequest createDescribeGroupRequest() {
        return (DescribeGroupsRequest)new DescribeGroupsRequest.Builder(new DescribeGroupsRequestData().setGroups(Collections.singletonList("test-group"))).build();
    }

    private DescribeGroupsResponse createDescribeGroupResponse() {
        String clientId = "consumer-1";
        String clientHost = "localhost";
        DescribeGroupsResponseData describeGroupsResponseData = new DescribeGroupsResponseData();
        DescribeGroupsResponseData.DescribedGroupMember member = DescribeGroupsResponse.groupMember((String)"memberId", null, (String)clientId, (String)clientHost, (byte[])new byte[0], (byte[])new byte[0]);
        DescribeGroupsResponseData.DescribedGroup metadata = DescribeGroupsResponse.groupMetadata((String)"test-group", (Errors)Errors.NONE, (String)"STABLE", (String)"consumer", (String)"roundrobin", Collections.singletonList(member), (int)Integer.MIN_VALUE);
        describeGroupsResponseData.groups().add(metadata);
        return new DescribeGroupsResponse(describeGroupsResponseData);
    }

    private LeaveGroupRequest createLeaveGroupRequest() {
        return (LeaveGroupRequest)new LeaveGroupRequest.Builder("group1", Collections.singletonList(new LeaveGroupRequestData.MemberIdentity().setMemberId("consumer1"))).build();
    }

    private LeaveGroupResponse createLeaveGroupResponse() {
        return new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()));
    }

    private DeleteGroupsRequest createDeleteGroupsRequest() {
        return (DeleteGroupsRequest)new DeleteGroupsRequest.Builder(new DeleteGroupsRequestData().setGroupsNames(Collections.singletonList("test-group"))).build();
    }

    private DeleteGroupsResponse createDeleteGroupsResponse() {
        DeleteGroupsResponseData.DeletableGroupResultCollection result = new DeleteGroupsResponseData.DeletableGroupResultCollection();
        result.add(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("test-group").setErrorCode(Errors.NONE.code()));
        return new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(result));
    }

    private ListOffsetRequest createListOffsetRequest(int version) {
        if (version == 0) {
            Map<TopicPartition, ListOffsetRequest.PartitionData> offsetData = Collections.singletonMap(new TopicPartition("test", 0), new ListOffsetRequest.PartitionData(1000000L, 10));
            return ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(offsetData).build((short)version);
        }
        if (version == 1) {
            Map<TopicPartition, ListOffsetRequest.PartitionData> offsetData = Collections.singletonMap(new TopicPartition("test", 0), new ListOffsetRequest.PartitionData(1000000L, Optional.empty()));
            return ListOffsetRequest.Builder.forConsumer((boolean)true, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(offsetData).build((short)version);
        }
        if (version >= 2 && version <= 5) {
            Map<TopicPartition, ListOffsetRequest.PartitionData> offsetData = Collections.singletonMap(new TopicPartition("test", 0), new ListOffsetRequest.PartitionData(1000000L, Optional.of(5)));
            return ListOffsetRequest.Builder.forConsumer((boolean)true, (IsolationLevel)IsolationLevel.READ_COMMITTED).setTargetTimes(offsetData).build((short)version);
        }
        throw new IllegalArgumentException("Illegal ListOffsetRequest version " + version);
    }

    private ListOffsetResponse createListOffsetResponse(int version) {
        if (version == 0) {
            HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
            responseData.put(new TopicPartition("test", 0), new ListOffsetResponse.PartitionData(Errors.NONE, Arrays.asList(100L)));
            return new ListOffsetResponse(responseData);
        }
        if (version >= 1 && version <= 5) {
            HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
            responseData.put(new TopicPartition("test", 0), new ListOffsetResponse.PartitionData(Errors.NONE, 10000L, 100L, Optional.of(27)));
            return new ListOffsetResponse(responseData);
        }
        throw new IllegalArgumentException("Illegal ListOffsetResponse version " + version);
    }

    private MetadataRequest createMetadataRequest(int version, List<String> topics) {
        return new MetadataRequest.Builder(topics, true).build((short)version);
    }

    private MetadataResponse createMetadataResponse() {
        Node node = new Node(1, "host1", 1001);
        List<Integer> replicas = Collections.singletonList(node.id());
        List<Integer> isr = Collections.singletonList(node.id());
        List offlineReplicas = Collections.emptyList();
        ArrayList<MetadataResponse.TopicMetadata> allTopicMetadata = new ArrayList<MetadataResponse.TopicMetadata>();
        allTopicMetadata.add(new MetadataResponse.TopicMetadata(Errors.NONE, "__consumer_offsets", true, Arrays.asList(new MetadataResponse.PartitionMetadata(Errors.NONE, new TopicPartition("__consumer_offsets", 1), Optional.of(node.id()), Optional.of(5), replicas, isr, offlineReplicas))));
        allTopicMetadata.add(new MetadataResponse.TopicMetadata(Errors.LEADER_NOT_AVAILABLE, "topic2", false, Collections.emptyList()));
        allTopicMetadata.add(new MetadataResponse.TopicMetadata(Errors.NONE, "topic3", false, Arrays.asList(new MetadataResponse.PartitionMetadata(Errors.LEADER_NOT_AVAILABLE, new TopicPartition("topic3", 0), Optional.empty(), Optional.empty(), replicas, isr, offlineReplicas))));
        return MetadataResponse.prepareResponse(Arrays.asList(node), null, (int)-1, allTopicMetadata);
    }

    private OffsetCommitRequest createOffsetCommitRequest(int version) {
        return new OffsetCommitRequest.Builder(new OffsetCommitRequestData().setGroupId("group1").setMemberId("consumer1").setGroupInstanceId(null).setGenerationId(100).setTopics(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestTopic().setName("test").setPartitions(Arrays.asList(new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(0).setCommittedOffset(100L).setCommittedLeaderEpoch(-1).setCommittedMetadata(""), new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(1).setCommittedOffset(200L).setCommittedLeaderEpoch(-1).setCommittedMetadata(null)))))).build((short)version);
    }

    private OffsetCommitResponse createOffsetCommitResponse() {
        return new OffsetCommitResponse(new OffsetCommitResponseData().setTopics(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponseTopic().setName("test").setPartitions(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code()))))));
    }

    private OffsetFetchRequest createOffsetFetchRequest(int version, boolean requireStable) {
        return new OffsetFetchRequest.Builder("group1", requireStable, Collections.singletonList(new TopicPartition("test11", 1))).build((short)version);
    }

    private OffsetFetchRequest createOffsetFetchRequestForAllPartition(String groupId, boolean requireStable) {
        return (OffsetFetchRequest)new OffsetFetchRequest.Builder(groupId, requireStable, null).build();
    }

    private OffsetFetchResponse createOffsetFetchResponse() {
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responseData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        responseData.put(new TopicPartition("test", 0), new OffsetFetchResponse.PartitionData(100L, Optional.empty(), "", Errors.NONE));
        responseData.put(new TopicPartition("test", 1), new OffsetFetchResponse.PartitionData(100L, Optional.of(10), null, Errors.NONE));
        return new OffsetFetchResponse(Errors.NONE, responseData);
    }

    private ProduceRequest createProduceRequest(int version) {
        if (version < 2) {
            throw new IllegalArgumentException("Produce request version 2 is not supported");
        }
        byte magic = version == 2 ? (byte)1 : 2;
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("woot".getBytes())});
        Map<TopicPartition, MemoryRecords> produceData = Collections.singletonMap(new TopicPartition("test", 0), records);
        return ProduceRequest.Builder.forMagic((byte)magic, (short)1, (int)5000, produceData, (String)"transactionalId").build((short)version);
    }

    private ProduceResponse createProduceResponse() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        responseData.put(new TopicPartition("test", 0), new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L, 100L));
        return new ProduceResponse(responseData, 0);
    }

    private ProduceResponse createProduceResponseWithErrorMessage() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        responseData.put(new TopicPartition("test", 0), new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L, 100L, Collections.singletonList(new ProduceResponse.RecordError(0, "error message")), "global error message"));
        return new ProduceResponse(responseData, 0);
    }

    private StopReplicaRequest createStopReplicaRequest(int version, boolean deletePartitions) {
        Set partitions = Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("test", 0)});
        return (StopReplicaRequest)new StopReplicaRequest.Builder((short)version, 0, 1, 0L, deletePartitions, (Collection)partitions).build();
    }

    private StopReplicaResponse createStopReplicaResponse() {
        ArrayList<StopReplicaResponseData.StopReplicaPartitionError> partitions = new ArrayList<StopReplicaResponseData.StopReplicaPartitionError>();
        partitions.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("test").setPartitionIndex(0).setErrorCode(Errors.NONE.code()));
        return new StopReplicaResponse(new StopReplicaResponseData().setErrorCode(Errors.NONE.code()).setPartitionErrors(partitions));
    }

    private ControlledShutdownRequest createControlledShutdownRequest() {
        ControlledShutdownRequestData data = new ControlledShutdownRequestData().setBrokerId(10).setBrokerEpoch(0L);
        return (ControlledShutdownRequest)new ControlledShutdownRequest.Builder(data, ApiKeys.CONTROLLED_SHUTDOWN.latestVersion()).build();
    }

    private ControlledShutdownRequest createControlledShutdownRequest(int version) {
        ControlledShutdownRequestData data = new ControlledShutdownRequestData().setBrokerId(10).setBrokerEpoch(0L);
        return new ControlledShutdownRequest.Builder(data, ApiKeys.CONTROLLED_SHUTDOWN.latestVersion()).build((short)version);
    }

    private ControlledShutdownResponse createControlledShutdownResponse() {
        ControlledShutdownResponseData.RemainingPartition p1 = new ControlledShutdownResponseData.RemainingPartition().setTopicName("test2").setPartitionIndex(5);
        ControlledShutdownResponseData.RemainingPartition p2 = new ControlledShutdownResponseData.RemainingPartition().setTopicName("test1").setPartitionIndex(10);
        ControlledShutdownResponseData.RemainingPartitionCollection pSet = new ControlledShutdownResponseData.RemainingPartitionCollection();
        pSet.add(p1);
        pSet.add(p2);
        ControlledShutdownResponseData data = new ControlledShutdownResponseData().setErrorCode(Errors.NONE.code()).setRemainingPartitions(pSet);
        return new ControlledShutdownResponse(data);
    }

    private LeaderAndIsrRequest createLeaderAndIsrRequest(int version) {
        ArrayList<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates = new ArrayList<LeaderAndIsrRequestData.LeaderAndIsrPartitionState>();
        List<Integer> isr = Arrays.asList(1, 2);
        List<Integer> replicas = Arrays.asList(1, 2, 3, 4);
        partitionStates.add(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("topic5").setPartitionIndex(105).setControllerEpoch(0).setLeader(2).setLeaderEpoch(1).setIsr(isr).setZkVersion(2).setReplicas(replicas).setIsNew(false));
        partitionStates.add(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("topic5").setPartitionIndex(1).setControllerEpoch(1).setLeader(1).setLeaderEpoch(1).setIsr(isr).setZkVersion(2).setReplicas(replicas).setIsNew(false));
        partitionStates.add(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("topic20").setPartitionIndex(1).setControllerEpoch(1).setLeader(0).setLeaderEpoch(1).setIsr(isr).setZkVersion(2).setReplicas(replicas).setIsNew(false));
        Set leaders = Utils.mkSet((Object[])new Node[]{new Node(0, "test0", 1223), new Node(1, "test1", 1223)});
        return (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder((short)version, 1, 10, 0L, partitionStates, (Collection)leaders).build();
    }

    private LeaderAndIsrResponse createLeaderAndIsrResponse() {
        ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions = new ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError>();
        partitions.add(new LeaderAndIsrResponseData.LeaderAndIsrPartitionError().setTopicName("test").setPartitionIndex(0).setErrorCode(Errors.NONE.code()));
        return new LeaderAndIsrResponse(new LeaderAndIsrResponseData().setErrorCode(Errors.NONE.code()).setPartitionErrors(partitions));
    }

    private UpdateMetadataRequest createUpdateMetadataRequest(int version, String rack) {
        ArrayList<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates = new ArrayList<UpdateMetadataRequestData.UpdateMetadataPartitionState>();
        List<Integer> isr = Arrays.asList(1, 2);
        List<Integer> replicas = Arrays.asList(1, 2, 3, 4);
        List<Integer> offlineReplicas = Arrays.asList(new Integer[0]);
        partitionStates.add(new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic5").setPartitionIndex(105).setControllerEpoch(0).setLeader(2).setLeaderEpoch(1).setIsr(isr).setZkVersion(2).setReplicas(replicas).setOfflineReplicas(offlineReplicas));
        partitionStates.add(new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic5").setPartitionIndex(1).setControllerEpoch(1).setLeader(1).setLeaderEpoch(1).setIsr(isr).setZkVersion(2).setReplicas(replicas).setOfflineReplicas(offlineReplicas));
        partitionStates.add(new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic20").setPartitionIndex(1).setControllerEpoch(1).setLeader(0).setLeaderEpoch(1).setIsr(isr).setZkVersion(2).setReplicas(replicas).setOfflineReplicas(offlineReplicas));
        SecurityProtocol plaintext = SecurityProtocol.PLAINTEXT;
        ArrayList<UpdateMetadataRequestData.UpdateMetadataEndpoint> endpoints1 = new ArrayList<UpdateMetadataRequestData.UpdateMetadataEndpoint>();
        endpoints1.add(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(1223).setSecurityProtocol(plaintext.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)plaintext).value()));
        ArrayList<UpdateMetadataRequestData.UpdateMetadataEndpoint> endpoints2 = new ArrayList<UpdateMetadataRequestData.UpdateMetadataEndpoint>();
        endpoints2.add(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(1244).setSecurityProtocol(plaintext.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)plaintext).value()));
        if (version > 0) {
            SecurityProtocol ssl = SecurityProtocol.SSL;
            endpoints2.add(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host2").setPort(1234).setSecurityProtocol(ssl.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)ssl).value()));
            endpoints2.add(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host2").setPort(1334).setSecurityProtocol(ssl.id));
            if (version >= 3) {
                ((UpdateMetadataRequestData.UpdateMetadataEndpoint)endpoints2.get(1)).setListener("CLIENT");
            }
        }
        List<UpdateMetadataRequestData.UpdateMetadataBroker> liveBrokers = Arrays.asList(new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints(endpoints1).setRack(rack), new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints(endpoints2).setRack(rack));
        return (UpdateMetadataRequest)new UpdateMetadataRequest.Builder((short)version, 1, 10, 0L, partitionStates, liveBrokers).build();
    }

    private UpdateMetadataResponse createUpdateMetadataResponse() {
        return new UpdateMetadataResponse(new UpdateMetadataResponseData().setErrorCode(Errors.NONE.code()));
    }

    private SaslHandshakeRequest createSaslHandshakeRequest() {
        return (SaslHandshakeRequest)new SaslHandshakeRequest.Builder(new SaslHandshakeRequestData().setMechanism("PLAIN")).build();
    }

    private SaslHandshakeResponse createSaslHandshakeResponse() {
        return new SaslHandshakeResponse(new SaslHandshakeResponseData().setErrorCode(Errors.NONE.code()).setMechanisms(Collections.singletonList("GSSAPI")));
    }

    private SaslAuthenticateRequest createSaslAuthenticateRequest() {
        SaslAuthenticateRequestData data = new SaslAuthenticateRequestData().setAuthBytes(new byte[0]);
        return new SaslAuthenticateRequest(data);
    }

    private SaslAuthenticateResponse createSaslAuthenticateResponse() {
        SaslAuthenticateResponseData data = new SaslAuthenticateResponseData().setErrorCode(Errors.NONE.code()).setAuthBytes(new byte[0]).setSessionLifetimeMs(Long.MAX_VALUE);
        return new SaslAuthenticateResponse(data);
    }

    private ApiVersionsRequest createApiVersionRequest() {
        return (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
    }

    private ApiVersionsResponse createApiVersionResponse() {
        ApiVersionsResponseData.ApiVersionsResponseKeyCollection apiVersions = new ApiVersionsResponseData.ApiVersionsResponseKeyCollection();
        apiVersions.add(new ApiVersionsResponseData.ApiVersionsResponseKey().setApiKey((short)0).setMinVersion((short)0).setMaxVersion((short)2));
        return new ApiVersionsResponse(new ApiVersionsResponseData().setErrorCode(Errors.NONE.code()).setThrottleTimeMs(0).setApiKeys(apiVersions));
    }

    private CreateTopicsRequest createCreateTopicRequest(int version) {
        return this.createCreateTopicRequest(version, version >= 1);
    }

    private CreateTopicsRequest createCreateTopicRequest(int version, boolean validateOnly) {
        CreateTopicsRequestData data = new CreateTopicsRequestData().setTimeoutMs(123).setValidateOnly(validateOnly);
        data.topics().add(new CreateTopicsRequestData.CreatableTopic().setNumPartitions(3).setReplicationFactor((short)5));
        CreateTopicsRequestData.CreatableTopic topic2 = new CreateTopicsRequestData.CreatableTopic();
        data.topics().add(topic2);
        topic2.assignments().add(new CreateTopicsRequestData.CreatableReplicaAssignment().setPartitionIndex(0).setBrokerIds(Arrays.asList(1, 2, 3)));
        topic2.assignments().add(new CreateTopicsRequestData.CreatableReplicaAssignment().setPartitionIndex(1).setBrokerIds(Arrays.asList(2, 3, 4)));
        topic2.configs().add(new CreateTopicsRequestData.CreateableTopicConfig().setName("config1").setValue("value1"));
        return new CreateTopicsRequest.Builder(data).build((short)version);
    }

    private CreateTopicsResponse createCreateTopicResponse() {
        CreateTopicsResponseData data = new CreateTopicsResponseData();
        data.topics().add(new CreateTopicsResponseData.CreatableTopicResult().setName("t1").setErrorCode(Errors.INVALID_TOPIC_EXCEPTION.code()).setErrorMessage(null));
        data.topics().add(new CreateTopicsResponseData.CreatableTopicResult().setName("t2").setErrorCode(Errors.LEADER_NOT_AVAILABLE.code()).setErrorMessage("Leader with id 5 is not available."));
        data.topics().add(new CreateTopicsResponseData.CreatableTopicResult().setName("t3").setErrorCode(Errors.NONE.code()).setNumPartitions(1).setReplicationFactor((short)2).setConfigs(Collections.singletonList(new CreateTopicsResponseData.CreatableTopicConfigs().setName("min.insync.replicas").setValue("2"))));
        return new CreateTopicsResponse(data);
    }

    private DeleteTopicsRequest createDeleteTopicsRequest() {
        return (DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("my_t1", "my_t2")).setTimeoutMs(1000)).build();
    }

    private DeleteTopicsResponse createDeleteTopicsResponse() {
        DeleteTopicsResponseData data = new DeleteTopicsResponseData();
        data.responses().add(new DeleteTopicsResponseData.DeletableTopicResult().setName("t1").setErrorCode(Errors.INVALID_TOPIC_EXCEPTION.code()));
        data.responses().add(new DeleteTopicsResponseData.DeletableTopicResult().setName("t2").setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()));
        return new DeleteTopicsResponse(data);
    }

    private InitProducerIdRequest createInitPidRequest() {
        InitProducerIdRequestData requestData = new InitProducerIdRequestData().setTransactionalId(null).setTransactionTimeoutMs(100);
        return (InitProducerIdRequest)new InitProducerIdRequest.Builder(requestData).build();
    }

    private InitProducerIdResponse createInitPidResponse() {
        InitProducerIdResponseData responseData = new InitProducerIdResponseData().setErrorCode(Errors.NONE.code()).setProducerEpoch((short)3).setProducerId(3332L).setThrottleTimeMs(0);
        return new InitProducerIdResponse(responseData);
    }

    private Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> createOffsetForLeaderEpochPartitionData() {
        HashMap<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> epochs = new HashMap<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData>();
        epochs.put(new TopicPartition("topic1", 0), new OffsetsForLeaderEpochRequest.PartitionData(Optional.of(0), 1));
        epochs.put(new TopicPartition("topic1", 1), new OffsetsForLeaderEpochRequest.PartitionData(Optional.of(0), 1));
        epochs.put(new TopicPartition("topic2", 2), new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), 3));
        return epochs;
    }

    private OffsetsForLeaderEpochRequest createLeaderEpochRequestForConsumer() {
        Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> epochs = this.createOffsetForLeaderEpochPartitionData();
        return (OffsetsForLeaderEpochRequest)OffsetsForLeaderEpochRequest.Builder.forConsumer(epochs).build();
    }

    private OffsetsForLeaderEpochRequest createLeaderEpochRequestForReplica(int version, int replicaId) {
        Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> epochs = this.createOffsetForLeaderEpochPartitionData();
        return (OffsetsForLeaderEpochRequest)OffsetsForLeaderEpochRequest.Builder.forFollower((short)((short)version), epochs, (int)replicaId).build();
    }

    private OffsetsForLeaderEpochResponse createLeaderEpochResponse() {
        HashMap<TopicPartition, EpochEndOffset> epochs = new HashMap<TopicPartition, EpochEndOffset>();
        epochs.put(new TopicPartition("topic1", 0), new EpochEndOffset(Errors.NONE, 1, 0L));
        epochs.put(new TopicPartition("topic1", 1), new EpochEndOffset(Errors.NONE, 1, 1L));
        epochs.put(new TopicPartition("topic2", 2), new EpochEndOffset(Errors.NONE, 1, 2L));
        return new OffsetsForLeaderEpochResponse(0, epochs);
    }

    private AddPartitionsToTxnRequest createAddPartitionsToTxnRequest() {
        return (AddPartitionsToTxnRequest)new AddPartitionsToTxnRequest.Builder("tid", 21L, 42, Collections.singletonList(new TopicPartition("topic", 73))).build();
    }

    private AddPartitionsToTxnResponse createAddPartitionsToTxnResponse() {
        return new AddPartitionsToTxnResponse(0, Collections.singletonMap(new TopicPartition("t", 0), Errors.NONE));
    }

    private AddOffsetsToTxnRequest createAddOffsetsToTxnRequest() {
        return (AddOffsetsToTxnRequest)new AddOffsetsToTxnRequest.Builder("tid", 21L, 42, "gid").build();
    }

    private AddOffsetsToTxnResponse createAddOffsetsToTxnResponse() {
        return new AddOffsetsToTxnResponse(0, Errors.NONE);
    }

    private EndTxnRequest createEndTxnRequest() {
        return (EndTxnRequest)new EndTxnRequest.Builder(new EndTxnRequestData().setTransactionalId("tid").setProducerId(21L).setProducerEpoch((short)42).setCommitted(TransactionResult.COMMIT.id)).build();
    }

    private EndTxnResponse createEndTxnResponse() {
        return new EndTxnResponse(new EndTxnResponseData().setErrorCode(Errors.NONE.code()).setThrottleTimeMs(0));
    }

    private WriteTxnMarkersRequest createWriteTxnMarkersRequest() {
        return (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Collections.singletonList(new WriteTxnMarkersRequest.TxnMarkerEntry(21L, 42, 73, TransactionResult.ABORT, Collections.singletonList(new TopicPartition("topic", 73))))).build();
    }

    private WriteTxnMarkersResponse createWriteTxnMarkersResponse() {
        HashMap<TopicPartition, Errors> errorPerPartitions = new HashMap<TopicPartition, Errors>();
        errorPerPartitions.put(new TopicPartition("topic", 73), Errors.NONE);
        HashMap<Long, HashMap<TopicPartition, Errors>> response = new HashMap<Long, HashMap<TopicPartition, Errors>>();
        response.put(21L, errorPerPartitions);
        return new WriteTxnMarkersResponse(response);
    }

    private TxnOffsetCommitRequest createTxnOffsetCommitRequest(int version) {
        HashMap<TopicPartition, TxnOffsetCommitRequest.CommittedOffset> offsets = new HashMap<TopicPartition, TxnOffsetCommitRequest.CommittedOffset>();
        offsets.put(new TopicPartition("topic", 73), new TxnOffsetCommitRequest.CommittedOffset(100L, null, Optional.empty()));
        offsets.put(new TopicPartition("topic", 74), new TxnOffsetCommitRequest.CommittedOffset(100L, "blah", Optional.of(27)));
        if (version < 3) {
            return (TxnOffsetCommitRequest)new TxnOffsetCommitRequest.Builder("transactionalId", "groupId", 21L, 42, offsets).build();
        }
        return (TxnOffsetCommitRequest)new TxnOffsetCommitRequest.Builder("transactionalId", "groupId", 21L, 42, offsets, "member", 2, Optional.of("instance")).build();
    }

    private TxnOffsetCommitResponse createTxnOffsetCommitResponse() {
        HashMap<TopicPartition, Errors> errorPerPartitions = new HashMap<TopicPartition, Errors>();
        errorPerPartitions.put(new TopicPartition("topic", 73), Errors.NONE);
        return new TxnOffsetCommitResponse(0, errorPerPartitions);
    }

    private DescribeAclsRequest createDescribeAclsRequest() {
        return (DescribeAclsRequest)new DescribeAclsRequest.Builder(new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "mytopic", PatternType.LITERAL), new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY))).build();
    }

    private DescribeAclsResponse createDescribeAclsResponse() {
        DescribeAclsResponseData data = new DescribeAclsResponseData().setErrorCode(Errors.NONE.code()).setErrorMessage(Errors.NONE.message()).setThrottleTimeMs(0).setResources(Collections.singletonList(new DescribeAclsResponseData.DescribeAclsResource().setResourceType(ResourceType.TOPIC.code()).setResourceName("mytopic").setPatternType(PatternType.LITERAL.code()).setAcls(Collections.singletonList(new DescribeAclsResponseData.AclDescription().setHost("*").setOperation(AclOperation.WRITE.code()).setPermissionType(AclPermissionType.ALLOW.code()).setPrincipal("User:ANONYMOUS")))));
        return new DescribeAclsResponse(data);
    }

    private CreateAclsRequest createCreateAclsRequest() {
        ArrayList<CreateAclsRequestData.AclCreation> creations = new ArrayList<CreateAclsRequestData.AclCreation>();
        creations.add(CreateAclsRequest.aclCreation((AclBinding)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "127.0.0.1", AclOperation.READ, AclPermissionType.ALLOW))));
        creations.add(CreateAclsRequest.aclCreation((AclBinding)new AclBinding(new ResourcePattern(ResourceType.GROUP, "mygroup", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.WRITE, AclPermissionType.DENY))));
        CreateAclsRequestData data = new CreateAclsRequestData().setCreations(creations);
        return (CreateAclsRequest)new CreateAclsRequest.Builder(data).build();
    }

    private CreateAclsResponse createCreateAclsResponse() {
        return new CreateAclsResponse(new CreateAclsResponseData().setResults(Arrays.asList(new CreateAclsResponseData.AclCreationResult(), new CreateAclsResponseData.AclCreationResult().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Foo bar"))));
    }

    private DeleteAclsRequest createDeleteAclsRequest() {
        DeleteAclsRequestData data = new DeleteAclsRequestData().setFilters(Arrays.asList(new DeleteAclsRequestData.DeleteAclsFilter().setResourceTypeFilter(ResourceType.ANY.code()).setResourceNameFilter(null).setPatternTypeFilter(PatternType.LITERAL.code()).setPrincipalFilter("User:ANONYMOUS").setHostFilter(null).setOperation(AclOperation.ANY.code()).setPermissionType(AclPermissionType.ANY.code()), new DeleteAclsRequestData.DeleteAclsFilter().setResourceTypeFilter(ResourceType.ANY.code()).setResourceNameFilter(null).setPatternTypeFilter(PatternType.LITERAL.code()).setPrincipalFilter("User:bob").setHostFilter(null).setOperation(AclOperation.ANY.code()).setPermissionType(AclPermissionType.ANY.code())));
        return (DeleteAclsRequest)new DeleteAclsRequest.Builder(data).build();
    }

    private DeleteAclsResponse createDeleteAclsResponse() {
        ArrayList<DeleteAclsResponseData.DeleteAclsFilterResult> filterResults = new ArrayList<DeleteAclsResponseData.DeleteAclsFilterResult>();
        filterResults.add(new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Arrays.asList(new DeleteAclsResponseData.DeleteAclsMatchingAcl().setResourceType(ResourceType.TOPIC.code()).setResourceName("mytopic3").setPatternType(PatternType.LITERAL.code()).setPrincipal("User:ANONYMOUS").setHost("*").setOperation(AclOperation.DESCRIBE.code()).setPermissionType(AclPermissionType.ALLOW.code()), new DeleteAclsResponseData.DeleteAclsMatchingAcl().setResourceType(ResourceType.TOPIC.code()).setResourceName("mytopic4").setPatternType(PatternType.LITERAL.code()).setPrincipal("User:ANONYMOUS").setHost("*").setOperation(AclOperation.DESCRIBE.code()).setPermissionType(AclPermissionType.DENY.code()))));
        filterResults.add(new DeleteAclsResponseData.DeleteAclsFilterResult().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("No security"));
        return new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(0).setFilterResults(filterResults));
    }

    private DescribeConfigsRequest createDescribeConfigsRequest(int version) {
        return new DescribeConfigsRequest.Builder(Arrays.asList(new ConfigResource(ConfigResource.Type.BROKER, "0"), new ConfigResource(ConfigResource.Type.TOPIC, "topic"))).build((short)version);
    }

    private DescribeConfigsRequest createDescribeConfigsRequestWithConfigEntries(int version) {
        HashMap<ConfigResource, List<String>> resources = new HashMap<ConfigResource, List<String>>();
        resources.put(new ConfigResource(ConfigResource.Type.BROKER, "0"), Arrays.asList("foo", "bar"));
        resources.put(new ConfigResource(ConfigResource.Type.TOPIC, "topic"), null);
        resources.put(new ConfigResource(ConfigResource.Type.TOPIC, "topic a"), Collections.emptyList());
        return new DescribeConfigsRequest.Builder(resources).build((short)version);
    }

    private DescribeConfigsResponse createDescribeConfigsResponse() {
        HashMap<ConfigResource, DescribeConfigsResponse.Config> configs = new HashMap<ConfigResource, DescribeConfigsResponse.Config>();
        List synonyms = Collections.emptyList();
        List<DescribeConfigsResponse.ConfigEntry> configEntries = Arrays.asList(new DescribeConfigsResponse.ConfigEntry("config_name", "config_value", DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, true, false, synonyms), new DescribeConfigsResponse.ConfigEntry("another_name", "another value", DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, false, true, synonyms));
        configs.put(new ConfigResource(ConfigResource.Type.BROKER, "0"), new DescribeConfigsResponse.Config(ApiError.NONE, configEntries));
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, "topic"), new DescribeConfigsResponse.Config(ApiError.NONE, Collections.emptyList()));
        return new DescribeConfigsResponse(200, configs);
    }

    private AlterConfigsRequest createAlterConfigsRequest() {
        HashMap<ConfigResource, AlterConfigsRequest.Config> configs = new HashMap<ConfigResource, AlterConfigsRequest.Config>();
        List<AlterConfigsRequest.ConfigEntry> configEntries = Arrays.asList(new AlterConfigsRequest.ConfigEntry("config_name", "config_value"), new AlterConfigsRequest.ConfigEntry("another_name", "another value"));
        configs.put(new ConfigResource(ConfigResource.Type.BROKER, "0"), new AlterConfigsRequest.Config(configEntries));
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, "topic"), new AlterConfigsRequest.Config(Collections.emptyList()));
        return new AlterConfigsRequest(0, configs, false);
    }

    private AlterConfigsResponse createAlterConfigsResponse() {
        HashMap<ConfigResource, ApiError> errors = new HashMap<ConfigResource, ApiError>();
        errors.put(new ConfigResource(ConfigResource.Type.BROKER, "0"), ApiError.NONE);
        errors.put(new ConfigResource(ConfigResource.Type.TOPIC, "topic"), new ApiError(Errors.INVALID_REQUEST, "This request is invalid"));
        return new AlterConfigsResponse(20, errors);
    }

    private CreatePartitionsRequest createCreatePartitionsRequest() {
        LinkedList<CreatePartitionsRequestData.CreatePartitionsTopic> topics = new LinkedList<CreatePartitionsRequestData.CreatePartitionsTopic>();
        topics.add(new CreatePartitionsRequestData.CreatePartitionsTopic().setName("my_topic").setCount(3));
        topics.add(new CreatePartitionsRequestData.CreatePartitionsTopic().setName("my_other_topic").setCount(3));
        CreatePartitionsRequestData data = new CreatePartitionsRequestData().setTimeoutMs(0).setValidateOnly(false).setTopics(topics);
        return new CreatePartitionsRequest(data, 0);
    }

    private CreatePartitionsRequest createCreatePartitionsRequestWithAssignments() {
        LinkedList<CreatePartitionsRequestData.CreatePartitionsTopic> topics = new LinkedList<CreatePartitionsRequestData.CreatePartitionsTopic>();
        CreatePartitionsRequestData.CreatePartitionsAssignment myTopicAssignment = new CreatePartitionsRequestData.CreatePartitionsAssignment().setBrokerIds(Collections.singletonList(2));
        topics.add(new CreatePartitionsRequestData.CreatePartitionsTopic().setName("my_topic").setCount(3).setAssignments(Collections.singletonList(myTopicAssignment)));
        topics.add(new CreatePartitionsRequestData.CreatePartitionsTopic().setName("my_other_topic").setCount(3).setAssignments(Arrays.asList(new CreatePartitionsRequestData.CreatePartitionsAssignment().setBrokerIds(Arrays.asList(2, 3)), new CreatePartitionsRequestData.CreatePartitionsAssignment().setBrokerIds(Arrays.asList(3, 1)))));
        CreatePartitionsRequestData data = new CreatePartitionsRequestData().setTimeoutMs(0).setValidateOnly(false).setTopics(topics);
        return new CreatePartitionsRequest(data, 0);
    }

    private CreatePartitionsResponse createCreatePartitionsResponse() {
        LinkedList<CreatePartitionsResponseData.CreatePartitionsTopicResult> results = new LinkedList<CreatePartitionsResponseData.CreatePartitionsTopicResult>();
        results.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("my_topic").setErrorCode(Errors.INVALID_REPLICA_ASSIGNMENT.code()));
        results.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("my_topic").setErrorCode(Errors.NONE.code()));
        CreatePartitionsResponseData data = new CreatePartitionsResponseData().setThrottleTimeMs(42).setResults(results);
        return new CreatePartitionsResponse(data);
    }

    private CreateDelegationTokenRequest createCreateTokenRequest() {
        ArrayList<CreateDelegationTokenRequestData.CreatableRenewers> renewers = new ArrayList<CreateDelegationTokenRequestData.CreatableRenewers>();
        renewers.add(new CreateDelegationTokenRequestData.CreatableRenewers().setPrincipalType("User").setPrincipalName("user1"));
        renewers.add(new CreateDelegationTokenRequestData.CreatableRenewers().setPrincipalType("User").setPrincipalName("user2"));
        return (CreateDelegationTokenRequest)new CreateDelegationTokenRequest.Builder(new CreateDelegationTokenRequestData().setRenewers(renewers).setMaxLifetimeMs(System.currentTimeMillis())).build();
    }

    private CreateDelegationTokenResponse createCreateTokenResponse() {
        CreateDelegationTokenResponseData data = new CreateDelegationTokenResponseData().setThrottleTimeMs(20).setErrorCode(Errors.NONE.code()).setPrincipalType("User").setPrincipalName("user1").setIssueTimestampMs(System.currentTimeMillis()).setExpiryTimestampMs(System.currentTimeMillis()).setMaxTimestampMs(System.currentTimeMillis()).setTokenId("token1").setHmac("test".getBytes());
        return new CreateDelegationTokenResponse(data);
    }

    private RenewDelegationTokenRequest createRenewTokenRequest() {
        RenewDelegationTokenRequestData data = new RenewDelegationTokenRequestData().setHmac("test".getBytes()).setRenewPeriodMs(System.currentTimeMillis());
        return (RenewDelegationTokenRequest)new RenewDelegationTokenRequest.Builder(data).build();
    }

    private RenewDelegationTokenResponse createRenewTokenResponse() {
        RenewDelegationTokenResponseData data = new RenewDelegationTokenResponseData().setThrottleTimeMs(20).setErrorCode(Errors.NONE.code()).setExpiryTimestampMs(System.currentTimeMillis());
        return new RenewDelegationTokenResponse(data);
    }

    private ExpireDelegationTokenRequest createExpireTokenRequest() {
        ExpireDelegationTokenRequestData data = new ExpireDelegationTokenRequestData().setHmac("test".getBytes()).setExpiryTimePeriodMs(System.currentTimeMillis());
        return (ExpireDelegationTokenRequest)new ExpireDelegationTokenRequest.Builder(data).build();
    }

    private ExpireDelegationTokenResponse createExpireTokenResponse() {
        ExpireDelegationTokenResponseData data = new ExpireDelegationTokenResponseData().setThrottleTimeMs(20).setErrorCode(Errors.NONE.code()).setExpiryTimestampMs(System.currentTimeMillis());
        return new ExpireDelegationTokenResponse(data);
    }

    private DescribeDelegationTokenRequest createDescribeTokenRequest() {
        ArrayList<KafkaPrincipal> owners = new ArrayList<KafkaPrincipal>();
        owners.add(SecurityUtils.parseKafkaPrincipal((String)"User:user1"));
        owners.add(SecurityUtils.parseKafkaPrincipal((String)"User:user2"));
        return (DescribeDelegationTokenRequest)new DescribeDelegationTokenRequest.Builder(owners).build();
    }

    private DescribeDelegationTokenResponse createDescribeTokenResponse() {
        ArrayList<KafkaPrincipal> renewers = new ArrayList<KafkaPrincipal>();
        renewers.add(SecurityUtils.parseKafkaPrincipal((String)"User:user1"));
        renewers.add(SecurityUtils.parseKafkaPrincipal((String)"User:user2"));
        LinkedList<DelegationToken> tokenList = new LinkedList<DelegationToken>();
        TokenInformation tokenInfo1 = new TokenInformation("1", SecurityUtils.parseKafkaPrincipal((String)"User:owner"), renewers, System.currentTimeMillis(), System.currentTimeMillis(), System.currentTimeMillis());
        TokenInformation tokenInfo2 = new TokenInformation("2", SecurityUtils.parseKafkaPrincipal((String)"User:owner1"), renewers, System.currentTimeMillis(), System.currentTimeMillis(), System.currentTimeMillis());
        tokenList.add(new DelegationToken(tokenInfo1, "test".getBytes()));
        tokenList.add(new DelegationToken(tokenInfo2, "test".getBytes()));
        return new DescribeDelegationTokenResponse(20, Errors.NONE, tokenList);
    }

    private ElectLeadersRequest createElectLeadersRequestNullPartitions() {
        return new ElectLeadersRequest.Builder(ElectionType.PREFERRED, null, 100).build((short)1);
    }

    private ElectLeadersRequest createElectLeadersRequest() {
        List<TopicPartition> partitions = Arrays.asList(new TopicPartition("data", 1), new TopicPartition("data", 2));
        return new ElectLeadersRequest.Builder(ElectionType.PREFERRED, partitions, 100).build((short)1);
    }

    private ElectLeadersResponse createElectLeadersResponse() {
        String topic = "myTopic";
        ArrayList electionResults = new ArrayList();
        ElectLeadersResponseData.ReplicaElectionResult electionResult = new ElectLeadersResponseData.ReplicaElectionResult();
        electionResult.setTopic(topic);
        ElectLeadersResponseData.PartitionResult partitionResult = new ElectLeadersResponseData.PartitionResult();
        partitionResult.setPartitionId(0);
        partitionResult.setErrorCode(ApiError.NONE.error().code());
        partitionResult.setErrorMessage(ApiError.NONE.message());
        electionResult.partitionResult().add(partitionResult);
        partitionResult = new ElectLeadersResponseData.PartitionResult();
        partitionResult.setPartitionId(1);
        partitionResult.setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code());
        partitionResult.setErrorMessage(Errors.UNKNOWN_TOPIC_OR_PARTITION.message());
        electionResult.partitionResult().add(partitionResult);
        return new ElectLeadersResponse(200, Errors.NONE.code(), electionResults);
    }

    private IncrementalAlterConfigsRequest createIncrementalAlterConfigsRequest() {
        IncrementalAlterConfigsRequestData data = new IncrementalAlterConfigsRequestData();
        IncrementalAlterConfigsRequestData.AlterableConfig alterableConfig = new IncrementalAlterConfigsRequestData.AlterableConfig().setName("retention.ms").setConfigOperation((byte)0).setValue("100");
        IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
        alterableConfigs.add(alterableConfig);
        data.resources().add(new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("testtopic").setResourceType(ResourceType.TOPIC.code()).setConfigs(alterableConfigs));
        return new IncrementalAlterConfigsRequest.Builder(data).build((short)0);
    }

    private IncrementalAlterConfigsResponse createIncrementalAlterConfigsResponse() {
        IncrementalAlterConfigsResponseData data = new IncrementalAlterConfigsResponseData();
        data.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("testtopic").setResourceType(ResourceType.TOPIC.code()).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate Keys"));
        return new IncrementalAlterConfigsResponse(data);
    }

    private AlterPartitionReassignmentsRequest createAlterPartitionReassignmentsRequest() {
        AlterPartitionReassignmentsRequestData data = new AlterPartitionReassignmentsRequestData();
        data.topics().add(new AlterPartitionReassignmentsRequestData.ReassignableTopic().setName("topic").setPartitions(Collections.singletonList(new AlterPartitionReassignmentsRequestData.ReassignablePartition().setPartitionIndex(0).setReplicas(null))));
        return new AlterPartitionReassignmentsRequest.Builder(data).build((short)0);
    }

    private AlterPartitionReassignmentsResponse createAlterPartitionReassignmentsResponse() {
        AlterPartitionReassignmentsResponseData data = new AlterPartitionReassignmentsResponseData();
        data.responses().add(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("topic").setPartitions(Collections.singletonList(new AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse().setPartitionIndex(0).setErrorCode(Errors.NO_REASSIGNMENT_IN_PROGRESS.code()).setErrorMessage("No reassignment is in progress for topic topic partition 0"))));
        return new AlterPartitionReassignmentsResponse(data);
    }

    private ListPartitionReassignmentsRequest createListPartitionReassignmentsRequest() {
        ListPartitionReassignmentsRequestData data = new ListPartitionReassignmentsRequestData();
        data.setTopics(Collections.singletonList(new ListPartitionReassignmentsRequestData.ListPartitionReassignmentsTopics().setName("topic").setPartitionIndexes(Collections.singletonList(1))));
        return new ListPartitionReassignmentsRequest.Builder(data).build((short)0);
    }

    private ListPartitionReassignmentsResponse createListPartitionReassignmentsResponse() {
        ListPartitionReassignmentsResponseData data = new ListPartitionReassignmentsResponseData();
        data.setTopics(Collections.singletonList(new ListPartitionReassignmentsResponseData.OngoingTopicReassignment().setName("topic").setPartitions(Collections.singletonList(new ListPartitionReassignmentsResponseData.OngoingPartitionReassignment().setPartitionIndex(0).setReplicas(Arrays.asList(1, 2)).setAddingReplicas(Collections.singletonList(2)).setRemovingReplicas(Collections.singletonList(1))))));
        return new ListPartitionReassignmentsResponse(data);
    }

    private OffsetDeleteRequest createOffsetDeleteRequest() {
        OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection topics = new OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection();
        topics.add(new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName("topic1").setPartitions(Collections.singletonList(new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(0))));
        OffsetDeleteRequestData data = new OffsetDeleteRequestData();
        data.setGroupId("group1");
        data.setTopics(topics);
        return new OffsetDeleteRequest.Builder(data).build((short)0);
    }

    private OffsetDeleteResponse createOffsetDeleteResponse() {
        OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection partitions = new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection();
        partitions.add(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code()));
        OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection topics = new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection();
        topics.add(new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("topic1").setPartitions(partitions));
        OffsetDeleteResponseData data = new OffsetDeleteResponseData();
        data.setErrorCode(Errors.NONE.code());
        data.setTopics(topics);
        return new OffsetDeleteResponse(data);
    }
}

