/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ApiVersionsRequestData
implements ApiMessage {
    private String clientSoftwareName;
    private String clientSoftwareVersion;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;

    public ApiVersionsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ApiVersionsRequestData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public ApiVersionsRequestData() {
        this.clientSoftwareName = "";
        this.clientSoftwareVersion = "";
    }

    public short apiKey() {
        return 18;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 3;
    }

    public void read(Readable _readable, short _version) {
        int length;
        if (_version >= 3) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field clientSoftwareName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clientSoftwareName had invalid length " + length);
            }
            this.clientSoftwareName = _readable.readString(length);
        } else {
            this.clientSoftwareName = "";
        }
        if (_version >= 3) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field clientSoftwareVersion was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clientSoftwareVersion had invalid length " + length);
            }
            this.clientSoftwareVersion = _readable.readString(length);
        } else {
            this.clientSoftwareVersion = "";
        }
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        if (_version >= 3) {
            _stringBytes = _cache.getSerializedValue((Object)this.clientSoftwareName);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        if (_version >= 3) {
            _stringBytes = _cache.getSerializedValue((Object)this.clientSoftwareVersion);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 3) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.clientSoftwareName = _version >= 3 ? struct.getString("client_software_name") : "";
        this.clientSoftwareVersion = _version >= 3 ? struct.getString("client_software_version") : "";
        if (_version >= 3 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 3) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 3) {
            struct.set("client_software_name", (Object)this.clientSoftwareName);
        }
        if (_version >= 3) {
            struct.set("client_software_version", (Object)this.clientSoftwareVersion);
        }
        if (_version >= 3) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        byte[] _stringBytes;
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 3) {
            _stringBytes = this.clientSoftwareName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clientSoftwareName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.clientSoftwareName, _stringBytes);
            _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
        }
        if (_version >= 3) {
            _stringBytes = this.clientSoftwareVersion.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clientSoftwareVersion' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.clientSoftwareVersion, _stringBytes);
            _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 3) {
            _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ApiVersionsRequestData)) {
            return false;
        }
        ApiVersionsRequestData other = (ApiVersionsRequestData)obj;
        if (this.clientSoftwareName == null ? other.clientSoftwareName != null : !this.clientSoftwareName.equals(other.clientSoftwareName)) {
            return false;
        }
        return !(this.clientSoftwareVersion == null ? other.clientSoftwareVersion != null : !this.clientSoftwareVersion.equals(other.clientSoftwareVersion));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.clientSoftwareName == null ? 0 : this.clientSoftwareName.hashCode());
        hashCode = 31 * hashCode + (this.clientSoftwareVersion == null ? 0 : this.clientSoftwareVersion.hashCode());
        return hashCode;
    }

    public String toString() {
        return "ApiVersionsRequestData(clientSoftwareName=" + (this.clientSoftwareName == null ? "null" : "'" + this.clientSoftwareName.toString() + "'") + ", clientSoftwareVersion=" + (this.clientSoftwareVersion == null ? "null" : "'" + this.clientSoftwareVersion.toString() + "'") + ")";
    }

    public String clientSoftwareName() {
        return this.clientSoftwareName;
    }

    public String clientSoftwareVersion() {
        return this.clientSoftwareVersion;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ApiVersionsRequestData setClientSoftwareName(String v) {
        this.clientSoftwareName = v;
        return this;
    }

    public ApiVersionsRequestData setClientSoftwareVersion(String v) {
        this.clientSoftwareVersion = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[0]));
        SCHEMA_3 = new Schema(new Field[]{new Field("client_software_name", (Type)Type.COMPACT_STRING, "The name of the client."), new Field("client_software_version", (Type)Type.COMPACT_STRING, "The version of the client."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }
}

