/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class SimpleExampleMessageData
implements ApiMessage {
    private UUID processId;
    private List<Integer> myTaggedIntArray;
    private String myNullableString;
    private short myInt16;
    private double myFloat64;
    private String myString;
    private byte[] myBytes;
    private UUID taggedUuid;
    private long taggedLong;
    private ByteBuffer zeroCopyByteBuffer;
    private ByteBuffer nullableZeroCopyByteBuffer;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[0]);
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("process_id", (Type)Type.UUID, ""), new Field("zero_copy_byte_buffer", (Type)Type.COMPACT_BYTES, ""), new Field("nullable_zero_copy_byte_buffer", (Type)Type.COMPACT_NULLABLE_BYTES, ""), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("my_tagged_int_array", (Type)new CompactArrayOf((Type)Type.INT32), ""), 1, new Field("my_nullable_string", (Type)Type.COMPACT_NULLABLE_STRING, ""), 2, new Field("my_int16", (Type)Type.INT16, ""), 3, new Field("my_float64", (Type)Type.FLOAT64, ""), 4, new Field("my_string", (Type)Type.COMPACT_STRING, ""), 5, new Field("my_bytes", (Type)Type.COMPACT_NULLABLE_BYTES, ""), 6, new Field("tagged_uuid", (Type)Type.UUID, ""), 7, new Field("tagged_long", (Type)Type.INT64, "")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};

    public SimpleExampleMessageData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public SimpleExampleMessageData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public SimpleExampleMessageData() {
        this.processId = MessageUtil.ZERO_UUID;
        this.myTaggedIntArray = new ArrayList<Integer>();
        this.myNullableString = null;
        this.myInt16 = (short)123;
        this.myFloat64 = Double.parseDouble("12.34");
        this.myString = "";
        this.myBytes = Bytes.EMPTY;
        this.taggedUuid = UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367");
        this.taggedLong = 0xCAFCACAFCACAFCAL;
        this.zeroCopyByteBuffer = ByteUtils.EMPTY_BUF;
        this.nullableZeroCopyByteBuffer = ByteUtils.EMPTY_BUF;
    }

    public short apiKey() {
        return -1;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable _readable, short _version) {
        int length;
        this.processId = _version >= 1 ? _readable.readUUID() : MessageUtil.ZERO_UUID;
        this.myTaggedIntArray = new ArrayList<Integer>();
        this.myNullableString = null;
        this.myInt16 = (short)123;
        this.myFloat64 = Double.parseDouble("12.34");
        this.myString = "";
        this.myBytes = Bytes.EMPTY;
        this.taggedUuid = UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367");
        this.taggedLong = 0xCAFCACAFCACAFCAL;
        if (_version >= 1) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field zeroCopyByteBuffer was serialized as null");
            }
            this.zeroCopyByteBuffer = _readable.readByteBuffer(length);
        } else {
            this.zeroCopyByteBuffer = ByteUtils.EMPTY_BUF;
        }
        this.nullableZeroCopyByteBuffer = _version >= 1 ? ((length = _readable.readUnsignedVarint() - 1) < 0 ? null : _readable.readByteBuffer(length)) : ByteUtils.EMPTY_BUF;
        this._unknownTaggedFields = null;
        if (_version >= 1) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            block10: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 0: {
                        int arrayLength = _readable.readUnsignedVarint() - 1;
                        if (arrayLength < 0) {
                            throw new RuntimeException("non-nullable field myTaggedIntArray was serialized as null");
                        }
                        ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
                        for (int i = 0; i < arrayLength; ++i) {
                            newCollection.add(_readable.readInt());
                        }
                        this.myTaggedIntArray = newCollection;
                        continue block10;
                    }
                    case 1: {
                        int length2 = _readable.readUnsignedVarint() - 1;
                        if (length2 < 0) {
                            this.myNullableString = null;
                            continue block10;
                        }
                        if (length2 > Short.MAX_VALUE) {
                            throw new RuntimeException("string field myNullableString had invalid length " + length2);
                        }
                        this.myNullableString = _readable.readString(length2);
                        continue block10;
                    }
                    case 2: {
                        this.myInt16 = _readable.readShort();
                        continue block10;
                    }
                    case 3: {
                        this.myFloat64 = _readable.readDouble();
                        continue block10;
                    }
                    case 4: {
                        int length2 = _readable.readUnsignedVarint() - 1;
                        if (length2 < 0) {
                            throw new RuntimeException("non-nullable field myString was serialized as null");
                        }
                        if (length2 > Short.MAX_VALUE) {
                            throw new RuntimeException("string field myString had invalid length " + length2);
                        }
                        this.myString = _readable.readString(length2);
                        continue block10;
                    }
                    case 5: {
                        int length2 = _readable.readUnsignedVarint() - 1;
                        if (length2 < 0) {
                            this.myBytes = null;
                            continue block10;
                        }
                        byte[] newBytes = new byte[length2];
                        _readable.readArray(newBytes);
                        this.myBytes = newBytes;
                        continue block10;
                    }
                    case 6: {
                        this.taggedUuid = _readable.readUUID();
                        continue block10;
                    }
                    case 7: {
                        this.taggedLong = _readable.readLong();
                        continue block10;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _writable.writeUUID(this.processId);
        } else if (this.processId != MessageUtil.ZERO_UUID) {
            throw new UnsupportedVersionException("Attempted to write a non-default processId at version " + _version);
        }
        if (_version >= 1) {
            if (!this.myTaggedIntArray.isEmpty()) {
                ++_numTaggedFields;
            }
        } else if (!this.myTaggedIntArray.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default myTaggedIntArray at version " + _version);
        }
        if (_version >= 1) {
            if (this.myNullableString != null) {
                ++_numTaggedFields;
            }
        } else if (this.myNullableString != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default myNullableString at version " + _version);
        }
        if (_version >= 1) {
            if (this.myInt16 != 123) {
                ++_numTaggedFields;
            }
        } else if (this.myInt16 != 123) {
            throw new UnsupportedVersionException("Attempted to write a non-default myInt16 at version " + _version);
        }
        if (_version >= 1) {
            if (this.myFloat64 != Double.parseDouble("12.34")) {
                ++_numTaggedFields;
            }
        } else if (this.myFloat64 != Double.parseDouble("12.34")) {
            throw new UnsupportedVersionException("Attempted to write a non-default myFloat64 at version " + _version);
        }
        if (_version >= 1) {
            if (!this.myString.equals("")) {
                ++_numTaggedFields;
            }
        } else if (!this.myString.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default myString at version " + _version);
        }
        if (_version >= 1) {
            if (this.myBytes == null || this.myBytes.length != 0) {
                ++_numTaggedFields;
            }
        } else if (this.myBytes == null || this.myBytes.length != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default myBytes at version " + _version);
        }
        if (_version >= 1) {
            if (this.taggedUuid != UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367")) {
                ++_numTaggedFields;
            }
        } else if (this.taggedUuid != UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367")) {
            throw new UnsupportedVersionException("Attempted to write a non-default taggedUuid at version " + _version);
        }
        if (_version >= 1) {
            if (this.taggedLong != 0xCAFCACAFCACAFCAL) {
                ++_numTaggedFields;
            }
        } else if (this.taggedLong != 0xCAFCACAFCACAFCAL) {
            throw new UnsupportedVersionException("Attempted to write a non-default taggedLong at version " + _version);
        }
        if (_version >= 1) {
            _writable.writeUnsignedVarint(this.zeroCopyByteBuffer.remaining() + 1);
            _writable.writeByteBuffer(this.zeroCopyByteBuffer);
        } else if (this.zeroCopyByteBuffer.hasRemaining()) {
            throw new UnsupportedVersionException("Attempted to write a non-default zeroCopyByteBuffer at version " + _version);
        }
        if (_version >= 1) {
            if (this.nullableZeroCopyByteBuffer == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.nullableZeroCopyByteBuffer.remaining() + 1);
                _writable.writeByteBuffer(this.nullableZeroCopyByteBuffer);
            }
        } else if (this.nullableZeroCopyByteBuffer == null || this.nullableZeroCopyByteBuffer.remaining() > 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default nullableZeroCopyByteBuffer at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 1) {
            byte[] _stringBytes;
            _writable.writeUnsignedVarint(_numTaggedFields);
            if (!this.myTaggedIntArray.isEmpty()) {
                _writable.writeUnsignedVarint(0);
                _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.myTaggedIntArray));
                _writable.writeUnsignedVarint(this.myTaggedIntArray.size() + 1);
                for (Integer myTaggedIntArrayElement : this.myTaggedIntArray) {
                    _writable.writeInt(myTaggedIntArrayElement.intValue());
                }
            }
            if (this.myNullableString != null) {
                _writable.writeUnsignedVarint(1);
                _stringBytes = _cache.getSerializedValue((Object)this.myNullableString);
                _writable.writeUnsignedVarint(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            if (this.myInt16 != 123) {
                _writable.writeUnsignedVarint(2);
                _writable.writeUnsignedVarint(2);
                _writable.writeShort(this.myInt16);
            }
            if (this.myFloat64 != Double.parseDouble("12.34")) {
                _writable.writeUnsignedVarint(3);
                _writable.writeUnsignedVarint(8);
                _writable.writeDouble(this.myFloat64);
            }
            if (!this.myString.equals("")) {
                _writable.writeUnsignedVarint(4);
                _stringBytes = _cache.getSerializedValue((Object)this.myString);
                _writable.writeUnsignedVarint(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            if (this.myBytes == null) {
                _writable.writeUnsignedVarint(5);
                _writable.writeUnsignedVarint(1);
                _writable.writeUnsignedVarint(0);
            } else if (this.myBytes.length != 0) {
                _writable.writeUnsignedVarint(5);
                _writable.writeUnsignedVarint(this.myBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(this.myBytes.length + 1)));
                _writable.writeUnsignedVarint(this.myBytes.length + 1);
                _writable.writeByteArray(this.myBytes);
            }
            if (this.taggedUuid != UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367")) {
                _writable.writeUnsignedVarint(6);
                _writable.writeUnsignedVarint(16);
                _writable.writeUUID(this.taggedUuid);
            }
            if (this.taggedLong != 0xCAFCACAFCACAFCAL) {
                _writable.writeUnsignedVarint(7);
                _writable.writeUnsignedVarint(8);
                _writable.writeLong(this.taggedLong);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 1) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.processId = _version >= 1 ? struct.getUUID("process_id") : MessageUtil.ZERO_UUID;
        if (_version >= 1) {
            if (_taggedFields.containsKey(0)) {
                Object[] _nestedObjects = (Object[])_taggedFields.remove(0);
                this.myTaggedIntArray = new ArrayList<Integer>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.myTaggedIntArray.add((Integer)nestedObject);
                }
            } else {
                this.myTaggedIntArray = new ArrayList<Integer>();
            }
        } else {
            this.myTaggedIntArray = new ArrayList<Integer>();
        }
        this.myNullableString = _version >= 1 ? (_taggedFields.containsKey(1) ? (String)_taggedFields.remove(1) : null) : null;
        this.myInt16 = _version >= 1 ? (_taggedFields.containsKey(2) ? (Short)_taggedFields.remove(2) : (short)123) : (short)123;
        this.myFloat64 = _version >= 1 ? (_taggedFields.containsKey(3) ? (Double)_taggedFields.remove(3) : Double.parseDouble("12.34")) : Double.parseDouble("12.34");
        this.myString = _version >= 1 ? (_taggedFields.containsKey(4) ? (String)_taggedFields.remove(4) : "") : "";
        this.myBytes = _version >= 1 ? (_taggedFields.containsKey(5) ? MessageUtil.byteBufferToArray((ByteBuffer)((ByteBuffer)_taggedFields.remove(5))) : Bytes.EMPTY) : Bytes.EMPTY;
        this.taggedUuid = _version >= 1 ? (_taggedFields.containsKey(6) ? (UUID)_taggedFields.remove(6) : UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367")) : UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367");
        this.taggedLong = _version >= 1 ? (_taggedFields.containsKey(7) ? (Long)_taggedFields.remove(7) : 0xCAFCACAFCACAFCAL) : 0xCAFCACAFCACAFCAL;
        this.zeroCopyByteBuffer = _version >= 1 ? struct.getBytes("zero_copy_byte_buffer") : ByteUtils.EMPTY_BUF;
        this.nullableZeroCopyByteBuffer = _version >= 1 ? struct.getBytes("nullable_zero_copy_byte_buffer") : ByteUtils.EMPTY_BUF;
        if (_version >= 1 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    public Struct toStruct(short _version) {
        TreeMap<Integer, Object> _taggedFields = null;
        if (_version >= 1) {
            _taggedFields = new TreeMap<Integer, Object>();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 1) {
            struct.set("process_id", (Object)this.processId);
        } else if (this.processId != MessageUtil.ZERO_UUID) {
            throw new UnsupportedVersionException("Attempted to write a non-default processId at version " + _version);
        }
        if (_version >= 1) {
            if (!this.myTaggedIntArray.isEmpty()) {
                Integer[] _nestedObjects = new Integer[this.myTaggedIntArray.size()];
                int i = 0;
                for (Integer element : this.myTaggedIntArray) {
                    _nestedObjects[i++] = element;
                }
                _taggedFields.put(0, _nestedObjects);
            }
        } else if (!this.myTaggedIntArray.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default myTaggedIntArray at version " + _version);
        }
        if (_version >= 1) {
            if (this.myNullableString != null) {
                _taggedFields.put(1, this.myNullableString);
            }
        } else if (this.myNullableString != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default myNullableString at version " + _version);
        }
        if (_version >= 1) {
            if (this.myInt16 != 123) {
                _taggedFields.put(2, this.myInt16);
            }
        } else if (this.myInt16 != 123) {
            throw new UnsupportedVersionException("Attempted to write a non-default myInt16 at version " + _version);
        }
        if (_version >= 1) {
            if (this.myFloat64 != Double.parseDouble("12.34")) {
                _taggedFields.put(3, this.myFloat64);
            }
        } else if (this.myFloat64 != Double.parseDouble("12.34")) {
            throw new UnsupportedVersionException("Attempted to write a non-default myFloat64 at version " + _version);
        }
        if (_version >= 1) {
            if (!this.myString.equals("")) {
                _taggedFields.put(4, this.myString);
            }
        } else if (!this.myString.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default myString at version " + _version);
        }
        if (_version >= 1) {
            if (this.myBytes == null || this.myBytes.length != 0) {
                _taggedFields.put(5, this.myBytes == null ? null : ByteBuffer.wrap(this.myBytes));
            }
        } else if (this.myBytes == null || this.myBytes.length != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default myBytes at version " + _version);
        }
        if (_version >= 1) {
            if (this.taggedUuid != UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367")) {
                _taggedFields.put(6, this.taggedUuid);
            }
        } else if (this.taggedUuid != UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367")) {
            throw new UnsupportedVersionException("Attempted to write a non-default taggedUuid at version " + _version);
        }
        if (_version >= 1) {
            if (this.taggedLong != 0xCAFCACAFCACAFCAL) {
                _taggedFields.put(7, this.taggedLong);
            }
        } else if (this.taggedLong != 0xCAFCACAFCACAFCAL) {
            throw new UnsupportedVersionException("Attempted to write a non-default taggedLong at version " + _version);
        }
        if (_version >= 1) {
            struct.set("zero_copy_byte_buffer", (Object)this.zeroCopyByteBuffer);
        } else if (this.zeroCopyByteBuffer.hasRemaining()) {
            throw new UnsupportedVersionException("Attempted to write a non-default zeroCopyByteBuffer at version " + _version);
        }
        if (_version >= 1) {
            struct.set("nullable_zero_copy_byte_buffer", (Object)this.nullableZeroCopyByteBuffer);
        } else if (this.nullableZeroCopyByteBuffer == null || this.nullableZeroCopyByteBuffer.remaining() > 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default nullableZeroCopyByteBuffer at version " + _version);
        }
        if (_version >= 1) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _stringPrefixSize;
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _size += 16;
        }
        if (_version >= 1 && !this.myTaggedIntArray.isEmpty()) {
            ++_numTaggedFields;
            ++_size;
            int _arraySize = 0;
            _arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.myTaggedIntArray.size() + 1));
            _cache.setArraySizeInBytes(this.myTaggedIntArray, _arraySize += this.myTaggedIntArray.size() * 4);
            _size += _arraySize + ByteUtils.sizeOfUnsignedVarint((int)_arraySize);
        }
        if (_version >= 1 && this.myNullableString != null) {
            ++_numTaggedFields;
            ++_size;
            byte[] _stringBytes = this.myNullableString.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'myNullableString' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.myNullableString, _stringBytes);
            _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            _size += _stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint((int)_stringPrefixSize);
        }
        if (_version >= 1 && this.myInt16 != 123) {
            ++_numTaggedFields;
            ++_size;
            ++_size;
            _size += 2;
        }
        if (_version >= 1 && this.myFloat64 != Double.parseDouble("12.34")) {
            ++_numTaggedFields;
            ++_size;
            ++_size;
            _size += 8;
        }
        if (_version >= 1 && !this.myString.equals("")) {
            ++_numTaggedFields;
            ++_size;
            byte[] _stringBytes = this.myString.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'myString' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.myString, _stringBytes);
            _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            _size += _stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint((int)_stringPrefixSize);
        }
        if (_version >= 1) {
            if (this.myBytes == null) {
                ++_numTaggedFields;
                ++_size;
                ++_size;
                ++_size;
            } else if (this.myBytes.length != 0) {
                ++_numTaggedFields;
                ++_size;
                int _bytesSize = this.myBytes.length;
                _size += (_bytesSize += ByteUtils.sizeOfUnsignedVarint((int)(this.myBytes.length + 1))) + ByteUtils.sizeOfUnsignedVarint((int)_bytesSize);
            }
        }
        if (_version >= 1 && this.taggedUuid != UUID.fromString("212d5494-4a8b-4fdf-94b3-88b470beb367")) {
            ++_numTaggedFields;
            ++_size;
            ++_size;
            _size += 16;
        }
        if (_version >= 1 && this.taggedLong != 0xCAFCACAFCACAFCAL) {
            ++_numTaggedFields;
            ++_size;
            ++_size;
            _size += 8;
        }
        if (_version >= 1) {
            int _bytesSize = this.zeroCopyByteBuffer.remaining();
            _size += (_bytesSize += ByteUtils.sizeOfUnsignedVarint((int)(this.zeroCopyByteBuffer.remaining() + 1)));
        }
        if (_version >= 1) {
            if (this.nullableZeroCopyByteBuffer == null) {
                ++_size;
            } else {
                int _bytesSize = this.nullableZeroCopyByteBuffer.remaining();
                _size += (_bytesSize += ByteUtils.sizeOfUnsignedVarint((int)(this.nullableZeroCopyByteBuffer.remaining() + 1)));
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 1) {
            _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleExampleMessageData)) {
            return false;
        }
        SimpleExampleMessageData other = (SimpleExampleMessageData)obj;
        if (!this.processId.equals(other.processId)) {
            return false;
        }
        if (this.myTaggedIntArray == null ? other.myTaggedIntArray != null : !this.myTaggedIntArray.equals(other.myTaggedIntArray)) {
            return false;
        }
        if (this.myNullableString == null ? other.myNullableString != null : !this.myNullableString.equals(other.myNullableString)) {
            return false;
        }
        if (this.myInt16 != other.myInt16) {
            return false;
        }
        if (this.myFloat64 != other.myFloat64) {
            return false;
        }
        if (this.myString == null ? other.myString != null : !this.myString.equals(other.myString)) {
            return false;
        }
        if (!Arrays.equals(this.myBytes, other.myBytes)) {
            return false;
        }
        if (!this.taggedUuid.equals(other.taggedUuid)) {
            return false;
        }
        if (this.taggedLong != other.taggedLong) {
            return false;
        }
        if (!Objects.equals(this.zeroCopyByteBuffer, other.zeroCopyByteBuffer)) {
            return false;
        }
        return Objects.equals(this.nullableZeroCopyByteBuffer, other.nullableZeroCopyByteBuffer);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.processId.hashCode();
        hashCode = 31 * hashCode + (this.myTaggedIntArray == null ? 0 : this.myTaggedIntArray.hashCode());
        hashCode = 31 * hashCode + (this.myNullableString == null ? 0 : this.myNullableString.hashCode());
        hashCode = 31 * hashCode + this.myInt16;
        hashCode = 31 * hashCode + Double.hashCode(this.myFloat64);
        hashCode = 31 * hashCode + (this.myString == null ? 0 : this.myString.hashCode());
        hashCode = 31 * hashCode + Arrays.hashCode(this.myBytes);
        hashCode = 31 * hashCode + this.taggedUuid.hashCode();
        hashCode = 31 * hashCode + ((int)(this.taggedLong >> 32) ^ (int)this.taggedLong);
        hashCode = 31 * hashCode + Objects.hashCode(this.zeroCopyByteBuffer);
        hashCode = 31 * hashCode + Objects.hashCode(this.nullableZeroCopyByteBuffer);
        return hashCode;
    }

    public String toString() {
        return "SimpleExampleMessageData(, myTaggedIntArray=" + MessageUtil.deepToString(this.myTaggedIntArray.iterator()) + ", myNullableString=" + (this.myNullableString == null ? "null" : "'" + this.myNullableString.toString() + "'") + ", myInt16=" + this.myInt16 + ", myFloat64=" + this.myFloat64 + ", myString=" + (this.myString == null ? "null" : "'" + this.myString.toString() + "'") + ", myBytes=" + Arrays.toString(this.myBytes) + ", taggedLong=" + this.taggedLong + ", zeroCopyByteBuffer=" + this.zeroCopyByteBuffer + ", nullableZeroCopyByteBuffer=" + this.nullableZeroCopyByteBuffer + ")";
    }

    public UUID processId() {
        return this.processId;
    }

    public List<Integer> myTaggedIntArray() {
        return this.myTaggedIntArray;
    }

    public String myNullableString() {
        return this.myNullableString;
    }

    public short myInt16() {
        return this.myInt16;
    }

    public double myFloat64() {
        return this.myFloat64;
    }

    public String myString() {
        return this.myString;
    }

    public byte[] myBytes() {
        return this.myBytes;
    }

    public UUID taggedUuid() {
        return this.taggedUuid;
    }

    public long taggedLong() {
        return this.taggedLong;
    }

    public ByteBuffer zeroCopyByteBuffer() {
        return this.zeroCopyByteBuffer;
    }

    public ByteBuffer nullableZeroCopyByteBuffer() {
        return this.nullableZeroCopyByteBuffer;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public SimpleExampleMessageData setProcessId(UUID v) {
        this.processId = v;
        return this;
    }

    public SimpleExampleMessageData setMyTaggedIntArray(List<Integer> v) {
        this.myTaggedIntArray = v;
        return this;
    }

    public SimpleExampleMessageData setMyNullableString(String v) {
        this.myNullableString = v;
        return this;
    }

    public SimpleExampleMessageData setMyInt16(short v) {
        this.myInt16 = v;
        return this;
    }

    public SimpleExampleMessageData setMyFloat64(double v) {
        this.myFloat64 = v;
        return this;
    }

    public SimpleExampleMessageData setMyString(String v) {
        this.myString = v;
        return this;
    }

    public SimpleExampleMessageData setMyBytes(byte[] v) {
        this.myBytes = v;
        return this;
    }

    public SimpleExampleMessageData setTaggedUuid(UUID v) {
        this.taggedUuid = v;
        return this;
    }

    public SimpleExampleMessageData setTaggedLong(long v) {
        this.taggedLong = v;
        return this;
    }

    public SimpleExampleMessageData setZeroCopyByteBuffer(ByteBuffer v) {
        this.zeroCopyByteBuffer = v;
        return this;
    }

    public SimpleExampleMessageData setNullableZeroCopyByteBuffer(ByteBuffer v) {
        this.nullableZeroCopyByteBuffer = v;
        return this;
    }
}

