/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.SaslChannelBuilder;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SaslChannelBuilderTest {
    @After
    public void tearDown() {
        System.clearProperty("sun.security.jgss.native");
    }

    @Test
    public void testCloseBeforeConfigureIsIdempotent() {
        SaslChannelBuilder builder = this.createChannelBuilder(SecurityProtocol.SASL_PLAINTEXT);
        builder.close();
        Assert.assertTrue((boolean)builder.loginManagers().isEmpty());
        builder.close();
        Assert.assertTrue((boolean)builder.loginManagers().isEmpty());
    }

    @Test
    public void testCloseAfterConfigIsIdempotent() {
        SaslChannelBuilder builder = this.createChannelBuilder(SecurityProtocol.SASL_PLAINTEXT);
        builder.configure(new HashMap());
        Assert.assertNotNull(builder.loginManagers().get("PLAIN"));
        builder.close();
        Assert.assertTrue((boolean)builder.loginManagers().isEmpty());
        builder.close();
        Assert.assertTrue((boolean)builder.loginManagers().isEmpty());
    }

    @Test
    public void testLoginManagerReleasedIfConfigureThrowsException() {
        SaslChannelBuilder builder = this.createChannelBuilder(SecurityProtocol.SASL_SSL);
        try {
            builder.configure(Collections.singletonMap("ssl.enabled.protocols", "1"));
            Assert.fail((String)"Exception should have been thrown");
        }
        catch (KafkaException e) {
            Assert.assertTrue((boolean)builder.loginManagers().isEmpty());
        }
        builder.close();
        Assert.assertTrue((boolean)builder.loginManagers().isEmpty());
    }

    @Test
    public void testNativeGssapiCredentials() throws Exception {
        System.setProperty("sun.security.jgss.native", "true");
        TestJaasConfig jaasConfig = new TestJaasConfig();
        jaasConfig.addEntry("jaasContext", TestGssapiLoginModule.class.getName(), new HashMap<String, Object>());
        JaasContext jaasContext = new JaasContext("jaasContext", JaasContext.Type.SERVER, (Configuration)jaasConfig, null);
        Map<String, JaasContext> jaasContexts = Collections.singletonMap("GSSAPI", jaasContext);
        GSSManager gssManager = (GSSManager)Mockito.mock(GSSManager.class);
        GSSName gssName = (GSSName)Mockito.mock(GSSName.class);
        Mockito.when((Object)gssManager.createName(Mockito.anyString(), (Oid)Mockito.any())).thenAnswer(unused -> gssName);
        Oid oid = new Oid("1.2.840.113554.1.2.2");
        Mockito.when((Object)gssManager.createCredential(gssName, Integer.MAX_VALUE, oid, 2)).thenAnswer(unused -> (GSSCredential)Mockito.mock(GSSCredential.class));
        SaslChannelBuilder channelBuilder1 = this.createGssapiChannelBuilder(jaasContexts, gssManager);
        Assert.assertEquals((long)1L, (long)channelBuilder1.subject("GSSAPI").getPrincipals().size());
        Assert.assertEquals((long)1L, (long)channelBuilder1.subject("GSSAPI").getPrivateCredentials().size());
        SaslChannelBuilder channelBuilder2 = this.createGssapiChannelBuilder(jaasContexts, gssManager);
        Assert.assertEquals((long)1L, (long)channelBuilder2.subject("GSSAPI").getPrincipals().size());
        Assert.assertEquals((long)1L, (long)channelBuilder2.subject("GSSAPI").getPrivateCredentials().size());
        Assert.assertSame((Object)channelBuilder1.subject("GSSAPI"), (Object)channelBuilder2.subject("GSSAPI"));
        ((GSSManager)Mockito.verify((Object)gssManager, (VerificationMode)Mockito.times((int)1))).createCredential(gssName, Integer.MAX_VALUE, oid, 2);
    }

    private SaslChannelBuilder createGssapiChannelBuilder(Map<String, JaasContext> jaasContexts, final GSSManager gssManager) {
        SaslChannelBuilder channelBuilder = new SaslChannelBuilder(Mode.SERVER, jaasContexts, SecurityProtocol.SASL_PLAINTEXT, new ListenerName("GSSAPI"), false, "GSSAPI", true, null, null, Time.SYSTEM, new LogContext()){

            protected GSSManager gssManager() {
                return gssManager;
            }
        };
        Map<String, String> props = Collections.singletonMap("sasl.kerberos.service.name", "kafka");
        channelBuilder.configure(new TestSecurityConfig(props).values());
        return channelBuilder;
    }

    private SaslChannelBuilder createChannelBuilder(SecurityProtocol securityProtocol) {
        TestJaasConfig jaasConfig = new TestJaasConfig();
        jaasConfig.addEntry("jaasContext", PlainLoginModule.class.getName(), new HashMap<String, Object>());
        JaasContext jaasContext = new JaasContext("jaasContext", JaasContext.Type.SERVER, (Configuration)jaasConfig, null);
        Map<String, JaasContext> jaasContexts = Collections.singletonMap("PLAIN", jaasContext);
        return new SaslChannelBuilder(Mode.CLIENT, jaasContexts, securityProtocol, new ListenerName("PLAIN"), false, "PLAIN", true, null, null, Time.SYSTEM, new LogContext());
    }

    public static final class TestGssapiLoginModule
    implements LoginModule {
        private Subject subject;

        @Override
        public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
            this.subject = subject;
        }

        @Override
        public boolean login() throws LoginException {
            this.subject.getPrincipals().add((Principal)new KafkaPrincipal("User", "kafka@kafka1.example.com"));
            return true;
        }

        @Override
        public boolean commit() throws LoginException {
            return true;
        }

        @Override
        public boolean abort() throws LoginException {
            return true;
        }

        @Override
        public boolean logout() throws LoginException {
            return true;
        }
    }
}

