/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.StopReplicaResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class StopReplicaResponseTest {
    @Test
    public void testErrorCountsFromGetErrorResponse() {
        StopReplicaRequest request = (StopReplicaRequest)new StopReplicaRequest.Builder(ApiKeys.STOP_REPLICA.latestVersion(), 15, 20, 0L, false, (Collection)Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1)})).build();
        StopReplicaResponse response = request.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assert.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 2), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsWithTopLevelError() {
        ArrayList<StopReplicaResponseData.StopReplicaPartitionError> errors = new ArrayList<StopReplicaResponseData.StopReplicaPartitionError>();
        errors.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("foo").setPartitionIndex(0));
        errors.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("foo").setPartitionIndex(1).setErrorCode(Errors.NOT_LEADER_FOR_PARTITION.code()));
        StopReplicaResponse response = new StopReplicaResponse(new StopReplicaResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setPartitionErrors(errors));
        Assert.assertEquals(Collections.singletonMap(Errors.UNKNOWN_SERVER_ERROR, 2), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsNoTopLevelError() {
        ArrayList<StopReplicaResponseData.StopReplicaPartitionError> errors = new ArrayList<StopReplicaResponseData.StopReplicaPartitionError>();
        errors.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("foo").setPartitionIndex(0));
        errors.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("foo").setPartitionIndex(1).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()));
        StopReplicaResponse response = new StopReplicaResponse(new StopReplicaResponseData().setErrorCode(Errors.NONE.code()).setPartitionErrors(errors));
        Map errorCounts = response.errorCounts();
        Assert.assertEquals((long)2L, (long)errorCounts.size());
        Assert.assertEquals((long)1L, (long)((Integer)errorCounts.get(Errors.NONE)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)errorCounts.get(Errors.CLUSTER_AUTHORIZATION_FAILED)).intValue());
    }

    @Test
    public void testToString() {
        ArrayList<StopReplicaResponseData.StopReplicaPartitionError> errors = new ArrayList<StopReplicaResponseData.StopReplicaPartitionError>();
        errors.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("foo").setPartitionIndex(0));
        errors.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName("foo").setPartitionIndex(1).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()));
        StopReplicaResponse response = new StopReplicaResponse(new StopReplicaResponseData().setPartitionErrors(errors));
        String responseStr = response.toString();
        Assert.assertTrue((boolean)responseStr.contains(StopReplicaResponse.class.getSimpleName()));
        Assert.assertTrue((boolean)responseStr.contains(((Object)errors).toString()));
        Assert.assertTrue((boolean)responseStr.contains("errorCode=" + Errors.NONE.code()));
    }
}

