/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslClientCallbackHandler;
import org.junit.Assert;
import org.junit.Test;

public class OAuthBearerSaslClienCallbackHandlerTest {
    private static OAuthBearerToken createTokenWithLifetimeMillis(final long lifetimeMillis) {
        return new OAuthBearerToken(){

            public String value() {
                return null;
            }

            public Long startTimeMs() {
                return null;
            }

            public Set<String> scope() {
                return null;
            }

            public String principalName() {
                return null;
            }

            public long lifetimeMs() {
                return lifetimeMillis;
            }
        };
    }

    @Test(expected=IOException.class)
    public void testWithZeroTokens() throws Throwable {
        OAuthBearerSaslClientCallbackHandler handler = OAuthBearerSaslClienCallbackHandlerTest.createCallbackHandler();
        try {
            Subject.doAs(new Subject(), () -> {
                OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
                handler.handle(new Callback[]{callback});
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
    }

    @Test
    public void testWithPotentiallyMultipleTokens() throws Exception {
        OAuthBearerSaslClientCallbackHandler handler = OAuthBearerSaslClienCallbackHandlerTest.createCallbackHandler();
        Subject.doAs(new Subject(), () -> {
            int maxTokens = 4;
            Set<Object> privateCredentials = Subject.getSubject(AccessController.getContext()).getPrivateCredentials();
            privateCredentials.clear();
            for (int num = 1; num <= 4; ++num) {
                privateCredentials.add(OAuthBearerSaslClienCallbackHandlerTest.createTokenWithLifetimeMillis(num));
                OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
                handler.handle(new Callback[]{callback});
                Assert.assertEquals((long)num, (long)callback.token().lifetimeMs());
            }
            return null;
        });
    }

    private static OAuthBearerSaslClientCallbackHandler createCallbackHandler() {
        OAuthBearerSaslClientCallbackHandler handler = new OAuthBearerSaslClientCallbackHandler();
        handler.configure(Collections.emptyMap(), "OAUTHBEARER", Collections.emptyList());
        return handler;
    }
}

