/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.junit.Assert;
import org.junit.Test;

public class OAuthBearerValidatorCallbackTest {
    private static final OAuthBearerToken TOKEN = new OAuthBearerToken(){

        public String value() {
            return "value";
        }

        public Long startTimeMs() {
            return null;
        }

        public Set<String> scope() {
            return Collections.emptySet();
        }

        public String principalName() {
            return "principalName";
        }

        public long lifetimeMs() {
            return 0L;
        }
    };

    @Test
    public void testError() {
        String errorStatus = "errorStatus";
        String errorScope = "errorScope";
        String errorOpenIDConfiguration = "errorOpenIDConfiguration";
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(TOKEN.value());
        callback.error(errorStatus, errorScope, errorOpenIDConfiguration);
        Assert.assertEquals((Object)errorStatus, (Object)callback.errorStatus());
        Assert.assertEquals((Object)errorScope, (Object)callback.errorScope());
        Assert.assertEquals((Object)errorOpenIDConfiguration, (Object)callback.errorOpenIDConfiguration());
        Assert.assertNull((Object)callback.token());
    }

    @Test
    public void testToken() {
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(TOKEN.value());
        callback.token(TOKEN);
        Assert.assertSame((Object)TOKEN, (Object)callback.token());
        Assert.assertNull((Object)callback.errorStatus());
        Assert.assertNull((Object)callback.errorScope());
        Assert.assertNull((Object)callback.errorOpenIDConfiguration());
    }
}

