/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class HeartbeatRequestData
implements ApiMessage {
    private String groupId;
    private int generationId;
    private String memberId;
    private String groupInstanceId;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema[] SCHEMAS;

    public HeartbeatRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public HeartbeatRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public HeartbeatRequestData(JsonNode _node, short _version) {
        this.fromJson(_node, _version);
    }

    public HeartbeatRequestData() {
        this.groupId = "";
        this.generationId = 0;
        this.memberId = "";
        this.groupInstanceId = null;
    }

    @Override
    public short apiKey() {
        return 12;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 4;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field groupId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field groupId had invalid length " + length);
        }
        this.groupId = _readable.readString(length);
        this.generationId = _readable.readInt();
        length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field memberId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field memberId had invalid length " + length);
        }
        this.memberId = _readable.readString(length);
        if (_version >= 3) {
            length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                this.groupInstanceId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field groupInstanceId had invalid length " + length);
                }
                this.groupInstanceId = _readable.readString(length);
            }
        } else {
            this.groupInstanceId = null;
        }
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = _cache.getSerializedValue(this.groupId);
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
        } else {
            _writable.writeShort((short)_stringBytes.length);
        }
        _writable.writeByteArray(_stringBytes);
        _writable.writeInt(this.generationId);
        _stringBytes = _cache.getSerializedValue(this.memberId);
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
        } else {
            _writable.writeShort((short)_stringBytes.length);
        }
        _writable.writeByteArray(_stringBytes);
        if (_version >= 3) {
            if (this.groupInstanceId == null) {
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.groupInstanceId);
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
        } else if (this.groupInstanceId != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default groupInstanceId at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.groupId = struct.getString("group_id");
        this.generationId = struct.getInt("generation_id");
        this.memberId = struct.getString("member_id");
        this.groupInstanceId = _version >= 3 ? struct.getString("group_instance_id") : null;
        if (_version >= 4 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 4) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("group_id", (Object)this.groupId);
        struct.set("generation_id", (Object)this.generationId);
        struct.set("member_id", (Object)this.memberId);
        if (_version >= 3) {
            struct.set("group_instance_id", (Object)this.groupInstanceId);
        } else if (this.groupInstanceId != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default groupInstanceId at version " + _version);
        }
        if (_version >= 4) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public void fromJson(JsonNode _node, short _version) {
        JsonNode _groupIdNode = _node.get("groupId");
        if (_groupIdNode == null) {
            throw new RuntimeException("HeartbeatRequestData: unable to locate field 'groupId', which is mandatory in version " + _version);
        }
        if (!_groupIdNode.isTextual()) {
            throw new RuntimeException("HeartbeatRequestData expected a string type, but got " + _node.getNodeType());
        }
        this.groupId = _groupIdNode.asText();
        JsonNode _generationIdNode = _node.get("generationId");
        if (_generationIdNode == null) {
            throw new RuntimeException("HeartbeatRequestData: unable to locate field 'generationId', which is mandatory in version " + _version);
        }
        this.generationId = MessageUtil.jsonNodeToInt(_generationIdNode, "HeartbeatRequestData");
        JsonNode _memberIdNode = _node.get("memberId");
        if (_memberIdNode == null) {
            throw new RuntimeException("HeartbeatRequestData: unable to locate field 'memberId', which is mandatory in version " + _version);
        }
        if (!_memberIdNode.isTextual()) {
            throw new RuntimeException("HeartbeatRequestData expected a string type, but got " + _node.getNodeType());
        }
        this.memberId = _memberIdNode.asText();
        JsonNode _groupInstanceIdNode = _node.get("groupInstanceId");
        if (_groupInstanceIdNode == null) {
            if (_version >= 3) {
                throw new RuntimeException("HeartbeatRequestData: unable to locate field 'groupInstanceId', which is mandatory in version " + _version);
            }
            this.groupInstanceId = null;
        } else if (_groupInstanceIdNode.isNull()) {
            this.groupInstanceId = null;
        } else {
            if (!_groupInstanceIdNode.isTextual()) {
                throw new RuntimeException("HeartbeatRequestData expected a string type, but got " + _node.getNodeType());
            }
            this.groupInstanceId = _groupInstanceIdNode.asText();
        }
    }

    @Override
    public JsonNode toJson(short _version) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("groupId", (JsonNode)new TextNode(this.groupId));
        _node.set("generationId", (JsonNode)new IntNode(this.generationId));
        _node.set("memberId", (JsonNode)new TextNode(this.memberId));
        if (_version >= 3) {
            if (this.groupInstanceId == null) {
                _node.set("groupInstanceId", (JsonNode)NullNode.instance);
            } else {
                _node.set("groupInstanceId", (JsonNode)new TextNode(this.groupInstanceId));
            }
        } else if (this.groupInstanceId != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default groupInstanceId at version " + _version);
        }
        return _node;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'groupId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.groupId, _stringBytes);
        _size = _version >= 4 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
        _size += 4;
        _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'memberId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.memberId, _stringBytes);
        _size = _version >= 4 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
        if (_version >= 3) {
            if (this.groupInstanceId == null) {
                _size = _version >= 4 ? ++_size : (_size += 2);
            } else {
                _stringBytes = this.groupInstanceId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'groupInstanceId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.groupInstanceId, _stringBytes);
                _size = _version >= 4 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 4) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HeartbeatRequestData)) {
            return false;
        }
        HeartbeatRequestData other = (HeartbeatRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.generationId != other.generationId) {
            return false;
        }
        if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
            return false;
        }
        return !(this.groupInstanceId == null ? other.groupInstanceId != null : !this.groupInstanceId.equals(other.groupInstanceId));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + this.generationId;
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        hashCode = 31 * hashCode + (this.groupInstanceId == null ? 0 : this.groupInstanceId.hashCode());
        return hashCode;
    }

    @Override
    public HeartbeatRequestData duplicate() {
        HeartbeatRequestData _duplicate = new HeartbeatRequestData();
        _duplicate.groupId = this.groupId;
        _duplicate.generationId = this.generationId;
        _duplicate.memberId = this.memberId;
        _duplicate.groupInstanceId = this.groupInstanceId == null ? null : this.groupInstanceId;
        return _duplicate;
    }

    public String toString() {
        return "HeartbeatRequestData(groupId=" + (this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", generationId=" + this.generationId + ", memberId=" + (this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", groupInstanceId=" + (this.groupInstanceId == null ? "null" : "'" + this.groupInstanceId.toString() + "'") + ")";
    }

    public String groupId() {
        return this.groupId;
    }

    public int generationId() {
        return this.generationId;
    }

    public String memberId() {
        return this.memberId;
    }

    public String groupInstanceId() {
        return this.groupInstanceId;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public HeartbeatRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public HeartbeatRequestData setGenerationId(int v) {
        this.generationId = v;
        return this;
    }

    public HeartbeatRequestData setMemberId(String v) {
        this.memberId = v;
        return this;
    }

    public HeartbeatRequestData setGroupInstanceId(String v) {
        this.groupInstanceId = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("group_id", Type.STRING, "The group id."), new Field("generation_id", Type.INT32, "The generation of the group."), new Field("member_id", Type.STRING, "The member ID.")));
        SCHEMA_3 = new Schema(new Field("group_id", Type.STRING, "The group id."), new Field("generation_id", Type.INT32, "The generation of the group."), new Field("member_id", Type.STRING, "The member ID."), new Field("group_instance_id", Type.NULLABLE_STRING, "The unique identifier of the consumer instance provided by end user."));
        SCHEMA_4 = new Schema(new Field("group_id", Type.COMPACT_STRING, "The group id."), new Field("generation_id", Type.INT32, "The generation of the group."), new Field("member_id", Type.COMPACT_STRING, "The member ID."), new Field("group_instance_id", Type.COMPACT_NULLABLE_STRING, "The unique identifier of the consumer instance provided by end user."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
    }
}

