/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class OffsetFetchRequestData
implements ApiMessage {
    private String groupId;
    private List<OffsetFetchRequestTopic> topics;
    private boolean requireStable;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema[] SCHEMAS;

    public OffsetFetchRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public OffsetFetchRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public OffsetFetchRequestData() {
        this.groupId = "";
        this.topics = new ArrayList<OffsetFetchRequestTopic>(0);
        this.requireStable = false;
    }

    public short apiKey() {
        return 9;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 7;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<OffsetFetchRequestTopic> newCollection;
        int arrayLength;
        int length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field groupId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field groupId had invalid length " + length);
        }
        this.groupId = _readable.readString(length);
        if (_version >= 6) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.topics = null;
            } else {
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new OffsetFetchRequestTopic(_readable, _version));
                }
                this.topics = newCollection;
            }
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                if (_version < 2) throw new RuntimeException("non-nullable field topics was serialized as null");
                this.topics = null;
            } else {
                newCollection = new ArrayList<OffsetFetchRequestTopic>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new OffsetFetchRequestTopic(_readable, _version));
                }
                this.topics = newCollection;
            }
        }
        this.requireStable = _version >= 7 ? _readable.readByte() != 0 : false;
        this._unknownTaggedFields = null;
        if (_version < 6) return;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        Object _stringBytes = _cache.getSerializedValue((Object)this.groupId);
        if (_version >= 6) {
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        } else {
            _writable.writeShort((short)((byte[])_stringBytes).length);
        }
        _writable.writeByteArray((byte[])_stringBytes);
        if (_version >= 6) {
            if (this.topics == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.topics.size() + 1);
                _stringBytes = this.topics.iterator();
                while (_stringBytes.hasNext()) {
                    OffsetFetchRequestTopic topicsElement = (OffsetFetchRequestTopic)_stringBytes.next();
                    topicsElement.write(_writable, _cache, _version);
                }
            }
        } else if (this.topics == null) {
            if (_version < 2) throw new NullPointerException();
            _writable.writeInt(-1);
        } else {
            _writable.writeInt(this.topics.size());
            _stringBytes = this.topics.iterator();
            while (_stringBytes.hasNext()) {
                OffsetFetchRequestTopic topicsElement = (OffsetFetchRequestTopic)_stringBytes.next();
                topicsElement.write(_writable, _cache, _version);
            }
        }
        if (_version >= 7) {
            _writable.writeByte(this.requireStable ? (byte)1 : 0);
        } else if (this.requireStable) {
            throw new UnsupportedVersionException("Attempted to write a non-default requireStable at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 6) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            return;
        } else {
            if (_numTaggedFields <= 0) return;
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 6) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.groupId = struct.getString("group_id");
        Object[] _nestedObjects = struct.getArray("topics");
        if (_nestedObjects == null) {
            this.topics = null;
        } else {
            this.topics = new ArrayList<OffsetFetchRequestTopic>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.topics.add(new OffsetFetchRequestTopic((Struct)nestedObject, _version));
            }
        }
        this.requireStable = _version >= 7 ? struct.getBoolean("require_stable") : false;
        if (_version >= 6 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 6) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("group_id", (Object)this.groupId);
        if (this.topics == null) {
            struct.set("topics", null);
        } else {
            Struct[] _nestedObjects = new Struct[this.topics.size()];
            int i = 0;
            for (OffsetFetchRequestTopic element : this.topics) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("topics", (Object)_nestedObjects);
        }
        if (_version >= 7) {
            struct.set("require_stable", (Object)this.requireStable);
        } else if (this.requireStable) {
            throw new UnsupportedVersionException("Attempted to write a non-default requireStable at version " + _version);
        }
        if (_version >= 6) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'groupId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.groupId, _stringBytes);
        _size = _version >= 6 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
        if (this.topics == null) {
            _size = _version >= 6 ? ++_size : (_size += 4);
        } else {
            int _arraySize = 0;
            _arraySize = _version >= 6 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.topics.size() + 1))) : (_arraySize += 4);
            for (OffsetFetchRequestTopic topicsElement : this.topics) {
                _arraySize += topicsElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        if (_version >= 7) {
            ++_size;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 6) {
            _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OffsetFetchRequestData)) {
            return false;
        }
        OffsetFetchRequestData other = (OffsetFetchRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return this.requireStable == other.requireStable;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + (this.requireStable ? 1231 : 1237);
        return hashCode;
    }

    public OffsetFetchRequestData duplicate() {
        OffsetFetchRequestData _duplicate = new OffsetFetchRequestData();
        _duplicate.groupId = this.groupId;
        if (this.topics == null) {
            _duplicate.topics = null;
        } else {
            ArrayList<OffsetFetchRequestTopic> newTopics = new ArrayList<OffsetFetchRequestTopic>(this.topics.size());
            for (OffsetFetchRequestTopic _element : this.topics) {
                newTopics.add(_element.duplicate());
            }
            _duplicate.topics = newTopics;
        }
        _duplicate.requireStable = this.requireStable;
        return _duplicate;
    }

    public String toString() {
        return "OffsetFetchRequestData(groupId=" + (this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", topics=" + (this.topics == null ? "null" : MessageUtil.deepToString(this.topics.iterator())) + ", requireStable=" + (this.requireStable ? "true" : "false") + ")";
    }

    public String groupId() {
        return this.groupId;
    }

    public List<OffsetFetchRequestTopic> topics() {
        return this.topics;
    }

    public boolean requireStable() {
        return this.requireStable;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public OffsetFetchRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public OffsetFetchRequestData setTopics(List<OffsetFetchRequestTopic> v) {
        this.topics = v;
        return this;
    }

    public OffsetFetchRequestData setRequireStable(boolean v) {
        this.requireStable = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("group_id", (Type)Type.STRING, "The group to fetch offsets for."), new Field("topics", (Type)new ArrayOf((Type)OffsetFetchRequestTopic.SCHEMA_0), "Each topic we would like to fetch offsets for, or null to fetch offsets for all topics.")});
        SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = new Schema(new Field[]{new Field("group_id", (Type)Type.STRING, "The group to fetch offsets for."), new Field("topics", (Type)ArrayOf.nullable((Type)OffsetFetchRequestTopic.SCHEMA_0), "Each topic we would like to fetch offsets for, or null to fetch offsets for all topics.")})));
        SCHEMA_6 = new Schema(new Field[]{new Field("group_id", (Type)Type.COMPACT_STRING, "The group to fetch offsets for."), new Field("topics", (Type)CompactArrayOf.nullable((Type)OffsetFetchRequestTopic.SCHEMA_6), "Each topic we would like to fetch offsets for, or null to fetch offsets for all topics."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMA_7 = new Schema(new Field[]{new Field("group_id", (Type)Type.COMPACT_STRING, "The group to fetch offsets for."), new Field("topics", (Type)CompactArrayOf.nullable((Type)OffsetFetchRequestTopic.SCHEMA_6), "Each topic we would like to fetch offsets for, or null to fetch offsets for all topics."), new Field("require_stable", (Type)Type.BOOLEAN, "Whether broker should hold on returning unstable offsets but set a retriable error code for the partition."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
    }

    public static class OffsetFetchRequestTopic
    implements Message {
        private String name;
        private List<Integer> partitionIndexes;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;

        public OffsetFetchRequestTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public OffsetFetchRequestTopic(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public OffsetFetchRequestTopic() {
            this.name = "";
            this.partitionIndexes = new ArrayList<Integer>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 7;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetFetchRequestTopic");
            }
            int length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitionIndexes was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitionIndexes = newCollection;
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.name);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(this.partitionIndexes.size() + 1);
            } else {
                _writable.writeInt(this.partitionIndexes.size());
            }
            _stringBytes = this.partitionIndexes.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionIndexesElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionIndexesElement.intValue());
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetFetchRequestTopic");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partition_indexes");
            this.partitionIndexes = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitionIndexes.add((Integer)nestedObject);
            }
            if (_version >= 6 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OffsetFetchRequestTopic");
            }
            TreeMap _taggedFields = null;
            if (_version >= 6) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Integer[] _nestedObjects = new Integer[this.partitionIndexes.size()];
            int i = 0;
            for (Integer element : this.partitionIndexes) {
                _nestedObjects[i++] = element;
            }
            struct.set("partition_indexes", (Object)_nestedObjects);
            if (_version >= 6) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OffsetFetchRequestTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size = _version >= 6 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1))) : (_size += _stringBytes.length + 2);
            int _arraySize = 0;
            _arraySize = _version >= 6 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.partitionIndexes.size() + 1))) : (_arraySize += 4);
            _size += (_arraySize += this.partitionIndexes.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 6) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetFetchRequestTopic)) {
                return false;
            }
            OffsetFetchRequestTopic other = (OffsetFetchRequestTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitionIndexes == null ? other.partitionIndexes != null : !this.partitionIndexes.equals(other.partitionIndexes));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitionIndexes == null ? 0 : this.partitionIndexes.hashCode());
            return hashCode;
        }

        public OffsetFetchRequestTopic duplicate() {
            OffsetFetchRequestTopic _duplicate = new OffsetFetchRequestTopic();
            _duplicate.name = this.name;
            ArrayList<Integer> newPartitionIndexes = new ArrayList<Integer>(this.partitionIndexes.size());
            for (Integer _element : this.partitionIndexes) {
                newPartitionIndexes.add(_element);
            }
            _duplicate.partitionIndexes = newPartitionIndexes;
            return _duplicate;
        }

        public String toString() {
            return "OffsetFetchRequestTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitionIndexes=" + MessageUtil.deepToString(this.partitionIndexes.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<Integer> partitionIndexes() {
            return this.partitionIndexes;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OffsetFetchRequestTopic setName(String v) {
            this.name = v;
            return this;
        }

        public OffsetFetchRequestTopic setPartitionIndexes(List<Integer> v) {
            this.partitionIndexes = v;
            return this;
        }

        static {
            SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("partition_indexes", (Type)new ArrayOf((Type)Type.INT32), "The partition indexes we would like to fetch offsets for.")})))));
            SCHEMA_7 = SCHEMA_6 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The topic name."), new Field("partition_indexes", (Type)new CompactArrayOf((Type)Type.INT32), "The partition indexes we would like to fetch offsets for."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }
}

