/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OffsetFetchRequestTest {
    private final String topicOne = "topic1";
    private final int partitionOne = 1;
    private final String topicTwo = "topic2";
    private final int partitionTwo = 2;
    private final String groupId = "groupId";
    private OffsetFetchRequest.Builder builder;
    private List<TopicPartition> partitions;

    @Before
    public void setUp() {
        this.partitions = Arrays.asList(new TopicPartition("topic1", 1), new TopicPartition("topic2", 2));
        this.builder = new OffsetFetchRequest.Builder("groupId", false, this.partitions, false);
    }

    @Test
    public void testConstructor() {
        Assert.assertFalse((boolean)this.builder.isAllTopicPartitions());
        int throttleTimeMs = 10;
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> expectedData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        for (TopicPartition partition : this.partitions) {
            expectedData.put(partition, new OffsetFetchResponse.PartitionData(-1L, Optional.empty(), "", Errors.NONE));
        }
        for (short version = 0; version <= ApiKeys.OFFSET_FETCH.latestVersion(); version = (short)(version + 1)) {
            OffsetFetchRequest request = this.builder.build(version);
            Assert.assertFalse((boolean)request.isAllPartitions());
            Assert.assertEquals((Object)"groupId", (Object)request.groupId());
            Assert.assertEquals(this.partitions, (Object)request.partitions());
            OffsetFetchResponse response = request.getErrorResponse(throttleTimeMs, Errors.NONE);
            Assert.assertEquals((Object)Errors.NONE, (Object)response.error());
            Assert.assertFalse((boolean)response.hasError());
            Assert.assertEquals(Collections.singletonMap(Errors.NONE, 1), (Object)response.errorCounts());
            if (version <= 1) {
                Assert.assertEquals(expectedData, (Object)response.responseData());
            }
            if (version >= 3) {
                Assert.assertEquals((long)throttleTimeMs, (long)response.throttleTimeMs());
                continue;
            }
            Assert.assertEquals((long)0L, (long)response.throttleTimeMs());
        }
    }

    @Test
    public void testConstructorFailForUnsupportedRequireStable() {
        for (short version = 0; version <= ApiKeys.OFFSET_FETCH.latestVersion(); version = (short)(version + 1)) {
            this.builder = new OffsetFetchRequest.Builder("groupId", true, null, false);
            short finalVersion = version;
            if (version < 2) {
                Assert.assertThrows(UnsupportedVersionException.class, () -> this.builder.build(finalVersion));
                continue;
            }
            OffsetFetchRequest request = this.builder.build(finalVersion);
            Assert.assertEquals((Object)"groupId", (Object)request.groupId());
            Assert.assertNull((Object)request.partitions());
            Assert.assertTrue((boolean)request.isAllPartitions());
            if (version < 7) {
                Assert.assertFalse((boolean)request.requireStable());
                continue;
            }
            Assert.assertTrue((boolean)request.requireStable());
        }
    }

    @Test
    public void testBuildThrowForUnsupportedRequireStable() {
        for (short version = 0; version <= ApiKeys.OFFSET_FETCH.latestVersion(); version = (short)(version + 1)) {
            this.builder = new OffsetFetchRequest.Builder("groupId", true, null, true);
            if (version < 7) {
                short finalVersion = version;
                Assert.assertThrows(UnsupportedVersionException.class, () -> this.builder.build(finalVersion));
                continue;
            }
            OffsetFetchRequest request = this.builder.build(version);
            Assert.assertTrue((boolean)request.requireStable());
        }
    }
}

