/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProviderCreator;
import org.apache.kafka.common.security.ssl.mock.TestPlainSaslServerProviderCreator;
import org.apache.kafka.common.security.ssl.mock.TestScramSaslServerProviderCreator;
import org.apache.kafka.common.utils.SecurityUtils;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SecurityUtilsTest {
    private SecurityProviderCreator testScramSaslServerProviderCreator = new TestScramSaslServerProviderCreator();
    private SecurityProviderCreator testPlainSaslServerProviderCreator = new TestPlainSaslServerProviderCreator();
    private Provider testScramSaslServerProvider = this.testScramSaslServerProviderCreator.getProvider();
    private Provider testPlainSaslServerProvider = this.testPlainSaslServerProviderCreator.getProvider();

    private void clearTestProviders() {
        Security.removeProvider(this.testScramSaslServerProvider.getName());
        Security.removeProvider(this.testPlainSaslServerProvider.getName());
    }

    @Before
    public void setUp() {
        this.clearTestProviders();
    }

    @After
    public void tearDown() {
        this.clearTestProviders();
    }

    @Test
    public void testPrincipalNameCanContainSeparator() {
        String name = "name:with:separator:in:it";
        KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)("User:" + name));
        Assert.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assert.assertEquals((Object)name, (Object)principal.getName());
    }

    @Test
    public void testParseKafkaPrincipalWithNonUserPrincipalType() {
        String name = "foo";
        String principalType = "Group";
        KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)(principalType + ":" + name));
        Assert.assertEquals((Object)principalType, (Object)principal.getPrincipalType());
        Assert.assertEquals((Object)name, (Object)principal.getName());
    }

    private int getProviderIndexFromName(String providerName, Provider[] providers) {
        for (int index = 0; index < providers.length; ++index) {
            if (!providers[index].getName().equals(providerName)) continue;
            return index;
        }
        return -1;
    }

    @Test
    public void testAddCustomSecurityProvider() {
        String customProviderClasses = this.testScramSaslServerProviderCreator.getClass().getName() + "," + this.testPlainSaslServerProviderCreator.getClass().getName();
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("security.providers", customProviderClasses);
        SecurityUtils.addConfiguredSecurityProviders(configs);
        Provider[] providers = Security.getProviders();
        int testScramSaslServerProviderIndex = this.getProviderIndexFromName(this.testScramSaslServerProvider.getName(), providers);
        int testPlainSaslServerProviderIndex = this.getProviderIndexFromName(this.testPlainSaslServerProvider.getName(), providers);
        MatcherAssert.assertThat((String)(this.testScramSaslServerProvider.getName() + " testProvider not found at expected index"), (testScramSaslServerProviderIndex == 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)(this.testPlainSaslServerProvider.getName() + " testProvider not found at expected index"), (testPlainSaslServerProviderIndex == 1 ? 1 : 0) != 0);
    }
}

