/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.kafka.clients.AddressChangeHostResolver;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.ClusterConnectionStates;
import org.apache.kafka.clients.ConnectionState;
import org.apache.kafka.clients.DefaultHostResolver;
import org.apache.kafka.clients.HostResolver;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClusterConnectionStatesTest {
    private static ArrayList<InetAddress> initialAddresses;
    private static ArrayList<InetAddress> newAddresses;
    private final MockTime time = new MockTime();
    private final long reconnectBackoffMs = 10000L;
    private final long reconnectBackoffMax = 60000L;
    private final double reconnectBackoffJitter = 0.2;
    private final String nodeId1 = "1001";
    private final String nodeId2 = "2002";
    private final String nodeId3 = "3003";
    private final String hostTwoIps = "multiple.ip.address";
    private ClusterConnectionStates connectionStates;
    private DefaultHostResolver singleIPHostResolver = new DefaultHostResolver();
    private AddressChangeHostResolver multipleIPHostResolver = new AddressChangeHostResolver(initialAddresses.toArray(new InetAddress[0]), newAddresses.toArray(new InetAddress[0]));

    @Before
    public void setup() {
        this.connectionStates = new ClusterConnectionStates(10000L, 60000L, new LogContext(), (HostResolver)this.singleIPHostResolver);
    }

    @Test
    public void testClusterConnectionStateChanges() {
        Assert.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost", ClientDnsLookup.DEFAULT);
        Assert.assertEquals((Object)this.connectionStates.connectionState("1001"), (Object)ConnectionState.CONNECTING);
        Assert.assertTrue((boolean)this.connectionStates.isConnecting("1001"));
        Assert.assertFalse((boolean)this.connectionStates.isReady("1001", this.time.milliseconds()));
        Assert.assertFalse((boolean)this.connectionStates.isBlackedOut("1001", this.time.milliseconds()));
        Assert.assertFalse((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        this.time.sleep(100L);
        this.connectionStates.ready("1001");
        Assert.assertEquals((Object)this.connectionStates.connectionState("1001"), (Object)ConnectionState.READY);
        Assert.assertTrue((boolean)this.connectionStates.isReady("1001", this.time.milliseconds()));
        Assert.assertTrue((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        Assert.assertFalse((boolean)this.connectionStates.isConnecting("1001"));
        Assert.assertFalse((boolean)this.connectionStates.isBlackedOut("1001", this.time.milliseconds()));
        Assert.assertEquals((long)this.connectionStates.connectionDelay("1001", this.time.milliseconds()), (long)Long.MAX_VALUE);
        this.time.sleep(15000L);
        this.connectionStates.disconnected("1001", this.time.milliseconds());
        Assert.assertEquals((Object)this.connectionStates.connectionState("1001"), (Object)ConnectionState.DISCONNECTED);
        Assert.assertTrue((boolean)this.connectionStates.isDisconnected("1001"));
        Assert.assertTrue((boolean)this.connectionStates.isBlackedOut("1001", this.time.milliseconds()));
        Assert.assertFalse((boolean)this.connectionStates.isConnecting("1001"));
        Assert.assertFalse((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        Assert.assertFalse((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
        double backoffTolerance = 2000.0;
        long currentBackoff = this.connectionStates.connectionDelay("1001", this.time.milliseconds());
        Assert.assertEquals((double)10000.0, (double)currentBackoff, (double)backoffTolerance);
        this.time.sleep(currentBackoff + 1L);
        Assert.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
    }

    @Test
    public void testMultipleNodeConnectionStates() {
        Assert.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
        Assert.assertTrue((boolean)this.connectionStates.canConnect("2002", this.time.milliseconds()));
        Assert.assertFalse((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        this.connectionStates.connecting("2002", this.time.milliseconds(), "localhost", ClientDnsLookup.DEFAULT);
        Assert.assertFalse((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        this.time.sleep(1000L);
        this.connectionStates.ready("2002");
        Assert.assertTrue((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost", ClientDnsLookup.DEFAULT);
        Assert.assertTrue((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        this.time.sleep(1000L);
        this.connectionStates.ready("1001");
        Assert.assertTrue((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        this.time.sleep(12000L);
        this.connectionStates.disconnected("2002", this.time.milliseconds());
        Assert.assertTrue((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        Assert.assertTrue((boolean)this.connectionStates.isBlackedOut("2002", this.time.milliseconds()));
        Assert.assertFalse((boolean)this.connectionStates.isBlackedOut("1001", this.time.milliseconds()));
        this.time.sleep(this.connectionStates.connectionDelay("2002", this.time.milliseconds()));
        this.connectionStates.disconnected("1001", this.time.milliseconds() + 1L);
        Assert.assertTrue((boolean)this.connectionStates.isBlackedOut("1001", this.time.milliseconds()));
        Assert.assertFalse((boolean)this.connectionStates.isBlackedOut("2002", this.time.milliseconds()));
        Assert.assertFalse((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
    }

    @Test
    public void testAuthorizationFailed() {
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost", ClientDnsLookup.DEFAULT);
        this.time.sleep(100L);
        this.connectionStates.authenticationFailed("1001", this.time.milliseconds(), new AuthenticationException("No path to CA for certificate!"));
        this.time.sleep(1000L);
        Assert.assertEquals((Object)this.connectionStates.connectionState("1001"), (Object)ConnectionState.AUTHENTICATION_FAILED);
        Assert.assertTrue((boolean)(this.connectionStates.authenticationException("1001") instanceof AuthenticationException));
        Assert.assertFalse((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        Assert.assertFalse((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
        this.time.sleep(this.connectionStates.connectionDelay("1001", this.time.milliseconds()) + 1L);
        Assert.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
        this.connectionStates.ready("1001");
        Assert.assertNull((Object)((Object)this.connectionStates.authenticationException("1001")));
    }

    @Test
    public void testRemoveNode() {
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost", ClientDnsLookup.DEFAULT);
        this.time.sleep(1000L);
        this.connectionStates.ready("1001");
        this.time.sleep(10000L);
        this.connectionStates.disconnected("1001", this.time.milliseconds());
        this.connectionStates.remove("1001");
        Assert.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
        Assert.assertFalse((boolean)this.connectionStates.isBlackedOut("1001", this.time.milliseconds()));
        Assert.assertEquals((long)this.connectionStates.connectionDelay("1001", this.time.milliseconds()), (long)0L);
    }

    @Test
    public void testMaxReconnectBackoff() {
        long effectiveMaxReconnectBackoff = Math.round(72000.0);
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost", ClientDnsLookup.DEFAULT);
        this.time.sleep(1000L);
        this.connectionStates.disconnected("1001", this.time.milliseconds());
        for (int i = 0; i < 100; ++i) {
            long reconnectBackoff = this.connectionStates.connectionDelay("1001", this.time.milliseconds());
            Assert.assertTrue((reconnectBackoff <= effectiveMaxReconnectBackoff ? 1 : 0) != 0);
            Assert.assertFalse((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
            this.time.sleep(reconnectBackoff + 1L);
            Assert.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
            this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost", ClientDnsLookup.DEFAULT);
            this.time.sleep(10L);
            this.connectionStates.disconnected("1001", this.time.milliseconds());
        }
    }

    @Test
    public void testExponentialReconnectBackoff() {
        int reconnectBackoffExpBase = 2;
        double reconnectBackoffMaxExp = Math.log(60000.0 / (double)Math.max(10000L, 1L)) / Math.log(2.0);
        for (int i = 0; i < 10; ++i) {
            this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost", ClientDnsLookup.DEFAULT);
            this.connectionStates.disconnected("1001", this.time.milliseconds());
            long expectedBackoff = Math.round(Math.pow(2.0, Math.min((double)i, reconnectBackoffMaxExp)) * 10000.0);
            long currentBackoff = this.connectionStates.connectionDelay("1001", this.time.milliseconds());
            Assert.assertEquals((double)expectedBackoff, (double)currentBackoff, (double)(0.2 * (double)expectedBackoff));
            this.time.sleep(this.connectionStates.connectionDelay("1001", this.time.milliseconds()) + 1L);
        }
    }

    @Test
    public void testThrottled() {
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost", ClientDnsLookup.DEFAULT);
        this.time.sleep(1000L);
        this.connectionStates.ready("1001");
        this.time.sleep(10000L);
        Assert.assertEquals((long)0L, (long)this.connectionStates.throttleDelayMs("1001", this.time.milliseconds()));
        this.connectionStates.throttle("1001", this.time.milliseconds() + 100L);
        Assert.assertEquals((long)100L, (long)this.connectionStates.throttleDelayMs("1001", this.time.milliseconds()));
        this.time.sleep(50L);
        Assert.assertEquals((long)50L, (long)this.connectionStates.throttleDelayMs("1001", this.time.milliseconds()));
        Assert.assertEquals((long)50L, (long)this.connectionStates.pollDelayMs("1001", this.time.milliseconds()));
        this.time.sleep(50L);
        Assert.assertEquals((long)0L, (long)this.connectionStates.throttleDelayMs("1001", this.time.milliseconds()));
        Assert.assertEquals((long)this.connectionStates.connectionDelay("1001", this.time.milliseconds()), (long)this.connectionStates.pollDelayMs("1001", this.time.milliseconds()));
    }

    @Test
    public void testSingleIPWithDefault() throws UnknownHostException {
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost", ClientDnsLookup.DEFAULT);
        InetAddress currAddress = this.connectionStates.currentAddress("1001");
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost", ClientDnsLookup.DEFAULT);
        Assert.assertSame((Object)currAddress, (Object)this.connectionStates.currentAddress("1001"));
    }

    @Test
    public void testSingleIPWithUseAll() throws UnknownHostException {
        Assert.assertEquals((long)1L, (long)ClientUtils.resolve((String)"localhost", (ClientDnsLookup)ClientDnsLookup.USE_ALL_DNS_IPS, (HostResolver)this.singleIPHostResolver).size());
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost", ClientDnsLookup.USE_ALL_DNS_IPS);
        InetAddress currAddress = this.connectionStates.currentAddress("1001");
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost", ClientDnsLookup.USE_ALL_DNS_IPS);
        Assert.assertSame((Object)currAddress, (Object)this.connectionStates.currentAddress("1001"));
    }

    @Test
    public void testMultipleIPsWithDefault() throws UnknownHostException {
        this.setupMultipleIPs();
        Assert.assertTrue((ClientUtils.resolve((String)"multiple.ip.address", (ClientDnsLookup)ClientDnsLookup.USE_ALL_DNS_IPS, (HostResolver)this.multipleIPHostResolver).size() > 1 ? 1 : 0) != 0);
        this.connectionStates.connecting("1001", this.time.milliseconds(), "multiple.ip.address", ClientDnsLookup.DEFAULT);
        InetAddress currAddress = this.connectionStates.currentAddress("1001");
        this.connectionStates.connecting("1001", this.time.milliseconds(), "multiple.ip.address", ClientDnsLookup.DEFAULT);
        Assert.assertSame((Object)currAddress, (Object)this.connectionStates.currentAddress("1001"));
    }

    @Test
    public void testMultipleIPsWithUseAll() throws UnknownHostException {
        this.setupMultipleIPs();
        Assert.assertTrue((ClientUtils.resolve((String)"multiple.ip.address", (ClientDnsLookup)ClientDnsLookup.USE_ALL_DNS_IPS, (HostResolver)this.multipleIPHostResolver).size() > 1 ? 1 : 0) != 0);
        this.connectionStates.connecting("1001", this.time.milliseconds(), "multiple.ip.address", ClientDnsLookup.USE_ALL_DNS_IPS);
        InetAddress addr1 = this.connectionStates.currentAddress("1001");
        this.connectionStates.connecting("1001", this.time.milliseconds(), "multiple.ip.address", ClientDnsLookup.USE_ALL_DNS_IPS);
        InetAddress addr2 = this.connectionStates.currentAddress("1001");
        Assert.assertNotSame((Object)addr1, (Object)addr2);
        this.connectionStates.connecting("1001", this.time.milliseconds(), "multiple.ip.address", ClientDnsLookup.USE_ALL_DNS_IPS);
        InetAddress addr3 = this.connectionStates.currentAddress("1001");
        Assert.assertNotSame((Object)addr1, (Object)addr3);
    }

    @Test
    public void testHostResolveChange() throws UnknownHostException, ReflectiveOperationException {
        this.setupMultipleIPs();
        Assert.assertTrue((ClientUtils.resolve((String)"multiple.ip.address", (ClientDnsLookup)ClientDnsLookup.USE_ALL_DNS_IPS, (HostResolver)this.multipleIPHostResolver).size() > 1 ? 1 : 0) != 0);
        this.connectionStates.connecting("1001", this.time.milliseconds(), "multiple.ip.address", ClientDnsLookup.DEFAULT);
        InetAddress addr1 = this.connectionStates.currentAddress("1001");
        this.multipleIPHostResolver.changeAddresses();
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost", ClientDnsLookup.DEFAULT);
        InetAddress addr2 = this.connectionStates.currentAddress("1001");
        Assert.assertNotSame((Object)addr1, (Object)addr2);
    }

    @Test
    public void testNodeWithNewHostname() throws UnknownHostException {
        this.setupMultipleIPs();
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost", ClientDnsLookup.DEFAULT);
        InetAddress addr1 = this.connectionStates.currentAddress("1001");
        this.multipleIPHostResolver.changeAddresses();
        this.connectionStates.connecting("1001", this.time.milliseconds(), "multiple.ip.address", ClientDnsLookup.DEFAULT);
        InetAddress addr2 = this.connectionStates.currentAddress("1001");
        Assert.assertNotSame((Object)addr1, (Object)addr2);
    }

    @Test
    public void testIsPreparingConnection() {
        Assert.assertFalse((boolean)this.connectionStates.isPreparingConnection("1001"));
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost", ClientDnsLookup.DEFAULT);
        Assert.assertTrue((boolean)this.connectionStates.isPreparingConnection("1001"));
        this.connectionStates.checkingApiVersions("1001");
        Assert.assertTrue((boolean)this.connectionStates.isPreparingConnection("1001"));
        this.connectionStates.disconnected("1001", this.time.milliseconds());
        Assert.assertFalse((boolean)this.connectionStates.isPreparingConnection("1001"));
    }

    private void setupMultipleIPs() {
        this.connectionStates = new ClusterConnectionStates(10000L, 60000L, new LogContext(), (HostResolver)this.multipleIPHostResolver);
    }

    static {
        try {
            initialAddresses = new ArrayList<InetAddress>(Arrays.asList(InetAddress.getByName("10.200.20.100"), InetAddress.getByName("10.200.20.101"), InetAddress.getByName("10.200.20.102")));
            newAddresses = new ArrayList<InetAddress>(Arrays.asList(InetAddress.getByName("10.200.20.103"), InetAddress.getByName("10.200.20.104"), InetAddress.getByName("10.200.20.105")));
        }
        catch (UnknownHostException e) {
            Assert.fail((String)"Attempted to create an invalid InetAddress, this should not happen");
        }
    }
}

