/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ScatteringByteChannel;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class NetworkReceiveTest {
    @Test
    public void testBytesRead() throws IOException {
        NetworkReceive receive = new NetworkReceive(128, "0");
        Assert.assertEquals((long)0L, (long)receive.bytesRead());
        ScatteringByteChannel channel = (ScatteringByteChannel)Mockito.mock(ScatteringByteChannel.class);
        ArgumentCaptor bufferCaptor = ArgumentCaptor.forClass(ByteBuffer.class);
        Mockito.when((Object)channel.read((ByteBuffer)bufferCaptor.capture())).thenAnswer(invocation -> {
            ((ByteBuffer)bufferCaptor.getValue()).putInt(128);
            return 4;
        }).thenReturn((Object)0);
        Assert.assertEquals((long)4L, (long)receive.readFrom(channel));
        Assert.assertEquals((long)4L, (long)receive.bytesRead());
        Assert.assertFalse((boolean)receive.complete());
        Mockito.reset((Object[])new ScatteringByteChannel[]{channel});
        Mockito.when((Object)channel.read((ByteBuffer)bufferCaptor.capture())).thenAnswer(invocation -> {
            ((ByteBuffer)bufferCaptor.getValue()).put(TestUtils.randomBytes(64));
            return 64;
        });
        Assert.assertEquals((long)64L, (long)receive.readFrom(channel));
        Assert.assertEquals((long)68L, (long)receive.bytesRead());
        Assert.assertFalse((boolean)receive.complete());
        Mockito.reset((Object[])new ScatteringByteChannel[]{channel});
        Mockito.when((Object)channel.read((ByteBuffer)bufferCaptor.capture())).thenAnswer(invocation -> {
            ((ByteBuffer)bufferCaptor.getValue()).put(TestUtils.randomBytes(64));
            return 64;
        });
        Assert.assertEquals((long)64L, (long)receive.readFrom(channel));
        Assert.assertEquals((long)132L, (long)receive.bytesRead());
        Assert.assertTrue((boolean)receive.complete());
    }
}

