/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.junit.Assert;
import org.junit.Test;

public class DeleteGroupsResponseTest {
    private static final String GROUP_ID_1 = "groupId1";
    private static final String GROUP_ID_2 = "groupId2";
    private static final int THROTTLE_TIME_MS = 10;
    private static DeleteGroupsResponse deleteGroupsResponse = new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(new DeleteGroupsResponseData.DeletableGroupResultCollection(Arrays.asList(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("groupId1").setErrorCode(Errors.NONE.code()), new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("groupId2").setErrorCode(Errors.GROUP_AUTHORIZATION_FAILED.code())).iterator())).setThrottleTimeMs(10));

    @Test
    public void testGetErrorWithExistingGroupIds() {
        Assert.assertEquals((Object)Errors.NONE, (Object)deleteGroupsResponse.get(GROUP_ID_1));
        Assert.assertEquals((Object)Errors.GROUP_AUTHORIZATION_FAILED, (Object)deleteGroupsResponse.get(GROUP_ID_2));
        HashMap<String, Errors> expectedErrors = new HashMap<String, Errors>();
        expectedErrors.put(GROUP_ID_1, Errors.NONE);
        expectedErrors.put(GROUP_ID_2, Errors.GROUP_AUTHORIZATION_FAILED);
        Assert.assertEquals(expectedErrors, (Object)deleteGroupsResponse.errors());
        HashMap<Errors, Integer> expectedErrorCounts = new HashMap<Errors, Integer>();
        expectedErrorCounts.put(Errors.NONE, 1);
        expectedErrorCounts.put(Errors.GROUP_AUTHORIZATION_FAILED, 1);
        Assert.assertEquals(expectedErrorCounts, (Object)deleteGroupsResponse.errorCounts());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetErrorWithInvalidGroupId() {
        deleteGroupsResponse.get("invalid-group-id");
    }

    @Test
    public void testGetThrottleTimeMs() {
        Assert.assertEquals((long)10L, (long)deleteGroupsResponse.throttleTimeMs());
    }
}

