/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.util.HashMap;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerExtensionsValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenMock;
import org.junit.Assert;
import org.junit.Test;

public class OAuthBearerExtensionsValidatorCallbackTest {
    private static final OAuthBearerToken TOKEN = new OAuthBearerTokenMock();

    @Test
    public void testValidatedExtensionsAreReturned() {
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("hello", "bye");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback(TOKEN, new SaslExtensions(extensions));
        Assert.assertTrue((boolean)callback.validatedExtensions().isEmpty());
        Assert.assertTrue((boolean)callback.invalidExtensions().isEmpty());
        callback.valid("hello");
        Assert.assertFalse((boolean)callback.validatedExtensions().isEmpty());
        Assert.assertEquals((Object)"bye", callback.validatedExtensions().get("hello"));
        Assert.assertTrue((boolean)callback.invalidExtensions().isEmpty());
    }

    @Test
    public void testInvalidExtensionsAndErrorMessagesAreReturned() {
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("hello", "bye");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback(TOKEN, new SaslExtensions(extensions));
        Assert.assertTrue((boolean)callback.validatedExtensions().isEmpty());
        Assert.assertTrue((boolean)callback.invalidExtensions().isEmpty());
        callback.error("hello", "error");
        Assert.assertFalse((boolean)callback.invalidExtensions().isEmpty());
        Assert.assertEquals((Object)"error", callback.invalidExtensions().get("hello"));
        Assert.assertTrue((boolean)callback.validatedExtensions().isEmpty());
    }

    @Test
    public void testUnvalidatedExtensionsAreIgnored() {
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("valid", "valid");
        extensions.put("error", "error");
        extensions.put("nothing", "nothing");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback(TOKEN, new SaslExtensions(extensions));
        callback.error("error", "error");
        callback.valid("valid");
        Assert.assertFalse((boolean)callback.validatedExtensions().containsKey("nothing"));
        Assert.assertFalse((boolean)callback.invalidExtensions().containsKey("nothing"));
        Assert.assertEquals((Object)"nothing", callback.ignoredExtensions().get("nothing"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCannotValidateExtensionWhichWasNotGiven() {
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("hello", "bye");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback(TOKEN, new SaslExtensions(extensions));
        callback.valid("???");
    }
}

