/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.FlattenedIterator;
import org.junit.Assert;
import org.junit.Test;

public class FlattenedIteratorTest {
    @Test
    public void testNestedLists() {
        List<List> list = Arrays.asList(Arrays.asList("foo", "a", "bc"), Arrays.asList("ddddd"), Arrays.asList("", "bar2", "baz45"));
        Iterable<String> flattenedIterable = () -> new FlattenedIterator(list.iterator(), l -> l.iterator());
        ArrayList flattened = new ArrayList();
        flattenedIterable.forEach(flattened::add);
        Assert.assertEquals(list.stream().flatMap(l -> l.stream()).collect(Collectors.toList()), flattened);
        ArrayList flattened2 = new ArrayList();
        flattenedIterable.forEach(flattened2::add);
        Assert.assertEquals(flattened, flattened2);
    }

    @Test
    public void testEmptyList() {
        List list = Collections.emptyList();
        Iterable<String> flattenedIterable = () -> new FlattenedIterator(list.iterator(), l -> l.iterator());
        ArrayList flattened = new ArrayList();
        flattenedIterable.forEach(flattened::add);
        Assert.assertEquals(Collections.emptyList(), flattened);
    }

    @Test
    public void testNestedSingleEmptyList() {
        List<List> list = Arrays.asList(Collections.emptyList());
        Iterable<String> flattenedIterable = () -> new FlattenedIterator(list.iterator(), l -> l.iterator());
        ArrayList flattened = new ArrayList();
        flattenedIterable.forEach(flattened::add);
        Assert.assertEquals(Collections.emptyList(), flattened);
    }

    @Test
    public void testEmptyListFollowedByNonEmpty() {
        List<List> list = Arrays.asList(Collections.emptyList(), Arrays.asList("boo", "b", "de"));
        Iterable<String> flattenedIterable = () -> new FlattenedIterator(list.iterator(), l -> l.iterator());
        ArrayList flattened = new ArrayList();
        flattenedIterable.forEach(flattened::add);
        Assert.assertEquals(list.stream().flatMap(l -> l.stream()).collect(Collectors.toList()), flattened);
    }

    @Test
    public void testEmptyListInBetweenNonEmpty() {
        List<List> list = Arrays.asList(Arrays.asList("aadwdwdw"), Collections.emptyList(), Arrays.asList("ee", "aa", "dd"));
        Iterable<String> flattenedIterable = () -> new FlattenedIterator(list.iterator(), l -> l.iterator());
        ArrayList flattened = new ArrayList();
        flattenedIterable.forEach(flattened::add);
        Assert.assertEquals(list.stream().flatMap(l -> l.stream()).collect(Collectors.toList()), flattened);
    }

    @Test
    public void testEmptyListAtTheEnd() {
        List<List> list = Arrays.asList(Arrays.asList("ee", "dd"), Arrays.asList("e"), Collections.emptyList());
        Iterable<String> flattenedIterable = () -> new FlattenedIterator(list.iterator(), l -> l.iterator());
        ArrayList flattened = new ArrayList();
        flattenedIterable.forEach(flattened::add);
        Assert.assertEquals(list.stream().flatMap(l -> l.stream()).collect(Collectors.toList()), flattened);
    }
}

