/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Base64;
import org.apache.kafka.common.Uuid;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UuidTest {
    @Test
    public void testSignificantBits() {
        Uuid id = new Uuid(34L, 98L);
        Assertions.assertEquals((long)id.getMostSignificantBits(), (long)34L);
        Assertions.assertEquals((long)id.getLeastSignificantBits(), (long)98L);
    }

    @Test
    public void testUuidEquality() {
        Uuid id1 = new Uuid(12L, 13L);
        Uuid id2 = new Uuid(12L, 13L);
        Uuid id3 = new Uuid(24L, 38L);
        Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)Uuid.ZERO_UUID);
        Assertions.assertEquals((Object)id1, (Object)id2);
        Assertions.assertNotEquals((Object)id1, (Object)id3);
        Assertions.assertEquals((int)Uuid.ZERO_UUID.hashCode(), (int)Uuid.ZERO_UUID.hashCode());
        Assertions.assertEquals((int)id1.hashCode(), (int)id2.hashCode());
        Assertions.assertNotEquals((int)id1.hashCode(), (int)id3.hashCode());
    }

    @Test
    public void testHashCode() {
        Uuid id1 = new Uuid(16L, 7L);
        Uuid id2 = new Uuid(1043L, 20075L);
        Uuid id3 = new Uuid(104312423523523L, 200732425676585L);
        Assertions.assertEquals((int)23, (int)id1.hashCode());
        Assertions.assertEquals((int)19064, (int)id2.hashCode());
        Assertions.assertEquals((int)-2011255899, (int)id3.hashCode());
    }

    @Test
    public void testStringConversion() {
        Uuid id = Uuid.randomUuid();
        String idString = id.toString();
        Assertions.assertEquals((Object)Uuid.fromString((String)idString), (Object)id);
        String zeroIdString = Uuid.ZERO_UUID.toString();
        Assertions.assertEquals((Object)Uuid.fromString((String)zeroIdString), (Object)Uuid.ZERO_UUID);
    }

    @Test
    public void testRandomUuid() {
        Uuid randomID = Uuid.randomUuid();
        Uuid reservedSentinel = new Uuid(0L, 1L);
        Assertions.assertNotEquals((Object)randomID, (Object)Uuid.ZERO_UUID);
        Assertions.assertNotEquals((Object)randomID, (Object)reservedSentinel);
    }

    @Test
    public void testCompareUuids() {
        Uuid id00 = new Uuid(0L, 0L);
        Uuid id01 = new Uuid(0L, 1L);
        Uuid id10 = new Uuid(1L, 0L);
        Assertions.assertEquals((int)0, (int)id00.compareTo(id00));
        Assertions.assertEquals((int)0, (int)id01.compareTo(id01));
        Assertions.assertEquals((int)0, (int)id10.compareTo(id10));
        Assertions.assertEquals((int)-1, (int)id00.compareTo(id01));
        Assertions.assertEquals((int)-1, (int)id00.compareTo(id10));
        Assertions.assertEquals((int)1, (int)id01.compareTo(id00));
        Assertions.assertEquals((int)1, (int)id10.compareTo(id00));
        Assertions.assertEquals((int)-1, (int)id01.compareTo(id10));
        Assertions.assertEquals((int)1, (int)id10.compareTo(id01));
    }

    @Test
    public void testFromStringWithInvalidInput() {
        String oversizeString = Base64.getUrlEncoder().withoutPadding().encodeToString(new byte[32]);
        Assertions.assertThrows(IllegalArgumentException.class, () -> Uuid.fromString((String)oversizeString));
        String undersizeString = Base64.getUrlEncoder().withoutPadding().encodeToString(new byte[4]);
        Assertions.assertThrows(IllegalArgumentException.class, () -> Uuid.fromString((String)undersizeString));
    }
}

