/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.producer.internals.StickyPartitionCache;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StickyPartitionCacheTest {
    private static final Node[] NODES = new Node[]{new Node(0, "localhost", 99), new Node(1, "localhost", 100), new Node(2, "localhost", 101), new Node(11, "localhost", 102)};
    static final String TOPIC_A = "topicA";
    static final String TOPIC_B = "topicB";
    static final String TOPIC_C = "topicC";

    @Test
    public void testStickyPartitionCache() {
        List<PartitionInfo> allPartitions = Arrays.asList(new PartitionInfo(TOPIC_A, 0, NODES[0], NODES, NODES), new PartitionInfo(TOPIC_A, 1, NODES[1], NODES, NODES), new PartitionInfo(TOPIC_A, 2, NODES[2], NODES, NODES), new PartitionInfo(TOPIC_B, 0, NODES[0], NODES, NODES));
        Cluster testCluster = new Cluster("clusterId", Arrays.asList(NODES), allPartitions, Collections.emptySet(), Collections.emptySet());
        StickyPartitionCache stickyPartitionCache = new StickyPartitionCache();
        int partA = stickyPartitionCache.partition(TOPIC_A, testCluster);
        Assertions.assertEquals((int)partA, (int)stickyPartitionCache.partition(TOPIC_A, testCluster));
        int partB = stickyPartitionCache.partition(TOPIC_B, testCluster);
        Assertions.assertEquals((int)partB, (int)stickyPartitionCache.partition(TOPIC_B, testCluster));
        int changedPartA = stickyPartitionCache.nextPartition(TOPIC_A, testCluster, partA);
        Assertions.assertEquals((int)changedPartA, (int)stickyPartitionCache.partition(TOPIC_A, testCluster));
        Assertions.assertNotEquals((int)partA, (int)changedPartA);
        int changedPartA2 = stickyPartitionCache.partition(TOPIC_A, testCluster);
        Assertions.assertEquals((int)changedPartA2, (int)changedPartA);
        int changedPartA3 = stickyPartitionCache.nextPartition(TOPIC_A, testCluster, partA);
        Assertions.assertEquals((int)changedPartA3, (int)changedPartA2);
        int changedPartB = stickyPartitionCache.nextPartition(TOPIC_B, testCluster, partB);
        Assertions.assertEquals((int)changedPartB, (int)stickyPartitionCache.partition(TOPIC_B, testCluster));
    }

    @Test
    public void unavailablePartitionsTest() {
        List<PartitionInfo> allPartitions = Arrays.asList(new PartitionInfo(TOPIC_A, 0, NODES[0], NODES, NODES), new PartitionInfo(TOPIC_A, 1, null, NODES, NODES), new PartitionInfo(TOPIC_A, 2, NODES[2], NODES, NODES), new PartitionInfo(TOPIC_B, 0, null, NODES, NODES), new PartitionInfo(TOPIC_B, 1, NODES[0], NODES, NODES), new PartitionInfo(TOPIC_C, 0, null, NODES, NODES));
        Cluster testCluster = new Cluster("clusterId", Arrays.asList(NODES[0], NODES[1], NODES[2]), allPartitions, Collections.emptySet(), Collections.emptySet());
        StickyPartitionCache stickyPartitionCache = new StickyPartitionCache();
        int partA = stickyPartitionCache.partition(TOPIC_A, testCluster);
        Assertions.assertNotEquals((int)1, (int)partA);
        for (int aPartitions = 0; aPartitions < 100; ++aPartitions) {
            partA = stickyPartitionCache.nextPartition(TOPIC_A, testCluster, partA);
            Assertions.assertNotEquals((int)1, (int)stickyPartitionCache.partition(TOPIC_A, testCluster));
        }
        int partB = stickyPartitionCache.partition(TOPIC_B, testCluster);
        Assertions.assertEquals((int)1, (int)partB);
        for (int bPartitions = 0; bPartitions < 100; ++bPartitions) {
            partB = stickyPartitionCache.nextPartition(TOPIC_B, testCluster, partB);
            Assertions.assertEquals((int)1, (int)stickyPartitionCache.partition(TOPIC_B, testCluster));
        }
        int partC = stickyPartitionCache.partition(TOPIC_C, testCluster);
        Assertions.assertEquals((int)0, (int)partC);
        partC = stickyPartitionCache.nextPartition(TOPIC_C, testCluster, partC);
        Assertions.assertEquals((int)0, (int)partC);
    }
}

