/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OAuthBearerTokenCallbackTest {
    private static final OAuthBearerToken TOKEN = new OAuthBearerToken(){

        public String value() {
            return "value";
        }

        public Long startTimeMs() {
            return null;
        }

        public Set<String> scope() {
            return Collections.emptySet();
        }

        public String principalName() {
            return "principalName";
        }

        public long lifetimeMs() {
            return 0L;
        }
    };

    @Test
    public void testError() {
        String errorCode = "errorCode";
        String errorDescription = "errorDescription";
        String errorUri = "errorUri";
        OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
        callback.error(errorCode, errorDescription, errorUri);
        Assertions.assertEquals((Object)errorCode, (Object)callback.errorCode());
        Assertions.assertEquals((Object)errorDescription, (Object)callback.errorDescription());
        Assertions.assertEquals((Object)errorUri, (Object)callback.errorUri());
        Assertions.assertNull((Object)callback.token());
    }

    @Test
    public void testToken() {
        OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
        callback.token(TOKEN);
        Assertions.assertSame((Object)TOKEN, (Object)callback.token());
        Assertions.assertNull((Object)callback.errorCode());
        Assertions.assertNull((Object)callback.errorDescription());
        Assertions.assertNull((Object)callback.errorUri());
    }
}

