/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.CoordinatorStrategy;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.OffsetDeleteRequest;
import org.apache.kafka.common.requests.OffsetDeleteResponse;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class DeleteConsumerGroupOffsetsHandler
implements AdminApiHandler<CoordinatorKey, Map<TopicPartition, Errors>> {
    private final CoordinatorKey groupId;
    private final Set<TopicPartition> partitions;
    private final Logger log;
    private final AdminApiLookupStrategy<CoordinatorKey> lookupStrategy;

    public DeleteConsumerGroupOffsetsHandler(String groupId, Set<TopicPartition> partitions, LogContext logContext) {
        this.groupId = CoordinatorKey.byGroupId(groupId);
        this.partitions = partitions;
        this.log = logContext.logger(DeleteConsumerGroupOffsetsHandler.class);
        this.lookupStrategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, logContext);
    }

    @Override
    public String apiName() {
        return "offsetDelete";
    }

    @Override
    public AdminApiLookupStrategy<CoordinatorKey> lookupStrategy() {
        return this.lookupStrategy;
    }

    public static AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, Map<TopicPartition, Errors>> newFuture(String groupId) {
        return AdminApiFuture.forKeys(Collections.singleton(CoordinatorKey.byGroupId(groupId)));
    }

    private void validateKeys(Set<CoordinatorKey> groupIds) {
        if (!groupIds.equals(Collections.singleton(this.groupId))) {
            throw new IllegalArgumentException("Received unexpected group ids " + groupIds + " (expected only " + Collections.singleton(this.groupId) + ")");
        }
    }

    public OffsetDeleteRequest.Builder buildRequest(int coordinatorId, Set<CoordinatorKey> groupIds) {
        this.validateKeys(groupIds);
        OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection topics = new OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection();
        this.partitions.stream().collect(Collectors.groupingBy(TopicPartition::topic)).forEach((topic, topicPartitions) -> topics.add(new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName((String)topic).setPartitions(topicPartitions.stream().map(tp -> new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(tp.partition())).collect(Collectors.toList()))));
        return new OffsetDeleteRequest.Builder(new OffsetDeleteRequestData().setGroupId(this.groupId.idValue).setTopics(topics));
    }

    @Override
    public AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, Errors>> handleResponse(Node coordinator, Set<CoordinatorKey> groupIds, AbstractResponse abstractResponse) {
        this.validateKeys(groupIds);
        OffsetDeleteResponse response = (OffsetDeleteResponse)abstractResponse;
        Errors error = Errors.forCode(response.data().errorCode());
        if (error != Errors.NONE) {
            HashMap<CoordinatorKey, Throwable> failed = new HashMap<CoordinatorKey, Throwable>();
            HashSet<CoordinatorKey> groupsToUnmap = new HashSet<CoordinatorKey>();
            this.handleGroupError(this.groupId, error, failed, groupsToUnmap);
            return new AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, Errors>>(Collections.emptyMap(), failed, new ArrayList<CoordinatorKey>(groupsToUnmap));
        }
        HashMap partitionResults = new HashMap();
        response.data().topics().forEach(topic -> topic.partitions().forEach(partition -> partitionResults.put(new TopicPartition(topic.name(), partition.partitionIndex()), Errors.forCode(partition.errorCode()))));
        return AdminApiHandler.ApiResult.completed(this.groupId, partitionResults);
    }

    private void handleGroupError(CoordinatorKey groupId, Errors error, Map<CoordinatorKey, Throwable> failed, Set<CoordinatorKey> groupsToUnmap) {
        switch (error) {
            case GROUP_AUTHORIZATION_FAILED: 
            case GROUP_ID_NOT_FOUND: 
            case INVALID_GROUP_ID: 
            case NON_EMPTY_GROUP: {
                this.log.debug("`OffsetDelete` request for group id {} failed due to error {}.", (Object)groupId.idValue, (Object)error);
                failed.put(groupId, error.exception());
                break;
            }
            case COORDINATOR_LOAD_IN_PROGRESS: {
                this.log.debug("`OffsetDelete` request for group id {} failed because the coordinator is still in the process of loading state. Will retry.", (Object)groupId.idValue);
                break;
            }
            case COORDINATOR_NOT_AVAILABLE: 
            case NOT_COORDINATOR: {
                this.log.debug("`OffsetDelete` request for group id {} returned error {}. Will attempt to find the coordinator again and retry.", (Object)groupId.idValue, (Object)error);
                groupsToUnmap.add(groupId);
                break;
            }
            default: {
                this.log.error("`OffsetDelete` request for group id {} failed due to unexpected error {}.", (Object)groupId.idValue, (Object)error);
                failed.put(groupId, error.exception());
            }
        }
    }
}

