/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.secured;

import java.security.Key;
import java.util.Collections;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.secured.AccessTokenBuilder;
import org.apache.kafka.common.security.oauthbearer.secured.AccessTokenValidator;
import org.apache.kafka.common.security.oauthbearer.secured.AccessTokenValidatorTest;
import org.apache.kafka.common.security.oauthbearer.secured.ValidatorAccessTokenValidator;
import org.jose4j.jws.JsonWebSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ValidatorAccessTokenValidatorTest
extends AccessTokenValidatorTest {
    @Override
    protected AccessTokenValidator createAccessTokenValidator(AccessTokenBuilder builder) {
        return new ValidatorAccessTokenValidator(Integer.valueOf(30), Collections.emptySet(), null, (jws, nestingContext) -> builder.jwk().getKey(), builder.scopeClaimName(), builder.subjectClaimName());
    }

    @Test
    public void testBasicEncryption() throws Exception {
        AccessTokenBuilder builder = new AccessTokenBuilder();
        AccessTokenValidator validator = this.createAccessTokenValidator(builder);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setKey((Key)builder.jwk().getPrivateKey());
        jws.setKeyIdHeaderValue(builder.jwk().getKeyId());
        jws.setAlgorithmHeaderValue("RS256");
        String accessToken = builder.build();
        OAuthBearerToken token = validator.validate(accessToken);
        Assertions.assertEquals((Object)builder.subject(), (Object)token.principalName());
        Assertions.assertEquals((long)(builder.issuedAtSeconds() * 1000L), (Long)token.startTimeMs());
        Assertions.assertEquals((long)(builder.expirationSeconds() * 1000L), (long)token.lifetimeMs());
        Assertions.assertEquals((int)1, (int)token.scope().size());
    }
}

