/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.acl;

import org.apache.kafka.common.acl.AclOperation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AclOperationTest {
    private static final AclOperationTestInfo[] INFOS = new AclOperationTestInfo[]{new AclOperationTestInfo(AclOperation.UNKNOWN, 0, "unknown", true), new AclOperationTestInfo(AclOperation.ANY, 1, "any", false), new AclOperationTestInfo(AclOperation.ALL, 2, "all", false), new AclOperationTestInfo(AclOperation.READ, 3, "read", false), new AclOperationTestInfo(AclOperation.WRITE, 4, "write", false), new AclOperationTestInfo(AclOperation.CREATE, 5, "create", false), new AclOperationTestInfo(AclOperation.DELETE, 6, "delete", false), new AclOperationTestInfo(AclOperation.ALTER, 7, "alter", false), new AclOperationTestInfo(AclOperation.DESCRIBE, 8, "describe", false), new AclOperationTestInfo(AclOperation.CLUSTER_ACTION, 9, "cluster_action", false), new AclOperationTestInfo(AclOperation.DESCRIBE_CONFIGS, 10, "describe_configs", false), new AclOperationTestInfo(AclOperation.ALTER_CONFIGS, 11, "alter_configs", false), new AclOperationTestInfo(AclOperation.IDEMPOTENT_WRITE, 12, "idempotent_write", false)};

    @Test
    public void testIsUnknown() throws Exception {
        for (AclOperationTestInfo info : INFOS) {
            Assertions.assertEquals((Object)info.unknown, (Object)info.operation.isUnknown(), (String)(info.operation + " was supposed to have unknown == " + info.unknown));
        }
    }

    @Test
    public void testCode() throws Exception {
        Assertions.assertEquals((int)AclOperation.values().length, (int)INFOS.length);
        for (AclOperationTestInfo info : INFOS) {
            Assertions.assertEquals((int)info.code, (int)info.operation.code(), (String)(info.operation + " was supposed to have code == " + info.code));
            Assertions.assertEquals((Object)info.operation, (Object)AclOperation.fromCode((byte)((byte)info.code)), (String)("AclOperation.fromCode(" + info.code + ") was supposed to be " + info.operation));
        }
        Assertions.assertEquals((Object)AclOperation.UNKNOWN, (Object)AclOperation.fromCode((byte)120));
    }

    @Test
    public void testName() throws Exception {
        for (AclOperationTestInfo info : INFOS) {
            Assertions.assertEquals((Object)info.operation, (Object)AclOperation.fromString((String)info.name), (String)("AclOperation.fromString(" + info.name + ") was supposed to be " + info.operation));
        }
        Assertions.assertEquals((Object)AclOperation.UNKNOWN, (Object)AclOperation.fromString((String)"something"));
    }

    @Test
    public void testExhaustive() {
        Assertions.assertEquals((int)INFOS.length, (int)AclOperation.values().length);
        for (int i = 0; i < INFOS.length; ++i) {
            Assertions.assertEquals((Object)INFOS[i].operation, (Object)AclOperation.values()[i]);
        }
    }

    private static class AclOperationTestInfo {
        private final AclOperation operation;
        private final int code;
        private final String name;
        private final boolean unknown;

        AclOperationTestInfo(AclOperation operation, int code, String name, boolean unknown) {
            this.operation = operation;
            this.code = code;
            this.name = name;
            this.unknown = unknown;
        }
    }
}

