/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CommonClientConfigsTest {
    @Test
    public void testExponentialBackoffDefaults() {
        TestConfig defaultConf = new TestConfig(Collections.emptyMap());
        Assertions.assertEquals((Long)50L, (Long)defaultConf.getLong("reconnect.backoff.ms"));
        Assertions.assertEquals((Long)1000L, (Long)defaultConf.getLong("reconnect.backoff.max.ms"));
        TestConfig bothSetConfig = new TestConfig(new HashMap<String, Object>(){
            {
                this.put("reconnect.backoff.ms", "123");
                this.put("reconnect.backoff.max.ms", "12345");
            }
        });
        Assertions.assertEquals((Long)123L, (Long)bothSetConfig.getLong("reconnect.backoff.ms"));
        Assertions.assertEquals((Long)12345L, (Long)bothSetConfig.getLong("reconnect.backoff.max.ms"));
        TestConfig reconnectBackoffSetConf = new TestConfig(new HashMap<String, Object>(){
            {
                this.put("reconnect.backoff.ms", "123");
            }
        });
        Assertions.assertEquals((Long)123L, (Long)reconnectBackoffSetConf.getLong("reconnect.backoff.ms"));
        Assertions.assertEquals((Long)123L, (Long)reconnectBackoffSetConf.getLong("reconnect.backoff.max.ms"));
    }

    @Test
    public void testInvalidSaslMechanism() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("security.protocol", SecurityProtocol.SASL_PLAINTEXT.name);
        configs.put("sasl.mechanism", null);
        ConfigException ce = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new TestConfig(configs));
        Assertions.assertTrue((boolean)ce.getMessage().contains("sasl.mechanism"));
        configs.put("sasl.mechanism", "");
        ce = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new TestConfig(configs));
        Assertions.assertTrue((boolean)ce.getMessage().contains("sasl.mechanism"));
    }

    private static class TestConfig
    extends AbstractConfig {
        private static final ConfigDef CONFIG = new ConfigDef().define("reconnect.backoff.ms", ConfigDef.Type.LONG, (Object)50L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "").define("reconnect.backoff.max.ms", ConfigDef.Type.LONG, (Object)1000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "").define("security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", (ConfigDef.Validator)ConfigDef.ValidString.in((String[])Utils.enumOptions(SecurityProtocol.class)), ConfigDef.Importance.MEDIUM, CommonClientConfigs.SECURITY_PROTOCOL_DOC).define("sasl.mechanism", ConfigDef.Type.STRING, (Object)"GSSAPI", ConfigDef.Importance.MEDIUM, "SASL mechanism used for client connections. This may be any mechanism for which a security provider is available. GSSAPI is the default mechanism.");

        protected Map<String, Object> postProcessParsedConfig(Map<String, Object> parsedValues) {
            CommonClientConfigs.postValidateSaslMechanismConfig((AbstractConfig)this);
            return CommonClientConfigs.postProcessReconnectBackoffConfigs((AbstractConfig)this, parsedValues);
        }

        public TestConfig(Map<?, ?> props) {
            super(CONFIG, props);
        }
    }
}

