/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.DescribeProducersOptions;
import org.apache.kafka.clients.admin.DescribeProducersResult;
import org.apache.kafka.clients.admin.ProducerState;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.ApiRequestScope;
import org.apache.kafka.clients.admin.internals.DescribeProducersHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.message.DescribeProducersRequestData;
import org.apache.kafka.common.message.DescribeProducersResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DescribeProducersRequest;
import org.apache.kafka.common.requests.DescribeProducersResponse;
import org.apache.kafka.common.utils.CollectionUtils;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DescribeProducersHandlerTest {
    private DescribeProducersHandler newHandler(DescribeProducersOptions options) {
        return new DescribeProducersHandler(options, new LogContext());
    }

    @Test
    public void testBrokerIdSetInOptions() {
        int brokerId = 3;
        Set topicPartitions = Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("foo", 5), new TopicPartition("bar", 3), new TopicPartition("foo", 4)});
        DescribeProducersHandler handler = this.newHandler(new DescribeProducersOptions().brokerId(brokerId));
        topicPartitions.forEach(topicPartition -> {
            ApiRequestScope scope = handler.lookupStrategy().lookupScope(topicPartition);
            Assertions.assertEquals((Object)OptionalInt.of(brokerId), (Object)scope.destinationBrokerId(), (String)("Unexpected brokerId for " + topicPartition));
        });
    }

    @Test
    public void testBrokerIdNotSetInOptions() {
        Set topicPartitions = Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("foo", 5), new TopicPartition("bar", 3), new TopicPartition("foo", 4)});
        DescribeProducersHandler handler = this.newHandler(new DescribeProducersOptions());
        topicPartitions.forEach(topicPartition -> {
            ApiRequestScope scope = handler.lookupStrategy().lookupScope(topicPartition);
            Assertions.assertEquals((Object)OptionalInt.empty(), (Object)scope.destinationBrokerId(), (String)("Unexpected brokerId for " + topicPartition));
        });
    }

    @Test
    public void testBuildRequest() {
        Set topicPartitions = Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("foo", 5), new TopicPartition("bar", 3), new TopicPartition("foo", 4)});
        DescribeProducersHandler handler = this.newHandler(new DescribeProducersOptions());
        int brokerId = 3;
        DescribeProducersRequest.Builder request = handler.buildBatchedRequest(brokerId, topicPartitions);
        List topics = request.data.topics();
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"foo", "bar"}), topics.stream().map(DescribeProducersRequestData.TopicRequest::name).collect(Collectors.toSet()));
        topics.forEach(topic -> {
            Set expectedTopicPartitions = "foo".equals(topic.name()) ? Utils.mkSet((Object[])new Integer[]{4, 5}) : Utils.mkSet((Object[])new Integer[]{3});
            Assertions.assertEquals((Object)expectedTopicPartitions, new HashSet(topic.partitionIndexes()));
        });
    }

    @Test
    public void testAuthorizationFailure() {
        TopicPartition topicPartition = new TopicPartition("foo", 5);
        Throwable exception = this.assertFatalError(topicPartition, Errors.TOPIC_AUTHORIZATION_FAILED);
        Assertions.assertTrue((boolean)(exception instanceof TopicAuthorizationException));
        TopicAuthorizationException authException = (TopicAuthorizationException)exception;
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"foo"}), (Object)authException.unauthorizedTopics());
    }

    @Test
    public void testInvalidTopic() {
        TopicPartition topicPartition = new TopicPartition("foo", 5);
        Throwable exception = this.assertFatalError(topicPartition, Errors.INVALID_TOPIC_EXCEPTION);
        Assertions.assertTrue((boolean)(exception instanceof InvalidTopicException));
        InvalidTopicException invalidTopicException = (InvalidTopicException)exception;
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"foo"}), (Object)invalidTopicException.invalidTopics());
    }

    @Test
    public void testUnexpectedError() {
        TopicPartition topicPartition = new TopicPartition("foo", 5);
        Throwable exception = this.assertFatalError(topicPartition, Errors.UNKNOWN_SERVER_ERROR);
        Assertions.assertTrue((boolean)(exception instanceof UnknownServerException));
    }

    @Test
    public void testRetriableErrors() {
        TopicPartition topicPartition = new TopicPartition("foo", 5);
        this.assertRetriableError(topicPartition, Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testUnmappedAfterNotLeaderError() {
        TopicPartition topicPartition = new TopicPartition("foo", 5);
        AdminApiHandler.ApiResult<TopicPartition, DescribeProducersResult.PartitionProducerState> result = this.handleResponseWithError(new DescribeProducersOptions(), topicPartition, Errors.NOT_LEADER_OR_FOLLOWER);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.completedKeys);
        Assertions.assertEquals(Collections.singletonList(topicPartition), (Object)result.unmappedKeys);
    }

    @Test
    public void testFatalNotLeaderErrorIfStaticMapped() {
        TopicPartition topicPartition = new TopicPartition("foo", 5);
        DescribeProducersOptions options = new DescribeProducersOptions().brokerId(1);
        AdminApiHandler.ApiResult<TopicPartition, DescribeProducersResult.PartitionProducerState> result = this.handleResponseWithError(options, topicPartition, Errors.NOT_LEADER_OR_FOLLOWER);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.completedKeys);
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{topicPartition}), result.failedKeys.keySet());
        Throwable exception = (Throwable)result.failedKeys.get(topicPartition);
        Assertions.assertTrue((boolean)(exception instanceof NotLeaderOrFollowerException));
    }

    @Test
    public void testCompletedResult() {
        TopicPartition topicPartition = new TopicPartition("foo", 5);
        DescribeProducersOptions options = new DescribeProducersOptions().brokerId(1);
        DescribeProducersHandler handler = this.newHandler(options);
        DescribeProducersResponseData.PartitionResponse partitionResponse = this.sampleProducerState(topicPartition);
        DescribeProducersResponse response = this.describeProducersResponse(Collections.singletonMap(topicPartition, partitionResponse));
        Node node = new Node(3, "host", 1);
        AdminApiHandler.ApiResult result = handler.handleResponse(node, Utils.mkSet((Object[])new TopicPartition[]{topicPartition}), (AbstractResponse)response);
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{topicPartition}), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        DescribeProducersResult.PartitionProducerState producerState = (DescribeProducersResult.PartitionProducerState)result.completedKeys.get(topicPartition);
        this.assertMatchingProducers(partitionResponse, producerState);
    }

    private void assertRetriableError(TopicPartition topicPartition, Errors error) {
        AdminApiHandler.ApiResult<TopicPartition, DescribeProducersResult.PartitionProducerState> result = this.handleResponseWithError(new DescribeProducersOptions(), topicPartition, error);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.completedKeys);
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
    }

    private Throwable assertFatalError(TopicPartition topicPartition, Errors error) {
        AdminApiHandler.ApiResult<TopicPartition, DescribeProducersResult.PartitionProducerState> result = this.handleResponseWithError(new DescribeProducersOptions(), topicPartition, error);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.completedKeys);
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{topicPartition}), result.failedKeys.keySet());
        return (Throwable)result.failedKeys.get(topicPartition);
    }

    private AdminApiHandler.ApiResult<TopicPartition, DescribeProducersResult.PartitionProducerState> handleResponseWithError(DescribeProducersOptions options, TopicPartition topicPartition, Errors error) {
        DescribeProducersHandler handler = this.newHandler(options);
        DescribeProducersResponse response = this.buildResponseWithError(topicPartition, error);
        Node node = new Node(options.brokerId().orElse(3), "host", 1);
        return handler.handleResponse(node, Utils.mkSet((Object[])new TopicPartition[]{topicPartition}), (AbstractResponse)response);
    }

    private DescribeProducersResponse buildResponseWithError(TopicPartition topicPartition, Errors error) {
        DescribeProducersResponseData.PartitionResponse partitionResponse = new DescribeProducersResponseData.PartitionResponse().setPartitionIndex(topicPartition.partition()).setErrorCode(error.code());
        return this.describeProducersResponse(Collections.singletonMap(topicPartition, partitionResponse));
    }

    private DescribeProducersResponseData.PartitionResponse sampleProducerState(TopicPartition topicPartition) {
        DescribeProducersResponseData.PartitionResponse partitionResponse = new DescribeProducersResponseData.PartitionResponse().setPartitionIndex(topicPartition.partition()).setErrorCode(Errors.NONE.code());
        partitionResponse.setActiveProducers(Arrays.asList(new DescribeProducersResponseData.ProducerState().setProducerId(12345L).setProducerEpoch(15).setLastSequence(75).setLastTimestamp(System.currentTimeMillis()).setCurrentTxnStartOffset(-1L), new DescribeProducersResponseData.ProducerState().setProducerId(98765L).setProducerEpoch(30).setLastSequence(150).setLastTimestamp(System.currentTimeMillis() - 5000L).setCurrentTxnStartOffset(5000L)));
        return partitionResponse;
    }

    private void assertMatchingProducers(DescribeProducersResponseData.PartitionResponse expected, DescribeProducersResult.PartitionProducerState actual) {
        List expectedProducers = expected.activeProducers();
        List actualProducers = actual.activeProducers();
        Assertions.assertEquals((int)expectedProducers.size(), (int)actualProducers.size());
        Map expectedByProducerId = expectedProducers.stream().collect(Collectors.toMap(DescribeProducersResponseData.ProducerState::producerId, Function.identity()));
        for (ProducerState actualProducerState : actualProducers) {
            DescribeProducersResponseData.ProducerState expectedProducerState = (DescribeProducersResponseData.ProducerState)expectedByProducerId.get(actualProducerState.producerId());
            Assertions.assertNotNull((Object)expectedProducerState);
            Assertions.assertEquals((int)expectedProducerState.producerEpoch(), (int)actualProducerState.producerEpoch());
            Assertions.assertEquals((int)expectedProducerState.lastSequence(), (int)actualProducerState.lastSequence());
            Assertions.assertEquals((long)expectedProducerState.lastTimestamp(), (long)actualProducerState.lastTimestamp());
            Assertions.assertEquals((long)expectedProducerState.currentTxnStartOffset(), (long)actualProducerState.currentTransactionStartOffset().orElse(-1L));
        }
    }

    private DescribeProducersResponse describeProducersResponse(Map<TopicPartition, DescribeProducersResponseData.PartitionResponse> partitionResponses) {
        DescribeProducersResponseData response = new DescribeProducersResponseData();
        Map partitionResponsesByTopic = CollectionUtils.groupPartitionDataByTopic(partitionResponses);
        for (Map.Entry topicEntry : partitionResponsesByTopic.entrySet()) {
            String topic = (String)topicEntry.getKey();
            Map topicPartitionResponses = (Map)topicEntry.getValue();
            DescribeProducersResponseData.TopicResponse topicResponse = new DescribeProducersResponseData.TopicResponse().setName(topic);
            response.topics().add(topicResponse);
            for (Map.Entry partitionEntry : topicPartitionResponses.entrySet()) {
                Integer partitionId = (Integer)partitionEntry.getKey();
                DescribeProducersResponseData.PartitionResponse partitionResponse = (DescribeProducersResponseData.PartitionResponse)partitionEntry.getValue();
                topicResponse.partitions().add(partitionResponse.setPartitionIndex(partitionId.intValue()));
            }
        }
        return new DescribeProducersResponse(response);
    }
}

