/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.ListOffsetsHandler;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class ListOffsetsHandlerTest {
    private final LogContext logContext = new LogContext();
    private final TopicPartition t0p0 = new TopicPartition("t0", 0);
    private final TopicPartition t0p1 = new TopicPartition("t0", 1);
    private final TopicPartition t1p0 = new TopicPartition("t1", 0);
    private final TopicPartition t1p1 = new TopicPartition("t1", 1);
    private final Node node = new Node(1, "host", 1234);
    private final Map<TopicPartition, Long> offsetTimestampsByPartition = new HashMap<TopicPartition, Long>(){
        {
            this.put(ListOffsetsHandlerTest.this.t0p0, -1L);
            this.put(ListOffsetsHandlerTest.this.t0p1, -2L);
            this.put(ListOffsetsHandlerTest.this.t1p0, 123L);
            this.put(ListOffsetsHandlerTest.this.t1p1, -3L);
        }
    };

    @Test
    public void testBuildRequestSimple() {
        ListOffsetsHandler handler = new ListOffsetsHandler(this.offsetTimestampsByPartition, new ListOffsetsOptions(), this.logContext);
        ListOffsetsRequest request = (ListOffsetsRequest)handler.buildBatchedRequest(this.node.id(), Utils.mkSet((Object[])new TopicPartition[]{this.t0p0, this.t0p1})).build();
        List topics = request.topics();
        Assertions.assertEquals((int)1, (int)topics.size());
        ListOffsetsRequestData.ListOffsetsTopic topic = (ListOffsetsRequestData.ListOffsetsTopic)topics.get(0);
        Assertions.assertEquals((int)2, (int)topic.partitions().size());
        for (ListOffsetsRequestData.ListOffsetsPartition partition : topic.partitions()) {
            TopicPartition topicPartition = new TopicPartition(topic.name(), partition.partitionIndex());
            this.assertExpectedTimestamp(topicPartition, partition.timestamp());
        }
        Assertions.assertEquals((Object)IsolationLevel.READ_UNCOMMITTED, (Object)request.isolationLevel());
    }

    @Test
    public void testBuildRequestMultipleTopicsWithReadCommitted() {
        ListOffsetsHandler handler = new ListOffsetsHandler(this.offsetTimestampsByPartition, new ListOffsetsOptions(IsolationLevel.READ_COMMITTED), this.logContext);
        ListOffsetsRequest request = (ListOffsetsRequest)handler.buildBatchedRequest(this.node.id(), this.offsetTimestampsByPartition.keySet()).build();
        List topics = request.topics();
        Assertions.assertEquals((int)2, (int)topics.size());
        HashMap<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition> partitions = new HashMap<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition>();
        for (ListOffsetsRequestData.ListOffsetsTopic listOffsetsTopic : topics) {
            for (ListOffsetsRequestData.ListOffsetsPartition partition : listOffsetsTopic.partitions()) {
                partitions.put(new TopicPartition(listOffsetsTopic.name(), partition.partitionIndex()), partition);
            }
        }
        Assertions.assertEquals((int)4, (int)partitions.size());
        for (Map.Entry entry : partitions.entrySet()) {
            this.assertExpectedTimestamp((TopicPartition)entry.getKey(), ((ListOffsetsRequestData.ListOffsetsPartition)entry.getValue()).timestamp());
        }
        Assertions.assertEquals((Object)IsolationLevel.READ_COMMITTED, (Object)request.isolationLevel());
    }

    @Test
    public void testBuildRequestAllowedVersions() {
        ListOffsetsHandler defaultOptionsHandler = new ListOffsetsHandler(this.offsetTimestampsByPartition, new ListOffsetsOptions(), this.logContext);
        ListOffsetsRequest.Builder builder = defaultOptionsHandler.buildBatchedRequest(this.node.id(), Utils.mkSet((Object[])new TopicPartition[]{this.t0p0, this.t0p1, this.t1p0}));
        Assertions.assertEquals((int)1, (int)builder.oldestAllowedVersion());
        ListOffsetsHandler readCommittedHandler = new ListOffsetsHandler(this.offsetTimestampsByPartition, new ListOffsetsOptions(IsolationLevel.READ_COMMITTED), this.logContext);
        builder = readCommittedHandler.buildBatchedRequest(this.node.id(), Utils.mkSet((Object[])new TopicPartition[]{this.t0p0, this.t0p1, this.t1p0}));
        Assertions.assertEquals((int)2, (int)builder.oldestAllowedVersion());
        builder = readCommittedHandler.buildBatchedRequest(this.node.id(), Utils.mkSet((Object[])new TopicPartition[]{this.t0p0, this.t0p1, this.t1p0, this.t1p1}));
        Assertions.assertEquals((int)7, (int)builder.oldestAllowedVersion());
    }

    @Test
    public void testHandleSuccessfulResponse() {
        AdminApiHandler.ApiResult<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> result = this.handleResponse(this.createResponse(Collections.emptyMap()));
        this.assertResult(result, this.offsetTimestampsByPartition.keySet(), Collections.emptyMap(), Collections.emptyList(), Collections.emptySet());
    }

    @Test
    public void testHandleRetriablePartitionTimeoutResponse() {
        TopicPartition errorPartition = this.t0p0;
        HashMap<TopicPartition, Short> errorsByPartition = new HashMap<TopicPartition, Short>();
        errorsByPartition.put(errorPartition, Errors.REQUEST_TIMED_OUT.code());
        AdminApiHandler.ApiResult<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> result = this.handleResponse(this.createResponse(errorsByPartition));
        Set<TopicPartition> retriable = Collections.singleton(errorPartition);
        HashSet<TopicPartition> completed = new HashSet<TopicPartition>(this.offsetTimestampsByPartition.keySet());
        completed.removeAll(retriable);
        this.assertResult(result, completed, Collections.emptyMap(), Collections.emptyList(), retriable);
    }

    @Test
    public void testHandleLookupRetriablePartitionInvalidMetadataResponse() {
        TopicPartition errorPartition = this.t0p0;
        Errors error = Errors.NOT_LEADER_OR_FOLLOWER;
        HashMap<TopicPartition, Short> errorsByPartition = new HashMap<TopicPartition, Short>();
        errorsByPartition.put(errorPartition, error.code());
        AdminApiHandler.ApiResult<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> result = this.handleResponse(this.createResponse(errorsByPartition));
        ArrayList<TopicPartition> unmapped = new ArrayList<TopicPartition>();
        unmapped.add(errorPartition);
        HashSet<TopicPartition> completed = new HashSet<TopicPartition>(this.offsetTimestampsByPartition.keySet());
        completed.removeAll(unmapped);
        this.assertResult(result, completed, Collections.emptyMap(), unmapped, Collections.emptySet());
    }

    @Test
    public void testHandleUnexpectedPartitionErrorResponse() {
        TopicPartition errorPartition = this.t0p0;
        Errors error = Errors.UNKNOWN_SERVER_ERROR;
        HashMap<TopicPartition, Short> errorsByPartition = new HashMap<TopicPartition, Short>();
        errorsByPartition.put(errorPartition, error.code());
        AdminApiHandler.ApiResult<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> result = this.handleResponse(this.createResponse(errorsByPartition));
        HashMap<TopicPartition, Throwable> failed = new HashMap<TopicPartition, Throwable>();
        failed.put(errorPartition, (Throwable)error.exception());
        HashSet<TopicPartition> completed = new HashSet<TopicPartition>(this.offsetTimestampsByPartition.keySet());
        completed.removeAll(failed.keySet());
        this.assertResult(result, completed, failed, Collections.emptyList(), Collections.emptySet());
    }

    @Test
    public void testHandleResponseSanityCheck() {
        TopicPartition errorPartition = this.t0p0;
        HashMap<TopicPartition, Long> specsByPartition = new HashMap<TopicPartition, Long>(this.offsetTimestampsByPartition);
        specsByPartition.remove(errorPartition);
        AdminApiHandler.ApiResult<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> result = this.handleResponse(ListOffsetsHandlerTest.createResponse(Collections.emptyMap(), specsByPartition));
        Assertions.assertEquals((int)(this.offsetTimestampsByPartition.size() - 1), (int)result.completedKeys.size());
        Assertions.assertEquals((int)1, (int)result.failedKeys.size());
        Assertions.assertEquals((Object)errorPartition, result.failedKeys.keySet().iterator().next());
        String sanityCheckMessage = ((Throwable)result.failedKeys.get(errorPartition)).getMessage();
        Assertions.assertTrue((boolean)sanityCheckMessage.contains("did not contain a result for topic partition"));
        Assertions.assertTrue((boolean)result.unmappedKeys.isEmpty());
    }

    @Test
    public void testHandleResponseUnsupportedVersion() {
        Set<Object> keysToTest;
        int brokerId = 1;
        UnsupportedVersionException uve = new UnsupportedVersionException("");
        HashMap<TopicPartition, OffsetSpec> maxTimestampPartitions = new HashMap<TopicPartition, OffsetSpec>();
        maxTimestampPartitions.put(this.t1p1, OffsetSpec.maxTimestamp());
        ListOffsetsHandler handler = new ListOffsetsHandler(this.offsetTimestampsByPartition, new ListOffsetsOptions(), this.logContext);
        HashMap<TopicPartition, Long> nonMaxTimestampPartitions = new HashMap<TopicPartition, Long>(this.offsetTimestampsByPartition);
        maxTimestampPartitions.forEach((k, v) -> {
            Long cfr_ignored_0 = (Long)nonMaxTimestampPartitions.remove(k);
        });
        Set<Object> expectedFailures = keysToTest = nonMaxTimestampPartitions.keySet();
        Assertions.assertEquals(ListOffsetsHandlerTest.mapToError(expectedFailures, (Throwable)uve), (Object)handler.handleUnsupportedVersionException(brokerId, uve, keysToTest));
        expectedFailures = keysToTest = maxTimestampPartitions.keySet();
        Assertions.assertEquals(ListOffsetsHandlerTest.mapToError(expectedFailures, (Throwable)uve), (Object)handler.handleUnsupportedVersionException(brokerId, uve, keysToTest));
        keysToTest = this.offsetTimestampsByPartition.keySet();
        expectedFailures = maxTimestampPartitions.keySet();
        Assertions.assertEquals(ListOffsetsHandlerTest.mapToError(expectedFailures, (Throwable)uve), (Object)handler.handleUnsupportedVersionException(brokerId, uve, keysToTest));
    }

    private static Map<TopicPartition, Throwable> mapToError(Set<TopicPartition> keys, Throwable t) {
        return keys.stream().collect(Collectors.toMap(k -> k, k -> t));
    }

    private void assertExpectedTimestamp(TopicPartition topicPartition, long actualTimestamp) {
        Long expectedTimestamp = this.offsetTimestampsByPartition.get(topicPartition);
        Assertions.assertEquals((Long)expectedTimestamp, (long)actualTimestamp);
    }

    private ListOffsetsResponse createResponse(Map<TopicPartition, Short> errorsByPartition) {
        return ListOffsetsHandlerTest.createResponse(errorsByPartition, this.offsetTimestampsByPartition);
    }

    private static ListOffsetsResponse createResponse(Map<TopicPartition, Short> errorsByPartition, Map<TopicPartition, Long> specsByPartition) {
        HashMap<String, ListOffsetsResponseData.ListOffsetsTopicResponse> responsesByTopic = new HashMap<String, ListOffsetsResponseData.ListOffsetsTopicResponse>();
        for (Map.Entry<TopicPartition, Long> offsetSpecEntry : specsByPartition.entrySet()) {
            TopicPartition topicPartition = offsetSpecEntry.getKey();
            ListOffsetsResponseData.ListOffsetsTopicResponse topicResponse = responsesByTopic.computeIfAbsent(topicPartition.topic(), t -> new ListOffsetsResponseData.ListOffsetsTopicResponse());
            topicResponse.setName(topicPartition.topic());
            ListOffsetsResponseData.ListOffsetsPartitionResponse partitionResponse = new ListOffsetsResponseData.ListOffsetsPartitionResponse();
            partitionResponse.setPartitionIndex(topicPartition.partition());
            partitionResponse.setOffset(ListOffsetsHandlerTest.getOffset(topicPartition, offsetSpecEntry.getValue()));
            partitionResponse.setErrorCode(errorsByPartition.getOrDefault(topicPartition, (short)0).shortValue());
            topicResponse.partitions().add(partitionResponse);
        }
        ListOffsetsResponseData responseData = new ListOffsetsResponseData();
        responseData.setTopics(new ArrayList(responsesByTopic.values()));
        return new ListOffsetsResponse(responseData);
    }

    private AdminApiHandler.ApiResult<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> handleResponse(ListOffsetsResponse response) {
        ListOffsetsHandler handler = new ListOffsetsHandler(this.offsetTimestampsByPartition, new ListOffsetsOptions(), this.logContext);
        return handler.handleResponse(this.node, this.offsetTimestampsByPartition.keySet(), (AbstractResponse)response);
    }

    private void assertResult(AdminApiHandler.ApiResult<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> result, Set<TopicPartition> expectedCompleted, Map<TopicPartition, Throwable> expectedFailed, List<TopicPartition> expectedUnmapped, Set<TopicPartition> expectedRetriable) {
        Assertions.assertEquals(expectedCompleted, result.completedKeys.keySet());
        Assertions.assertEquals(expectedFailed, (Object)result.failedKeys);
        Assertions.assertEquals(expectedUnmapped, (Object)result.unmappedKeys);
        HashSet<TopicPartition> actualRetriable = new HashSet<TopicPartition>(this.offsetTimestampsByPartition.keySet());
        actualRetriable.removeAll(result.completedKeys.keySet());
        actualRetriable.removeAll(result.failedKeys.keySet());
        actualRetriable.removeAll(new HashSet(result.unmappedKeys));
        Assertions.assertEquals(expectedRetriable, actualRetriable);
    }

    private static long getOffset(TopicPartition topicPartition, Long offsetQuery) {
        long base = 1024L;
        if (offsetQuery == -2L) {
            return (long)topicPartition.hashCode() & base - 1L;
        }
        if (offsetQuery >= 0L) {
            return base;
        }
        if (offsetQuery == -1L) {
            return base + 1L + ((long)topicPartition.hashCode() & base - 1L);
        }
        return 2L * base + 1L;
    }
}

