/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConsumerGroupMetadataTest {
    private String groupId = "group";

    @Test
    public void testAssignmentConstructor() {
        String memberId = "member";
        int generationId = 2;
        String groupInstanceId = "instance";
        ConsumerGroupMetadata groupMetadata = new ConsumerGroupMetadata(this.groupId, generationId, memberId, Optional.of(groupInstanceId));
        Assertions.assertEquals((Object)this.groupId, (Object)groupMetadata.groupId());
        Assertions.assertEquals((int)generationId, (int)groupMetadata.generationId());
        Assertions.assertEquals((Object)memberId, (Object)groupMetadata.memberId());
        Assertions.assertTrue((boolean)groupMetadata.groupInstanceId().isPresent());
        Assertions.assertEquals((Object)groupInstanceId, groupMetadata.groupInstanceId().get());
    }

    @Test
    public void testGroupIdConstructor() {
        ConsumerGroupMetadata groupMetadata = new ConsumerGroupMetadata(this.groupId);
        Assertions.assertEquals((Object)this.groupId, (Object)groupMetadata.groupId());
        Assertions.assertEquals((int)-1, (int)groupMetadata.generationId());
        Assertions.assertEquals((Object)"", (Object)groupMetadata.memberId());
        Assertions.assertFalse((boolean)groupMetadata.groupInstanceId().isPresent());
    }

    @Test
    public void testInvalidGroupId() {
        String memberId = "member";
        int generationId = 2;
        Assertions.assertThrows(NullPointerException.class, () -> new ConsumerGroupMetadata(null, generationId, memberId, Optional.empty()));
    }

    @Test
    public void testInvalidMemberId() {
        int generationId = 2;
        Assertions.assertThrows(NullPointerException.class, () -> new ConsumerGroupMetadata(this.groupId, generationId, null, Optional.empty()));
    }

    @Test
    public void testInvalidInstanceId() {
        String memberId = "member";
        int generationId = 2;
        Assertions.assertThrows(NullPointerException.class, () -> new ConsumerGroupMetadata(this.groupId, generationId, memberId, null));
    }
}

