/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Objects;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TopicIdPartitionTest {
    private final Uuid topicId0 = new Uuid(-4883993789924556279L, -5960309683534398572L);
    private final String topicName0 = "a_topic_name";
    private final int partition1 = 1;
    private final TopicPartition topicPartition0 = new TopicPartition("a_topic_name", 1);
    private final TopicIdPartition topicIdPartition0 = new TopicIdPartition(this.topicId0, this.topicPartition0);
    private final TopicIdPartition topicIdPartition1 = new TopicIdPartition(this.topicId0, 1, "a_topic_name");
    private final TopicIdPartition topicIdPartitionWithNullTopic0 = new TopicIdPartition(this.topicId0, 1, null);
    private final TopicIdPartition topicIdPartitionWithNullTopic1 = new TopicIdPartition(this.topicId0, new TopicPartition(null, 1));
    private final Uuid topicId1 = new Uuid(7759286116672424028L, -5081215629859775948L);
    private final String topicName1 = "another_topic_name";
    private final TopicIdPartition topicIdPartition2 = new TopicIdPartition(this.topicId1, 1, "another_topic_name");
    private final TopicIdPartition topicIdPartitionWithNullTopic2 = new TopicIdPartition(this.topicId1, new TopicPartition(null, 1));

    TopicIdPartitionTest() {
    }

    @Test
    public void testEquals() {
        Assertions.assertEquals((Object)this.topicIdPartition0, (Object)this.topicIdPartition1);
        Assertions.assertEquals((Object)this.topicIdPartition1, (Object)this.topicIdPartition0);
        Assertions.assertEquals((Object)this.topicIdPartitionWithNullTopic0, (Object)this.topicIdPartitionWithNullTopic1);
        Assertions.assertNotEquals((Object)this.topicIdPartition0, (Object)this.topicIdPartition2);
        Assertions.assertNotEquals((Object)this.topicIdPartition2, (Object)this.topicIdPartition0);
        Assertions.assertNotEquals((Object)this.topicIdPartition0, (Object)this.topicIdPartitionWithNullTopic0);
        Assertions.assertNotEquals((Object)this.topicIdPartitionWithNullTopic0, (Object)this.topicIdPartitionWithNullTopic2);
    }

    @Test
    public void testHashCode() {
        Assertions.assertEquals((int)Objects.hash(this.topicIdPartition0.topicId(), this.topicIdPartition0.topicPartition()), (int)this.topicIdPartition0.hashCode());
        Assertions.assertEquals((int)this.topicIdPartition0.hashCode(), (int)this.topicIdPartition1.hashCode());
        Assertions.assertEquals((int)Objects.hash(this.topicIdPartitionWithNullTopic0.topicId(), new TopicPartition(null, 1)), (int)this.topicIdPartitionWithNullTopic0.hashCode());
        Assertions.assertEquals((int)this.topicIdPartitionWithNullTopic0.hashCode(), (int)this.topicIdPartitionWithNullTopic1.hashCode());
        Assertions.assertNotEquals((int)this.topicIdPartition0.hashCode(), (int)this.topicIdPartition2.hashCode());
        Assertions.assertNotEquals((int)this.topicIdPartition0.hashCode(), (int)this.topicIdPartitionWithNullTopic0.hashCode());
        Assertions.assertNotEquals((int)this.topicIdPartitionWithNullTopic0.hashCode(), (int)this.topicIdPartitionWithNullTopic2.hashCode());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"vDiRhkpVQgmtSLnsAZx7lA:a_topic_name-1", (Object)this.topicIdPartition0.toString());
        Assertions.assertEquals((Object)"vDiRhkpVQgmtSLnsAZx7lA:null-1", (Object)this.topicIdPartitionWithNullTopic0.toString());
    }
}

