/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.time.Duration;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.KafkaShareConsumer;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KafkaShareConsumerMetricsTest {
    private final String topic = "test";
    private final Uuid topicId = Uuid.randomUuid();
    private final Map<String, Uuid> topicIds = Stream.of(new AbstractMap.SimpleEntry<String, Uuid>("test", this.topicId)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    private final Time time = new MockTime();
    private final SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
    private final String groupId = "mock-group";

    @Test
    public void testPollTimeMetrics() {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        KafkaShareConsumer<String, String> consumer = this.newShareConsumer(this.time, client, this.subscription, metadata);
        consumer.subscribe(Collections.singletonList("test"));
        Metrics metrics = consumer.metricsRegistry();
        MetricName lastPollSecondsAgoName = metrics.metricName("last-poll-seconds-ago", "consumer-share-metrics");
        MetricName timeBetweenPollAvgName = metrics.metricName("time-between-poll-avg", "consumer-share-metrics");
        MetricName timeBetweenPollMaxName = metrics.metricName("time-between-poll-max", "consumer-share-metrics");
        Assertions.assertEquals((Object)-1.0, (Object)((Metric)consumer.metrics().get(lastPollSecondsAgoName)).metricValue());
        Assertions.assertEquals((Object)Double.NaN, (Object)((Metric)consumer.metrics().get(timeBetweenPollAvgName)).metricValue());
        Assertions.assertEquals((Object)Double.NaN, (Object)((Metric)consumer.metrics().get(timeBetweenPollMaxName)).metricValue());
        consumer.poll(Duration.ZERO);
        Assertions.assertEquals((Object)0.0, (Object)((Metric)consumer.metrics().get(lastPollSecondsAgoName)).metricValue());
        Assertions.assertEquals((Object)0.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollAvgName)).metricValue());
        Assertions.assertEquals((Object)0.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollMaxName)).metricValue());
        this.time.sleep(5000L);
        Assertions.assertEquals((Object)5.0, (Object)((Metric)consumer.metrics().get(lastPollSecondsAgoName)).metricValue());
        consumer.poll(Duration.ZERO);
        Assertions.assertEquals((Object)2500.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollAvgName)).metricValue());
        Assertions.assertEquals((Object)5000.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollMaxName)).metricValue());
        this.time.sleep(10000L);
        Assertions.assertEquals((Object)10.0, (Object)((Metric)consumer.metrics().get(lastPollSecondsAgoName)).metricValue());
        consumer.poll(Duration.ZERO);
        Assertions.assertEquals((Object)5000.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollAvgName)).metricValue());
        Assertions.assertEquals((Object)10000.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollMaxName)).metricValue());
        this.time.sleep(5000L);
        Assertions.assertEquals((Object)5.0, (Object)((Metric)consumer.metrics().get(lastPollSecondsAgoName)).metricValue());
        consumer.poll(Duration.ZERO);
        Assertions.assertEquals((Object)5000.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollAvgName)).metricValue());
        Assertions.assertEquals((Object)10000.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollMaxName)).metricValue());
    }

    @Test
    public void testPollIdleRatio() {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        KafkaShareConsumer<String, String> consumer = this.newShareConsumer(this.time, client, this.subscription, metadata);
        Metrics metrics = consumer.metricsRegistry();
        MetricName pollIdleRatio = metrics.metricName("poll-idle-ratio-avg", "consumer-share-metrics");
        Assertions.assertEquals((Object)Double.NaN, (Object)((Metric)consumer.metrics().get(pollIdleRatio)).metricValue());
        consumer.kafkaShareConsumerMetrics().recordPollStart(this.time.milliseconds());
        this.time.sleep(50L);
        consumer.kafkaShareConsumerMetrics().recordPollEnd(this.time.milliseconds());
        Assertions.assertEquals((Object)1.0, (Object)((Metric)consumer.metrics().get(pollIdleRatio)).metricValue());
        this.time.sleep(50L);
        consumer.kafkaShareConsumerMetrics().recordPollStart(this.time.milliseconds());
        consumer.kafkaShareConsumerMetrics().recordPollEnd(this.time.milliseconds());
        Assertions.assertEquals((Object)0.5, (Object)((Metric)consumer.metrics().get(pollIdleRatio)).metricValue());
        this.time.sleep(25L);
        consumer.kafkaShareConsumerMetrics().recordPollStart(this.time.milliseconds());
        this.time.sleep(25L);
        consumer.kafkaShareConsumerMetrics().recordPollEnd(this.time.milliseconds());
        Assertions.assertEquals((Object)0.5, (Object)((Metric)consumer.metrics().get(pollIdleRatio)).metricValue());
    }

    private static boolean consumerMetricPresent(KafkaShareConsumer<String, String> consumer, String name) {
        MetricName metricName = new MetricName(name, "consumer-share-metrics", "", Collections.emptyMap());
        return consumer.metricsRegistry().metrics().containsKey(metricName);
    }

    @Test
    public void testClosingConsumerUnregistersConsumerMetrics() {
        MockTime time = new MockTime(1L);
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        KafkaShareConsumer<String, String> consumer = this.newShareConsumer(time, client, this.subscription, metadata);
        consumer.subscribe(Collections.singletonList("test"));
        Assertions.assertTrue((boolean)KafkaShareConsumerMetricsTest.consumerMetricPresent(consumer, "last-poll-seconds-ago"));
        Assertions.assertTrue((boolean)KafkaShareConsumerMetricsTest.consumerMetricPresent(consumer, "time-between-poll-avg"));
        Assertions.assertTrue((boolean)KafkaShareConsumerMetricsTest.consumerMetricPresent(consumer, "time-between-poll-max"));
        consumer.close();
        Assertions.assertFalse((boolean)KafkaShareConsumerMetricsTest.consumerMetricPresent(consumer, "last-poll-seconds-ago"));
        Assertions.assertFalse((boolean)KafkaShareConsumerMetricsTest.consumerMetricPresent(consumer, "time-between-poll-avg"));
        Assertions.assertFalse((boolean)KafkaShareConsumerMetricsTest.consumerMetricPresent(consumer, "time-between-poll-max"));
    }

    private ConsumerMetadata createMetadata(SubscriptionState subscription) {
        return new ConsumerMetadata(0L, 0L, Long.MAX_VALUE, false, false, subscription, new LogContext(), new ClusterResourceListeners());
    }

    private KafkaShareConsumer<String, String> newShareConsumer(Time time, KafkaClient client, SubscriptionState subscription, ConsumerMetadata metadata) {
        return this.newShareConsumer(time, client, subscription, metadata, "mock-group", Optional.of(new StringDeserializer()));
    }

    private KafkaShareConsumer<String, String> newShareConsumer(Time time, KafkaClient client, SubscriptionState subscriptions, ConsumerMetadata metadata, String groupId, Optional<Deserializer<String>> valueDeserializerOpt) {
        String clientId = "mock-consumer";
        StringDeserializer keyDeserializer = new StringDeserializer();
        Deserializer<String> valueDeserializer = valueDeserializerOpt.orElse((Deserializer<String>)new StringDeserializer());
        LogContext logContext = new LogContext();
        ConsumerConfig config = this.newConsumerConfig(groupId, valueDeserializer);
        return new KafkaShareConsumer(logContext, clientId, groupId, config, (Deserializer)keyDeserializer, valueDeserializer, time, client, subscriptions, metadata);
    }

    private ConsumerConfig newConsumerConfig(String groupId, Deserializer<String> valueDeserializer) {
        String clientId = "mock-consumer";
        long retryBackoffMs = 100L;
        long retryBackoffMaxMs = 1000L;
        int minBytes = 1;
        int maxBytes = Integer.MAX_VALUE;
        int maxWaitMs = 500;
        int fetchSize = 0x100000;
        int maxPollRecords = Integer.MAX_VALUE;
        boolean checkCrcs = true;
        int rebalanceTimeoutMs = 60000;
        int defaultApiTimeoutMs = 60000;
        int requestTimeoutMs = defaultApiTimeoutMs / 2;
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("check.crcs", checkCrcs);
        configs.put("client.id", clientId);
        configs.put("client.rack", "");
        configs.put("default.api.timeout.ms", defaultApiTimeoutMs);
        configs.put("fetch.max.bytes", maxBytes);
        configs.put("fetch.max.wait.ms", maxWaitMs);
        configs.put("fetch.min.bytes", minBytes);
        configs.put("group.id", groupId);
        configs.put("key.deserializer", StringDeserializer.class);
        configs.put("max.partition.fetch.bytes", fetchSize);
        configs.put("max.poll.interval.ms", rebalanceTimeoutMs);
        configs.put("max.poll.records", maxPollRecords);
        configs.put("request.timeout.ms", requestTimeoutMs);
        configs.put("retry.backoff.max.ms", retryBackoffMaxMs);
        configs.put("retry.backoff.ms", retryBackoffMs);
        configs.put("value.deserializer", valueDeserializer.getClass());
        return new ConsumerConfig(configs);
    }

    private void initMetadata(MockClient mockClient, Map<String, Integer> partitionCounts) {
        HashMap<String, Uuid> metadataIds = new HashMap<String, Uuid>();
        for (String name : partitionCounts.keySet()) {
            metadataIds.put(name, this.topicIds.get(name));
        }
        MetadataResponse initialMetadata = RequestTestUtils.metadataUpdateWithIds(1, partitionCounts, metadataIds);
        mockClient.updateMetadata(initialMetadata);
    }
}

