/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractPartitionAssignor;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AbstractPartitionAssignorTest {
    public static final String TEST_NAME_WITH_RACK_CONFIG = "{displayName}.rackConfig = {0}";
    public static final String TEST_NAME_WITH_CONSUMER_RACK = "{displayName}.hasConsumerRack = {0}";
    public static final String[] ALL_RACKS = new String[]{"a", "b", "c", "d", "e", "f"};

    @Test
    public void testMemberInfoSortingWithoutGroupInstanceId() {
        AbstractPartitionAssignor.MemberInfo m1 = new AbstractPartitionAssignor.MemberInfo("a", Optional.empty());
        AbstractPartitionAssignor.MemberInfo m2 = new AbstractPartitionAssignor.MemberInfo("b", Optional.empty());
        AbstractPartitionAssignor.MemberInfo m3 = new AbstractPartitionAssignor.MemberInfo("c", Optional.empty());
        List<AbstractPartitionAssignor.MemberInfo> memberInfoList = Arrays.asList(m1, m2, m3);
        Assertions.assertEquals(memberInfoList, (Object)Utils.sorted(memberInfoList));
    }

    @Test
    public void testMemberInfoSortingWithAllGroupInstanceId() {
        AbstractPartitionAssignor.MemberInfo m1 = new AbstractPartitionAssignor.MemberInfo("a", Optional.of("y"));
        AbstractPartitionAssignor.MemberInfo m2 = new AbstractPartitionAssignor.MemberInfo("b", Optional.of("z"));
        AbstractPartitionAssignor.MemberInfo m3 = new AbstractPartitionAssignor.MemberInfo("c", Optional.of("x"));
        List<AbstractPartitionAssignor.MemberInfo> memberInfoList = Arrays.asList(m1, m2, m3);
        Assertions.assertEquals(Arrays.asList(m3, m1, m2), (Object)Utils.sorted(memberInfoList));
    }

    @Test
    public void testMemberInfoSortingSomeGroupInstanceId() {
        AbstractPartitionAssignor.MemberInfo m1 = new AbstractPartitionAssignor.MemberInfo("a", Optional.empty());
        AbstractPartitionAssignor.MemberInfo m2 = new AbstractPartitionAssignor.MemberInfo("b", Optional.of("y"));
        AbstractPartitionAssignor.MemberInfo m3 = new AbstractPartitionAssignor.MemberInfo("c", Optional.of("x"));
        List<AbstractPartitionAssignor.MemberInfo> memberInfoList = Arrays.asList(m1, m2, m3);
        Assertions.assertEquals(Arrays.asList(m3, m2, m1), (Object)Utils.sorted(memberInfoList));
    }

    @Test
    public void testMergeSortManyMemberInfo() {
        Random rand = new Random();
        int bound = 2;
        ArrayList<AbstractPartitionAssignor.MemberInfo> memberInfoList = new ArrayList<AbstractPartitionAssignor.MemberInfo>();
        ArrayList<Object> staticMemberList = new ArrayList<Object>();
        ArrayList<AbstractPartitionAssignor.MemberInfo> dynamicMemberList = new ArrayList<AbstractPartitionAssignor.MemberInfo>();
        for (int i = 0; i < 100; ++i) {
            String id = Integer.toString(i + 100);
            Optional<Object> groupInstanceId = rand.nextInt(bound) < bound / 2 ? Optional.of(id) : Optional.empty();
            AbstractPartitionAssignor.MemberInfo m = new AbstractPartitionAssignor.MemberInfo(id, groupInstanceId);
            memberInfoList.add(m);
            if (m.groupInstanceId.isPresent()) {
                staticMemberList.add(m);
                continue;
            }
            dynamicMemberList.add(m);
        }
        staticMemberList.addAll(dynamicMemberList);
        Collections.shuffle(memberInfoList);
        Assertions.assertEquals(staticMemberList, (Object)Utils.sorted(memberInfoList));
    }

    @Test
    public void testUseRackAwareAssignment() {
        RangeAssignor assignor = new RangeAssignor();
        String[] racks = new String[]{"a", "b", "c"};
        Set<String> allRacks = Set.of(racks);
        Set<String> twoRacks = Set.of("a", "b");
        HashMap<TopicPartition, Set<String>> partitionsOnAllRacks = new HashMap<TopicPartition, Set<String>>();
        HashMap<TopicPartition, Set<String>> partitionsOnSubsetOfRacks = new HashMap<TopicPartition, Set<String>>();
        for (int i = 0; i < 10; ++i) {
            TopicPartition tp = new TopicPartition("topic", i);
            partitionsOnAllRacks.put(tp, allRacks);
            partitionsOnSubsetOfRacks.put(tp, Set.of(racks[i % racks.length]));
        }
        Assertions.assertFalse((boolean)assignor.useRackAwareAssignment(Collections.emptySet(), Collections.emptySet(), partitionsOnAllRacks));
        Assertions.assertFalse((boolean)assignor.useRackAwareAssignment(Collections.emptySet(), allRacks, partitionsOnAllRacks));
        Assertions.assertFalse((boolean)assignor.useRackAwareAssignment(allRacks, Collections.emptySet(), Collections.emptyMap()));
        Assertions.assertFalse((boolean)assignor.useRackAwareAssignment(Set.of("d"), allRacks, partitionsOnAllRacks));
        Assertions.assertFalse((boolean)assignor.useRackAwareAssignment(allRacks, allRacks, partitionsOnAllRacks));
        Assertions.assertFalse((boolean)assignor.useRackAwareAssignment(twoRacks, allRacks, partitionsOnAllRacks));
        Assertions.assertFalse((boolean)assignor.useRackAwareAssignment(Set.of("a", "d"), allRacks, partitionsOnAllRacks));
        Assertions.assertTrue((boolean)assignor.useRackAwareAssignment(allRacks, allRacks, partitionsOnSubsetOfRacks));
        Assertions.assertTrue((boolean)assignor.useRackAwareAssignment(twoRacks, allRacks, partitionsOnSubsetOfRacks));
        Assertions.assertTrue((boolean)assignor.useRackAwareAssignment(Set.of("a", "d"), allRacks, partitionsOnSubsetOfRacks));
        assignor.preferRackAwareLogic = true;
        Assertions.assertFalse((boolean)assignor.useRackAwareAssignment(Collections.emptySet(), Collections.emptySet(), partitionsOnAllRacks));
        Assertions.assertFalse((boolean)assignor.useRackAwareAssignment(Collections.emptySet(), allRacks, partitionsOnAllRacks));
        Assertions.assertFalse((boolean)assignor.useRackAwareAssignment(allRacks, Collections.emptySet(), Collections.emptyMap()));
        Assertions.assertFalse((boolean)assignor.useRackAwareAssignment(Set.of("d"), allRacks, partitionsOnAllRacks));
        Assertions.assertTrue((boolean)assignor.useRackAwareAssignment(allRacks, allRacks, partitionsOnAllRacks));
        Assertions.assertTrue((boolean)assignor.useRackAwareAssignment(twoRacks, allRacks, partitionsOnAllRacks));
        Assertions.assertTrue((boolean)assignor.useRackAwareAssignment(allRacks, allRacks, partitionsOnSubsetOfRacks));
        Assertions.assertTrue((boolean)assignor.useRackAwareAssignment(twoRacks, allRacks, partitionsOnSubsetOfRacks));
    }

    public static List<String> racks(int numRacks) {
        ArrayList<String> racks = new ArrayList<String>(numRacks);
        for (int i = 0; i < numRacks; ++i) {
            racks.add(ALL_RACKS[i % ALL_RACKS.length]);
        }
        return racks;
    }

    public static List<String> nullRacks(int numRacks) {
        return Arrays.asList(new String[numRacks]);
    }

    public static void verifyRackAssignment(AbstractPartitionAssignor assignor, Map<String, Integer> numPartitionsPerTopic, int replicationFactor, List<String> brokerRacks, List<String> consumerRacks, List<List<String>> consumerTopics, List<String> expectedAssignments, int numPartitionsWithRackMismatch) {
        AbstractPartitionAssignorTest.verifyRackAssignment(assignor, numPartitionsPerTopic, replicationFactor, brokerRacks, consumerRacks, consumerTopics, Collections.emptyList(), expectedAssignments, numPartitionsWithRackMismatch);
    }

    public static void verifyRackAssignment(AbstractPartitionAssignor assignor, Map<String, Integer> numPartitionsPerTopic, int replicationFactor, List<String> brokerRacks, List<String> consumerRacks, List<List<String>> consumerTopics, List<String> consumerOwnedPartitions, List<String> expectedAssignments, int numPartitionsWithRackMismatch) {
        List consumers = IntStream.range(0, consumerRacks.size()).mapToObj(i -> "consumer" + i).collect(Collectors.toList());
        List<ConsumerPartitionAssignor.Subscription> subscriptions = AbstractPartitionAssignorTest.subscriptions(consumerTopics, consumerRacks, consumerOwnedPartitions);
        Map<String, List<PartitionInfo>> partitionsPerTopic = AbstractPartitionAssignorTest.partitionsPerTopic(numPartitionsPerTopic, replicationFactor, brokerRacks);
        HashMap<String, ConsumerPartitionAssignor.Subscription> subscriptionsByConsumer = new HashMap<String, ConsumerPartitionAssignor.Subscription>(consumers.size());
        for (int i2 = 0; i2 < subscriptions.size(); ++i2) {
            subscriptionsByConsumer.put((String)consumers.get(i2), subscriptions.get(i2));
        }
        HashMap<String, String> expectedAssignment = new HashMap<String, String>(consumers.size());
        for (int i3 = 0; i3 < consumers.size(); ++i3) {
            expectedAssignment.put((String)consumers.get(i3), expectedAssignments.get(i3));
        }
        Map assignment = assignor.assignPartitions(partitionsPerTopic, subscriptionsByConsumer);
        Map<String, String> actualAssignment = assignment.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> AbstractPartitionAssignorTest.toSortedString((List)e.getValue())));
        Assertions.assertEquals(expectedAssignment, actualAssignment);
        if (numPartitionsWithRackMismatch >= 0) {
            ArrayList<TopicPartition> numMismatched = new ArrayList<TopicPartition>();
            for (int i4 = 0; i4 < consumers.size(); ++i4) {
                String rack = consumerRacks.get(i4);
                if (rack == null) continue;
                List partitions = (List)assignment.get(consumers.get(i4));
                for (TopicPartition tp : partitions) {
                    PartitionInfo partitionInfo = partitionsPerTopic.get(tp.topic()).stream().filter(p -> p.topic().equals(tp.topic()) && p.partition() == tp.partition()).findFirst().get();
                    if (!Arrays.stream(partitionInfo.replicas()).noneMatch(n -> rack.equals(n.rack()))) continue;
                    numMismatched.add(tp);
                }
            }
            Assertions.assertEquals((int)numPartitionsWithRackMismatch, (int)numMismatched.size(), (String)("Partitions with rack mismatch " + String.valueOf(numMismatched)));
        }
    }

    private static String toSortedString(List<?> partitions) {
        return partitions.stream().map(Object::toString).sorted().collect(Collectors.joining(", "));
    }

    private static List<ConsumerPartitionAssignor.Subscription> subscriptions(List<List<String>> consumerTopics, List<String> consumerRacks, List<String> consumerOwnedPartitions) {
        List<List<TopicPartition>> ownedPartitions = AbstractPartitionAssignorTest.ownedPartitions(consumerOwnedPartitions, consumerTopics.size());
        ArrayList<ConsumerPartitionAssignor.Subscription> subscriptions = new ArrayList<ConsumerPartitionAssignor.Subscription>(consumerTopics.size());
        for (int i = 0; i < consumerTopics.size(); ++i) {
            subscriptions.add(new ConsumerPartitionAssignor.Subscription(consumerTopics.get(i), null, ownedPartitions.get(i), -1, Optional.ofNullable(consumerRacks.get(i))));
        }
        return subscriptions;
    }

    private static List<List<TopicPartition>> ownedPartitions(List<String> consumerOwnedPartitions, int numConsumers) {
        ArrayList<List<TopicPartition>> owedPartitions = new ArrayList<List<TopicPartition>>(numConsumers);
        for (int i = 0; i < numConsumers; ++i) {
            List owned = Collections.emptyList();
            if (consumerOwnedPartitions == null || consumerOwnedPartitions.size() <= i) {
                owedPartitions.add(owned);
                continue;
            }
            String[] partitions = consumerOwnedPartitions.get(i).split(", ");
            ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>(partitions.length);
            for (String partition : partitions) {
                String topic = partition.substring(0, partition.lastIndexOf(45));
                int p = Integer.parseInt(partition.substring(partition.lastIndexOf(45) + 1));
                topicPartitions.add(new TopicPartition(topic, p));
            }
            owedPartitions.add(topicPartitions);
        }
        return owedPartitions;
    }

    private static Map<String, List<PartitionInfo>> partitionsPerTopic(Map<String, Integer> numPartitionsPerTopic, int replicationFactor, List<String> brokerRacks) {
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        int nextIndex = 0;
        for (Map.Entry<String, Integer> entry : numPartitionsPerTopic.entrySet()) {
            String topic = entry.getKey();
            int numPartitions = entry.getValue();
            partitionsPerTopic.put(topic, AbstractPartitionAssignorTest.partitionInfos(topic, numPartitions, replicationFactor, brokerRacks, nextIndex));
            nextIndex += numPartitions;
        }
        return partitionsPerTopic;
    }

    private static List<PartitionInfo> partitionInfos(String topic, int numberOfPartitions, int replicationFactor, List<String> brokerRacks, int nextNodeIndex) {
        int numBrokers = brokerRacks.size();
        ArrayList<Node> nodes = new ArrayList<Node>(numBrokers);
        for (int i = 0; i < brokerRacks.size(); ++i) {
            nodes.add(new Node(i, "", i, brokerRacks.get(i)));
        }
        ArrayList<PartitionInfo> partitionInfos = new ArrayList<PartitionInfo>(numberOfPartitions);
        for (int i = 0; i < numberOfPartitions; ++i) {
            Node[] replicas = new Node[replicationFactor];
            for (int j = 0; j < replicationFactor; ++j) {
                replicas[j] = (Node)nodes.get((i + j + nextNodeIndex) % nodes.size());
            }
            partitionInfos.add(new PartitionInfo(topic, i, replicas[0], replicas, replicas));
        }
        return partitionInfos;
    }

    public static List<PartitionInfo> partitionInfos(String topic, int numberOfPartitions, int replicationFactor, int numBrokerRacks, int nextNodeIndex) {
        int numBrokers = numBrokerRacks <= 0 ? replicationFactor : numBrokerRacks * replicationFactor;
        ArrayList<String> brokerRacks = new ArrayList<String>(numBrokers);
        for (int i = 0; i < numBrokers; ++i) {
            brokerRacks.add(numBrokerRacks <= 0 ? null : ALL_RACKS[i % numBrokerRacks]);
        }
        return AbstractPartitionAssignorTest.partitionInfos(topic, numberOfPartitions, replicationFactor, brokerRacks, nextNodeIndex);
    }

    public static void preferRackAwareLogic(AbstractPartitionAssignor assignor, boolean value) {
        assignor.preferRackAwareLogic = value;
    }

    public static enum RackConfig {
        NO_BROKER_RACK,
        NO_CONSUMER_RACK,
        BROKER_AND_CONSUMER_RACK;

    }
}

