/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.telemetry.internals;

import io.opentelemetry.proto.metrics.v1.AggregationTemporality;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.NumberDataPoint;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.telemetry.internals.MetricKey;
import org.apache.kafka.common.telemetry.internals.SinglePointMetric;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SinglePointMetricTest {
    private MetricKey metricKey;
    private Instant now;

    @BeforeEach
    public void setUp() {
        this.metricKey = new MetricKey("name", Collections.emptyMap());
        this.now = Instant.now();
    }

    @Test
    public void testGaugeWithNumberValue() {
        SinglePointMetric gaugeNumber = SinglePointMetric.gauge((MetricKey)this.metricKey, (Number)1L, (Instant)this.now, Collections.emptySet());
        MetricKey metricKey = gaugeNumber.key();
        Assertions.assertEquals((Object)"name", (Object)metricKey.name());
        Metric metric = gaugeNumber.builder().build();
        Assertions.assertEquals((int)1, (int)metric.getGauge().getDataPointsCount());
        NumberDataPoint point = metric.getGauge().getDataPoints(0);
        Assertions.assertEquals((double)((double)this.now.getEpochSecond() * Math.pow(10.0, 9.0) + (double)this.now.getNano()), (double)point.getTimeUnixNano());
        Assertions.assertEquals((long)0L, (long)point.getStartTimeUnixNano());
        Assertions.assertEquals((long)1L, (long)point.getAsInt());
        Assertions.assertEquals((int)0, (int)point.getAttributesCount());
    }

    @Test
    public void testGaugeWithDoubleValue() {
        SinglePointMetric gaugeNumber = SinglePointMetric.gauge((MetricKey)this.metricKey, (double)1.0, (Instant)this.now, Collections.emptySet());
        MetricKey metricKey = gaugeNumber.key();
        Assertions.assertEquals((Object)"name", (Object)metricKey.name());
        Metric metric = gaugeNumber.builder().build();
        Assertions.assertEquals((int)1, (int)metric.getGauge().getDataPointsCount());
        NumberDataPoint point = metric.getGauge().getDataPoints(0);
        Assertions.assertEquals((double)((double)this.now.getEpochSecond() * Math.pow(10.0, 9.0) + (double)this.now.getNano()), (double)point.getTimeUnixNano());
        Assertions.assertEquals((long)0L, (long)point.getStartTimeUnixNano());
        Assertions.assertEquals((double)1.0, (double)point.getAsDouble());
        Assertions.assertEquals((int)0, (int)point.getAttributesCount());
    }

    @Test
    public void testGaugeWithMetricTags() {
        MetricKey metricKey = new MetricKey("name", Collections.singletonMap("tag", "value"));
        SinglePointMetric gaugeNumber = SinglePointMetric.gauge((MetricKey)metricKey, (double)1.0, (Instant)this.now, Collections.emptySet());
        MetricKey key = gaugeNumber.key();
        Assertions.assertEquals((Object)"name", (Object)key.name());
        Metric metric = gaugeNumber.builder().build();
        Assertions.assertEquals((int)1, (int)metric.getGauge().getDataPointsCount());
        NumberDataPoint point = metric.getGauge().getDataPoints(0);
        Assertions.assertEquals((double)((double)this.now.getEpochSecond() * Math.pow(10.0, 9.0) + (double)this.now.getNano()), (double)point.getTimeUnixNano());
        Assertions.assertEquals((long)0L, (long)point.getStartTimeUnixNano());
        Assertions.assertEquals((double)1.0, (double)point.getAsDouble());
        Assertions.assertEquals((int)1, (int)point.getAttributesCount());
        Assertions.assertEquals((Object)"tag", (Object)point.getAttributes(0).getKey());
        Assertions.assertEquals((Object)"value", (Object)point.getAttributes(0).getValue().getStringValue());
    }

    @Test
    public void testGaugeNumberWithExcludeLabels() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("tag1", "value1");
        tags.put("tag2", "value2");
        MetricKey metricKey = new MetricKey("name", tags);
        SinglePointMetric gaugeNumber = SinglePointMetric.gauge((MetricKey)metricKey, (Number)1L, (Instant)this.now, Collections.singleton("random"));
        Metric metric = gaugeNumber.builder().build();
        Assertions.assertEquals((int)1, (int)metric.getGauge().getDataPointsCount());
        NumberDataPoint point = metric.getGauge().getDataPoints(0);
        Assertions.assertEquals((int)2, (int)point.getAttributesCount());
        for (int i = 0; i < point.getAttributesCount(); ++i) {
            Assertions.assertTrue((point.getAttributes(i).getKey().equals("tag1") || point.getAttributes(i).getKey().equals("tag2") ? 1 : 0) != 0);
            Assertions.assertTrue((point.getAttributes(i).getValue().getStringValue().equals("value1") || point.getAttributes(i).getValue().getStringValue().equals("value2") ? 1 : 0) != 0);
        }
        gaugeNumber = SinglePointMetric.gauge((MetricKey)metricKey, (Number)1L, (Instant)this.now, Collections.singleton("tag1"));
        metric = gaugeNumber.builder().build();
        Assertions.assertEquals((int)1, (int)metric.getGauge().getDataPointsCount());
        point = metric.getGauge().getDataPoints(0);
        Assertions.assertEquals((int)1, (int)point.getAttributesCount());
        Assertions.assertEquals((Object)"tag2", (Object)point.getAttributes(0).getKey());
        Assertions.assertEquals((Object)"value2", (Object)point.getAttributes(0).getValue().getStringValue());
        gaugeNumber = SinglePointMetric.gauge((MetricKey)metricKey, (Number)1L, (Instant)this.now, tags.keySet());
        metric = gaugeNumber.builder().build();
        Assertions.assertEquals((int)1, (int)metric.getGauge().getDataPointsCount());
        point = metric.getGauge().getDataPoints(0);
        Assertions.assertEquals((int)0, (int)point.getAttributesCount());
    }

    @Test
    public void testGaugeDoubleWithExcludeLabels() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("tag1", "value1");
        tags.put("tag2", "value2");
        MetricKey metricKey = new MetricKey("name", tags);
        SinglePointMetric gaugeNumber = SinglePointMetric.gauge((MetricKey)metricKey, (double)1.0, (Instant)this.now, Collections.singleton("random"));
        Metric metric = gaugeNumber.builder().build();
        Assertions.assertEquals((int)1, (int)metric.getGauge().getDataPointsCount());
        NumberDataPoint point = metric.getGauge().getDataPoints(0);
        Assertions.assertEquals((int)2, (int)point.getAttributesCount());
        for (int i = 0; i < point.getAttributesCount(); ++i) {
            Assertions.assertTrue((point.getAttributes(i).getKey().equals("tag1") || point.getAttributes(i).getKey().equals("tag2") ? 1 : 0) != 0);
            Assertions.assertTrue((point.getAttributes(i).getValue().getStringValue().equals("value1") || point.getAttributes(i).getValue().getStringValue().equals("value2") ? 1 : 0) != 0);
        }
        gaugeNumber = SinglePointMetric.gauge((MetricKey)metricKey, (double)1.0, (Instant)this.now, Collections.singleton("tag1"));
        metric = gaugeNumber.builder().build();
        Assertions.assertEquals((int)1, (int)metric.getGauge().getDataPointsCount());
        point = metric.getGauge().getDataPoints(0);
        Assertions.assertEquals((int)1, (int)point.getAttributesCount());
        Assertions.assertEquals((Object)"tag2", (Object)point.getAttributes(0).getKey());
        Assertions.assertEquals((Object)"value2", (Object)point.getAttributes(0).getValue().getStringValue());
        gaugeNumber = SinglePointMetric.gauge((MetricKey)metricKey, (double)1.0, (Instant)this.now, tags.keySet());
        metric = gaugeNumber.builder().build();
        Assertions.assertEquals((int)1, (int)metric.getGauge().getDataPointsCount());
        point = metric.getGauge().getDataPoints(0);
        Assertions.assertEquals((int)0, (int)point.getAttributesCount());
    }

    @Test
    public void testSum() {
        SinglePointMetric sum = SinglePointMetric.sum((MetricKey)this.metricKey, (double)1.0, (boolean)false, (Instant)this.now, null, Collections.emptySet());
        MetricKey key = sum.key();
        Assertions.assertEquals((Object)"name", (Object)key.name());
        Metric metric = sum.builder().build();
        Assertions.assertFalse((boolean)metric.getSum().getIsMonotonic());
        Assertions.assertEquals((Object)AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE, (Object)metric.getSum().getAggregationTemporality());
        Assertions.assertEquals((int)1, (int)metric.getSum().getDataPointsCount());
        NumberDataPoint point = metric.getSum().getDataPoints(0);
        Assertions.assertEquals((double)((double)this.now.getEpochSecond() * Math.pow(10.0, 9.0) + (double)this.now.getNano()), (double)point.getTimeUnixNano());
        Assertions.assertEquals((long)0L, (long)point.getStartTimeUnixNano());
        Assertions.assertEquals((double)1.0, (double)point.getAsDouble());
        Assertions.assertEquals((int)0, (int)point.getAttributesCount());
    }

    @Test
    public void testSumWithStartTimeAndTags() {
        MetricKey metricKey = new MetricKey("name", Collections.singletonMap("tag", "value"));
        SinglePointMetric sum = SinglePointMetric.sum((MetricKey)metricKey, (double)1.0, (boolean)true, (Instant)this.now, (Instant)this.now, Collections.emptySet());
        MetricKey key = sum.key();
        Assertions.assertEquals((Object)"name", (Object)key.name());
        Metric metric = sum.builder().build();
        Assertions.assertTrue((boolean)metric.getSum().getIsMonotonic());
        Assertions.assertEquals((Object)AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE, (Object)metric.getSum().getAggregationTemporality());
        Assertions.assertEquals((int)1, (int)metric.getSum().getDataPointsCount());
        NumberDataPoint point = metric.getSum().getDataPoints(0);
        Assertions.assertEquals((double)((double)this.now.getEpochSecond() * Math.pow(10.0, 9.0) + (double)this.now.getNano()), (double)point.getTimeUnixNano());
        Assertions.assertEquals((double)((double)this.now.getEpochSecond() * Math.pow(10.0, 9.0) + (double)this.now.getNano()), (double)point.getStartTimeUnixNano());
        Assertions.assertEquals((double)1.0, (double)point.getAsDouble());
        Assertions.assertEquals((int)1, (int)point.getAttributesCount());
        Assertions.assertEquals((Object)"tag", (Object)point.getAttributes(0).getKey());
        Assertions.assertEquals((Object)"value", (Object)point.getAttributes(0).getValue().getStringValue());
    }

    @Test
    public void testSumWithExcludeLabels() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("tag1", "value1");
        tags.put("tag2", "value2");
        MetricKey metricKey = new MetricKey("name", tags);
        SinglePointMetric gaugeNumber = SinglePointMetric.sum((MetricKey)metricKey, (double)1.0, (boolean)true, (Instant)this.now, Collections.singleton("random"));
        Metric metric = gaugeNumber.builder().build();
        Assertions.assertEquals((int)1, (int)metric.getSum().getDataPointsCount());
        NumberDataPoint point = metric.getSum().getDataPoints(0);
        Assertions.assertEquals((int)2, (int)point.getAttributesCount());
        for (int i = 0; i < point.getAttributesCount(); ++i) {
            Assertions.assertTrue((point.getAttributes(i).getKey().equals("tag1") || point.getAttributes(i).getKey().equals("tag2") ? 1 : 0) != 0);
            Assertions.assertTrue((point.getAttributes(i).getValue().getStringValue().equals("value1") || point.getAttributes(i).getValue().getStringValue().equals("value2") ? 1 : 0) != 0);
        }
        gaugeNumber = SinglePointMetric.sum((MetricKey)metricKey, (double)1.0, (boolean)true, (Instant)this.now, Collections.singleton("tag1"));
        metric = gaugeNumber.builder().build();
        Assertions.assertEquals((int)1, (int)metric.getSum().getDataPointsCount());
        point = metric.getSum().getDataPoints(0);
        Assertions.assertEquals((int)1, (int)point.getAttributesCount());
        Assertions.assertEquals((Object)"tag2", (Object)point.getAttributes(0).getKey());
        Assertions.assertEquals((Object)"value2", (Object)point.getAttributes(0).getValue().getStringValue());
        gaugeNumber = SinglePointMetric.sum((MetricKey)metricKey, (double)1.0, (boolean)true, (Instant)this.now, tags.keySet());
        metric = gaugeNumber.builder().build();
        Assertions.assertEquals((int)1, (int)metric.getSum().getDataPointsCount());
        point = metric.getSum().getDataPoints(0);
        Assertions.assertEquals((int)0, (int)point.getAttributesCount());
    }

    @Test
    public void testDeltaSum() {
        SinglePointMetric sum = SinglePointMetric.deltaSum((MetricKey)this.metricKey, (double)1.0, (boolean)true, (Instant)this.now, (Instant)this.now, Collections.emptySet());
        MetricKey key = sum.key();
        Assertions.assertEquals((Object)"name", (Object)key.name());
        Metric metric = sum.builder().build();
        Assertions.assertTrue((boolean)metric.getSum().getIsMonotonic());
        Assertions.assertEquals((Object)AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA, (Object)metric.getSum().getAggregationTemporality());
        Assertions.assertEquals((int)1, (int)metric.getSum().getDataPointsCount());
        NumberDataPoint point = metric.getSum().getDataPoints(0);
        Assertions.assertEquals((double)((double)this.now.getEpochSecond() * Math.pow(10.0, 9.0) + (double)this.now.getNano()), (double)point.getTimeUnixNano());
        Assertions.assertEquals((double)((double)this.now.getEpochSecond() * Math.pow(10.0, 9.0) + (double)this.now.getNano()), (double)point.getStartTimeUnixNano());
        Assertions.assertEquals((double)1.0, (double)point.getAsDouble());
        Assertions.assertEquals((int)0, (int)point.getAttributesCount());
    }

    @Test
    public void testDeltaSumWithExcludeLabels() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("tag1", "value1");
        tags.put("tag2", "value2");
        MetricKey metricKey = new MetricKey("name", tags);
        SinglePointMetric gaugeNumber = SinglePointMetric.deltaSum((MetricKey)metricKey, (double)1.0, (boolean)true, (Instant)this.now, (Instant)this.now, Collections.singleton("random"));
        Metric metric = gaugeNumber.builder().build();
        Assertions.assertEquals((int)1, (int)metric.getSum().getDataPointsCount());
        NumberDataPoint point = metric.getSum().getDataPoints(0);
        Assertions.assertEquals((int)2, (int)point.getAttributesCount());
        for (int i = 0; i < point.getAttributesCount(); ++i) {
            Assertions.assertTrue((point.getAttributes(i).getKey().equals("tag1") || point.getAttributes(i).getKey().equals("tag2") ? 1 : 0) != 0);
            Assertions.assertTrue((point.getAttributes(i).getValue().getStringValue().equals("value1") || point.getAttributes(i).getValue().getStringValue().equals("value2") ? 1 : 0) != 0);
        }
        gaugeNumber = SinglePointMetric.deltaSum((MetricKey)metricKey, (double)1.0, (boolean)true, (Instant)this.now, (Instant)this.now, Collections.singleton("tag1"));
        metric = gaugeNumber.builder().build();
        Assertions.assertEquals((int)1, (int)metric.getSum().getDataPointsCount());
        point = metric.getSum().getDataPoints(0);
        Assertions.assertEquals((int)1, (int)point.getAttributesCount());
        Assertions.assertEquals((Object)"tag2", (Object)point.getAttributes(0).getKey());
        Assertions.assertEquals((Object)"value2", (Object)point.getAttributes(0).getValue().getStringValue());
        gaugeNumber = SinglePointMetric.deltaSum((MetricKey)metricKey, (double)1.0, (boolean)true, (Instant)this.now, (Instant)this.now, tags.keySet());
        metric = gaugeNumber.builder().build();
        Assertions.assertEquals((int)1, (int)metric.getSum().getDataPointsCount());
        point = metric.getSum().getDataPoints(0);
        Assertions.assertEquals((int)0, (int)point.getAttributesCount());
    }
}

