/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.admin.internals.AdminFetchMetricsManager;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AdminFetchMetricsManagerTest {
    private static final double EPSILON = 1.0E-4;
    private final Time time = new MockTime(1L, 0L, 0L);
    private Metrics metrics;
    private AdminFetchMetricsManager adminFetchMetricsManager;
    private final String group = "group";

    @BeforeEach
    public void setup() {
        this.metrics = new Metrics(this.time);
        this.adminFetchMetricsManager = new AdminFetchMetricsManager(this.metrics);
    }

    @AfterEach
    public void tearDown() {
        Utils.closeQuietly((AutoCloseable)this.metrics, (String)"metrics");
        this.metrics = null;
        this.adminFetchMetricsManager = null;
    }

    @Test
    public void testSingleNodeLatency() {
        String connectionId = "0";
        MetricName nodeLatencyAvg = this.metrics.metricName("request-latency-avg", "group");
        MetricName nodeLatencyMax = this.metrics.metricName("request-latency-max", "group");
        this.registerNodeLatencyMetric(connectionId, nodeLatencyAvg, nodeLatencyMax);
        this.adminFetchMetricsManager.recordLatency(connectionId, 333L);
        this.mockSleepTimeWindow();
        this.adminFetchMetricsManager.recordLatency(connectionId, 444L);
        Assertions.assertEquals((double)388.5, (double)this.metricValue(nodeLatencyAvg), (double)1.0E-4);
        Assertions.assertEquals((double)444.0, (double)this.metricValue(nodeLatencyMax), (double)1.0E-4);
        this.adminFetchMetricsManager.recordLatency(connectionId, 666L);
        Assertions.assertEquals((double)481.0, (double)this.metricValue(nodeLatencyAvg), (double)1.0E-4);
        Assertions.assertEquals((double)666.0, (double)this.metricValue(nodeLatencyMax), (double)1.0E-4);
        this.mockSleepTimeWindow();
        Assertions.assertEquals((double)555.0, (double)this.metricValue(nodeLatencyAvg), (double)1.0E-4);
        Assertions.assertEquals((double)666.0, (double)this.metricValue(nodeLatencyMax), (double)1.0E-4);
        this.mockSleepTimeWindow();
        Assertions.assertTrue((boolean)Double.isNaN(this.metricValue(nodeLatencyAvg)));
        Assertions.assertTrue((boolean)Double.isNaN(this.metricValue(nodeLatencyMax)));
    }

    @Test
    public void testMultiNodeLatency() {
        String connectionId0 = "0";
        MetricName nodeLatencyAvg0 = this.metrics.metricName("request-latency-avg", "group", this.genericTag(connectionId0));
        MetricName nodeLatencyMax0 = this.metrics.metricName("request-latency-max", "group", this.genericTag(connectionId0));
        this.registerNodeLatencyMetric(connectionId0, nodeLatencyAvg0, nodeLatencyMax0);
        this.adminFetchMetricsManager.recordLatency(connectionId0, 5L);
        this.adminFetchMetricsManager.recordLatency(connectionId0, 8L);
        String connectionId1 = "1";
        MetricName nodeLatencyAvg1 = this.metrics.metricName("request-latency-avg", "group", this.genericTag(connectionId1));
        MetricName nodeLatencyMax1 = this.metrics.metricName("request-latency-max", "group", this.genericTag(connectionId1));
        this.registerNodeLatencyMetric(connectionId1, nodeLatencyAvg1, nodeLatencyMax1);
        this.adminFetchMetricsManager.recordLatency(connectionId1, 105L);
        this.adminFetchMetricsManager.recordLatency(connectionId1, 108L);
        Assertions.assertEquals((double)6.5, (double)this.metricValue(nodeLatencyAvg0), (double)1.0E-4);
        Assertions.assertEquals((double)8.0, (double)this.metricValue(nodeLatencyMax0), (double)1.0E-4);
        Assertions.assertEquals((double)106.5, (double)this.metricValue(nodeLatencyAvg1), (double)1.0E-4);
        Assertions.assertEquals((double)108.0, (double)this.metricValue(nodeLatencyMax1), (double)1.0E-4);
        this.mockSleepTimeWindow();
        this.adminFetchMetricsManager.recordLatency(connectionId0, 11L);
        this.adminFetchMetricsManager.recordLatency(connectionId1, 111L);
        Assertions.assertEquals((double)8.0, (double)this.metricValue(nodeLatencyAvg0), (double)1.0E-4);
        Assertions.assertEquals((double)11.0, (double)this.metricValue(nodeLatencyMax0), (double)1.0E-4);
        Assertions.assertEquals((double)108.0, (double)this.metricValue(nodeLatencyAvg1), (double)1.0E-4);
        Assertions.assertEquals((double)111.0, (double)this.metricValue(nodeLatencyMax1), (double)1.0E-4);
        this.mockSleepTimeWindow();
        Assertions.assertEquals((double)11.0, (double)this.metricValue(nodeLatencyAvg0), (double)1.0E-4);
        Assertions.assertEquals((double)11.0, (double)this.metricValue(nodeLatencyMax0), (double)1.0E-4);
        Assertions.assertEquals((double)111.0, (double)this.metricValue(nodeLatencyAvg1), (double)1.0E-4);
        Assertions.assertEquals((double)111.0, (double)this.metricValue(nodeLatencyMax1), (double)1.0E-4);
        this.mockSleepTimeWindow();
        Assertions.assertTrue((boolean)Double.isNaN(this.metricValue(nodeLatencyAvg0)));
        Assertions.assertTrue((boolean)Double.isNaN(this.metricValue(nodeLatencyMax0)));
        Assertions.assertTrue((boolean)Double.isNaN(this.metricValue(nodeLatencyAvg1)));
        Assertions.assertTrue((boolean)Double.isNaN(this.metricValue(nodeLatencyMax1)));
        this.adminFetchMetricsManager.recordLatency(connectionId0, 500L);
        this.adminFetchMetricsManager.recordLatency(connectionId0, 600L);
        this.mockSleepTimeWindow();
        this.adminFetchMetricsManager.recordLatency(connectionId1, 800L);
        this.adminFetchMetricsManager.recordLatency(connectionId1, 900L);
        Assertions.assertEquals((double)550.0, (double)this.metricValue(nodeLatencyAvg0), (double)1.0E-4);
        Assertions.assertEquals((double)600.0, (double)this.metricValue(nodeLatencyMax0), (double)1.0E-4);
        Assertions.assertEquals((double)850.0, (double)this.metricValue(nodeLatencyAvg1), (double)1.0E-4);
        Assertions.assertEquals((double)900.0, (double)this.metricValue(nodeLatencyMax1), (double)1.0E-4);
        this.mockSleepTimeWindow();
        Assertions.assertTrue((boolean)Double.isNaN(this.metricValue(nodeLatencyAvg0)));
        Assertions.assertTrue((boolean)Double.isNaN(this.metricValue(nodeLatencyMax0)));
        Assertions.assertEquals((double)850.0, (double)this.metricValue(nodeLatencyAvg1), (double)1.0E-4);
        Assertions.assertEquals((double)900.0, (double)this.metricValue(nodeLatencyMax1), (double)1.0E-4);
        this.mockSleepTimeWindow();
        Assertions.assertTrue((boolean)Double.isNaN(this.metricValue(nodeLatencyAvg1)));
        Assertions.assertTrue((boolean)Double.isNaN(this.metricValue(nodeLatencyMax1)));
    }

    private Map<String, String> genericTag(String connectionId) {
        return Collections.singletonMap("node-id", "node-" + connectionId);
    }

    private void mockSleepTimeWindow() {
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
    }

    private void registerNodeLatencyMetric(String connectionId, MetricName nodeLatencyAvg, MetricName nodeLatencyMax) {
        String nodeTimeName = "node-" + connectionId + ".latency";
        Sensor nodeRequestTime = this.metrics.sensor(nodeTimeName);
        nodeRequestTime.add(nodeLatencyAvg, (MeasurableStat)new Avg());
        nodeRequestTime.add(nodeLatencyMax, (MeasurableStat)new Max());
    }

    private double metricValue(MetricName metricName) {
        KafkaMetric metric = this.metrics.metric(metricName);
        return (Double)metric.metricValue();
    }
}

