/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractPartitionAssignorTest;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;

public class RangeAssignorTest {
    private final RangeAssignor assignor = new RangeAssignor();
    private final String topic1 = "topic1";
    private final String topic2 = "topic2";
    private final String consumer1 = "consumer1";
    private final String instance1 = "instance1";
    private final String consumer2 = "consumer2";
    private final String instance2 = "instance2";
    private final String consumer3 = "consumer3";
    private final String instance3 = "instance3";
    private int numBrokerRacks;
    private boolean hasConsumerRack;
    private List<AbstractPartitionAssignor.MemberInfo> staticMemberInfos;
    private int replicationFactor = 3;

    @BeforeEach
    public void setUp() {
        this.staticMemberInfos = new ArrayList<AbstractPartitionAssignor.MemberInfo>();
        this.staticMemberInfos.add(new AbstractPartitionAssignor.MemberInfo("consumer1", Optional.of("instance1")));
        this.staticMemberInfos.add(new AbstractPartitionAssignor.MemberInfo("consumer2", Optional.of("instance2")));
        this.staticMemberInfos.add(new AbstractPartitionAssignor.MemberInfo("consumer3", Optional.of("instance3")));
    }

    @ParameterizedTest(name="{displayName}.hasConsumerRack = {0}")
    @ValueSource(booleans={true, false})
    public void testOneConsumerNoTopic(boolean hasConsumerRack) {
        this.initializeRacks(hasConsumerRack ? AbstractPartitionAssignorTest.RackConfig.BROKER_AND_CONSUMER_RACK : AbstractPartitionAssignorTest.RackConfig.NO_CONSUMER_RACK);
        HashMap partitionsPerTopic = new HashMap();
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, Collections.singletonMap("consumer1", this.subscription(Collections.emptyList(), 0)));
        Assertions.assertEquals(Collections.singleton("consumer1"), assignment.keySet());
        Assertions.assertTrue((boolean)((List)assignment.get("consumer1")).isEmpty());
    }

    @ParameterizedTest(name="{displayName}.hasConsumerRack = {0}")
    @ValueSource(booleans={true, false})
    public void testOneConsumerNonexistentTopic(boolean hasConsumerRack) {
        this.initializeRacks(hasConsumerRack ? AbstractPartitionAssignorTest.RackConfig.BROKER_AND_CONSUMER_RACK : AbstractPartitionAssignorTest.RackConfig.NO_CONSUMER_RACK);
        HashMap partitionsPerTopic = new HashMap();
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, Collections.singletonMap("consumer1", this.subscription(RangeAssignorTest.topics("topic1"), 0)));
        Assertions.assertEquals(Collections.singleton("consumer1"), assignment.keySet());
        Assertions.assertTrue((boolean)((List)assignment.get("consumer1")).isEmpty());
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testOneConsumerOneTopic(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put("topic1", this.partitionInfos("topic1", 3));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, Collections.singletonMap("consumer1", this.subscription(RangeAssignorTest.topics("topic1"), 0)));
        Assertions.assertEquals(Collections.singleton("consumer1"), assignment.keySet());
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 0), RangeAssignorTest.tp("topic1", 1), RangeAssignorTest.tp("topic1", 2)), (List)assignment.get("consumer1"));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testOnlyAssignsPartitionsFromSubscribedTopics(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        String otherTopic = "other";
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put("topic1", this.partitionInfos("topic1", 3));
        partitionsPerTopic.put(otherTopic, this.partitionInfos(otherTopic, 3));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, Collections.singletonMap("consumer1", this.subscription(RangeAssignorTest.topics("topic1"), 0)));
        Assertions.assertEquals(Collections.singleton("consumer1"), assignment.keySet());
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 0), RangeAssignorTest.tp("topic1", 1), RangeAssignorTest.tp("topic1", 2)), (List)assignment.get("consumer1"));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testOneConsumerMultipleTopics(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        Map<String, List<PartitionInfo>> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(1, 2);
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, Collections.singletonMap("consumer1", this.subscription(RangeAssignorTest.topics("topic1", "topic2"), 0)));
        Assertions.assertEquals(Collections.singleton("consumer1"), assignment.keySet());
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 0), RangeAssignorTest.tp("topic2", 0), RangeAssignorTest.tp("topic2", 1)), (List)assignment.get("consumer1"));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testTwoConsumersOneTopicOnePartition(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put("topic1", this.partitionInfos("topic1", 1));
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        consumers.put("consumer1", this.subscription(RangeAssignorTest.topics("topic1"), 0));
        consumers.put("consumer2", this.subscription(RangeAssignorTest.topics("topic1"), 1));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, consumers);
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 0)), (List)assignment.get("consumer1"));
        this.assertAssignment(Collections.emptyList(), (List)assignment.get("consumer2"));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testTwoConsumersOneTopicTwoPartitions(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put("topic1", this.partitionInfos("topic1", 2));
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        consumers.put("consumer1", this.subscription(RangeAssignorTest.topics("topic1"), 0));
        consumers.put("consumer2", this.subscription(RangeAssignorTest.topics("topic1"), 1));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, consumers);
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 0)), (List)assignment.get("consumer1"));
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 1)), (List)assignment.get("consumer2"));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testMultipleConsumersMixedTopics(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        Map<String, List<PartitionInfo>> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(3, 2);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        consumers.put("consumer1", this.subscription(RangeAssignorTest.topics("topic1"), 0));
        consumers.put("consumer2", this.subscription(RangeAssignorTest.topics("topic1", "topic2"), 1));
        consumers.put("consumer3", this.subscription(RangeAssignorTest.topics("topic1"), 2));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, consumers);
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 0)), (List)assignment.get("consumer1"));
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 1), RangeAssignorTest.tp("topic2", 0), RangeAssignorTest.tp("topic2", 1)), (List)assignment.get("consumer2"));
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 2)), (List)assignment.get("consumer3"));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testTwoConsumersTwoTopicsSixPartitions(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        String topic1 = "topic1";
        String topic2 = "topic2";
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        Map<String, List<PartitionInfo>> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(3, 3);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        consumers.put(consumer1, this.subscription(RangeAssignorTest.topics(topic1, topic2), 0));
        consumers.put(consumer2, this.subscription(RangeAssignorTest.topics(topic1, topic2), 1));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, consumers);
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(topic1, 0), RangeAssignorTest.tp(topic1, 1), RangeAssignorTest.tp(topic2, 0), RangeAssignorTest.tp(topic2, 1)), (List)assignment.get(consumer1));
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp(topic1, 2), RangeAssignorTest.tp(topic2, 2)), (List)assignment.get(consumer2));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testTwoStaticConsumersTwoTopicsSixPartitions(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        String consumerIdLow = "consumer-b";
        String consumerIdHigh = "consumer-a";
        Map<String, List<PartitionInfo>> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(3, 3);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        ConsumerPartitionAssignor.Subscription consumerLowSubscription = this.subscription(RangeAssignorTest.topics("topic1", "topic2"), 0);
        consumerLowSubscription.setGroupInstanceId(Optional.of("instance1"));
        consumers.put(consumerIdLow, consumerLowSubscription);
        ConsumerPartitionAssignor.Subscription consumerHighSubscription = this.subscription(RangeAssignorTest.topics("topic1", "topic2"), 1);
        consumerHighSubscription.setGroupInstanceId(Optional.of("instance2"));
        consumers.put(consumerIdHigh, consumerHighSubscription);
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, consumers);
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 0), RangeAssignorTest.tp("topic1", 1), RangeAssignorTest.tp("topic2", 0), RangeAssignorTest.tp("topic2", 1)), (List)assignment.get(consumerIdLow));
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 2), RangeAssignorTest.tp("topic2", 2)), (List)assignment.get(consumerIdHigh));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testOneStaticConsumerAndOneDynamicConsumerTwoTopicsSixPartitions(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        String consumerIdLow = "consumer-b";
        String consumerIdHigh = "consumer-a";
        Map<String, List<PartitionInfo>> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(3, 3);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        ConsumerPartitionAssignor.Subscription consumerLowSubscription = this.subscription(RangeAssignorTest.topics("topic1", "topic2"), 0);
        consumerLowSubscription.setGroupInstanceId(Optional.of("instance1"));
        consumers.put(consumerIdLow, consumerLowSubscription);
        consumers.put(consumerIdHigh, this.subscription(RangeAssignorTest.topics("topic1", "topic2"), 1));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, consumers);
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 0), RangeAssignorTest.tp("topic1", 1), RangeAssignorTest.tp("topic2", 0), RangeAssignorTest.tp("topic2", 1)), (List)assignment.get(consumerIdLow));
        this.assertAssignment(RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 2), RangeAssignorTest.tp("topic2", 2)), (List)assignment.get(consumerIdHigh));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testStaticMemberRangeAssignmentPersistent(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig, 5);
        Map<String, List<PartitionInfo>> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(5, 4);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        int consumerIndex = 0;
        for (AbstractPartitionAssignor.MemberInfo m : this.staticMemberInfos) {
            ConsumerPartitionAssignor.Subscription subscription = this.subscription(RangeAssignorTest.topics("topic1", "topic2"), consumerIndex++);
            subscription.setGroupInstanceId(m.groupInstanceId);
            consumers.put(m.memberId, subscription);
        }
        String consumer4 = "consumer4";
        consumers.put(consumer4, this.subscription(RangeAssignorTest.topics("topic1", "topic2"), consumerIndex++));
        HashMap<String, List<TopicPartition>> expectedAssignment = new HashMap<String, List<TopicPartition>>();
        expectedAssignment.put("consumer1", RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 0), RangeAssignorTest.tp("topic1", 1), RangeAssignorTest.tp("topic2", 0)));
        expectedAssignment.put("consumer2", RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 2), RangeAssignorTest.tp("topic2", 1)));
        expectedAssignment.put("consumer3", RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 3), RangeAssignorTest.tp("topic2", 2)));
        expectedAssignment.put(consumer4, RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 4), RangeAssignorTest.tp("topic2", 3)));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, consumers);
        Assertions.assertEquals(expectedAssignment, (Object)assignment);
        consumers.remove(consumer4);
        String consumer5 = "consumer5";
        consumers.put(consumer5, this.subscription(RangeAssignorTest.topics("topic1", "topic2"), consumerIndex++));
        expectedAssignment.remove(consumer4);
        expectedAssignment.put(consumer5, RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 4), RangeAssignorTest.tp("topic2", 3)));
        assignment = this.assignor.assignPartitions(partitionsPerTopic, consumers);
        Assertions.assertEquals(expectedAssignment, (Object)assignment);
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testStaticMemberRangeAssignmentPersistentAfterMemberIdChanges(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        Map<String, List<PartitionInfo>> partitionsPerTopic = this.setupPartitionsPerTopicWithTwoTopics(5, 5);
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        int consumerIndex = 0;
        for (AbstractPartitionAssignor.MemberInfo m : this.staticMemberInfos) {
            ConsumerPartitionAssignor.Subscription subscription = this.subscription(RangeAssignorTest.topics("topic1", "topic2"), consumerIndex++);
            subscription.setGroupInstanceId(m.groupInstanceId);
            consumers.put(m.memberId, subscription);
        }
        HashMap<String, List<TopicPartition>> expectedInstanceAssignment = new HashMap<String, List<TopicPartition>>();
        expectedInstanceAssignment.put("instance1", RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 0), RangeAssignorTest.tp("topic1", 1), RangeAssignorTest.tp("topic2", 0), RangeAssignorTest.tp("topic2", 1)));
        expectedInstanceAssignment.put("instance2", RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 2), RangeAssignorTest.tp("topic1", 3), RangeAssignorTest.tp("topic2", 2), RangeAssignorTest.tp("topic2", 3)));
        expectedInstanceAssignment.put("instance3", RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 4), RangeAssignorTest.tp("topic2", 4)));
        Map<String, List<TopicPartition>> staticAssignment = RangeAssignorTest.checkStaticAssignment((AbstractPartitionAssignor)this.assignor, partitionsPerTopic, consumers);
        Assertions.assertEquals(expectedInstanceAssignment, staticAssignment);
        String consumer4 = "consumer4";
        String consumer5 = "consumer5";
        consumers.put(consumer4, (ConsumerPartitionAssignor.Subscription)consumers.get("consumer3"));
        consumers.remove("consumer3");
        consumers.put(consumer5, (ConsumerPartitionAssignor.Subscription)consumers.get("consumer2"));
        consumers.remove("consumer2");
        Map<String, List<TopicPartition>> newStaticAssignment = RangeAssignorTest.checkStaticAssignment((AbstractPartitionAssignor)this.assignor, partitionsPerTopic, consumers);
        Assertions.assertEquals(staticAssignment, newStaticAssignment);
    }

    @Test
    public void testRackAwareStaticMemberRangeAssignmentPersistentAfterMemberIdChanges() {
        this.initializeRacks(AbstractPartitionAssignorTest.RackConfig.BROKER_AND_CONSUMER_RACK);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        int replicationFactor = 2;
        int numBrokerRacks = 3;
        partitionsPerTopic.put("topic1", AbstractPartitionAssignorTest.partitionInfos("topic1", 5, replicationFactor, numBrokerRacks, 0));
        partitionsPerTopic.put("topic2", AbstractPartitionAssignorTest.partitionInfos("topic2", 5, replicationFactor, numBrokerRacks, 0));
        ArrayList<AbstractPartitionAssignor.MemberInfo> staticMemberInfos = new ArrayList<AbstractPartitionAssignor.MemberInfo>();
        staticMemberInfos.add(new AbstractPartitionAssignor.MemberInfo("consumer1", Optional.of("instance1"), Optional.of(AbstractPartitionAssignorTest.ALL_RACKS[0])));
        staticMemberInfos.add(new AbstractPartitionAssignor.MemberInfo("consumer2", Optional.of("instance2"), Optional.of(AbstractPartitionAssignorTest.ALL_RACKS[1])));
        staticMemberInfos.add(new AbstractPartitionAssignor.MemberInfo("consumer3", Optional.of("instance3"), Optional.of(AbstractPartitionAssignorTest.ALL_RACKS[2])));
        HashMap<String, ConsumerPartitionAssignor.Subscription> consumers = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        int consumerIndex = 0;
        for (AbstractPartitionAssignor.MemberInfo m : staticMemberInfos) {
            ConsumerPartitionAssignor.Subscription subscription = this.subscription(RangeAssignorTest.topics("topic1", "topic2"), consumerIndex++);
            subscription.setGroupInstanceId(m.groupInstanceId);
            consumers.put(m.memberId, subscription);
        }
        HashMap<String, List<TopicPartition>> expectedInstanceAssignment = new HashMap<String, List<TopicPartition>>();
        expectedInstanceAssignment.put("instance1", RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 0), RangeAssignorTest.tp("topic1", 2), RangeAssignorTest.tp("topic2", 0), RangeAssignorTest.tp("topic2", 2)));
        expectedInstanceAssignment.put("instance2", RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 1), RangeAssignorTest.tp("topic1", 3), RangeAssignorTest.tp("topic2", 1), RangeAssignorTest.tp("topic2", 3)));
        expectedInstanceAssignment.put("instance3", RangeAssignorTest.partitions(RangeAssignorTest.tp("topic1", 4), RangeAssignorTest.tp("topic2", 4)));
        Map<String, List<TopicPartition>> staticAssignment = RangeAssignorTest.checkStaticAssignment((AbstractPartitionAssignor)this.assignor, partitionsPerTopic, consumers);
        Assertions.assertEquals(expectedInstanceAssignment, staticAssignment);
        String consumer4 = "consumer4";
        String consumer5 = "consumer5";
        consumers.put(consumer4, (ConsumerPartitionAssignor.Subscription)consumers.get("consumer3"));
        consumers.remove("consumer3");
        consumers.put(consumer5, (ConsumerPartitionAssignor.Subscription)consumers.get("consumer2"));
        consumers.remove("consumer2");
        Map<String, List<TopicPartition>> newStaticAssignment = RangeAssignorTest.checkStaticAssignment((AbstractPartitionAssignor)this.assignor, partitionsPerTopic, consumers);
        Assertions.assertEquals(staticAssignment, newStaticAssignment);
    }

    @Test
    public void testRackAwareAssignmentWithUniformSubscription() {
        Map topics = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"t1", (Object)6), Utils.mkEntry((Object)"t2", (Object)7), Utils.mkEntry((Object)"t3", (Object)2)});
        List<String> allTopics = Arrays.asList("t1", "t2", "t3");
        List<List<String>> consumerTopics = Arrays.asList(allTopics, allTopics, allTopics);
        this.verifyNonRackAwareAssignment(topics, consumerTopics, Arrays.asList("t1-0, t1-1, t2-0, t2-1, t2-2, t3-0", "t1-2, t1-3, t2-3, t2-4, t3-1", "t1-4, t1-5, t2-5, t2-6"));
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 1, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, Arrays.asList("t1-0, t1-3, t2-0, t2-3, t2-6", "t1-1, t1-4, t2-1, t2-4, t3-0", "t1-2, t1-5, t2-2, t2-5, t3-1"), 0);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 2, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, Arrays.asList("t1-0, t1-2, t2-0, t2-2, t2-3, t3-1", "t1-1, t1-3, t2-1, t2-4, t3-0", "t1-4, t1-5, t2-5, t2-6"), 1);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(2), AbstractPartitionAssignorTest.racks(3), consumerTopics, Arrays.asList("t1-0, t1-1, t2-0, t2-1, t2-2, t3-0", "t1-2, t1-3, t2-3, t2-4, t3-1", "t1-4, t1-5, t2-5, t2-6"), 4);
    }

    @Test
    public void testRackAwareAssignmentWithNonEqualSubscription() {
        Map topics = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"t1", (Object)6), Utils.mkEntry((Object)"t2", (Object)7), Utils.mkEntry((Object)"t3", (Object)2)});
        List<String> allTopics = Arrays.asList("t1", "t2", "t3");
        List<List<String>> consumerTopics = Arrays.asList(allTopics, allTopics, Arrays.asList("t1", "t3"));
        this.verifyNonRackAwareAssignment(topics, consumerTopics, Arrays.asList("t1-0, t1-1, t2-0, t2-1, t2-2, t2-3, t3-0", "t1-2, t1-3, t2-4, t2-5, t2-6, t3-1", "t1-4, t1-5"));
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 1, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, Arrays.asList("t1-0, t1-3, t2-0, t2-2, t2-3, t2-6", "t1-1, t1-4, t2-1, t2-4, t2-5, t3-0", "t1-2, t1-5, t3-1"), 2);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 2, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, Arrays.asList("t1-0, t1-2, t2-0, t2-2, t2-3, t2-5, t3-1", "t1-1, t1-3, t2-1, t2-4, t2-6, t3-0", "t1-4, t1-5"), 0);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(2), AbstractPartitionAssignorTest.racks(3), consumerTopics, Arrays.asList("t1-0, t1-1, t2-0, t2-1, t2-2, t2-3, t3-0", "t1-2, t1-3, t2-4, t2-5, t2-6, t3-1", "t1-4, t1-5"), 2);
    }

    @Test
    public void testRackAwareAssignmentWithUniformPartitions() {
        Map topics = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"t1", (Object)5), Utils.mkEntry((Object)"t2", (Object)5), Utils.mkEntry((Object)"t3", (Object)5)});
        List<String> allTopics = Arrays.asList("t1", "t2", "t3");
        List<List<String>> consumerTopics = Arrays.asList(allTopics, allTopics, allTopics);
        List<String> nonRackAwareAssignment = Arrays.asList("t1-0, t1-1, t2-0, t2-1, t3-0, t3-1", "t1-2, t1-3, t2-2, t2-3, t3-2, t3-3", "t1-4, t2-4, t3-4");
        this.verifyNonRackAwareAssignment(topics, consumerTopics, nonRackAwareAssignment);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 1, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, nonRackAwareAssignment, 10);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 2, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, nonRackAwareAssignment, 5);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(2), AbstractPartitionAssignorTest.racks(3), consumerTopics, nonRackAwareAssignment, 3);
    }

    @Test
    public void testRackAwareAssignmentWithUniformPartitionsNonEqualSubscription() {
        Map topics = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"t1", (Object)5), Utils.mkEntry((Object)"t2", (Object)5), Utils.mkEntry((Object)"t3", (Object)5)});
        List<String> allTopics = Arrays.asList("t1", "t2", "t3");
        List<List<String>> consumerTopics = Arrays.asList(allTopics, allTopics, Arrays.asList("t1", "t3"));
        this.verifyNonRackAwareAssignment(topics, consumerTopics, Arrays.asList("t1-0, t1-1, t2-0, t2-1, t2-2, t3-0, t3-1", "t1-2, t1-3, t2-3, t2-4, t3-2, t3-3", "t1-4, t3-4"));
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 1, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, Arrays.asList("t1-0, t1-1, t2-0, t2-1, t2-4, t3-0, t3-1", "t1-2, t1-3, t2-2, t2-3, t3-2, t3-3", "t1-4, t3-4"), 9);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 2, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, Arrays.asList("t1-2, t2-0, t2-1, t2-3, t3-2", "t1-0, t1-3, t2-2, t2-4, t3-0, t3-3", "t1-1, t1-4, t3-1, t3-4"), 0);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(2), AbstractPartitionAssignorTest.racks(3), consumerTopics, Arrays.asList("t1-0, t1-1, t2-0, t2-1, t2-2, t3-0, t3-1", "t1-2, t1-3, t2-3, t2-4, t3-2, t3-3", "t1-4, t3-4"), 2);
    }

    @Test
    public void testRackAwareAssignmentWithCoPartitioning() {
        Map topics = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"t1", (Object)6), Utils.mkEntry((Object)"t2", (Object)6), Utils.mkEntry((Object)"t3", (Object)2), Utils.mkEntry((Object)"t4", (Object)2)});
        List<List<String>> consumerTopics = Arrays.asList(Arrays.asList("t1", "t2"), Arrays.asList("t1", "t2"), Arrays.asList("t3", "t4"), Arrays.asList("t3", "t4"));
        List<String> consumerRacks = Arrays.asList(AbstractPartitionAssignorTest.ALL_RACKS[0], AbstractPartitionAssignorTest.ALL_RACKS[1], AbstractPartitionAssignorTest.ALL_RACKS[1], AbstractPartitionAssignorTest.ALL_RACKS[0]);
        List<String> nonRackAwareAssignment = Arrays.asList("t1-0, t1-1, t1-2, t2-0, t2-1, t2-2", "t1-3, t1-4, t1-5, t2-3, t2-4, t2-5", "t3-0, t4-0", "t3-1, t4-1");
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(2), consumerRacks, consumerTopics, nonRackAwareAssignment, -1);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(2), consumerRacks, consumerTopics, nonRackAwareAssignment, -1);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 2, AbstractPartitionAssignorTest.racks(2), consumerRacks, consumerTopics, nonRackAwareAssignment, 0);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 1, AbstractPartitionAssignorTest.racks(2), consumerRacks, consumerTopics, Arrays.asList("t1-0, t1-2, t1-4, t2-0, t2-2, t2-4", "t1-1, t1-3, t1-5, t2-1, t2-3, t2-5", "t3-1, t4-1", "t3-0, t4-0"), 0);
        List<String> allTopics = Arrays.asList("t1", "t2", "t3", "t4");
        consumerTopics = Arrays.asList(allTopics, allTopics, allTopics, allTopics);
        nonRackAwareAssignment = Arrays.asList("t1-0, t1-1, t2-0, t2-1, t3-0, t4-0", "t1-2, t1-3, t2-2, t2-3, t3-1, t4-1", "t1-4, t2-4", "t1-5, t2-5");
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(2), consumerRacks, consumerTopics, nonRackAwareAssignment, -1);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(2), consumerRacks, consumerTopics, nonRackAwareAssignment, -1);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 2, AbstractPartitionAssignorTest.racks(2), consumerRacks, consumerTopics, nonRackAwareAssignment, 0);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 1, AbstractPartitionAssignorTest.racks(2), consumerRacks, consumerTopics, Arrays.asList("t1-0, t1-2, t2-0, t2-2, t3-0, t4-0", "t1-1, t1-3, t2-1, t2-3, t3-1, t4-1", "t1-5, t2-5", "t1-4, t2-4"), 0);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 1, AbstractPartitionAssignorTest.racks(3), consumerRacks, consumerTopics, Arrays.asList("t1-0, t1-3, t2-0, t2-3, t3-0, t4-0", "t1-1, t1-4, t2-1, t2-4, t3-1, t4-1", "t1-2, t2-2", "t1-5, t2-5"), 6);
    }

    @Test
    public void testCoPartitionedAssignmentWithSameSubscription() {
        Map topics = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"t1", (Object)6), Utils.mkEntry((Object)"t2", (Object)6), Utils.mkEntry((Object)"t3", (Object)2), Utils.mkEntry((Object)"t4", (Object)2), Utils.mkEntry((Object)"t5", (Object)4), Utils.mkEntry((Object)"t6", (Object)4)});
        List<String> topicList = Arrays.asList("t1", "t2", "t3", "t4", "t5", "t6", "t7", "t8", "t9");
        List<List<String>> consumerTopics = Arrays.asList(topicList, topicList, topicList);
        List<String> consumerRacks = Arrays.asList(AbstractPartitionAssignorTest.ALL_RACKS[0], AbstractPartitionAssignorTest.ALL_RACKS[1], AbstractPartitionAssignorTest.ALL_RACKS[2]);
        List<String> nonRackAwareAssignment = Arrays.asList("t1-0, t1-1, t2-0, t2-1, t3-0, t4-0, t5-0, t5-1, t6-0, t6-1", "t1-2, t1-3, t2-2, t2-3, t3-1, t4-1, t5-2, t6-2", "t1-4, t1-5, t2-4, t2-5, t5-3, t6-3");
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.nullRacks(3), consumerRacks, consumerTopics, nonRackAwareAssignment, -1);
        AbstractPartitionAssignorTest.preferRackAwareLogic((AbstractPartitionAssignor)this.assignor, true);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), consumerRacks, consumerTopics, nonRackAwareAssignment, 0);
        List<String> rackAwareAssignment = Arrays.asList("t1-0, t1-2, t2-0, t2-2, t3-0, t4-0, t5-1, t6-1", "t1-1, t1-3, t2-1, t2-3, t3-1, t4-1, t5-2, t6-2", "t1-4, t1-5, t2-4, t2-5, t5-0, t5-3, t6-0, t6-3");
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 2, AbstractPartitionAssignorTest.racks(3), consumerRacks, consumerTopics, rackAwareAssignment, 0);
    }

    private void verifyNonRackAwareAssignment(Map<String, Integer> topics, List<List<String>> consumerTopics, List<String> nonRackAwareAssignment) {
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.nullRacks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, nonRackAwareAssignment, -1);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.nullRacks(3), consumerTopics, nonRackAwareAssignment, -1);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, nonRackAwareAssignment, 0);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 4, AbstractPartitionAssignorTest.racks(4), AbstractPartitionAssignorTest.racks(3), consumerTopics, nonRackAwareAssignment, 0);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), Arrays.asList("d", "e", "f"), consumerTopics, nonRackAwareAssignment, -1);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), Arrays.asList(null, "e", "f"), consumerTopics, nonRackAwareAssignment, -1);
        AbstractPartitionAssignorTest.preferRackAwareLogic((AbstractPartitionAssignor)this.assignor, true);
        AbstractPartitionAssignorTest.verifyRackAssignment((AbstractPartitionAssignor)this.assignor, topics, 3, AbstractPartitionAssignorTest.racks(3), AbstractPartitionAssignorTest.racks(3), consumerTopics, nonRackAwareAssignment, 0);
        AbstractPartitionAssignorTest.preferRackAwareLogic((AbstractPartitionAssignor)this.assignor, false);
    }

    private static Map<String, List<TopicPartition>> checkStaticAssignment(AbstractPartitionAssignor assignor, Map<String, List<PartitionInfo>> partitionsPerTopic, Map<String, ConsumerPartitionAssignor.Subscription> consumers) {
        Map assignmentByMemberId = assignor.assignPartitions(partitionsPerTopic, consumers);
        HashMap<String, List<TopicPartition>> assignmentByInstanceId = new HashMap<String, List<TopicPartition>>();
        for (Map.Entry<String, ConsumerPartitionAssignor.Subscription> entry : consumers.entrySet()) {
            String memberId = entry.getKey();
            Optional instanceId = entry.getValue().groupInstanceId();
            instanceId.ifPresent(id -> assignmentByInstanceId.put((String)id, (List)assignmentByMemberId.get(memberId)));
        }
        return assignmentByInstanceId;
    }

    private void assertAssignment(List<TopicPartition> expected, List<TopicPartition> actual) {
        Assertions.assertEquals(new HashSet<TopicPartition>(expected), new HashSet<TopicPartition>(actual));
    }

    private Map<String, List<PartitionInfo>> setupPartitionsPerTopicWithTwoTopics(int numberOfPartitions1, int numberOfPartitions2) {
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put("topic1", this.partitionInfos("topic1", numberOfPartitions1));
        partitionsPerTopic.put("topic2", this.partitionInfos("topic2", numberOfPartitions2));
        return partitionsPerTopic;
    }

    private List<PartitionInfo> partitionInfos(String topic, int numberOfPartitions) {
        return AbstractPartitionAssignorTest.partitionInfos(topic, numberOfPartitions, this.replicationFactor, this.numBrokerRacks, 0);
    }

    private ConsumerPartitionAssignor.Subscription subscription(List<String> topics, int consumerIndex) {
        int numRacks = this.numBrokerRacks > 0 ? this.numBrokerRacks : AbstractPartitionAssignorTest.ALL_RACKS.length;
        Optional<Object> rackId = Optional.ofNullable(this.hasConsumerRack ? AbstractPartitionAssignorTest.ALL_RACKS[consumerIndex % numRacks] : null);
        return new ConsumerPartitionAssignor.Subscription(topics, null, Collections.emptyList(), -1, rackId);
    }

    private static List<String> topics(String ... topics) {
        return Arrays.asList(topics);
    }

    private static List<TopicPartition> partitions(TopicPartition ... partitions) {
        return Arrays.asList(partitions);
    }

    private static TopicPartition tp(String topic, int partition) {
        return new TopicPartition(topic, partition);
    }

    void initializeRacks(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig, 3);
    }

    void initializeRacks(AbstractPartitionAssignorTest.RackConfig rackConfig, int maxConsumers) {
        this.replicationFactor = maxConsumers;
        this.numBrokerRacks = rackConfig != AbstractPartitionAssignorTest.RackConfig.NO_BROKER_RACK ? maxConsumers : 0;
        this.hasConsumerRack = rackConfig != AbstractPartitionAssignorTest.RackConfig.NO_CONSUMER_RACK;
        AbstractPartitionAssignorTest.preferRackAwareLogic((AbstractPartitionAssignor)this.assignor, true);
    }
}

