/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import org.apache.kafka.clients.producer.PreparedTxnState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PreparedTxnStateTest {
    @Test
    public void testDefaultConstructor() {
        PreparedTxnState state = new PreparedTxnState();
        Assertions.assertEquals((Object)"", (Object)state.toString(), (String)"Empty state should serialize to an empty string");
        Assertions.assertEquals((long)-1L, (long)state.producerId(), (String)"Default producerId should be -1");
        Assertions.assertEquals((short)-1, (short)state.epoch(), (String)"Default epoch should be -1");
        Assertions.assertFalse((boolean)state.hasTransaction(), (String)"Default state should not have a transaction");
    }

    @Test
    public void testParameterizedConstructor() {
        long producerId = 123L;
        short epoch = 45;
        PreparedTxnState state = new PreparedTxnState(producerId, epoch);
        Assertions.assertEquals((long)producerId, (long)state.producerId(), (String)"ProducerId should match");
        Assertions.assertEquals((short)epoch, (short)state.epoch(), (String)"Epoch should match");
        Assertions.assertTrue((boolean)state.hasTransaction(), (String)"State should have a transaction");
        Assertions.assertEquals((Object)"123:45", (Object)state.toString(), (String)"Serialized form should match expected format");
    }

    @Test
    public void testDeserializationFromString() {
        String serialized = "123:45";
        PreparedTxnState state = new PreparedTxnState(serialized);
        Assertions.assertEquals((Object)serialized, (Object)state.toString(), (String)"Deserialized state should match the original serialized string");
        Assertions.assertEquals((long)123L, (long)state.producerId(), (String)"Deserialized producerId should match");
        Assertions.assertEquals((short)45, (short)state.epoch(), (String)"Deserialized epoch should match");
        Assertions.assertTrue((boolean)state.hasTransaction(), (String)"Deserialized state should have a transaction");
    }

    @Test
    public void testRoundTripSerialization() {
        String original = "9876:54";
        PreparedTxnState state = new PreparedTxnState(original);
        String serialized = state.toString();
        Assertions.assertEquals((Object)original, (Object)serialized, (String)"Round-trip serialization should preserve values");
        PreparedTxnState stateAgain = new PreparedTxnState(serialized);
        Assertions.assertEquals((Object)original, (Object)stateAgain.toString(), (String)"Re-deserialized state should match original");
        Assertions.assertEquals((long)state.producerId(), (long)stateAgain.producerId(), (String)"Producer IDs should match");
        Assertions.assertEquals((short)state.epoch(), (short)stateAgain.epoch(), (String)"Epochs should match");
        String emptyString = "";
        PreparedTxnState emptyState = new PreparedTxnState(emptyString);
        String emptyStateSerialized = emptyState.toString();
        Assertions.assertEquals((Object)emptyString, (Object)emptyStateSerialized, (String)"Round-trip of empty string should remain empty");
        Assertions.assertEquals((long)-1L, (long)emptyState.producerId(), (String)"Empty string should result in producerId -1");
        Assertions.assertEquals((short)-1, (short)emptyState.epoch(), (String)"Empty string should result in epoch -1");
        PreparedTxnState emptyStateAgain = new PreparedTxnState(emptyStateSerialized);
        Assertions.assertEquals((Object)emptyString, (Object)emptyStateAgain.toString(), (String)"Re-deserialized empty state should still be empty");
        Assertions.assertEquals((long)-1L, (long)emptyStateAgain.producerId(), (String)"Empty string should result in producerId -1");
        Assertions.assertEquals((short)-1, (short)emptyStateAgain.epoch(), (String)"Empty string should result in epoch -1");
    }

    @Test
    public void testHandlingOfNullOrEmptyString() {
        PreparedTxnState stateWithNull = new PreparedTxnState(null);
        Assertions.assertEquals((Object)"", (Object)stateWithNull.toString(), (String)"Null string should result in empty state");
        Assertions.assertFalse((boolean)stateWithNull.hasTransaction(), (String)"State from null string should not have a transaction");
        PreparedTxnState stateWithEmpty = new PreparedTxnState("");
        Assertions.assertEquals((Object)"", (Object)stateWithEmpty.toString(), (String)"Empty string should result in empty state");
        Assertions.assertFalse((boolean)stateWithEmpty.hasTransaction(), (String)"State from empty string should not have a transaction");
    }

    @Test
    public void testMaxValues() {
        String maxValues = "9223372036854775807:32767";
        PreparedTxnState state = new PreparedTxnState(maxValues);
        Assertions.assertEquals((Object)maxValues, (Object)state.toString(), (String)"Max values should be handled correctly");
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)state.producerId(), (String)"Max producer ID should be handled correctly");
        Assertions.assertEquals((short)Short.MAX_VALUE, (short)state.epoch(), (String)"Max epoch should be handled correctly");
        Assertions.assertTrue((boolean)state.hasTransaction(), (String)"State with max values should have a transaction");
    }

    @Test
    public void testEqualsAndHashCode() {
        PreparedTxnState state1 = new PreparedTxnState(123L, 45);
        PreparedTxnState state2 = new PreparedTxnState(123L, 45);
        PreparedTxnState state3 = new PreparedTxnState(456L, 78);
        PreparedTxnState state4 = new PreparedTxnState(123L, 46);
        Assertions.assertEquals((Object)state1, (Object)state2, (String)"Equal states should be equal");
        Assertions.assertNotEquals((Object)state1, (Object)state3, (String)"States with different producer IDs should not be equal");
        Assertions.assertNotEquals((Object)state1, (Object)state4, (String)"States with different epochs should not be equal");
        Assertions.assertNotEquals(null, (Object)state1, (String)"State should not equal null");
        Assertions.assertEquals((int)state1.hashCode(), (int)state2.hashCode(), (String)"Equal states should have same hash code");
        Assertions.assertNotEquals((int)state1.hashCode(), (int)state3.hashCode(), (String)"Different states should have different hash codes");
    }

    @Test
    public void testHasTransaction() {
        PreparedTxnState stateWithTransaction = new PreparedTxnState(0L, 0);
        Assertions.assertTrue((boolean)stateWithTransaction.hasTransaction(), (String)"State with producerId 0 should have a transaction");
        PreparedTxnState stateWithoutTransaction = new PreparedTxnState(-1L, -1);
        Assertions.assertFalse((boolean)stateWithoutTransaction.hasTransaction(), (String)"State with producerId -1 should not have a transaction");
    }

    @Test
    public void testInvalidFormatThrowsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PreparedTxnState("123"), (String)"String with missing epoch should throw IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PreparedTxnState("123:45:67"), (String)"String with extra parts should throw IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PreparedTxnState("abc:45"), (String)"Non-numeric producer ID should throw IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PreparedTxnState("123:xyz"), (String)"Non-numeric epoch should throw IllegalArgumentException");
    }

    @Test
    public void testInvalidProducerIdEpochCombinations() {
        new PreparedTxnState("0:0");
        new PreparedTxnState("123:45");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PreparedTxnState("123:-2"), (String)"Positive producerId with negative epoch (not -1) should throw IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PreparedTxnState("-2:45"), (String)"Negative producerId (not -1) with positive epoch should throw IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PreparedTxnState("-2:-2"), (String)"Negative producerId and epoch (not -1) should throw IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PreparedTxnState("-1:45"), (String)"ProducerId -1 with positive epoch should throw IllegalArgumentException");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PreparedTxnState("123:-1"), (String)"Positive producerId with epoch -1 should throw IllegalArgumentException");
    }
}

