/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OffsetCommitResponseTest {
    protected final int throttleTimeMs = 10;
    protected final String topicOne = "topic1";
    protected final int partitionOne = 1;
    protected final Errors errorOne = Errors.COORDINATOR_NOT_AVAILABLE;
    protected final Errors errorTwo = Errors.NOT_COORDINATOR;
    protected final String topicTwo = "topic2";
    protected final int partitionTwo = 2;
    protected TopicPartition tp1 = new TopicPartition("topic1", 1);
    protected TopicPartition tp2 = new TopicPartition("topic2", 2);
    protected Map<Errors, Integer> expectedErrorCounts;
    protected Map<TopicPartition, Errors> errorsMap;

    @BeforeEach
    public void setUp() {
        this.expectedErrorCounts = new EnumMap<Errors, Integer>(Errors.class);
        this.expectedErrorCounts.put(this.errorOne, 1);
        this.expectedErrorCounts.put(this.errorTwo, 1);
        this.errorsMap = new HashMap<TopicPartition, Errors>();
        this.errorsMap.put(this.tp1, this.errorOne);
        this.errorsMap.put(this.tp2, this.errorTwo);
    }

    @Test
    public void testConstructorWithErrorResponse() {
        OffsetCommitResponse response = new OffsetCommitResponse(10, this.errorsMap);
        Assertions.assertEquals(this.expectedErrorCounts, (Object)response.errorCounts());
        Assertions.assertEquals((int)10, (int)response.throttleTimeMs());
    }

    @Test
    public void testParse() {
        OffsetCommitResponseData data = new OffsetCommitResponseData().setTopics(Arrays.asList(new OffsetCommitResponseData.OffsetCommitResponseTopic().setPartitions(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(1).setErrorCode(this.errorOne.code()))), new OffsetCommitResponseData.OffsetCommitResponseTopic().setPartitions(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(2).setErrorCode(this.errorTwo.code()))))).setThrottleTimeMs(10);
        Iterator iterator = ApiKeys.OFFSET_COMMIT.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            ByteBufferAccessor readable = MessageUtil.toByteBufferAccessor((Message)data, (short)version);
            OffsetCommitResponse response = OffsetCommitResponse.parse((Readable)readable, (short)version);
            Assertions.assertEquals(this.expectedErrorCounts, (Object)response.errorCounts());
            if (version >= 3) {
                Assertions.assertEquals((int)10, (int)response.throttleTimeMs());
            } else {
                Assertions.assertEquals((int)0, (int)response.throttleTimeMs());
            }
            Assertions.assertEquals((Object)(version >= 4 ? 1 : 0), (Object)response.shouldClientThrottle(version));
        }
    }
}

