/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.util.Map;
import org.apache.kafka.common.security.oauthbearer.BrokerJwtValidator;
import org.apache.kafka.common.security.oauthbearer.JwtValidator;
import org.apache.kafka.common.security.oauthbearer.JwtValidatorTest;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenBuilder;
import org.apache.kafka.common.security.oauthbearer.internals.secured.CloseableVerificationKeyResolver;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.lang.InvalidAlgorithmException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BrokerJwtValidatorTest
extends JwtValidatorTest {
    @Override
    protected JwtValidator createJwtValidator(AccessTokenBuilder builder) {
        CloseableVerificationKeyResolver resolver = (jws, nestingContext) -> builder.jwk().getKey();
        return new BrokerJwtValidator(resolver);
    }

    @Test
    public void testRsaEncryptionAlgorithm() throws Exception {
        PublicJsonWebKey jwk = this.createRsaJwk();
        this.testEncryptionAlgorithm(jwk, "RS256");
    }

    @Test
    public void testEcdsaEncryptionAlgorithm() throws Exception {
        PublicJsonWebKey jwk = this.createEcJwk();
        this.testEncryptionAlgorithm(jwk, "ES256");
    }

    @Test
    public void testInvalidEncryptionAlgorithm() throws Exception {
        PublicJsonWebKey jwk = this.createRsaJwk();
        this.assertThrowsWithMessage(InvalidAlgorithmException.class, () -> this.testEncryptionAlgorithm(jwk, "fake"), "fake is an unknown, unsupported or unavailable alg algorithm");
    }

    @Test
    public void testMissingSubShouldBeValid() throws Exception {
        String subClaimName = "client_id";
        String subject = "otherSub";
        PublicJsonWebKey jwk = this.createRsaJwk();
        AccessTokenBuilder tokenBuilder = new AccessTokenBuilder().jwk(jwk).alg("RS256").addCustomClaim(subClaimName, subject).subjectClaimName(subClaimName).subject(null);
        JwtValidator validator = this.createJwtValidator(tokenBuilder);
        Map<String, ?> saslConfigs = this.getSaslConfigs("sasl.oauthbearer.sub.claim.name", subClaimName);
        validator.configure(saslConfigs, "OAUTHBEARER", this.getJaasConfigEntries());
        OAuthBearerToken token = validator.validate(tokenBuilder.build());
        Assertions.assertEquals((Object)subject, (Object)token.principalName());
    }

    private void testEncryptionAlgorithm(PublicJsonWebKey jwk, String alg) throws Exception {
        AccessTokenBuilder builder = new AccessTokenBuilder().jwk(jwk).alg(alg);
        JwtValidator validator = this.createJwtValidator(builder);
        validator.configure(this.getSaslConfigs(), "OAUTHBEARER", this.getJaasConfigEntries());
        String accessToken = builder.build();
        OAuthBearerToken token = validator.validate(accessToken);
        Assertions.assertEquals((Object)builder.subject(), (Object)token.principalName());
        Assertions.assertEquals((long)(builder.issuedAtSeconds() * 1000L), (Long)token.startTimeMs());
        Assertions.assertEquals((long)(builder.expirationSeconds() * 1000L), (long)token.lifetimeMs());
        Assertions.assertEquals((int)1, (int)token.scope().size());
    }
}

