/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.oauthbearer.JwtBearerJwtRetriever;
import org.apache.kafka.common.security.oauthbearer.JwtRetrieverException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JwtBearerJwtRetrieverTest
extends OAuthBearerTest {
    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls");
        System.clearProperty("org.apache.kafka.sasl.oauthbearer.allowed.files");
    }

    @Test
    public void testConfigure() throws Exception {
        String tokenEndpointUrl = "https://www.example.com";
        String privateKeyFile = this.generatePrivateKey().getPath();
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", tokenEndpointUrl);
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.files", privateKeyFile);
        Map<String, ?> configs = this.getSaslConfigs(Map.of("sasl.oauthbearer.token.endpoint.url", tokenEndpointUrl, "sasl.oauthbearer.assertion.algorithm", "RS256", "sasl.oauthbearer.assertion.private.key.file", privateKeyFile));
        List<AppConfigurationEntry> jaasConfigEntries = this.getJaasConfigEntries();
        try (JwtBearerJwtRetriever jwtRetriever = new JwtBearerJwtRetriever();){
            Assertions.assertDoesNotThrow(() -> jwtRetriever.configure(configs, "OAUTHBEARER", jaasConfigEntries));
        }
    }

    @Test
    public void testConfigureWithMalformedPrivateKey() throws Exception {
        String tokenEndpointUrl = "https://www.example.com";
        String malformedPrivateKeyFile = TestUtils.tempFile().getPath();
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", tokenEndpointUrl);
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.files", malformedPrivateKeyFile);
        Map<String, ?> configs = this.getSaslConfigs(Map.of("sasl.oauthbearer.token.endpoint.url", tokenEndpointUrl, "sasl.oauthbearer.assertion.algorithm", "RS256", "sasl.oauthbearer.assertion.private.key.file", malformedPrivateKeyFile));
        List<AppConfigurationEntry> jaasConfigEntries = this.getJaasConfigEntries();
        try (JwtBearerJwtRetriever jwtRetriever = new JwtBearerJwtRetriever();){
            JwtRetrieverException e = (JwtRetrieverException)Assertions.assertThrows(JwtRetrieverException.class, () -> jwtRetriever.configure(configs, "OAUTHBEARER", jaasConfigEntries));
            Assertions.assertNotNull((Object)e.getCause());
            Assertions.assertInstanceOf(GeneralSecurityException.class, (Object)e.getCause());
        }
    }

    @Test
    public void testConfigureWithStaticAssertion() throws Exception {
        String tokenEndpointUrl = "https://www.example.com";
        String assertionFile = TestUtils.tempFile(this.createJwt("jdoe")).getPath();
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", tokenEndpointUrl);
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.files", assertionFile);
        Map<String, ?> configs = this.getSaslConfigs(Map.of("sasl.oauthbearer.token.endpoint.url", tokenEndpointUrl, "sasl.oauthbearer.assertion.algorithm", "RS256", "sasl.oauthbearer.assertion.file", assertionFile));
        List<AppConfigurationEntry> jaasConfigEntries = this.getJaasConfigEntries();
        try (JwtBearerJwtRetriever jwtRetriever = new JwtBearerJwtRetriever();){
            Assertions.assertDoesNotThrow(() -> jwtRetriever.configure(configs, "OAUTHBEARER", jaasConfigEntries));
        }
    }

    @Test
    public void testConfigureWithInvalidPassphrase() throws Exception {
        String tokenEndpointUrl = "https://www.example.com";
        String privateKeyFile = this.generatePrivateKey().getPath();
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls", tokenEndpointUrl);
        System.setProperty("org.apache.kafka.sasl.oauthbearer.allowed.files", privateKeyFile);
        Map<String, ?> configs = this.getSaslConfigs(Map.of("sasl.oauthbearer.token.endpoint.url", tokenEndpointUrl, "sasl.oauthbearer.assertion.algorithm", "RS256", "sasl.oauthbearer.assertion.private.key.file", privateKeyFile, "sasl.oauthbearer.assertion.private.key.passphrase", "this-passphrase-is-invalid"));
        List<AppConfigurationEntry> jaasConfigEntries = this.getJaasConfigEntries();
        try (JwtBearerJwtRetriever jwtRetriever = new JwtBearerJwtRetriever();){
            JwtRetrieverException e = (JwtRetrieverException)Assertions.assertThrows(JwtRetrieverException.class, () -> jwtRetriever.configure(configs, "OAUTHBEARER", jaasConfigEntries));
            Assertions.assertNotNull((Object)e.getCause());
            Assertions.assertInstanceOf(IOException.class, (Object)e.getCause());
        }
    }
}

