/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.CachedFile;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CachedFileTest
extends OAuthBearerTest {
    @Test
    public void testStaticPolicy() throws Exception {
        File tmpFile = TestUtils.tempFile("  foo  ");
        CachedFile.Transformer transformer = (file, contents) -> contents.trim();
        CachedFile.RefreshPolicy refreshPolicy = CachedFile.RefreshPolicy.staticPolicy();
        CachedFile cachedFile = new CachedFile(tmpFile, transformer, refreshPolicy);
        Assertions.assertEquals((long)cachedFile.lastModified(), (long)tmpFile.lastModified());
        Assertions.assertEquals((long)7L, (long)cachedFile.size());
        Assertions.assertEquals((Object)"  foo  ", (Object)cachedFile.contents());
        Assertions.assertEquals((Object)"foo", (Object)cachedFile.transformed());
        Utils.sleep((long)10L);
        Files.writeString(tmpFile.toPath(), (CharSequence)"  bar baz  ", StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        Assertions.assertNotEquals((long)cachedFile.lastModified(), (long)tmpFile.lastModified());
        Assertions.assertNotEquals((long)cachedFile.size(), (long)tmpFile.length());
        Assertions.assertEquals((long)7L, (long)cachedFile.size());
        Assertions.assertEquals((Object)"  foo  ", (Object)cachedFile.contents());
        Assertions.assertEquals((Object)"foo", (Object)cachedFile.transformed());
    }

    @Test
    public void testLastModifiedPolicy() throws Exception {
        File tmpFile = TestUtils.tempFile("  foo  ");
        CachedFile.Transformer transformer = (file, contents) -> contents.trim();
        CachedFile.RefreshPolicy refreshPolicy = CachedFile.RefreshPolicy.lastModifiedPolicy();
        CachedFile cachedFile = new CachedFile(tmpFile, transformer, refreshPolicy);
        Assertions.assertEquals((long)cachedFile.lastModified(), (long)tmpFile.lastModified());
        Assertions.assertEquals((long)7L, (long)cachedFile.size());
        Assertions.assertEquals((Object)"  foo  ", (Object)cachedFile.contents());
        Assertions.assertEquals((Object)"foo", (Object)cachedFile.transformed());
        Utils.sleep((long)10L);
        Files.writeString(tmpFile.toPath(), (CharSequence)"  bar baz  ", StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        Assertions.assertEquals((long)18L, (long)cachedFile.size());
        Assertions.assertEquals((Object)"  foo    bar baz  ", (Object)cachedFile.contents());
        Assertions.assertEquals((Object)"foo    bar baz", (Object)cachedFile.transformed());
    }

    @Test
    public void testFileDoesNotExist() throws IOException {
        File tmpFile = TestUtils.tempFile("  foo  ");
        CachedFile.RefreshPolicy refreshPolicy = CachedFile.RefreshPolicy.lastModifiedPolicy();
        CachedFile cachedFile = new CachedFile(tmpFile, CachedFile.STRING_NOOP_TRANSFORMER, refreshPolicy);
        Assertions.assertTrue((boolean)tmpFile.exists());
        Assertions.assertDoesNotThrow(() -> ((CachedFile)cachedFile).size());
        Assertions.assertDoesNotThrow(() -> ((CachedFile)cachedFile).lastModified());
        Assertions.assertDoesNotThrow(() -> ((CachedFile)cachedFile).contents());
        Assertions.assertDoesNotThrow(() -> ((CachedFile)cachedFile).transformed());
        Assertions.assertTrue((boolean)tmpFile.delete());
        Utils.sleep((long)50L);
        Assertions.assertFalse((boolean)tmpFile.exists());
        Assertions.assertThrows(KafkaException.class, () -> ((CachedFile)cachedFile).size());
        Assertions.assertThrows(KafkaException.class, () -> ((CachedFile)cachedFile).lastModified());
        Assertions.assertThrows(KafkaException.class, () -> ((CachedFile)cachedFile).contents());
        Assertions.assertThrows(KafkaException.class, () -> ((CachedFile)cachedFile).transformed());
        System.out.println("yo");
        Utils.sleep((long)10L);
        Files.writeString(tmpFile.toPath(), (CharSequence)"valid data!", StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
        Assertions.assertTrue((boolean)tmpFile.exists());
        Assertions.assertDoesNotThrow(() -> ((CachedFile)cachedFile).size());
        Assertions.assertDoesNotThrow(() -> ((CachedFile)cachedFile).lastModified());
        Assertions.assertDoesNotThrow(() -> ((CachedFile)cachedFile).contents());
        Assertions.assertDoesNotThrow(() -> ((CachedFile)cachedFile).transformed());
    }

    @Test
    public void testTransformerError() throws Exception {
        File tmpFile = TestUtils.tempFile("[\"foo\"]");
        CachedFile.Transformer jsonTransformer = (file, json) -> {
            try {
                ObjectMapper mapper = new ObjectMapper();
                return (List)mapper.readValue(json, List.class);
            }
            catch (Exception e) {
                throw new KafkaException((Throwable)e);
            }
        };
        CachedFile.RefreshPolicy refreshPolicy = CachedFile.RefreshPolicy.lastModifiedPolicy();
        CachedFile cachedFile = new CachedFile(tmpFile, jsonTransformer, refreshPolicy);
        Assertions.assertEquals(List.of("foo"), (Object)cachedFile.transformed());
        Utils.sleep((long)10L);
        Files.writeString(tmpFile.toPath(), (CharSequence)"[\"foo\", \"bar\", \"baz\"]", StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        Assertions.assertEquals(List.of("foo", "bar", "baz"), (Object)cachedFile.transformed());
    }
}

