/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Collections;
import java.util.HashSet;
import java.util.OptionalInt;
import java.util.Set;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.AllBrokersStrategy;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AllBrokersStrategyTest {
    private final LogContext logContext = new LogContext();

    AllBrokersStrategyTest() {
    }

    @Test
    public void testBuildRequest() {
        AllBrokersStrategy strategy = new AllBrokersStrategy(this.logContext);
        MetadataRequest.Builder builder = strategy.buildRequest(AllBrokersStrategy.LOOKUP_KEYS);
        Assertions.assertEquals(Collections.emptyList(), (Object)builder.topics());
    }

    @Test
    public void testBuildRequestWithInvalidLookupKeys() {
        AllBrokersStrategy strategy = new AllBrokersStrategy(this.logContext);
        AllBrokersStrategy.BrokerKey key1 = new AllBrokersStrategy.BrokerKey(OptionalInt.empty());
        AllBrokersStrategy.BrokerKey key2 = new AllBrokersStrategy.BrokerKey(OptionalInt.of(1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> strategy.buildRequest(Set.of(key1)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> strategy.buildRequest(Set.of(key2)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> strategy.buildRequest(Set.of(key1, key2)));
        HashSet<AllBrokersStrategy.BrokerKey> keys = new HashSet<AllBrokersStrategy.BrokerKey>(AllBrokersStrategy.LOOKUP_KEYS);
        keys.add(key2);
        Assertions.assertThrows(IllegalArgumentException.class, () -> strategy.buildRequest(keys));
    }

    @Test
    public void testHandleResponse() {
        AllBrokersStrategy strategy = new AllBrokersStrategy(this.logContext);
        MetadataResponseData response = new MetadataResponseData();
        response.brokers().add((ImplicitLinkedHashCollection.Element)new MetadataResponseData.MetadataResponseBroker().setNodeId(1).setHost("host1").setPort(9092));
        response.brokers().add((ImplicitLinkedHashCollection.Element)new MetadataResponseData.MetadataResponseBroker().setNodeId(2).setHost("host2").setPort(9092));
        AdminApiLookupStrategy.LookupResult lookupResult = strategy.handleResponse(AllBrokersStrategy.LOOKUP_KEYS, (AbstractResponse)new MetadataResponse(response, ApiKeys.METADATA.latestVersion()));
        Assertions.assertEquals(Collections.emptyMap(), (Object)lookupResult.failedKeys);
        Set<AllBrokersStrategy.BrokerKey> expectedMappedKeys = Set.of(new AllBrokersStrategy.BrokerKey(OptionalInt.of(1)), new AllBrokersStrategy.BrokerKey(OptionalInt.of(2)));
        Assertions.assertEquals(expectedMappedKeys, lookupResult.mappedKeys.keySet());
        lookupResult.mappedKeys.forEach((brokerKey, brokerId) -> Assertions.assertEquals((Object)OptionalInt.of(brokerId), (Object)brokerKey.brokerId));
    }

    @Test
    public void testHandleResponseWithNoBrokers() {
        AllBrokersStrategy strategy = new AllBrokersStrategy(this.logContext);
        MetadataResponseData response = new MetadataResponseData();
        AdminApiLookupStrategy.LookupResult lookupResult = strategy.handleResponse(AllBrokersStrategy.LOOKUP_KEYS, (AbstractResponse)new MetadataResponse(response, ApiKeys.METADATA.latestVersion()));
        Assertions.assertEquals(Collections.emptyMap(), (Object)lookupResult.failedKeys);
        Assertions.assertEquals(Collections.emptyMap(), (Object)lookupResult.mappedKeys);
    }

    @Test
    public void testHandleResponseWithInvalidLookupKeys() {
        AllBrokersStrategy strategy = new AllBrokersStrategy(this.logContext);
        AllBrokersStrategy.BrokerKey key1 = new AllBrokersStrategy.BrokerKey(OptionalInt.empty());
        AllBrokersStrategy.BrokerKey key2 = new AllBrokersStrategy.BrokerKey(OptionalInt.of(1));
        MetadataResponse response = new MetadataResponse(new MetadataResponseData(), ApiKeys.METADATA.latestVersion());
        Assertions.assertThrows(IllegalArgumentException.class, () -> strategy.handleResponse(Set.of(key1), (AbstractResponse)response));
        Assertions.assertThrows(IllegalArgumentException.class, () -> strategy.handleResponse(Set.of(key2), (AbstractResponse)response));
        Assertions.assertThrows(IllegalArgumentException.class, () -> strategy.handleResponse(Set.of(key1, key2), (AbstractResponse)response));
        HashSet<AllBrokersStrategy.BrokerKey> keys = new HashSet<AllBrokersStrategy.BrokerKey>(AllBrokersStrategy.LOOKUP_KEYS);
        keys.add(key2);
        Assertions.assertThrows(IllegalArgumentException.class, () -> strategy.handleResponse(keys, (AbstractResponse)response));
    }
}

