/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Collections;
import java.util.Set;
import org.apache.kafka.clients.admin.FenceProducersOptions;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.FenceProducersHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.InitProducerIdResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.ProducerIdAndEpoch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FenceProducersHandlerTest {
    private final LogContext logContext = new LogContext();
    private final Node node = new Node(1, "host", 1234);
    private final int requestTimeoutMs = 30000;
    private final FenceProducersOptions options = new FenceProducersOptions();

    @Test
    public void testBuildRequest() {
        FenceProducersHandler handler = new FenceProducersHandler(this.options, this.logContext, 30000);
        Set.of("foo", "bar", "baz").forEach(transactionalId -> this.assertLookup(handler, (String)transactionalId, 30000));
    }

    @Test
    public void testBuildRequestOptionsTimeout() {
        int optionsTimeoutMs = 50000;
        this.options.timeoutMs(Integer.valueOf(50000));
        FenceProducersHandler handler = new FenceProducersHandler(this.options, this.logContext, 30000);
        Set.of("foo", "bar", "baz").forEach(transactionalId -> this.assertLookup(handler, (String)transactionalId, 50000));
    }

    @Test
    public void testHandleSuccessfulResponse() {
        String transactionalId = "foo";
        CoordinatorKey key = CoordinatorKey.byTransactionalId((String)transactionalId);
        FenceProducersHandler handler = new FenceProducersHandler(this.options, this.logContext, 30000);
        short epoch = 57;
        long producerId = 7L;
        InitProducerIdResponse response = new InitProducerIdResponse(new InitProducerIdResponseData().setProducerEpoch(epoch).setProducerId(producerId));
        AdminApiHandler.ApiResult result = handler.handleSingleResponse(this.node, key, (AbstractResponse)response);
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.completedKeys.keySet());
        ProducerIdAndEpoch expected = new ProducerIdAndEpoch(producerId, epoch);
        Assertions.assertEquals((Object)expected, result.completedKeys.get(key));
    }

    @Test
    public void testHandleErrorResponse() {
        String transactionalId = "foo";
        FenceProducersHandler handler = new FenceProducersHandler(this.options, this.logContext, 30000);
        this.assertFatalError(handler, transactionalId, Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED);
        this.assertFatalError(handler, transactionalId, Errors.CLUSTER_AUTHORIZATION_FAILED);
        this.assertFatalError(handler, transactionalId, Errors.UNKNOWN_SERVER_ERROR);
        this.assertFatalError(handler, transactionalId, Errors.PRODUCER_FENCED);
        this.assertFatalError(handler, transactionalId, Errors.TRANSACTIONAL_ID_NOT_FOUND);
        this.assertFatalError(handler, transactionalId, Errors.INVALID_PRODUCER_EPOCH);
        this.assertRetriableError(handler, transactionalId, Errors.COORDINATOR_LOAD_IN_PROGRESS);
        this.assertUnmappedKey(handler, transactionalId, Errors.NOT_COORDINATOR);
        this.assertUnmappedKey(handler, transactionalId, Errors.COORDINATOR_NOT_AVAILABLE);
        this.assertRetriableError(handler, transactionalId, Errors.CONCURRENT_TRANSACTIONS);
    }

    private void assertFatalError(FenceProducersHandler handler, String transactionalId, Errors error) {
        CoordinatorKey key = CoordinatorKey.byTransactionalId((String)transactionalId);
        AdminApiHandler.ApiResult<CoordinatorKey, ProducerIdAndEpoch> result = this.handleResponseError(handler, transactionalId, error);
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Set.of(key), result.failedKeys.keySet());
        Throwable throwable = (Throwable)result.failedKeys.get(key);
        Assertions.assertInstanceOf(error.exception().getClass(), (Object)throwable);
    }

    private void assertRetriableError(FenceProducersHandler handler, String transactionalId, Errors error) {
        AdminApiHandler.ApiResult<CoordinatorKey, ProducerIdAndEpoch> result = this.handleResponseError(handler, transactionalId, error);
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
    }

    private void assertUnmappedKey(FenceProducersHandler handler, String transactionalId, Errors error) {
        CoordinatorKey key = CoordinatorKey.byTransactionalId((String)transactionalId);
        AdminApiHandler.ApiResult<CoordinatorKey, ProducerIdAndEpoch> result = this.handleResponseError(handler, transactionalId, error);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
        Assertions.assertEquals(Collections.singletonList(key), (Object)result.unmappedKeys);
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, ProducerIdAndEpoch> handleResponseError(FenceProducersHandler handler, String transactionalId, Errors error) {
        CoordinatorKey key = CoordinatorKey.byTransactionalId((String)transactionalId);
        Set<CoordinatorKey> keys = Set.of(key);
        InitProducerIdResponse response = new InitProducerIdResponse(new InitProducerIdResponseData().setErrorCode(error.code()));
        AdminApiHandler.ApiResult result = handler.handleResponse(this.node, keys, (AbstractResponse)response);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.completedKeys);
        return result;
    }

    private void assertLookup(FenceProducersHandler handler, String transactionalId, int txnTimeoutMs) {
        CoordinatorKey key = CoordinatorKey.byTransactionalId((String)transactionalId);
        InitProducerIdRequest.Builder request = handler.buildSingleRequest(1, key);
        Assertions.assertEquals((Object)transactionalId, (Object)request.data.transactionalId());
        Assertions.assertEquals((int)txnTimeoutMs, (int)request.data.transactionTimeoutMs());
    }
}

